/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.render.svg;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.observable.collections.list.ObservableList;
import org.jetbrains.letsPlot.commons.intern.observable.event.EventHandler;
import org.jetbrains.letsPlot.commons.intern.observable.property.Property;
import org.jetbrains.letsPlot.commons.registration.CompositeRegistration;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgUID;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgCircleElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgClipPathElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgDefsElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGraphicsElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgIRI;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransform;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransformBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 <2\u00020\u0001:\u0001<B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001bH$J\b\u0010#\u001a\u00020\u001bH\u0002J\b\u0010$\u001a\u00020\u001bH\u0016J\u000e\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'J\u0016\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u0016J\u0006\u0010+\u001a\u00020\u001bJ\u0016\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u0016J\u000e\u0010,\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\u0012J\b\u00100\u001a\u00020\u001bH\u0004J\u0014\u00101\u001a\b\u0012\u0004\u0012\u0002H302\"\u0004\b\u0000\u00103H\u0004J\u0010\u00104\u001a\u00020\u001b2\u0006\u00105\u001a\u000206H\u0004J\u000e\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u0016J\u000e\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u0012J\u000e\u0010;\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u0012R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u00048DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00000\fj\b\u0012\u0004\u0012\u00020\u0000`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006="}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "", "()V", "childComponents", "", "getChildComponents", "()Ljava/util/List;", "<set-?>", "", "isBuilt", "()Z", "myChildComponents", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "myCompositeRegistration", "Lorg/jetbrains/letsPlot/commons/registration/CompositeRegistration;", "myIsBuilding", "myOrigin", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "myRootGroup", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "myRotationAngle", "", "rootGroup", "getRootGroup", "()Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "add", "", "child", "node", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "addClassName", "className", "", "buildComponent", "buildComponentIntern", "clear", "clipBounds", "rect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "clipCircle", "center", "radius", "ensureBuilt", "moveTo", "x", "y", "p", "needRebuild", "rebuildHandler", "Lorg/jetbrains/letsPlot/commons/intern/observable/event/EventHandler;", "EventT", "reg", "r", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "rotate", "angle", "toAbsoluteCoordinates", "location", "toRelativeCoordinates", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nSvgComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SvgComponent.kt\norg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,189:1\n1#2:190\n*E\n"})
public abstract class SvgComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isBuilt;
    private boolean myIsBuilding;
    @NotNull
    private final SvgGElement myRootGroup = new SvgGElement();
    @NotNull
    private final ArrayList<SvgComponent> myChildComponents = new ArrayList();
    @NotNull
    private DoubleVector myOrigin = DoubleVector.Companion.getZERO();
    private double myRotationAngle;
    @NotNull
    private CompositeRegistration myCompositeRegistration = new CompositeRegistration(new Registration[0]);
    @NotNull
    public static final String CLIP_PATH_ID_PREFIX = "c";

    protected final boolean isBuilt() {
        return this.isBuilt;
    }

    @NotNull
    protected final List<SvgComponent> getChildComponents() {
        if (!this.isBuilt) {
            boolean bl = false;
            String string = "Plot has not yet built";
            throw new IllegalArgumentException(string.toString());
        }
        return new ArrayList(this.myChildComponents);
    }

    @NotNull
    public final SvgGElement getRootGroup() {
        this.ensureBuilt();
        return this.myRootGroup;
    }

    public final void ensureBuilt() {
        if (!this.isBuilt && !this.myIsBuilding) {
            this.buildComponentIntern();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void buildComponentIntern() {
        try {
            this.myIsBuilding = true;
            this.buildComponent();
        }
        finally {
            this.myIsBuilding = false;
            this.isBuilt = true;
        }
    }

    protected abstract void buildComponent();

    @NotNull
    protected final <EventT> EventHandler<EventT> rebuildHandler() {
        return new EventHandler<EventT>(this){
            final /* synthetic */ SvgComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void onEvent(EventT event) {
                this.this$0.needRebuild();
            }
        };
    }

    protected final void needRebuild() {
        if (this.isBuilt) {
            this.clear();
            this.buildComponentIntern();
        }
    }

    protected final void reg(@NotNull Registration r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        this.myCompositeRegistration.add(r);
    }

    public void clear() {
        this.isBuilt = false;
        for (SvgComponent child : this.myChildComponents) {
            child.clear();
        }
        this.myChildComponents.clear();
        this.myRootGroup.children().clear();
        this.myCompositeRegistration.remove();
        this.myCompositeRegistration = new CompositeRegistration(new Registration[0]);
    }

    public final void add(@NotNull SvgComponent child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        this.myChildComponents.add(child);
        this.add(child.getRootGroup());
    }

    public final void add(@NotNull SvgNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.myRootGroup.children().add(node);
    }

    public final void moveTo(@NotNull DoubleVector p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.myOrigin = p;
        this.myRootGroup.transform().set(Companion.buildTransform(this.myOrigin, this.myRotationAngle));
    }

    public final void moveTo(double x2, double y2) {
        this.moveTo(new DoubleVector(x2, y2));
    }

    public final void rotate(double angle) {
        this.myRotationAngle = angle;
        this.myRootGroup.transform().set(Companion.buildTransform(this.myOrigin, this.myRotationAngle));
    }

    @NotNull
    public final DoubleVector toRelativeCoordinates(@NotNull DoubleVector location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return this.getRootGroup().pointToTransformedCoordinates(location2);
    }

    @NotNull
    public final DoubleVector toAbsoluteCoordinates(@NotNull DoubleVector location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return this.getRootGroup().pointToAbsoluteCoordinates(location2);
    }

    /*
     * WARNING - void declaration
     */
    public final void clipBounds(@NotNull DoubleRectangle rect2) {
        SvgDefsElement svgDefsElement;
        void $this$clipBounds_u24lambda_u242_u24lambda_u241;
        SvgRectElement svgRectElement;
        SvgClipPathElement svgClipPathElement;
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        SvgClipPathElement $this$clipBounds_u24lambda_u242 = svgClipPathElement = new SvgClipPathElement();
        boolean bl = false;
        $this$clipBounds_u24lambda_u242.id().set(SvgUID.INSTANCE.get(CLIP_PATH_ID_PREFIX));
        SvgRectElement svgRectElement2 = svgRectElement = new SvgRectElement();
        ObservableList<SvgNode> observableList = $this$clipBounds_u24lambda_u242.children();
        boolean bl2 = false;
        $this$clipBounds_u24lambda_u242_u24lambda_u241.x().set(rect2.getLeft());
        $this$clipBounds_u24lambda_u242_u24lambda_u241.y().set(rect2.getTop());
        $this$clipBounds_u24lambda_u242_u24lambda_u241.width().set(rect2.getWidth());
        $this$clipBounds_u24lambda_u242_u24lambda_u241.height().set(rect2.getHeight());
        observableList.add(svgRectElement);
        SvgClipPathElement clipPathElement = svgClipPathElement;
        SvgDefsElement $this$clipBounds_u24lambda_u243 = svgDefsElement = new SvgDefsElement();
        boolean bl3 = false;
        $this$clipBounds_u24lambda_u243.children().add(clipPathElement);
        SvgDefsElement defs = svgDefsElement;
        this.add(defs);
        Property<SvgIRI> property2 = this.getRootGroup().clipPath();
        Object ValueT = clipPathElement.id().get();
        Intrinsics.checkNotNull(ValueT);
        property2.set(new SvgIRI((String)ValueT));
        this.getRootGroup().setAttribute(SvgGraphicsElement.Companion.getCLIP_BOUNDS_JFX(), rect2);
    }

    /*
     * WARNING - void declaration
     */
    public final void clipCircle(@NotNull DoubleVector center, double radius) {
        SvgDefsElement svgDefsElement;
        void $this$clipCircle_u24lambda_u245_u24lambda_u244;
        SvgCircleElement svgCircleElement;
        SvgClipPathElement svgClipPathElement;
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        SvgClipPathElement $this$clipCircle_u24lambda_u245 = svgClipPathElement = new SvgClipPathElement();
        boolean bl = false;
        $this$clipCircle_u24lambda_u245.id().set(SvgUID.INSTANCE.get(CLIP_PATH_ID_PREFIX));
        SvgCircleElement svgCircleElement2 = svgCircleElement = new SvgCircleElement();
        ObservableList<SvgNode> observableList = $this$clipCircle_u24lambda_u245.children();
        boolean bl2 = false;
        $this$clipCircle_u24lambda_u245_u24lambda_u244.cx().set(center.getX());
        $this$clipCircle_u24lambda_u245_u24lambda_u244.cy().set(center.getY());
        $this$clipCircle_u24lambda_u245_u24lambda_u244.r().set(radius);
        observableList.add(svgCircleElement);
        SvgClipPathElement clipPathElement = svgClipPathElement;
        SvgDefsElement $this$clipCircle_u24lambda_u246 = svgDefsElement = new SvgDefsElement();
        boolean bl3 = false;
        $this$clipCircle_u24lambda_u246.children().add(clipPathElement);
        SvgDefsElement defs = svgDefsElement;
        this.add(defs);
        Property<SvgIRI> property2 = this.getRootGroup().clipPath();
        Object ValueT = clipPathElement.id().get();
        Intrinsics.checkNotNull(ValueT);
        property2.set(new SvgIRI((String)ValueT));
        this.getRootGroup().setAttribute(SvgGraphicsElement.Companion.getCLIP_CIRCLE_JFX(), DoubleRectangle.Companion.XYWH(center.getX() - radius, center.getY() - radius, radius * (double)2, radius * (double)2));
    }

    public void addClassName(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.myRootGroup.addClass(className);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent$Companion;", "", "()V", "CLIP_PATH_ID_PREFIX", "", "buildTransform", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTransform;", "origin", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "rotationAngle", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SvgTransform buildTransform(@NotNull DoubleVector origin, double rotationAngle) {
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            SvgTransformBuilder transformBuilder = new SvgTransformBuilder();
            if (!Intrinsics.areEqual((Object)origin, (Object)DoubleVector.Companion.getZERO())) {
                transformBuilder.translate(origin.getX(), origin.getY());
            }
            if (!(rotationAngle == 0.0)) {
                transformBuilder.rotate(rotationAngle);
            }
            return transformBuilder.build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

