/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.StatContext;
import org.jetbrains.letsPlot.core.plot.base.data.TransformVar;
import org.jetbrains.letsPlot.core.plot.base.stat.BaseStat;
import org.jetbrains.letsPlot.core.plot.base.stat.BinStatUtil;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nJ;\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\u0014H\u0016J\u0012\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001bH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStat;", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BaseStat;", "binCount", "", "binWidth", "", "xPosKind", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStat$XPosKind;", "xPos", "threshold", "(ILjava/lang/Double;Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStat$XPosKind;DLjava/lang/Double;)V", "binOptions", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStatUtil$BinOptions;", "Ljava/lang/Double;", "apply", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "data", "statCtx", "Lorg/jetbrains/letsPlot/core/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "consumes", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Companion", "XPosKind", "plot-base"})
@SourceDebugExtension(value={"SMAP\nBinStat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/BinStat\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n959#2,7:115\n1549#2:122\n1620#2,3:123\n959#2,7:126\n1549#2:133\n1620#2,3:134\n1855#2,2:137\n1855#2,2:139\n*S KotlinDebug\n*F\n+ 1 BinStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/BinStat\n*L\n71#1:115,7\n71#1:122\n71#1:123,3\n72#1:126,7\n72#1:133\n72#1:134,3\n76#1:137,2\n89#1:139,2\n*E\n"})
public class BinStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XPosKind xPosKind;
    private final double xPos;
    @Nullable
    private final Double threshold;
    @NotNull
    private final BinStatUtil.BinOptions binOptions;
    public static final int DEF_BIN_COUNT = 30;
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;

    public BinStat(int binCount, @Nullable Double binWidth, @NotNull XPosKind xPosKind, double xPos, @Nullable Double threshold) {
        Intrinsics.checkNotNullParameter((Object)((Object)xPosKind), (String)"xPosKind");
        super(DEF_MAPPING);
        this.xPosKind = xPosKind;
        this.xPos = xPos;
        this.threshold = threshold;
        this.binOptions = new BinStatUtil.BinOptions(binCount, binWidth);
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        Object[] objectArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getWEIGHT()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Aes[] aesArray = new Aes[]{Aes.Companion.getX()};
        if (!this.hasRequiredValues(data, aesArray)) {
            return this.withEmptyStatValues();
        }
        ArrayList<Double> statX = new ArrayList<Double>();
        ArrayList<Double> statCount = new ArrayList<Double>();
        ArrayList<Double> statDensity = new ArrayList<Double>();
        ArrayList<Double> statSumProp = new ArrayList<Double>();
        ArrayList<Double> statSumPct = new ArrayList<Double>();
        DoubleSpan rangeX = statCtx.overallXRange();
        if (rangeX != null) {
            BinStatUtil.HistBinsData binsData = BinStatUtil.INSTANCE.computeHistogramStatSeries(data, rangeX, data.getNumeric(TransformVar.INSTANCE.getX()), this.xPosKind, this.xPos, this.binOptions);
            statX.addAll((Collection)binsData.getX$plot_base());
            statCount.addAll((Collection)binsData.getCount$plot_base());
            statDensity.addAll((Collection)binsData.getDensity$plot_base());
            statSumProp.addAll((Collection)binsData.getSumProp$plot_base());
            statSumPct.addAll((Collection)binsData.getSumPct$plot_base());
        }
        if (this.threshold != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Iterable $this$takeWhile$iv = CollectionsKt.withIndex((Iterable)statCount);
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                IndexedValue it = (IndexedValue)item$iv;
                boolean bl = false;
                if (!(((Number)it.getValue()).doubleValue() <= this.threshold)) break;
                list$iv.add(item$iv);
            }
            $this$takeWhile$iv = list$iv;
            boolean $i$f$map = false;
            list$iv = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                IndexedValue indexedValue = (IndexedValue)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getIndex());
            }
            List leftDropPart = (List)destination$iv$iv;
            Iterable $this$takeWhile$iv2 = CollectionsKt.reversed((Iterable)CollectionsKt.withIndex((Iterable)statCount));
            boolean $i$f$takeWhile2 = false;
            ArrayList list$iv2 = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv2) {
                IndexedValue it = (IndexedValue)item$iv;
                boolean bl = false;
                if (!(((Number)it.getValue()).doubleValue() <= this.threshold)) break;
                list$iv2.add(item$iv);
            }
            $this$takeWhile$iv2 = list$iv2;
            boolean $i$f$map2 = false;
            list$iv2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IndexedValue bl = (IndexedValue)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getIndex());
            }
            List rightDropPart = (List)destination$iv$iv2;
            List dropList = CollectionsKt.plus((Collection)leftDropPart, (Iterable)rightDropPart);
            Iterable $this$forEach$iv = dropList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                statCount.set(it, Double.NaN);
                statDensity.set(it, Double.NaN);
                statSumProp.set(it, Double.NaN);
                statSumPct.set(it, Double.NaN);
            }
            $this$forEach$iv = statX.size() - dropList.size() > 1 ? dropList : (!((Collection)leftDropPart).isEmpty() ? CollectionsKt.plus((Collection)CollectionsKt.dropLast((List)leftDropPart, (int)1), (Iterable)rightDropPart) : (!((Collection)rightDropPart).isEmpty() ? CollectionsKt.plus((Collection)leftDropPart, (Iterable)CollectionsKt.dropLast((List)rightDropPart, (int)1)) : CollectionsKt.emptyList()));
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                statX.set(it, Double.NaN);
            }
        }
        return new DataFrame.Builder().putNumeric(Stats.INSTANCE.getX(), (List<Double>)statX).putNumeric(Stats.INSTANCE.getCOUNT(), (List<Double>)statCount).putNumeric(Stats.INSTANCE.getDENSITY(), (List<Double>)statDensity).putNumeric(Stats.INSTANCE.getSUMPROP(), (List<Double>)statSumProp).putNumeric(Stats.INSTANCE.getSUMPCT(), (List<Double>)statSumPct).build();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getCOUNT())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStat$Companion;", "", "()V", "DEF_BIN_COUNT", "", "DEF_MAPPING", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStat$XPosKind;", "", "(Ljava/lang/String;I)V", "NONE", "CENTER", "BOUNDARY", "plot-base"})
    public static final class XPosKind
    extends Enum<XPosKind> {
        public static final /* enum */ XPosKind NONE = new XPosKind();
        public static final /* enum */ XPosKind CENTER = new XPosKind();
        public static final /* enum */ XPosKind BOUNDARY = new XPosKind();
        private static final /* synthetic */ XPosKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static XPosKind[] values() {
            return (XPosKind[])$VALUES.clone();
        }

        public static XPosKind valueOf(String value) {
            return Enum.valueOf(XPosKind.class, value);
        }

        @NotNull
        public static EnumEntries<XPosKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = xPosKindArray = new XPosKind[]{XPosKind.NONE, XPosKind.CENTER, XPosKind.BOUNDARY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

