/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.tooltip.loc;

import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangles;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.GeometryKt;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.geometry.PolylineSimplifier;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetLocator;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.MathUtil;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.PolygonTargetProjection;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.PolygonTargetProjection$Companion$create$;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.TargetProjection;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.TargetProjectionKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0006\u0010\f\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/PolygonTargetProjection;", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/TargetProjection;", "data", "", "(Ljava/lang/Object;)V", "getData", "()Ljava/lang/Object;", "x", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "xy", "", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/PolygonTargetProjection$RingXY;", "y", "Companion", "RingXY", "plot-builder"})
public final class PolygonTargetProjection
extends TargetProjection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object data;
    private static final double POINTS_COUNT_TO_SKIP_SIMPLIFICATION = 20.0;
    private static final double AREA_TOLERANCE_RATIO = 0.1;
    private static final double MAX_TOLERANCE = 40.0;
    private static final boolean isLogEnabled = false;

    private PolygonTargetProjection(Object data) {
        this.data = data;
    }

    @NotNull
    public final Object getData() {
        return this.data;
    }

    @NotNull
    public final DoubleSpan x() {
        Object object = this.data;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.commons.interval.DoubleSpan");
        return (DoubleSpan)object;
    }

    @NotNull
    public final DoubleSpan y() {
        Object object = this.data;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.commons.interval.DoubleSpan");
        return (DoubleSpan)object;
    }

    @NotNull
    public final List<RingXY> xy() {
        Object object = this.data;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.PolygonTargetProjection.RingXY>");
        return (List)object;
    }

    public /* synthetic */ PolygonTargetProjection(Object data, DefaultConstructorMarker $constructor_marker) {
        this(data);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J0\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\u00172\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\fH\u0002J\"\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\f2\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/PolygonTargetProjection$Companion;", "", "()V", "AREA_TOLERANCE_RATIO", "", "MAX_TOLERANCE", "POINTS_COUNT_TO_SKIP_SIMPLIFICATION", "isLogEnabled", "", "create", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/PolygonTargetProjection;", "points", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "lookupSpace", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator$LookupSpace;", "log", "", "str", "", "mapToAxis", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "coordSelector", "Lkotlin/Function1;", "rings", "mapToXY", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/PolygonTargetProjection$RingXY;", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nTargetProjection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetProjection.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/PolygonTargetProjection$Companion\n+ 2 Geometry.kt\norg/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/GeometryKt\n*L\n1#1,206:1\n22#2:207\n*S KotlinDebug\n*F\n+ 1 TargetProjection.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/PolygonTargetProjection$Companion\n*L\n75#1:207\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PolygonTargetProjection create(@NotNull List<DoubleVector> points2, @NotNull GeomTargetLocator.LookupSpace lookupSpace) {
            PolygonTargetProjection polygonTargetProjection;
            Intrinsics.checkNotNullParameter(points2, (String)"points");
            Intrinsics.checkNotNullParameter((Object)((Object)lookupSpace), (String)"lookupSpace");
            boolean $i$f$splitRings = false;
            List<List<DoubleVector>> rings = GeometryKt.splitRings(points2, Companion$create$$inlined$splitRings$1.INSTANCE);
            switch (WhenMappings.$EnumSwitchMapping$0[lookupSpace.ordinal()]) {
                case 1: {
                    polygonTargetProjection = new PolygonTargetProjection(this.mapToAxis((Function1<? super DoubleVector, Double>)((Function1)create.1.INSTANCE), rings), null);
                    break;
                }
                case 2: {
                    polygonTargetProjection = new PolygonTargetProjection(this.mapToAxis((Function1<? super DoubleVector, Double>)((Function1)create.2.INSTANCE), rings), null);
                    break;
                }
                case 3: {
                    polygonTargetProjection = new PolygonTargetProjection(this.mapToXY(rings), null);
                    break;
                }
                case 4: {
                    TargetProjectionKt.access$undefinedLookupSpaceError();
                    throw new KotlinNothingValueException();
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return polygonTargetProjection;
        }

        private final DoubleSpan mapToAxis(Function1<? super DoubleVector, Double> coordSelector2, List<? extends List<DoubleVector>> rings) {
            double min;
            double max = min = ((Number)coordSelector2.invoke((Object)rings.get(0).get(0))).doubleValue();
            for (List<DoubleVector> list2 : rings) {
                for (DoubleVector point : list2) {
                    min = Math.min(min, ((Number)coordSelector2.invoke((Object)point)).doubleValue());
                    max = Math.max(max, ((Number)coordSelector2.invoke((Object)point)).doubleValue());
                }
            }
            return new DoubleSpan(min, max);
        }

        private final List<RingXY> mapToXY(List<? extends List<DoubleVector>> rings) {
            ArrayList<RingXY> polygon2 = new ArrayList<RingXY>();
            for (List list2 : rings) {
                DoubleRectangle bbox2;
                if (list2.size() < 4) continue;
                if (DoubleRectangles.INSTANCE.boundingBox(list2) == null) {
                    throw new IllegalStateException("bbox should be not null - ring is not empty".toString());
                }
                double area = GeometryKt.calculateArea(list2);
                List simplifiedRing = null;
                if ((double)list2.size() > 20.0) {
                    double tolerance = Math.min(area * 0.1, 40.0);
                    simplifiedRing = (List)CollectionsKt.single(PolylineSimplifier.Companion.visvalingamWhyatt(list2).setWeightLimit(tolerance).getPoints());
                } else {
                    simplifiedRing = list2;
                }
                if (simplifiedRing.size() < 4) continue;
                polygon2.add(new RingXY(simplifiedRing, bbox2));
            }
            return polygon2;
        }

        private final void log(String str) {
            System.out.println((Object)str);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[GeomTargetLocator.LookupSpace.values().length];
                try {
                    nArray[GeomTargetLocator.LookupSpace.X.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GeomTargetLocator.LookupSpace.Y.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GeomTargetLocator.LookupSpace.XY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GeomTargetLocator.LookupSpace.NONE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0086\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/PolygonTargetProjection$RingXY;", "", "edges", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "bbox", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "(Ljava/util/List;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;)V", "contains", "", "p", "plot-builder"})
    public static final class RingXY {
        @NotNull
        private final List<DoubleVector> edges;
        @NotNull
        private final DoubleRectangle bbox;

        public RingXY(@NotNull List<DoubleVector> edges, @NotNull DoubleRectangle bbox2) {
            Intrinsics.checkNotNullParameter(edges, (String)"edges");
            Intrinsics.checkNotNullParameter((Object)bbox2, (String)"bbox");
            this.edges = edges;
            this.bbox = bbox2;
        }

        public final boolean contains(@NotNull DoubleVector p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return this.bbox.contains(p) && MathUtil.INSTANCE.polygonContainsCoordinate$plot_builder(this.edges, p);
        }
    }
}

