/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.java.library.MavenCoordinates;
import com.intellij.java.library.MavenCoordinatesKt;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemCoordinateContributor;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.libraries.Library;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\f\u0010\b\u001a\u00020\u0005*\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/JavaGradleCoordinateContributor;", "Lcom/intellij/openapi/externalSystem/service/project/ExternalSystemCoordinateContributor;", "<init>", "()V", "findLibraryCoordinate", "Lcom/intellij/openapi/externalSystem/model/project/ProjectCoordinate;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "toProjectCoordinate", "Lcom/intellij/java/library/MavenCoordinates;", "intellij.gradle.java"})
public final class JavaGradleCoordinateContributor
implements ExternalSystemCoordinateContributor {
    @Nullable
    public ProjectCoordinate findLibraryCoordinate(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        ProjectModelExternalSource projectModelExternalSource = library.getExternalSource();
        if (projectModelExternalSource == null) {
            return null;
        }
        ProjectModelExternalSource librarySource = projectModelExternalSource;
        if (!Intrinsics.areEqual((Object)librarySource.getId(), (Object)GradleConstants.SYSTEM_ID.getId())) {
            return null;
        }
        MavenCoordinates mavenCoordinates = MavenCoordinatesKt.getMavenCoordinates((Library)library);
        return mavenCoordinates != null ? this.toProjectCoordinate(mavenCoordinates) : null;
    }

    private final ProjectCoordinate toProjectCoordinate(MavenCoordinates $this$toProjectCoordinate) {
        return (ProjectCoordinate)new ProjectId($this$toProjectCoordinate.getGroupId(), $this$toProjectCoordinate.getArtifactId(), $this$toProjectCoordinate.getVersion());
    }
}

