/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.dsl.impl.java;

import com.intellij.debugger.streams.core.trace.dsl.Expression;
import com.intellij.debugger.streams.core.trace.dsl.Lambda;
import com.intellij.debugger.streams.core.trace.dsl.impl.TextExpression;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaLambdaBody;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0010\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\u0003*\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/debugger/streams/trace/dsl/impl/java/JavaLambda;", "Lcom/intellij/debugger/streams/core/trace/dsl/Lambda;", "variableName", "", "body", "Lcom/intellij/debugger/streams/trace/dsl/impl/java/JavaLambdaBody;", "<init>", "(Ljava/lang/String;Lcom/intellij/debugger/streams/trace/dsl/impl/java/JavaLambdaBody;)V", "getVariableName", "()Ljava/lang/String;", "getBody", "()Lcom/intellij/debugger/streams/trace/dsl/impl/java/JavaLambdaBody;", "call", "Lcom/intellij/debugger/streams/core/trace/dsl/Expression;", "callName", "args", "", "(Ljava/lang/String;[Lcom/intellij/debugger/streams/core/trace/dsl/Expression;)Lcom/intellij/debugger/streams/core/trace/dsl/Expression;", "toCode", "indent", "", "convert", "intellij.java.debugger.streams"})
public final class JavaLambda
implements Lambda {
    @NotNull
    private final String variableName;
    @NotNull
    private final JavaLambdaBody body;

    public JavaLambda(@NotNull String variableName, @NotNull JavaLambdaBody body) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        Intrinsics.checkNotNullParameter((Object)((Object)body), (String)"body");
        this.variableName = variableName;
        this.body = body;
    }

    @NotNull
    public String getVariableName() {
        return this.variableName;
    }

    @NotNull
    public JavaLambdaBody getBody() {
        return this.body;
    }

    @NotNull
    public Expression call(@NotNull String callName, Expression ... args) {
        Intrinsics.checkNotNullParameter((Object)callName, (String)"callName");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new TextExpression("(" + this.toCode(0) + ")").call(callName, Arrays.copyOf(args, args.length));
    }

    @NotNull
    public String toCode(int indent) {
        return this.withIndent(this.getVariableName() + " -> " + this.convert(this.getBody(), indent), indent);
    }

    private final String convert(JavaLambdaBody $this$convert, int indent) {
        return $this$convert.isExpression() ? $this$convert.toCode(0) : "{\n" + $this$convert.toCode(indent + 1) + $this$convert.withIndent("}", indent);
    }
}

