/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaPropertyDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/ConstantsChecker;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "containsKotlinConstVals", "", "getContainsKotlinConstVals", "()Z", "setContainsKotlinConstVals", "(Z)V", "visitSimpleNameExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitKtElement", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "frontend.java"})
final class ConstantsChecker
extends KtVisitorVoid {
    @NotNull
    private final BindingContext bindingContext;
    private boolean containsKotlinConstVals;

    public ConstantsChecker(@NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        this.bindingContext = bindingContext;
    }

    public final boolean getContainsKotlinConstVals() {
        return this.containsKotlinConstVals;
    }

    public final void setContainsKotlinConstVals(boolean bl) {
        this.containsKotlinConstVals = bl;
    }

    @Override
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)expression, (BindingContext)this.bindingContext);
        if (resolvedCall != null) {
            CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getResultingDescriptor(...)");
            CallableDescriptor callableDescriptor2 = callableDescriptor;
            if (callableDescriptor2 instanceof PropertyDescriptor && !(callableDescriptor2 instanceof JavaPropertyDescriptor) && ((PropertyDescriptor)callableDescriptor2).isConst()) {
                this.containsKotlinConstVals = true;
            }
        }
    }

    @Override
    public void visitKtElement(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!this.containsKotlinConstVals) {
            element.acceptChildren(this);
        }
    }
}

