/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.ir.ValueRemapper;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrAttributesKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6AddBoxParameterLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6PrimaryConstructorOptimizationLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6PrimaryConstructorOptimizationLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsAnnotations;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrMutableAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.ReferencedSymbolRemapper;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\bH\u0016J\u0014\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u000eH\u0002J3\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0007\"\u0004\b\u0000\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u00020\u00160\u0015H\u0082\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6PrimaryConstructorOptimizationLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "convertToRegularConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "removeConstructorForExport", "", "withoutFirst", "T", "", "predicate", "Lkotlin/Function1;", "", "backend.js"})
@SourceDebugExtension(value={"SMAP\nES6PrimaryConstructorOptimizationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ES6PrimaryConstructorOptimizationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6PrimaryConstructorOptimizationLowering\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n+ 4 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,279:1\n153#1,11:284\n284#2,4:280\n17#3,16:295\n33#3:312\n19#4:311\n1#5:313\n*S KotlinDebug\n*F\n+ 1 ES6PrimaryConstructorOptimizationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6PrimaryConstructorOptimizationLowering\n*L\n75#1:284,11\n64#1:280,4\n79#1:295,16\n79#1:312\n79#1:311\n*E\n"})
public final class ES6PrimaryConstructorOptimizationLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;

    public ES6PrimaryConstructorOptimizationLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!(this.context.getEs6mode() && declaration instanceof IrFunction && ES6PrimaryConstructorOptimizationLoweringKt.access$getShouldBeConvertedToPlainConstructor((IrFunction)declaration))) {
            return null;
        }
        IrClass irClass = IrUtilsKt.getParentAsClass((IrDeclaration)declaration);
        IrFunction defaultConstructor = IrJsUtilsKt.findDefaultConstructorForReflection(irClass);
        if (ExportModelGeneratorKt.isExported((IrDeclaration)irClass, this.context)) {
            this.removeConstructorForExport(irClass);
        }
        IrConstructor constructorReplacement = this.convertToRegularConstructor((IrFunction)declaration, irClass);
        if (Intrinsics.areEqual((Object)declaration, (Object)defaultConstructor)) {
            JsIrAttributesKt.setDefaultConstructorForReflection(irClass, constructorReplacement);
        }
        return kotlin.collections.CollectionsKt.listOf((Object)constructorReplacement);
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor convertToRegularConstructor(IrFunction $this$convertToRegularConstructor, IrClass irClass) {
        Object object;
        IrBody irBody;
        DeepCopySymbolRemapper it;
        IrConstructor constructor;
        IrConstructor irConstructor;
        IrValueParameterSymbol classThisSymbol;
        IrClass superClass;
        IrFunction original;
        block7: {
            List list;
            void $this$withoutFirst$iv;
            original = $this$convertToRegularConstructor;
            superClass = IrUtilsKt.getSuperClass((IrClass)irClass);
            IrValueParameter irValueParameter = irClass.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter);
            classThisSymbol = irValueParameter.getSymbol();
            IrFactory $this$buildConstructor$iv = $this$convertToRegularConstructor.getFactory();
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u2424$iv = new IrFunctionBuilder();
            boolean $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22 = false;
            Object $this$convertToRegularConstructor_u24lambda_u240 = $this$buildConstructor_u24lambda_u2424$iv;
            boolean bl = false;
            $this$convertToRegularConstructor_u24lambda_u240.updateFrom(original);
            $this$convertToRegularConstructor_u24lambda_u240.setPrimary(true);
            $this$convertToRegularConstructor_u24lambda_u240.setReturnType(original.getReturnType());
            $this$convertToRegularConstructor_u24lambda_u240.setOrigin((IrDeclarationOrigin)IrDeclarationOrigin.Companion.getDEFINED());
            constructor = irConstructor = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u2424$iv);
            boolean bl2 = false;
            IrUtilsKt.copyAnnotationsFrom((IrMutableAnnotationContainer)((IrMutableAnnotationContainer)constructor), (IrAnnotationContainer)((IrAnnotationContainer)original));
            IrUtilsKt.copyValueAndTypeParametersFrom((IrFunction)((IrFunction)constructor), (IrFunction)original);
            constructor.setParent((IrDeclarationParent)irClass);
            if (!ExportModelGeneratorKt.isExported((IrDeclaration)irClass, this.context)) break block7;
            ES6PrimaryConstructorOptimizationLowering $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22 = this;
            $this$convertToRegularConstructor_u24lambda_u240 = original.getAnnotations();
            IrConstructor irConstructor2 = constructor;
            boolean $i$f$withoutFirst = false;
            void original$iv = $this$withoutFirst$iv;
            List $this$withoutFirst_u24lambda_u246$iv = list = kotlin.collections.CollectionsKt.createListBuilder();
            boolean bl3 = false;
            boolean isFirstMatch$iv = true;
            for (Object element$iv : original$iv) {
                block9: {
                    block8: {
                        if (!isFirstMatch$iv) break block8;
                        it = (IrConstructorCall)element$iv;
                        boolean bl4 = false;
                        if (IrUtilsKt.isAnnotation((IrConstructorCall)it, (FqName)JsAnnotations.INSTANCE.getJsExportIgnoreFqn())) break block9;
                    }
                    $this$withoutFirst_u24lambda_u246$iv.add(element$iv);
                    continue;
                }
                isFirstMatch$iv = false;
            }
            irConstructor2.setAnnotations(kotlin.collections.CollectionsKt.build((List)list));
        }
        IrValueParameter boxParameter = ES6AddBoxParameterLoweringKt.getBoxParameter((IrFunction)constructor);
        IrBody irBody2 = original.getBody();
        if (irBody2 != null) {
            IrElement $this$deepCopyWithSymbols_u24default$iv = (IrElement)irBody2;
            boolean $i$f$deepCopyWithSymbols = false;
            IrElement $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
            boolean $i$f$deepCopyImpl = false;
            DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
            IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyImpl$iv$iv, (IrVisitorVoid)((IrVisitorVoid)symbolRemapper$iv$iv));
            it = symbolRemapper$iv$iv;
            boolean bl = false;
            ReferencedSymbolRemapper p0 = (ReferencedSymbolRemapper)it;
            TypeRemapper typeRemapper$iv$iv = (TypeRemapper)new DeepCopyTypeRemapper(p0);
            IrElement irElement = $this$deepCopyImpl$iv$iv.transform((IrElementTransformer)new DeepCopyIrTreeWithSymbols((SymbolRemapper)symbolRemapper$iv$iv, typeRemapper$iv$iv), null);
            if (irElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBody");
            }
            irBody = (IrBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrElement)((IrBody)irElement)), (IrDeclarationParent)((IrDeclarationParent)constructor));
        } else {
            irBody = null;
        }
        Intrinsics.checkNotNull(irBody, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
        IrBlockBody it2 = object = (IrBlockBody)irBody;
        boolean bl = false;
        constructor.setBody((IrBody)it2);
        IrBlockBody body = object;
        object = MapsKt.emptyMap();
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)body), (IrElementTransformerVoid)((IrElementTransformerVoid)new ValueRemapper(original, constructor, this, classThisSymbol, boxParameter, superClass, irClass, (Map<IrValueSymbol, ? extends IrValueSymbol>)object){
            private final HashMap<IrValueSymbol, IrValueSymbol> map;
            final /* synthetic */ IrFunction $original;
            final /* synthetic */ ES6PrimaryConstructorOptimizationLowering this$0;
            final /* synthetic */ IrValueParameterSymbol $classThisSymbol;
            final /* synthetic */ IrValueParameter $boxParameter;
            final /* synthetic */ IrClass $superClass;
            final /* synthetic */ IrClass $irClass;
            {
                void destination$iv;
                void $this$associateTo$iv;
                this.$original = $original;
                this.this$0 = $receiver;
                this.$classThisSymbol = $classThisSymbol;
                this.$boxParameter = $boxParameter;
                this.$superClass = $superClass;
                this.$irClass = $irClass;
                super($super_call_param$1);
                Iterable iterable = kotlin.collections.CollectionsKt.zip((Iterable)IrUtilsKt.getNonDispatchParameters((IrFunction)$original), (Iterable)IrUtilsKt.getNonDispatchParameters((IrFunction)((IrFunction)$constructor)));
                Map map = CollectionsKt.newHashMapWithExpectedSize((int)($original.getParameters().size() - 1));
                convertToRegularConstructor.2.2 var17_11 = this;
                boolean $i$f$associateTo = false;
                for (T element$iv : $this$associateTo$iv) {
                    void var14_15 = destination$iv;
                    Pair it = (Pair)element$iv;
                    boolean bl = false;
                    Pair pair = TuplesKt.to((Object)((IrValueParameter)it.getFirst()).getSymbol(), (Object)((IrValueParameter)it.getSecond()).getSymbol());
                    var14_15.put(pair.getFirst(), pair.getSecond());
                }
                var17_11.map = (HashMap)destination$iv;
            }

            protected HashMap<IrValueSymbol, IrValueSymbol> getMap() {
                return this.map;
            }

            public IrExpression visitReturn(IrReturn expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                if (Intrinsics.areEqual((Object)expression2.getReturnTargetSymbol(), (Object)this.$original.getSymbol())) {
                    return IrJsUtilsKt.irEmpty(ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0));
                }
                return super.visitReturn(expression2);
            }

            public IrExpression visitCall(IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                return Intrinsics.areEqual((Object)expression2.getSymbol(), (Object)ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0).getIntrinsics().getJsBoxApplySymbol()) ? IrJsUtilsKt.irEmpty(ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0)) : super.visitCall(expression2);
            }

            /*
             * WARNING - void declaration
             */
            public IrStatement visitVariable(IrVariable declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                IrExpression initializer = declaration.getInitializer();
                if (initializer instanceof IrCall) {
                    if (ES6ConstructorLoweringKt.isSyntheticDelegatingReplacement((IrFunctionAccessExpression)initializer)) {
                        this.getMap().put(declaration.getSymbol(), this.$classThisSymbol);
                        return (IrStatement)super.visitCall((IrCall)initializer);
                    }
                    if (Intrinsics.areEqual((Object)((IrCall)initializer).getSymbol(), (Object)ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0).getIntrinsics().getJsCreateThisSymbol())) {
                        IrStatement irStatement;
                        this.getMap().put(declaration.getSymbol(), this.$classThisSymbol);
                        if (this.$boxParameter != null && this.$superClass == null) {
                            void $this$visitVariable_u24lambda_u241;
                            IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0).getIntrinsics().getJsBoxApplySymbol(), null, null, null, null, 0, 0, 126, null);
                            IrClass irClass = this.$irClass;
                            IrValueParameter irValueParameter = this.$boxParameter;
                            IrCall irCall2 = irCall;
                            convertToRegularConstructor.2.2 var18_11 = this;
                            boolean bl = false;
                            IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = $this$visitVariable_u24lambda_u241.getArguments();
                            IrValueParameter irValueParameter2 = irClass.getThisReceiver();
                            Intrinsics.checkNotNull((Object)irValueParameter2);
                            valueArgumentsList.set(0, (Object)JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, (IrValueSymbol)irValueParameter2.getSymbol(), null, 2, null));
                            $this$visitVariable_u24lambda_u241.getArguments().set(1, (Object)JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, (IrValueSymbol)irValueParameter.getSymbol(), null, 2, null));
                            irStatement = (IrStatement)super.visitCall(irCall);
                        } else {
                            irStatement = (IrStatement)IrJsUtilsKt.irEmpty(ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0));
                        }
                        return irStatement;
                    }
                    if (Intrinsics.areEqual((Object)((IrCall)initializer).getSymbol(), (Object)ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0).getIntrinsics().getJsCreateExternalThisSymbol())) {
                        void $this$assignFrom$iv;
                        IrDelegatingConstructorCall irDelegatingConstructorCall;
                        this.getMap().put(declaration.getSymbol(), this.$classThisSymbol);
                        IrClass irClass = this.$superClass;
                        if (irClass == null || (irClass = IrUtilsKt.getPrimaryConstructor((IrClass)irClass)) == null || (irClass = irClass.getSymbol()) == null) {
                            void message$iv;
                            IrExceptionBuilder irExceptionBuilder;
                            String bl = "Expect to have external constructor here";
                            IrClass irClass2 = this.$superClass;
                            boolean $i$f$irError = false;
                            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder((String)message$iv);
                            boolean bl2 = false;
                            IrExceptionBuilder $this$visitVariable_u24lambda_u243 = $this$irError_u24lambda_u240$iv;
                            boolean bl3 = false;
                            IrClass irClass3 = irClass2;
                            if (irClass3 != null) {
                                IrClass it = irClass3;
                                boolean bl4 = false;
                                $this$visitVariable_u24lambda_u243.withIrEntry("superClass", (IrElement)it);
                            }
                            IrExceptionBuilder builder$iv = irExceptionBuilder;
                            throw new IllegalStateException(builder$iv.buildString().toString());
                        }
                        IrClass externalConstructor = irClass;
                        Object $this$visitVariable_u24lambda_u241 = ((IrCall)initializer).getArguments().get(2);
                        IrVararg irVararg = $this$visitVariable_u24lambda_u241 instanceof IrVararg ? (IrVararg)$this$visitVariable_u24lambda_u241 : null;
                        if (irVararg == null) {
                            IrExceptionBuilder irExceptionBuilder;
                            String message$iv = "Wrong type of argument was provided";
                            boolean $i$f$irError = false;
                            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
                            boolean bl = false;
                            IrExceptionBuilder $this$visitVariable_u24lambda_u244 = $this$irError_u24lambda_u240$iv;
                            boolean bl5 = false;
                            $this$visitVariable_u24lambda_u244.withIrEntry("initializer", (IrElement)initializer);
                            IrExceptionBuilder builder$iv = irExceptionBuilder;
                            throw new IllegalStateException(builder$iv.buildString().toString());
                        }
                        IrVararg parameters = irVararg;
                        IrDelegatingConstructorCall $this$visitVariable_u24lambda_u246 = irDelegatingConstructorCall = JsIrBuilder.buildDelegatingConstructorCall$default(JsIrBuilder.INSTANCE, (IrConstructorSymbol)externalConstructor, null, 0, 0, 14, null);
                        boolean bl = false;
                        List list = (List)$this$visitVariable_u24lambda_u246.getArguments();
                        Iterable other$iv = parameters.getElements();
                        boolean $i$f$assignFrom = false;
                        $this$assignFrom$iv.clear();
                        Iterable $this$mapTo$iv$iv = other$iv;
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            IrVarargElement it = (IrVarargElement)item$iv$iv;
                            Collection collection = (Collection)$this$assignFrom$iv;
                            boolean bl6 = false;
                            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                            collection.add((IrExpression)it);
                        }
                        Collection cfr_ignored_0 = (Collection)$this$assignFrom$iv;
                        return (IrStatement)irDelegatingConstructorCall;
                    }
                }
                return super.visitVariable(declaration);
            }
        }));
        return irConstructor;
    }

    private final void removeConstructorForExport(IrClass $this$removeConstructorForExport) {
        $this$removeConstructorForExport.getDeclarations().removeIf(arg_0 -> ES6PrimaryConstructorOptimizationLowering.removeConstructorForExport$lambda$5(ES6PrimaryConstructorOptimizationLowering::removeConstructorForExport$lambda$4, arg_0));
    }

    private final <T> List<T> withoutFirst(Iterable<? extends T> $this$withoutFirst, Function1<? super T, Boolean> predicate) {
        List list;
        boolean $i$f$withoutFirst = false;
        Iterable<T> original = $this$withoutFirst;
        List $this$withoutFirst_u24lambda_u246 = list = kotlin.collections.CollectionsKt.createListBuilder();
        boolean bl = false;
        boolean isFirstMatch = true;
        for (T element : original) {
            if (!isFirstMatch || !((Boolean)predicate.invoke(element)).booleanValue()) {
                $this$withoutFirst_u24lambda_u246.add(element);
                continue;
            }
            isFirstMatch = false;
        }
        return kotlin.collections.CollectionsKt.build((List)list);
    }

    private static final boolean removeConstructorForExport$lambda$4(IrDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof IrConstructor;
    }

    private static final boolean removeConstructorForExport$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ JsIrBackendContext access$getContext$p(ES6PrimaryConstructorOptimizationLowering $this) {
        return $this.context;
    }
}

