/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.calls;

import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.CallsTransformer;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperator;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrDynamicOperatorExpressionImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\t*\u00020\u000bH\u0004J\f\u0010\u000f\u001a\u00020\t*\u00020\u000bH\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/NativeGetterSetterTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/CallsTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "transformFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "doNotIntrinsify", "", "transformToIndexedRead", "transformToIndexedWrite", "backend.js"})
public class NativeGetterSetterTransformer
implements CallsTransformer {
    @NotNull
    private final JsIrBackendContext context;

    public NativeGetterSetterTransformer(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public IrExpression transformFunctionAccess(@NotNull IrFunctionAccessExpression call, boolean doNotIntrinsify) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        IrFunction callee = ((IrFunctionSymbol)call.getSymbol()).getOwner();
        return AnnotationUtilsKt.isJsNativeGetter((IrAnnotationContainer)callee) ? this.transformToIndexedRead(call) : (AnnotationUtilsKt.isJsNativeSetter((IrAnnotationContainer)callee) ? this.transformToIndexedWrite(call) : (IrExpression)call);
    }

    @NotNull
    protected final IrExpression transformToIndexedRead(@NotNull IrFunctionAccessExpression $this$transformToIndexedRead) {
        IrDynamicOperatorExpressionImpl irDynamicOperatorExpressionImpl;
        Intrinsics.checkNotNullParameter((Object)$this$transformToIndexedRead, (String)"<this>");
        IrExpression irExpression = (IrExpression)CollectionsKt.getOrNull((List)((List)$this$transformToIndexedRead.getArguments()), (int)0);
        if (irExpression == null) {
            CompilationExceptionKt.compilationException((String)"Native getter call should have a receiver argument", (IrElement)((IrElement)$this$transformToIndexedRead));
            throw new KotlinNothingValueException();
        }
        IrExpression obj = irExpression;
        IrExpression irExpression2 = (IrExpression)CollectionsKt.getOrNull((List)((List)$this$transformToIndexedRead.getArguments()), (int)1);
        if (irExpression2 == null) {
            CompilationExceptionKt.compilationException((String)"Native getter call should have the key argument", (IrElement)((IrElement)$this$transformToIndexedRead));
            throw new KotlinNothingValueException();
        }
        IrExpression propertyName = irExpression2;
        IrDynamicOperatorExpressionImpl it = irDynamicOperatorExpressionImpl = BuildersKt.IrDynamicOperatorExpressionImpl((int)$this$transformToIndexedRead.getStartOffset(), (int)$this$transformToIndexedRead.getEndOffset(), (IrType)this.context.getIrBuiltIns().getAnyNType(), (IrDynamicOperator)IrDynamicOperator.ARRAY_ACCESS);
        boolean bl = false;
        it.setReceiver(obj);
        it.getArguments().add(propertyName);
        return (IrExpression)irDynamicOperatorExpressionImpl;
    }

    @NotNull
    protected final IrExpression transformToIndexedWrite(@NotNull IrFunctionAccessExpression $this$transformToIndexedWrite) {
        IrDynamicOperatorExpressionImpl irDynamicOperatorExpressionImpl;
        Intrinsics.checkNotNullParameter((Object)$this$transformToIndexedWrite, (String)"<this>");
        IrExpression irExpression = (IrExpression)CollectionsKt.getOrNull((List)((List)$this$transformToIndexedWrite.getArguments()), (int)2);
        if (irExpression == null) {
            CompilationExceptionKt.compilationException((String)"Native setter call should have a value argument", (IrElement)((IrElement)$this$transformToIndexedWrite));
            throw new KotlinNothingValueException();
        }
        IrExpression value = irExpression;
        IrDynamicOperatorExpressionImpl it = irDynamicOperatorExpressionImpl = BuildersKt.IrDynamicOperatorExpressionImpl((int)$this$transformToIndexedWrite.getStartOffset(), (int)$this$transformToIndexedWrite.getEndOffset(), (IrType)$this$transformToIndexedWrite.getType(), (IrDynamicOperator)IrDynamicOperator.EQ);
        boolean bl = false;
        it.setReceiver(this.transformToIndexedRead($this$transformToIndexedWrite));
        it.getArguments().add(value);
        return (IrExpression)irDynamicOperatorExpressionImpl;
    }
}

