/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.util.MetadataHelpersKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0016\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0018\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000fR\u0011\u0010\u0019\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/resolve/CompilerDeserializationConfiguration;", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "skipMetadataVersionCheck", "", "getSkipMetadataVersionCheck", "()Z", "skipPrereleaseCheck", "getSkipPrereleaseCheck", "reportErrorsOnPreReleaseDependencies", "getReportErrorsOnPreReleaseDependencies", "allowUnstableDependencies", "getAllowUnstableDependencies", "typeAliasesAllowed", "getTypeAliasesAllowed", "isJvmPackageNameSupported", "readDeserializedContracts", "getReadDeserializedContracts", "frontend"})
public class CompilerDeserializationConfiguration
implements DeserializationConfiguration {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final MetadataVersion metadataVersion;
    private final boolean skipMetadataVersionCheck;
    private final boolean skipPrereleaseCheck;
    private final boolean reportErrorsOnPreReleaseDependencies;
    private final boolean allowUnstableDependencies;
    private final boolean typeAliasesAllowed;
    private final boolean isJvmPackageNameSupported;
    private final boolean readDeserializedContracts;

    public CompilerDeserializationConfiguration(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
        this.metadataVersion = MetadataHelpersKt.toMetadataVersion((LanguageVersion)this.languageVersionSettings.getLanguageVersion());
        this.skipMetadataVersionCheck = (Boolean)this.languageVersionSettings.getFlag(AnalysisFlags.getSkipMetadataVersionCheck());
        this.skipPrereleaseCheck = (Boolean)this.languageVersionSettings.getFlag(AnalysisFlags.getSkipPrereleaseCheck());
        this.reportErrorsOnPreReleaseDependencies = !this.skipPrereleaseCheck && !this.languageVersionSettings.isPreRelease() && !KotlinCompilerVersion.isPreRelease();
        this.allowUnstableDependencies = (Boolean)this.languageVersionSettings.getFlag(AnalysisFlags.getAllowUnstableDependencies());
        this.typeAliasesAllowed = this.languageVersionSettings.supportsFeature(LanguageFeature.TypeAliases);
        this.isJvmPackageNameSupported = this.languageVersionSettings.supportsFeature(LanguageFeature.JvmPackageName);
        this.readDeserializedContracts = this.languageVersionSettings.supportsFeature(LanguageFeature.ReadDeserializedContracts);
    }

    @NotNull
    protected final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @Override
    @NotNull
    public MetadataVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    @Override
    public final boolean getSkipMetadataVersionCheck() {
        return this.skipMetadataVersionCheck;
    }

    @Override
    public final boolean getSkipPrereleaseCheck() {
        return this.skipPrereleaseCheck;
    }

    @Override
    public final boolean getReportErrorsOnPreReleaseDependencies() {
        return this.reportErrorsOnPreReleaseDependencies;
    }

    @Override
    public final boolean getAllowUnstableDependencies() {
        return this.allowUnstableDependencies;
    }

    @Override
    public final boolean getTypeAliasesAllowed() {
        return this.typeAliasesAllowed;
    }

    @Override
    public final boolean isJvmPackageNameSupported() {
        return this.isJvmPackageNameSupported;
    }

    @Override
    public final boolean getReadDeserializedContracts() {
        return this.readDeserializedContracts;
    }
}

