/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.SupertypeLoopChecker;
import org.jetbrains.kotlin.resolve.FindLoopsInSupertypes;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.utils.DFS;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JR\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\f0\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/SupertypeLoopCheckerImpl;", "Lorg/jetbrains/kotlin/descriptors/SupertypeLoopChecker;", "<init>", "()V", "findLoopsInSupertypesAndDisconnect", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "currentTypeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "superTypes", "neighbors", "Lkotlin/Function1;", "", "reportLoop", "", "frontend"})
@SourceDebugExtension(value={"SMAP\nfindLoopsInSupertypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 findLoopsInSupertypes.kt\norg/jetbrains/kotlin/resolve/SupertypeLoopCheckerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1563#2:76\n1634#2,3:77\n*S KotlinDebug\n*F\n+ 1 findLoopsInSupertypes.kt\norg/jetbrains/kotlin/resolve/SupertypeLoopCheckerImpl\n*L\n35#1:76\n35#1:77,3\n*E\n"})
public final class SupertypeLoopCheckerImpl
implements SupertypeLoopChecker {
    @Override
    @NotNull
    public Collection<KotlinType> findLoopsInSupertypesAndDisconnect(@NotNull TypeConstructor currentTypeConstructor, @NotNull Collection<? extends KotlinType> superTypes, @NotNull Function1<? super TypeConstructor, ? extends Iterable<? extends KotlinType>> neighbors2, @NotNull Function1<? super KotlinType, Unit> reportLoop) {
        Intrinsics.checkNotNullParameter((Object)currentTypeConstructor, (String)"currentTypeConstructor");
        Intrinsics.checkNotNullParameter(superTypes, (String)"superTypes");
        Intrinsics.checkNotNullParameter(neighbors2, (String)"neighbors");
        Intrinsics.checkNotNullParameter(reportLoop, (String)"reportLoop");
        DFS.Neighbors graph = arg_0 -> SupertypeLoopCheckerImpl.findLoopsInSupertypesAndDisconnect$lambda$1(neighbors2, arg_0);
        SmartList superTypesToRemove = new SmartList();
        for (KotlinType superType : superTypes) {
            ClassifierDescriptor it;
            if (!FindLoopsInSupertypes.access$isReachable(superType.getConstructor(), currentTypeConstructor, graph)) continue;
            superTypesToRemove.add((Object)superType);
            reportLoop.invoke((Object)superType);
            if (currentTypeConstructor.getDeclarationDescriptor() == null) continue;
            boolean bl = false;
            if (!DescriptorUtilsKt.isCompanionObject(it)) continue;
            SimpleType simpleType = it.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
            reportLoop.invoke((Object)simpleType);
        }
        return superTypesToRemove.isEmpty() ? superTypes : (Collection)CollectionsKt.minus((Iterable)superTypes, (Iterable)((Iterable)superTypesToRemove));
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable findLoopsInSupertypesAndDisconnect$lambda$1(Function1 $neighbors, TypeConstructor node) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)node);
        Iterable $this$map$iv = (Iterable)$neighbors.invoke((Object)node);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getConstructor());
        }
        return (List)destination$iv$iv;
    }
}

