/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.org.objectweb.asm.Type;

public class AsmTypes {
    private static final Map<Class<?>, Type> TYPES_MAP = new ConcurrentHashMap();
    public static final Type OBJECT_TYPE = AsmTypes.getType(Object.class);
    public static final Type JAVA_STRING_TYPE = AsmTypes.getType(String.class);
    public static final Type JAVA_THROWABLE_TYPE = AsmTypes.getType(Throwable.class);
    public static final Type JAVA_CLASS_TYPE = AsmTypes.getType(Class.class);
    public static final Type JAVA_CLASS_ARRAY_TYPE = Type.getObjectType((String)("[" + JAVA_CLASS_TYPE.getDescriptor()));
    public static final Type ENUM_TYPE = AsmTypes.getType(Enum.class);
    public static final Type NUMBER_TYPE = AsmTypes.getType(Number.class);
    public static final Type BOOLEAN_WRAPPER_TYPE = AsmTypes.getType(Boolean.class);
    public static final Type CHARACTER_WRAPPER_TYPE = AsmTypes.getType(Character.class);
    public static final Type VOID_WRAPPER_TYPE = AsmTypes.getType(Void.class);
    public static final Type UNIT_TYPE = Type.getObjectType((String)"kotlin/Unit");
    public static final Type FUNCTION_REFERENCE = Type.getObjectType((String)"kotlin/jvm/internal/FunctionReference");
    public static final Type FUNCTION_REFERENCE_IMPL = Type.getObjectType((String)"kotlin/jvm/internal/FunctionReferenceImpl");
    public static final Type PROPERTY_REFERENCE0 = Type.getObjectType((String)"kotlin/jvm/internal/PropertyReference0");
    public static final Type PROPERTY_REFERENCE1 = Type.getObjectType((String)"kotlin/jvm/internal/PropertyReference1");
    public static final Type PROPERTY_REFERENCE2 = Type.getObjectType((String)"kotlin/jvm/internal/PropertyReference2");
    public static final Type MUTABLE_PROPERTY_REFERENCE0 = Type.getObjectType((String)"kotlin/jvm/internal/MutablePropertyReference0");
    public static final Type MUTABLE_PROPERTY_REFERENCE1 = Type.getObjectType((String)"kotlin/jvm/internal/MutablePropertyReference1");
    public static final Type MUTABLE_PROPERTY_REFERENCE2 = Type.getObjectType((String)"kotlin/jvm/internal/MutablePropertyReference2");
    public static final Type FUNCTION1 = Type.getObjectType((String)"kotlin/jvm/functions/Function1");
    public static final Type[] PROPERTY_REFERENCE_IMPL = new Type[]{Type.getObjectType((String)"kotlin/jvm/internal/PropertyReference0Impl"), Type.getObjectType((String)"kotlin/jvm/internal/PropertyReference1Impl"), Type.getObjectType((String)"kotlin/jvm/internal/PropertyReference2Impl")};
    public static final Type[] MUTABLE_PROPERTY_REFERENCE_IMPL = new Type[]{Type.getObjectType((String)"kotlin/jvm/internal/MutablePropertyReference0Impl"), Type.getObjectType((String)"kotlin/jvm/internal/MutablePropertyReference1Impl"), Type.getObjectType((String)"kotlin/jvm/internal/MutablePropertyReference2Impl")};
    public static final Type K_CLASS_TYPE = AsmTypes.reflect("KClass");
    public static final Type K_CLASS_ARRAY_TYPE = Type.getObjectType((String)("[" + K_CLASS_TYPE.getDescriptor()));
    public static final Type K_CLASSIFIER_TYPE = AsmTypes.reflect("KClassifier");
    public static final Type K_TYPE = AsmTypes.reflect("KType");
    public static final Type K_TYPE_PROJECTION = AsmTypes.reflect("KTypeProjection");
    public static final Type K_TYPE_PROJECTION_COMPANION = AsmTypes.reflect("KTypeProjection$Companion");
    public static final Type K_TYPE_PARAMETER = AsmTypes.reflect("KTypeParameter");
    public static final Type K_VARIANCE = AsmTypes.reflect("KVariance");
    public static final Type SUSPEND_FUNCTION_TYPE = Type.getObjectType((String)"kotlin/coroutines/jvm/internal/SuspendFunction");
    public static final String REFLECTION = "kotlin/jvm/internal/Reflection";
    private static final String REF_TYPE_PREFIX = "kotlin/jvm/internal/Ref$";
    public static final Type OBJECT_REF_TYPE = Type.getObjectType((String)"kotlin/jvm/internal/Ref$ObjectRef");
    public static final Type DEFAULT_CONSTRUCTOR_MARKER = Type.getObjectType((String)"kotlin/jvm/internal/DefaultConstructorMarker");
    public static final Type ENUM_ENTRIES = Type.getObjectType((String)"kotlin/enums/EnumEntries");
    public static final List<Type> OPTIMIZED_PROPERTY_REFERENCE_SUPERTYPES = CollectionsKt.flatten(Arrays.asList(Arrays.asList(PROPERTY_REFERENCE_IMPL), Arrays.asList(MUTABLE_PROPERTY_REFERENCE_IMPL)));

    @NotNull
    private static Type reflect(@NotNull String className) {
        if (className == null) {
            AsmTypes.$$$reportNull$$$0(0);
        }
        Type type = Type.getObjectType((String)("kotlin/reflect/" + className));
        if (type == null) {
            AsmTypes.$$$reportNull$$$0(1);
        }
        return type;
    }

    public static boolean isSharedVarType(@NotNull Type type) {
        if (type == null) {
            AsmTypes.$$$reportNull$$$0(2);
        }
        return type.getSort() == 10 && type.getInternalName().startsWith(REF_TYPE_PREFIX);
    }

    @NotNull
    public static Type sharedTypeForPrimitive(@NotNull PrimitiveType primitiveType) {
        if (primitiveType == null) {
            AsmTypes.$$$reportNull$$$0(3);
        }
        String typeName = primitiveType.getTypeName().getIdentifier();
        Type type = Type.getObjectType((String)(REF_TYPE_PREFIX + typeName + "Ref"));
        if (type == null) {
            AsmTypes.$$$reportNull$$$0(4);
        }
        return type;
    }

    @NotNull
    public static Type valueTypeForPrimitive(PrimitiveType primitiveType) {
        switch (primitiveType) {
            case BOOLEAN: {
                Type type = Type.BOOLEAN_TYPE;
                if (type == null) {
                    AsmTypes.$$$reportNull$$$0(5);
                }
                return type;
            }
            case CHAR: {
                Type type = Type.CHAR_TYPE;
                if (type == null) {
                    AsmTypes.$$$reportNull$$$0(6);
                }
                return type;
            }
            case BYTE: {
                Type type = Type.BYTE_TYPE;
                if (type == null) {
                    AsmTypes.$$$reportNull$$$0(7);
                }
                return type;
            }
            case SHORT: {
                Type type = Type.SHORT_TYPE;
                if (type == null) {
                    AsmTypes.$$$reportNull$$$0(8);
                }
                return type;
            }
            case INT: {
                Type type = Type.INT_TYPE;
                if (type == null) {
                    AsmTypes.$$$reportNull$$$0(9);
                }
                return type;
            }
            case FLOAT: {
                Type type = Type.FLOAT_TYPE;
                if (type == null) {
                    AsmTypes.$$$reportNull$$$0(10);
                }
                return type;
            }
            case LONG: {
                Type type = Type.LONG_TYPE;
                if (type == null) {
                    AsmTypes.$$$reportNull$$$0(11);
                }
                return type;
            }
            case DOUBLE: {
                Type type = Type.DOUBLE_TYPE;
                if (type == null) {
                    AsmTypes.$$$reportNull$$$0(12);
                }
                return type;
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static Type getType(@NotNull Class<?> javaClass) {
        if (javaClass == null) {
            AsmTypes.$$$reportNull$$$0(13);
        }
        Type type = TYPES_MAP.computeIfAbsent(javaClass, k -> Type.getType((Class)javaClass));
        if (type == null) {
            AsmTypes.$$$reportNull$$$0(14);
        }
        return type;
    }

    private AsmTypes() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/jvm/AsmTypes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitiveType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/jvm/AsmTypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "reflect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "sharedTypeForPrimitive";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "valueTypeForPrimitive";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reflect";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSharedVarType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sharedTypeForPrimitive";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

