/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.core.ui.impl;

import com.intellij.debugger.streams.core.trace.CollectionTreeBuilder;
import com.intellij.debugger.streams.core.trace.DebuggerCommandLauncher;
import com.intellij.debugger.streams.core.trace.TraceElement;
import com.intellij.debugger.streams.core.ui.impl.CollectionTree;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/debugger/streams/core/ui/impl/IntermediateTree;", "Lcom/intellij/debugger/streams/core/ui/impl/CollectionTree;", "traceElements", "", "Lcom/intellij/debugger/streams/core/trace/TraceElement;", "launcher", "Lcom/intellij/debugger/streams/core/trace/DebuggerCommandLauncher;", "myBuilder", "Lcom/intellij/debugger/streams/core/trace/CollectionTreeBuilder;", "debugName", "", "<init>", "(Ljava/util/List;Lcom/intellij/debugger/streams/core/trace/DebuggerCommandLauncher;Lcom/intellij/debugger/streams/core/trace/CollectionTreeBuilder;Ljava/lang/String;)V", "myXValue2TraceElement", "", "Lcom/intellij/xdebugger/frame/XValueContainer;", "itemsCount", "", "getItemsCount", "MyTraceElementsRoot", "intellij.debugger.streams.core"})
public final class IntermediateTree
extends CollectionTree {
    @NotNull
    private final CollectionTreeBuilder myBuilder;
    @NotNull
    private final Map<XValueContainer, TraceElement> myXValue2TraceElement;
    private final int itemsCount;

    public IntermediateTree(final @NotNull List<? extends TraceElement> traceElements, @NotNull DebuggerCommandLauncher launcher, @NotNull CollectionTreeBuilder myBuilder, @NotNull String debugName) {
        Intrinsics.checkNotNullParameter(traceElements, (String)"traceElements");
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)myBuilder, (String)"myBuilder");
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        super(traceElements, launcher, myBuilder, debugName);
        this.myBuilder = myBuilder;
        this.myXValue2TraceElement = new HashMap();
        this.itemsCount = traceElements.size();
        XValueNodeImpl root = new XValueNodeImpl((XDebuggerTree)this, null, "root", (XValue)new MyTraceElementsRoot(traceElements, launcher));
        this.setRoot((XDebuggerTreeNode)root, false);
        root.setLeaf(false);
        this.addTreeListener(new XDebuggerTreeListener(){

            public void nodeLoaded(RestorableStateNode node, String name) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                XDebuggerTreeListener listener = this;
                if (node instanceof XValueContainerNode) {
                    XValueContainer xValueContainer = ((XValueContainerNode)node).getValueContainer();
                    Intrinsics.checkNotNullExpressionValue((Object)xValueContainer, (String)"getValueContainer(...)");
                    XValueContainer container = xValueContainer;
                    if (myBuilder.isSupported(container)) {
                        ApplicationManager.getApplication().invokeLater(() -> 1.nodeLoaded$lambda$1(this, container, node, traceElements, listener));
                    }
                }
            }

            private static final void nodeLoaded$lambda$1$lambda$0(IntermediateTree this$0) {
                this$0.repaint();
            }

            private static final void nodeLoaded$lambda$1(IntermediateTree this$0, XValueContainer $container, RestorableStateNode $node, List $traceElements, XDebuggerTreeListener $listener) {
                TraceElement element = (TraceElement)this$0.myXValue2TraceElement.get($container);
                if (element != null) {
                    Map map = this$0.myValue2Path;
                    Intrinsics.checkNotNullExpressionValue((Object)map, (String)"myValue2Path");
                    Map map2 = map;
                    TreePath treePath = ((XDebuggerTreeNode)$node).getPath();
                    map2.put(element, treePath);
                    Map map3 = this$0.myPath2Value;
                    Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"myPath2Value");
                    map2 = map3;
                    map2.put(((XDebuggerTreeNode)$node).getPath(), element);
                }
                if (this$0.myPath2Value.size() == $traceElements.size()) {
                    this$0.myXValue2TraceElement.clear();
                    this$0.removeTreeListener($listener);
                    ApplicationManager.getApplication().invokeLater(() -> 1.nodeLoaded$lambda$1$lambda$0(this$0));
                }
            }
        });
    }

    @Override
    public int getItemsCount() {
        return this.itemsCount;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/debugger/streams/core/ui/impl/IntermediateTree$MyTraceElementsRoot;", "Lcom/intellij/xdebugger/frame/XValue;", "myTraceElements", "", "Lcom/intellij/debugger/streams/core/trace/TraceElement;", "myDebuggerCommandLauncher", "Lcom/intellij/debugger/streams/core/trace/DebuggerCommandLauncher;", "<init>", "(Lcom/intellij/debugger/streams/core/ui/impl/IntermediateTree;Ljava/util/List;Lcom/intellij/debugger/streams/core/trace/DebuggerCommandLauncher;)V", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "computePresentation", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "intellij.debugger.streams.core"})
    private final class MyTraceElementsRoot
    extends XValue {
        @NotNull
        private final List<TraceElement> myTraceElements;
        @NotNull
        private final DebuggerCommandLauncher myDebuggerCommandLauncher;

        public MyTraceElementsRoot(@NotNull List<? extends TraceElement> myTraceElements, DebuggerCommandLauncher myDebuggerCommandLauncher) {
            Intrinsics.checkNotNullParameter(myTraceElements, (String)"myTraceElements");
            Intrinsics.checkNotNullParameter((Object)myDebuggerCommandLauncher, (String)"myDebuggerCommandLauncher");
            this.myTraceElements = myTraceElements;
            this.myDebuggerCommandLauncher = myDebuggerCommandLauncher;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            XValueChildrenList children = new XValueChildrenList();
            for (TraceElement value : this.myTraceElements) {
                XNamedValue namedValue = IntermediateTree.this.myBuilder.createXNamedValue(value.getValue(), this.myDebuggerCommandLauncher);
                IntermediateTree.this.myXValue2TraceElement.put(namedValue, value);
                children.add(namedValue);
            }
            node.addChildren(children, true);
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            node.setPresentation(null, "", "", true);
        }
    }
}

