/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.impl;

import com.intellij.diagnostic.hprof.parser.ConstantPoolEntry;
import com.intellij.diagnostic.hprof.parser.HProfEventBasedParser;
import com.intellij.diagnostic.hprof.parser.InstanceFieldEntry;
import com.intellij.diagnostic.hprof.parser.StaticFieldEntry;
import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.hprof.api.MuiType;
import com.intellij.profiler.ultimate.hprof.api.MuiUtils;
import com.intellij.profiler.ultimate.hprof.impl.HprofDump;
import com.intellij.profiler.ultimate.hprof.impl.HprofField;
import com.intellij.profiler.ultimate.hprof.impl.HprofObject;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001Bw\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001cR\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\u001e\u0010\u001fR\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\n\n\u0002\u0010#\u001a\u0004\b!\u0010\"R\u001a\u0010\u000f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0016\"\u0004\b%\u0010&R\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0016R\u0014\u00100\u001a\u0002018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u0002058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0016R\u0016\u0010:\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010(R\u001a\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0014\u0010@\u001a\u00020AX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010BR\u001d\u0010C\u001a\u0004\u0018\u00010\u00008VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bF\u0010G\u001a\u0004\bD\u0010ER\u0013\u0010H\u001a\u0004\u0018\u00010I\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010K\u00a8\u0006L"}, d2={"Lcom/intellij/profiler/ultimate/hprof/impl/HprofClass;", "Lcom/intellij/profiler/ultimate/hprof/api/MuiType;", "classId", "", "stackTraceSerialNumber", "superClassId", "classloaderClassId", "instanceSize", "constants", "", "Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;", "softRefCount", "retainedSize_", "dump", "Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;", "<init>", "(JJJJJ[Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;[Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;[Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;JLjava/lang/Long;Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;)V", "getClassId", "()J", "getStackTraceSerialNumber", "getSuperClassId", "getClassloaderClassId", "getInstanceSize", "getConstants", "()[Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;", "[Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;", "getStaticFields", "()[Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;", "[Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;", "getInstanceFields", "()[Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;", "[Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;", "getSoftRefCount", "setSoftRefCount", "(J)V", "getRetainedSize_", "()Ljava/lang/Long;", "setRetainedSize_", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "getDump", "()Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;", "id", "getId", "name", "", "getName", "()Ljava/lang/String;", "instanceCount", "", "getInstanceCount", "()I", "totalSize", "getTotalSize", "retainedSize", "getRetainedSize", "fields", "Lcom/intellij/profiler/ultimate/hprof/impl/HprofField;", "getFields", "()[Lcom/intellij/profiler/ultimate/hprof/impl/HprofField;", "isArray", "", "()Z", "supertype", "getSupertype", "()Lcom/intellij/profiler/ultimate/hprof/impl/HprofClass;", "supertype$delegate", "Lkotlin/Lazy;", "arrayLengths", "Lit/unimi/dsi/fastutil/ints/Int2IntOpenHashMap;", "getArrayLengths", "()Lit/unimi/dsi/fastutil/ints/Int2IntOpenHashMap;", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nHprofClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HprofClass.kt\ncom/intellij/profiler/ultimate/hprof/impl/HprofClass\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,66:1\n3829#2:67\n4344#2,2:68\n11228#2:80\n11563#2,3:81\n1563#3:70\n1634#3,3:71\n1208#3,2:74\n1236#3,4:76\n37#4:84\n36#4,3:85\n*S KotlinDebug\n*F\n+ 1 HprofClass.kt\ncom/intellij/profiler/ultimate/hprof/impl/HprofClass\n*L\n38#1:67\n38#1:68,2\n45#1:80\n45#1:81,3\n38#1:70\n38#1:71,3\n41#1:74,2\n41#1:76,4\n59#1:84\n59#1:85,3\n*E\n"})
public final class HprofClass
implements MuiType {
    private final long classId;
    private final long stackTraceSerialNumber;
    private final long superClassId;
    private final long classloaderClassId;
    private final long instanceSize;
    @NotNull
    private final ConstantPoolEntry[] constants;
    @NotNull
    private final StaticFieldEntry[] staticFields;
    @NotNull
    private final InstanceFieldEntry[] instanceFields;
    private long softRefCount;
    @Nullable
    private Long retainedSize_;
    @NotNull
    private final HprofDump dump;
    private final boolean isArray;
    @NotNull
    private final Lazy supertype$delegate;
    @Nullable
    private final Int2IntOpenHashMap arrayLengths;

    public HprofClass(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields, long softRefCount, @Nullable Long retainedSize_, @NotNull HprofDump dump) {
        Intrinsics.checkNotNullParameter((Object)constants, (String)"constants");
        Intrinsics.checkNotNullParameter((Object)staticFields, (String)"staticFields");
        Intrinsics.checkNotNullParameter((Object)instanceFields, (String)"instanceFields");
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        this.classId = classId;
        this.stackTraceSerialNumber = stackTraceSerialNumber;
        this.superClassId = superClassId;
        this.classloaderClassId = classloaderClassId;
        this.instanceSize = instanceSize;
        this.constants = constants;
        this.staticFields = staticFields;
        this.instanceFields = instanceFields;
        this.softRefCount = softRefCount;
        this.retainedSize_ = retainedSize_;
        this.dump = dump;
        String string = this.dump.getClasses().getClassString(this.classId);
        this.isArray = string != null ? StringsKt.startsWith$default((CharSequence)string, (char)'[', (boolean)false, (int)2, null) : false;
        this.supertype$delegate = LazyKt.lazy(() -> HprofClass.supertype_delegate$lambda$5(this));
        this.arrayLengths = this.isArray() ? new Int2IntOpenHashMap() : null;
    }

    public /* synthetic */ HprofClass(long l, long l2, long l3, long l4, long l5, ConstantPoolEntry[] constantPoolEntryArray, StaticFieldEntry[] staticFieldEntryArray, InstanceFieldEntry[] instanceFieldEntryArray, long l6, Long l7, HprofDump hprofDump, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            l6 = 0L;
        }
        if ((n & 0x200) != 0) {
            l7 = null;
        }
        this(l, l2, l3, l4, l5, constantPoolEntryArray, staticFieldEntryArray, instanceFieldEntryArray, l6, l7, hprofDump);
    }

    public final long getClassId() {
        return this.classId;
    }

    public final long getStackTraceSerialNumber() {
        return this.stackTraceSerialNumber;
    }

    public final long getSuperClassId() {
        return this.superClassId;
    }

    public final long getClassloaderClassId() {
        return this.classloaderClassId;
    }

    @Override
    public long getInstanceSize() {
        return this.instanceSize;
    }

    @NotNull
    public final ConstantPoolEntry[] getConstants() {
        return this.constants;
    }

    @NotNull
    public final StaticFieldEntry[] getStaticFields() {
        return this.staticFields;
    }

    @NotNull
    public final InstanceFieldEntry[] getInstanceFields() {
        return this.instanceFields;
    }

    public final long getSoftRefCount() {
        return this.softRefCount;
    }

    public final void setSoftRefCount(long l) {
        this.softRefCount = l;
    }

    @Nullable
    public final Long getRetainedSize_() {
        return this.retainedSize_;
    }

    public final void setRetainedSize_(@Nullable Long l) {
        this.retainedSize_ = l;
    }

    @NotNull
    public final HprofDump getDump() {
        return this.dump;
    }

    @Override
    public long getId() {
        return this.classId;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.dump.getClasses().getPrettyName(this.classId);
        if (string == null) {
            string = "n/a";
        }
        return string;
    }

    @Override
    public int getInstanceCount() {
        return (int)this.softRefCount;
    }

    @Override
    public long getTotalSize() {
        return this.dump.getTotalSize(this.classId);
    }

    @Override
    @Nullable
    public Long getRetainedSize() {
        return this.dump.isRetainedSizeCalculated() ? this.retainedSize_ : null;
    }

    @NotNull
    public HprofField[] getFields() {
        return (HprofField[])this.dump.runParser(arg_0 -> HprofClass._get_fields_$lambda$4(this, arg_0));
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }

    @Override
    @Nullable
    public HprofClass getSupertype() {
        Lazy lazy = this.supertype$delegate;
        return (HprofClass)lazy.getValue();
    }

    @Nullable
    public final Int2IntOpenHashMap getArrayLengths() {
        return this.arrayLengths;
    }

    /*
     * WARNING - void declaration
     */
    private static final HprofField[] _get_fields_$lambda$4(HprofClass this$0, HProfEventBasedParser $this$runParser) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Object object;
        Object objects;
        Iterable it;
        Object object2;
        void $this$mapTo$iv$iv2;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$runParser, (String)"$this$runParser");
        StaticFieldEntry[] $this$filter$iv = this$0.staticFields;
        boolean $i$f$filter = false;
        StaticFieldEntry[] staticFieldEntryArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (StaticFieldEntry element$iv$iv : $this$filterTo$iv$iv) {
            void it2 = element$iv$iv;
            boolean bl = false;
            if (!(it2.getType() == Type.OBJECT && it2.getValue() > 0L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            StaticFieldEntry element$iv$iv;
            element$iv$iv = (StaticFieldEntry)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object2.add(it.getValue());
        }
        List objectToLoad = (List)destination$iv$iv;
        if (!((Collection)objectToLoad).isEmpty()) {
            void $this$associateByTo$iv$iv;
            long position = $this$runParser.getBuffer().position();
            Iterable $this$associateBy$iv = ArraysKt.filterIsInstance((Object[])MuiUtils.collectObjects$default(this$0.dump, CollectionsKt.toLongArray((Collection)objectToLoad), 0, 0, 6, null), HprofObject.class);
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            it = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it3;
                HprofObject hprofObject = (HprofObject)element$iv$iv;
                object2 = destination$iv$iv2;
                boolean bl = false;
                object2.put(it3.getId(), element$iv$iv);
            }
            objects = destination$iv$iv2;
            $this$runParser.getBuffer().position(position);
            object = objects;
        } else {
            object = MapsKt.emptyMap();
        }
        Object objects2 = object;
        Object $this$map$iv2 = this$0.staticFields;
        boolean $i$f$map2 = false;
        objects = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(((StaticFieldEntry[])$this$map$iv2).length);
        boolean $i$f$mapTo2 = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it4;
            void item$iv$iv;
            void $i$f$associateByTo = item$iv$iv = $this$mapTo$iv$iv[i];
            object2 = destination$iv$iv3;
            boolean bl = false;
            String string = this$0.dump.getClasses().getObjectString(it4.getFieldNameStringId());
            if (string == null) {
                string = UltimateProfilerBundleKt.profilerMessage("hprof.stub.unknown", new Object[0]);
            }
            Type type = it4.getType();
            object2.add(new HprofField(string, type, switch (WhenMappings.$EnumSwitchMapping$0[it4.getType().ordinal()]) {
                case 1 -> objects2.get(it4.getValue());
                case 2 -> Boolean.valueOf(it4.getValue() > 0L);
                case 3 -> Character.valueOf((char)it4.getValue());
                case 4 -> Float.valueOf(Float.intBitsToFloat((int)it4.getValue()));
                case 5 -> Double.longBitsToDouble(it4.getValue());
                case 6 -> (byte)it4.getValue();
                case 7 -> (short)it4.getValue();
                case 8 -> (int)it4.getValue();
                case 9 -> it4.getValue();
                default -> null;
            }, true));
        }
        $this$map$iv2 = (List)destination$iv$iv3;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new HprofField[0]);
    }

    private static final HprofClass supertype_delegate$lambda$5(HprofClass this$0) {
        return this$0.dump.getClasses().get(this$0.superClassId);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.BOOLEAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.CHAR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.FLOAT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.DOUBLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.BYTE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.SHORT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.INT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.LONG.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

