/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.core.resolve;

import com.intellij.debugger.streams.core.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.core.trace.TraceElement;
import com.intellij.debugger.streams.core.trace.TraceInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/debugger/streams/core/resolve/ChunkedResolver;", "Lcom/intellij/debugger/streams/core/resolve/ValuesOrderResolver;", "<init>", "()V", "resolve", "Lcom/intellij/debugger/streams/core/resolve/ValuesOrderResolver$Result;", "info", "Lcom/intellij/debugger/streams/core/trace/TraceInfo;", "intellij.debugger.streams.core"})
@SourceDebugExtension(value={"SMAP\nChunkedResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkedResolver.kt\ncom/intellij/debugger/streams/core/resolve/ChunkedResolver\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n37#2:35\n36#2,3:36\n37#2:39\n36#2,3:40\n1563#3:43\n1634#3,3:44\n1869#3,2:47\n*S KotlinDebug\n*F\n+ 1 ChunkedResolver.kt\ncom/intellij/debugger/streams/core/resolve/ChunkedResolver\n*L\n12#1:35\n12#1:36,3\n13#1:39\n13#1:40,3\n27#1:43\n27#1:44,3\n28#1:47,2\n*E\n"})
public final class ChunkedResolver
implements ValuesOrderResolver {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Map<Integer, TraceElement> map = info.getValuesOrderBefore();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getValuesOrderBefore(...)");
        Map<Integer, TraceElement> beforeIndex = map;
        Map<Integer, TraceElement> map2 = info.getValuesOrderAfter();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getValuesOrderAfter(...)");
        Map<Integer, TraceElement> afterIndex = map2;
        Map invertedOrder = new LinkedHashMap();
        Collection $this$toTypedArray$iv = CollectionsKt.sorted((Iterable)beforeIndex.keySet());
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Integer[] beforeTimes = thisCollection$iv.toArray(new Integer[0]);
        Collection $this$toTypedArray$iv2 = CollectionsKt.sorted((Iterable)afterIndex.keySet());
        int $i$f$toTypedArray2 = 0;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        Integer[] afterTimes = thisCollection$iv2.toArray(new Integer[0]);
        int beforeIx = 0;
        for (Integer afterTime : afterTimes) {
            while (beforeIx < beforeTimes.length && beforeTimes[beforeIx] < afterTime) {
                Integer n = beforeTimes[beforeIx];
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
                invertedOrder.computeIfAbsent(afterTime, arg_0 -> ChunkedResolver.resolve$lambda$1(ChunkedResolver::resolve$lambda$0, arg_0)).add(n);
                ++beforeIx;
            }
        }
        Map direct = new LinkedHashMap();
        Map reverse = new LinkedHashMap();
        for (Map.Entry<Integer, TraceElement> entry : afterIndex.entrySet()) {
            void $this$mapTo$iv$iv;
            Integer timeAfter = entry.getKey();
            TraceElement elementAfter = entry.getValue();
            List list = (List)invertedOrder.get(timeAfter);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List before = list;
            Iterable $this$map$iv = before;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                int n = ((Number)item$iv$iv).intValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                TraceElement traceElement = beforeIndex.get((int)it);
                Intrinsics.checkNotNull((Object)traceElement);
                collection.add(traceElement);
            }
            List beforeElements = (List)destination$iv$iv;
            Iterable $this$forEach$iv = beforeElements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TraceElement it = (TraceElement)element$iv;
                boolean bl = false;
                direct.put(it, CollectionsKt.listOf((Object)elementAfter));
            }
            reverse.put(elementAfter, beforeElements);
        }
        ValuesOrderResolver.Result result = ValuesOrderResolver.Result.of(direct, reverse);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"of(...)");
        return result;
    }

    private static final List resolve$lambda$0(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List resolve$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

