/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.assemble;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.theme.LegendTheme;
import org.jetbrains.letsPlot.core.plot.builder.assemble.ColorBarAssembler;
import org.jetbrains.letsPlot.core.plot.builder.assemble.ColorBarOptions;
import org.jetbrains.letsPlot.core.plot.builder.assemble.GuideKey;
import org.jetbrains.letsPlot.core.plot.builder.assemble.GuideOptionsList;
import org.jetbrains.letsPlot.core.plot.builder.assemble.tiles.GeomLayerInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bJ>\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u0016\u001a\u00020\u00172\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bJ,\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotGuidesAssemblerUtil;", "", "()V", "checkFitsColorBar", "", "aes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "scale", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "createColorBarAssembler", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/ColorBarAssembler;", "scaleName", "", "transformedDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "scaleMapper", "Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "Lorg/jetbrains/letsPlot/commons/values/Color;", "options", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/ColorBarOptions;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "fitsColorBar", "", "mappedRenderedAesToCreateGuides", "", "layer", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/tiles/GeomLayerInfo;", "guideOptionsMap", "", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/GuideKey;", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/GuideOptionsList;", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPlotGuidesAssemblerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotGuidesAssemblerUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PlotGuidesAssemblerUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class PlotGuidesAssemblerUtil {
    @NotNull
    public static final PlotGuidesAssemblerUtil INSTANCE = new PlotGuidesAssemblerUtil();

    private PlotGuidesAssemblerUtil() {
    }

    @NotNull
    public final List<Aes<?>> mappedRenderedAesToCreateGuides(@NotNull GeomLayerInfo layer, @NotNull Map<GuideKey, GuideOptionsList> guideOptionsMap) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter(guideOptionsMap, (String)"guideOptionsMap");
        if (layer.isLegendDisabled()) {
            return CollectionsKt.emptyList();
        }
        ArrayList result2 = new ArrayList();
        for (Aes<?> aes2 : layer.renderedAes()) {
            if (Aes.Companion.noGuideNeeded(aes2) || layer.hasConstant(aes2) || !layer.hasBinding(aes2)) continue;
            GuideOptionsList guideOptionsList = guideOptionsMap.get(GuideKey.Companion.fromAes(aes2));
            if (guideOptionsList != null ? guideOptionsList.hasNone() : false) continue;
            result2.add(aes2);
        }
        return result2;
    }

    @NotNull
    public final ColorBarAssembler createColorBarAssembler(@NotNull String scaleName, @NotNull DoubleSpan transformedDomain, @NotNull Scale scale, @NotNull ScaleMapper<Color> scaleMapper2, @Nullable ColorBarOptions options, @NotNull LegendTheme theme) {
        Intrinsics.checkNotNullParameter((Object)scaleName, (String)"scaleName");
        Intrinsics.checkNotNullParameter((Object)transformedDomain, (String)"transformedDomain");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter(scaleMapper2, (String)"scaleMapper");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        return new ColorBarAssembler(scaleName, transformedDomain, scale, scaleMapper2, theme, options);
    }

    public final boolean fitsColorBar(@NotNull Aes<?> aes2, @NotNull Scale scale) {
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        return aes2.isColor() && scale.isContinuous();
    }

    public final void checkFitsColorBar(@NotNull Aes<?> aes2, @NotNull Scale scale) {
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        if (!aes2.isColor()) {
            boolean $i$a$-check-PlotGuidesAssemblerUtil$checkFitsColorBar$32 = false;
            String $i$a$-check-PlotGuidesAssemblerUtil$checkFitsColorBar$32 = "Color-bar is not applicable to " + aes2 + " aesthetic";
            throw new IllegalStateException($i$a$-check-PlotGuidesAssemblerUtil$checkFitsColorBar$32.toString());
        }
        if (!scale.isContinuous()) {
            boolean bl = false;
            String string = "Color-bar is only applicable when both domain and color palette are continuous";
            throw new IllegalStateException(string.toString());
        }
    }
}

