/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 86708728518958L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1928695050 + (char)-23421, 1928695050 + (char)-20979, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1928695050 + (char)-23422, 1928695050 + (char)-9058, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 32920446623461L;
                thread = Thread.currentThread();
                String[] stringArray = SshAgentIpcService.z();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (stringArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-477750150 - -((char)-26166), -477750150 - -((char)-24923), (int)l2) + string + WindowsNamedPipeAgentIpc.b(-477750150 - -((char)-26165), -477750150 - -((char)-7370), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-477750150 - -((char)-26168), 477750150 - 26365, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                String[] stringArray;
                l2 = 55151282986435L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    stringArray = SshAgentIpcService.z();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-392030370 + -8697, 392030370 + 28794, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-392030370 + -8696, 392030370 + 25911, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-392030370 + -8695, 392030370 + 25577, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (stringArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-392030370 + -8694, 392030370 + 19907, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-392030370 + -8693, -392030370 + -32398, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-392030370 + -8692, 392030370 + 23546, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-392030370 + -8694, 392030370 + 19907, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-392030370 + -8691, -392030370 + -29903, (int)l2));
            if (!ActionTimestamp.V()) {
                SshAgentIpcService.z(new String[1]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n;
        block8: {
            block7: {
                String[] stringArray;
                block6: {
                    long l2 = 100613289590760L;
                    stringArray = SshAgentIpcService.z();
                    try {
                        try {
                            n = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (stringArray != null) break block6;
                            if (n < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (stringArray != null) break block8;
                    if (n > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n = 1;
                break block8;
            }
            n = 0;
        }
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        block32: {
            boolean bl;
            block34: {
                block33: {
                    Object object;
                    Object object2;
                    String[] stringArray;
                    long l2;
                    block28: {
                        block29: {
                            l2 = 82040950078541L;
                            String[] stringArray2 = SshAgentIpcService.z();
                            this.assertConnectionThread();
                            stringArray = stringArray2;
                            Object object3 = this.lock;
                            synchronized (object3) {
                                boolean bl2;
                                NamedPipeState namedPipeState;
                                NamedPipeState namedPipeState2;
                                block26: {
                                    block27: {
                                        boolean bl3 = false;
                                        try {
                                            namedPipeState2 = this.state;
                                            namedPipeState = NamedPipeState.Closing;
                                            if (stringArray != null) break block26;
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block27;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                                        boolean bl4 = false;
                                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1515169200 + -((char)-31378), 1515169200 + (char)-31358, (int)l2));
                                        logger.info(WindowsNamedPipeAgentIpc.b(-1515169200 + -((char)-31382), 1515169200 + 29243, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1515169200 + -((char)-31379), 1515169200 + (char)-32313, (int)l2) + this.state);
                                        throw new ClosedChannelException();
                                    }
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Open;
                                }
                                try {
                                    bl2 = namedPipeState2 == namedPipeState;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl2) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(-1515169200 + -((char)-31382), 1515169200 + 29243, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1515169200 + -((char)-31376), 1515169200 + (char)-21802, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.state = NamedPipeState.Connecting;
                                Unit unit = Unit.INSTANCE;
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl6 = false;
                            try {
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1515169200 + -((char)-31378), 1515169200 + (char)-31358, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1515169200 + -((char)-31382), 1515169200 + 29243, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1515169200 + -((char)-31377), 1515169200 + (char)-27293, (int)l2));
                                object2 = Kernel32.INSTANCE;
                                if (stringArray != null) break block28;
                                if (object2.ConnectNamedPipe(this.hPipe, null)) break block29;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            int n = Kernel32.INSTANCE.GetLastError();
                            if (n == 535) {
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                                boolean bl7 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1515169200 + -((char)-31378), 1515169200 + (char)-31358, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1515169200 + -((char)-31382), 1515169200 + 29243, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1515169200 + -((char)-31406), 1515169200 + 30500, (int)l2));
                            } else {
                                throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1515169200 + -((char)-31382), 1515169200 + 29243, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1515169200 + -((char)-31407), 1515169200 + (char)-29157, (int)l2) + ErrorToolsKt.prettyHRESULT(n)).toString());
                            }
                        }
                        object2 = this.lock;
                    }
                    Kernel32 kernel32 = object2;
                    synchronized (kernel32) {
                        boolean bl8;
                        NamedPipeState namedPipeState;
                        NamedPipeState namedPipeState3;
                        block30: {
                            block31: {
                                boolean bl9 = false;
                                namedPipeState3 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (stringArray != null) break block30;
                                try {
                                    block35: {
                                        if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block31;
                                        break block35;
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                    }
                                    throw new ClosedChannelException();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                            }
                            namedPipeState3 = this.state;
                            namedPipeState = NamedPipeState.Connecting;
                        }
                        try {
                            bl8 = namedPipeState3 == namedPipeState;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        if (!bl8) {
                            boolean bl10 = false;
                            String string = WindowsNamedPipeAgentIpc.b(-1515169200 + -((char)-31382), 1515169200 + 29243, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1515169200 + -((char)-31376), 1515169200 + (char)-21802, (int)l2) + this.state;
                            throw new IllegalArgumentException(string.toString());
                        }
                        this.state = NamedPipeState.Connected;
                        object = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                    boolean bl11 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1515169200 + -((char)-31378), 1515169200 + (char)-31358, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1515169200 + -((char)-31382), 1515169200 + 29243, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1515169200 + -((char)-31404), -1515169200 + -((char)-14653), (int)l2));
                    long l3 = this.getRequesterPid();
                    this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
                    object = new PipeReadableByteChannel(this);
                    PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
                    try {
                        try {
                            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                                final /* synthetic */ PipeReadableByteChannel $read;
                                final /* synthetic */ PipeWritableByteChannel $write;
                                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                                private static final String[] a;
                                private static final String[] b;
                                {
                                    this.$read = $read;
                                    this.$write = $write;
                                    this.this$0 = $receiver;
                                }

                                public InputStream getInputStream() {
                                    long l2 = 67503847949684L;
                                    InputStream inputStream = Channels.newInputStream(this.$read);
                                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-153089760 - -((char)-26698), -153089760 - -((char)-17580), (int)l2));
                                    return inputStream;
                                }

                                public OutputStream getOutputStream() {
                                    long l2 = 104311662744461L;
                                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-208008090 - -((char)-5688), -208008090 - -((char)-19884), (int)l2));
                                    return outputStream;
                                }

                                public void close() {
                                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                static {
                                    block13: {
                                        var5 = new String[2];
                                        var3_1 = 0;
                                        var2_2 = ":[\n9\u009b\u00ecCo\u001c\u00fa\u001a\u00ed\u00c5\u00ff%\u00ed>\u00aa(\u0014O5\u00a4\u00f2UW\u00e7\u009d\n\u00a2\u001d2\u00e7\u00fd\u00a0&c\u0015\u0084\u00bb";
                                        var4_3 = ":[\n9\u009b\u00ecCo\u001c\u00fa\u001a\u00ed\u00c5\u00ff%\u00ed>\u00aa(\u0014O5\u00a4\u00f2UW\u00e7\u009d\n\u00a2\u001d2\u00e7\u00fd\u00a0&c\u0015\u0084\u00bb".length();
                                        var1_4 = 19;
                                        var0_5 = -1;
lbl7:
                                        // 2 sources

                                        while (true) {
                                            continue;
                                            break;
                                        }
lbl9:
                                        // 1 sources

                                        while (true) {
                                            var5[var3_1++] = new String(v0).intern();
                                            if ((var0_5 += var1_4) < var4_3) {
                                                var1_4 = var2_2.charAt(var0_5);
                                                ** continue;
                                            }
                                            break block13;
                                            break;
                                        }
                                        v1 = ++var0_5;
                                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                                        v3 = v2.length;
                                        var6_6 = 0;
                                        v4 = 29;
                                        v5 = v2;
                                        v6 = v3;
                                        if (v3 > 1) ** GOTO lbl67
                                        do {
                                            v7 = v4;
                                            v5 = v5;
                                            v8 = v5;
                                            v9 = v4;
                                            v10 = var6_6;
                                            while (true) {
                                                switch (var6_6 % 7) {
                                                    case 0: {
                                                        v11 = 75;
                                                        break;
                                                    }
                                                    case 1: {
                                                        v11 = 32;
                                                        break;
                                                    }
                                                    case 2: {
                                                        v11 = 78;
                                                        break;
                                                    }
                                                    case 3: {
                                                        v11 = 104;
                                                        break;
                                                    }
                                                    case 4: {
                                                        v11 = 90;
                                                        break;
                                                    }
                                                    case 5: {
                                                        v11 = 104;
                                                        break;
                                                    }
                                                    default: {
                                                        v11 = 19;
                                                    }
                                                }
                                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                                ++var6_6;
                                                v4 = v7;
                                                if (v7 != 0) break;
                                                v7 = v4;
                                                v5 = v5;
                                                v10 = v4;
                                                v8 = v5;
                                                v9 = v4;
                                            }
lbl67:
                                            // 2 sources

                                            v0 = v5;
                                            v6 = v6;
                                        } while (v6 > var6_6);
                                        ** while (true)
                                    }
                                    accept.3.a = var5;
                                    accept.3.b = new String[2];
                                }

                                private static String a(int n, int n2, int n3) {
                                    int n4 = (n ^ n3 ^ 0x65A2) & 0xFFFF;
                                    if (b[n4] == null) {
                                        int n5;
                                        char[] cArray = a[n4].toCharArray();
                                        int n6 = switch (cArray[0] & 0xFF) {
                                            case 0 -> 161;
                                            case 1 -> 180;
                                            case 2 -> 88;
                                            case 3 -> 123;
                                            case 4 -> 133;
                                            case 5 -> 134;
                                            case 6 -> 49;
                                            case 7 -> 97;
                                            case 8 -> 175;
                                            case 9 -> 185;
                                            case 10 -> 105;
                                            case 11 -> 22;
                                            case 12 -> 107;
                                            case 13 -> 95;
                                            case 14 -> 219;
                                            case 15 -> 225;
                                            case 16 -> 67;
                                            case 17 -> 68;
                                            case 18 -> 31;
                                            case 19 -> 116;
                                            case 20 -> 188;
                                            case 21 -> 158;
                                            case 22 -> 120;
                                            case 23 -> 152;
                                            case 24 -> 63;
                                            case 25 -> 192;
                                            case 26 -> 94;
                                            case 27 -> 227;
                                            case 28 -> 234;
                                            case 29 -> 7;
                                            case 30 -> 82;
                                            case 31 -> 142;
                                            case 32 -> 135;
                                            case 33 -> 147;
                                            case 34 -> 250;
                                            case 35 -> 163;
                                            case 36 -> 148;
                                            case 37 -> 240;
                                            case 38 -> 85;
                                            case 39 -> 253;
                                            case 40 -> 171;
                                            case 41 -> 47;
                                            case 42 -> 198;
                                            case 43 -> 155;
                                            case 44 -> 51;
                                            case 45 -> 74;
                                            case 46 -> 1;
                                            case 47 -> 37;
                                            case 48 -> 24;
                                            case 49 -> 242;
                                            case 50 -> 214;
                                            case 51 -> 78;
                                            case 52 -> 197;
                                            case 53 -> 11;
                                            case 54 -> 132;
                                            case 55 -> 46;
                                            case 56 -> 244;
                                            case 57 -> 29;
                                            case 58 -> 231;
                                            case 59 -> 20;
                                            case 60 -> 91;
                                            case 61 -> 248;
                                            case 62 -> 93;
                                            case 63 -> 19;
                                            case 64 -> 241;
                                            case 65 -> 201;
                                            case 66 -> 239;
                                            case 67 -> 217;
                                            case 68 -> 23;
                                            case 69 -> 26;
                                            case 70 -> 4;
                                            case 71 -> 220;
                                            case 72 -> 121;
                                            case 73 -> 237;
                                            case 74 -> 86;
                                            case 75 -> 222;
                                            case 76 -> 61;
                                            case 77 -> 65;
                                            case 78 -> 255;
                                            case 79 -> 12;
                                            case 80 -> 172;
                                            case 81 -> 187;
                                            case 82 -> 10;
                                            case 83 -> 52;
                                            case 84 -> 165;
                                            case 85 -> 55;
                                            case 86 -> 8;
                                            case 87 -> 28;
                                            case 88 -> 140;
                                            case 89 -> 34;
                                            case 90 -> 151;
                                            case 91 -> 126;
                                            case 92 -> 196;
                                            case 93 -> 205;
                                            case 94 -> 166;
                                            case 95 -> 79;
                                            case 96 -> 251;
                                            case 97 -> 35;
                                            case 98 -> 102;
                                            case 99 -> 154;
                                            case 100 -> 233;
                                            case 101 -> 221;
                                            case 102 -> 159;
                                            case 103 -> 160;
                                            case 104 -> 106;
                                            case 105 -> 66;
                                            case 106 -> 252;
                                            case 107 -> 124;
                                            case 108 -> 254;
                                            case 109 -> 112;
                                            case 110 -> 189;
                                            case 111 -> 17;
                                            case 112 -> 143;
                                            case 113 -> 108;
                                            case 114 -> 144;
                                            case 115 -> 38;
                                            case 116 -> 119;
                                            case 117 -> 183;
                                            case 118 -> 18;
                                            case 119 -> 32;
                                            case 120 -> 223;
                                            case 121 -> 90;
                                            case 122 -> 122;
                                            case 123 -> 80;
                                            case 124 -> 118;
                                            case 125 -> 191;
                                            case 126 -> 44;
                                            case 127 -> 73;
                                            case 128 -> 139;
                                            case 129 -> 176;
                                            case 130 -> 77;
                                            case 131 -> 89;
                                            case 132 -> 170;
                                            case 133 -> 162;
                                            case 134 -> 69;
                                            case 135 -> 186;
                                            case 136 -> 178;
                                            case 137 -> 174;
                                            case 138 -> 193;
                                            case 139 -> 33;
                                            case 140 -> 213;
                                            case 141 -> 36;
                                            case 142 -> 27;
                                            case 143 -> 212;
                                            case 144 -> 109;
                                            case 145 -> 164;
                                            case 146 -> 75;
                                            case 147 -> 130;
                                            case 148 -> 42;
                                            case 149 -> 50;
                                            case 150 -> 72;
                                            case 151 -> 100;
                                            case 152 -> 127;
                                            case 153 -> 101;
                                            case 154 -> 59;
                                            case 155 -> 141;
                                            case 156 -> 53;
                                            case 157 -> 111;
                                            case 158 -> 137;
                                            case 159 -> 246;
                                            case 160 -> 181;
                                            case 161 -> 136;
                                            case 162 -> 48;
                                            case 163 -> 195;
                                            case 164 -> 169;
                                            case 165 -> 25;
                                            case 166 -> 115;
                                            case 167 -> 210;
                                            case 168 -> 184;
                                            case 169 -> 96;
                                            case 170 -> 114;
                                            case 171 -> 146;
                                            case 172 -> 40;
                                            case 173 -> 16;
                                            case 174 -> 190;
                                            case 175 -> 131;
                                            case 176 -> 110;
                                            case 177 -> 236;
                                            case 178 -> 232;
                                            case 179 -> 167;
                                            case 180 -> 30;
                                            case 181 -> 128;
                                            case 182 -> 64;
                                            case 183 -> 208;
                                            case 184 -> 182;
                                            case 185 -> 200;
                                            case 186 -> 41;
                                            case 187 -> 54;
                                            case 188 -> 2;
                                            case 189 -> 177;
                                            case 190 -> 199;
                                            case 191 -> 104;
                                            case 192 -> 113;
                                            case 193 -> 81;
                                            case 194 -> 58;
                                            case 195 -> 62;
                                            case 196 -> 3;
                                            case 197 -> 5;
                                            case 198 -> 238;
                                            case 199 -> 138;
                                            case 200 -> 6;
                                            case 201 -> 249;
                                            case 202 -> 70;
                                            case 203 -> 14;
                                            case 204 -> 156;
                                            case 205 -> 203;
                                            case 206 -> 245;
                                            case 207 -> 57;
                                            case 208 -> 125;
                                            case 209 -> 179;
                                            case 210 -> 224;
                                            case 211 -> 247;
                                            case 212 -> 15;
                                            case 213 -> 60;
                                            case 214 -> 216;
                                            case 215 -> 206;
                                            case 216 -> 83;
                                            case 217 -> 204;
                                            case 218 -> 87;
                                            case 219 -> 103;
                                            case 220 -> 98;
                                            case 221 -> 229;
                                            case 222 -> 149;
                                            case 223 -> 117;
                                            case 224 -> 168;
                                            case 225 -> 230;
                                            case 226 -> 202;
                                            case 227 -> 9;
                                            case 228 -> 0;
                                            case 229 -> 209;
                                            case 230 -> 150;
                                            case 231 -> 194;
                                            case 232 -> 129;
                                            case 233 -> 228;
                                            case 234 -> 157;
                                            case 235 -> 99;
                                            case 236 -> 235;
                                            case 237 -> 45;
                                            case 238 -> 76;
                                            case 239 -> 173;
                                            case 240 -> 84;
                                            case 241 -> 215;
                                            case 242 -> 211;
                                            case 243 -> 21;
                                            case 244 -> 207;
                                            case 245 -> 218;
                                            case 246 -> 43;
                                            case 247 -> 13;
                                            case 248 -> 39;
                                            case 249 -> 92;
                                            case 250 -> 145;
                                            case 251 -> 56;
                                            case 252 -> 226;
                                            case 253 -> 153;
                                            case 254 -> 243;
                                            default -> 71;
                                        };
                                        int n7 = ((n2 ^= n3) & 0xFF) - n6;
                                        if (n7 < 0) {
                                            n7 += 256;
                                        }
                                        if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                                            n5 += 256;
                                        }
                                        int n8 = 0;
                                        while (n8 < cArray.length) {
                                            int n9 = n8 % 2;
                                            int n10 = n8;
                                            char[] cArray2 = cArray;
                                            char c2 = cArray[n10];
                                            if (n9 == 0) {
                                                cArray2[n10] = (char)(c2 ^ n7);
                                                n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                                            } else {
                                                cArray2[n10] = (char)(c2 ^ n5);
                                                n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                                            }
                                            ++n8;
                                        }
                                        accept.3.b[n4] = new String(cArray).intern();
                                    }
                                    return b[n4];
                                }
                            };
                            if (stringArray == null) break block32;
                            if (ActionTimestamp.V()) break block33;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block34;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            ActionTimestamp.z(bl);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n;
            long l3;
            block2: {
                block3: {
                    l3 = 17947115192845L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String[] stringArray = SshAgentIpcService.z();
                    try {
                        n = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (stringArray != null) break block2;
                        if (n == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1553048430 + -((char)-3600), 1553048430 + (char)-3580, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1553048430 + -((char)-3604), 1553179500 - (char)-1599, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1553048430 + -((char)-3627), -1553179500 - -((char)-19680), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n = Kernel32.INSTANCE.GetLastError();
            }
            int n2 = n;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1553048430 + -((char)-3600), 1553048430 + (char)-3580, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1553048430 + -((char)-3604), 1553179500 - (char)-1599, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1553048430 + -((char)-3624), 1553179500 - (char)-18928, (int)l3) + ErrorToolsKt.prettyHRESULT(n2));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String[] stringArray;
                    block13: {
                        long l2 = 106526634488542L;
                        String[] stringArray2 = SshAgentIpcService.z();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-1439279670 + -((char)-1182), 1439410740 - (char)-4802, (int)l2));
                        stringArray = stringArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (stringArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (stringArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-1439279670 + -((char)-1185), 1439279670 + (char)-8748, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (stringArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String[] stringArray;
        long l2;
        block25: {
            block26: {
                l2 = 63149074715557L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    stringArray = SshAgentIpcService.z();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (stringArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (stringArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(170653140 - (char)-1334, -170653140 - -((char)-1362), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(170653140 - (char)-1338, -170522070 + -((char)-11737), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(170653140 - (char)-1341, 170522070 + (char)-26679, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(170653140 - (char)-1338, -170522070 + -((char)-11737), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(170653140 - (char)-1332, -170522070 + -((char)-30020), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(170653140 - (char)-1334, -170653140 - -((char)-1362), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(170653140 - (char)-1338, -170522070 + -((char)-11737), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(170653140 - (char)-1354, 170522070 + (char)-13680, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (stringArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(170653140 - (char)-1334, -170653140 - -((char)-1362), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(170653140 - (char)-1338, -170522070 + -((char)-11737), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(170653140 - (char)-1355, 170522070 + (char)-11427, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (stringArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(170653140 - (char)-1334, -170653140 - -((char)-1362), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(170653140 - (char)-1338, -170522070 + -((char)-11737), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(170653140 - (char)-1352, -170522070 + -((char)-11878), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String[] stringArray;
                block16: {
                    l2 = 131882803226519L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                stringArray = SshAgentIpcService.z();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (stringArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1537451100 - (char)-27356, -1537451100 - -((char)-27324), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(1537451100 - (char)-27360, -1537451100 - -28813, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1537451100 - (char)-27347, 1537451100 - 15899, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(1537451100 - (char)-27340, 1537451100 - 12858, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1537451100 - (char)-27356, -1537451100 - -((char)-27324), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1537451100 - (char)-27360, -1537451100 - -28813, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1537451100 - (char)-27341, -1537451100 - -19769, (int)l2));
                            n = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (stringArray != null) break block15;
                            if (n != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = Kernel32.INSTANCE.GetLastError();
                        if (stringArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n2 = n;
                    if (n2 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1537451100 - (char)-27356, -1537451100 - -((char)-27324), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(1537451100 - (char)-27360, -1537451100 - -28813, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1537451100 - (char)-27342, 1537451100 - 23845, (int)l2) + ErrorToolsKt.prettyHRESULT(n2));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1537451100 - (char)-27356, -1537451100 - -((char)-27324), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1537451100 - (char)-27360, -1537451100 - -28813, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1537451100 - (char)-27343, 1537451100 - 20064, (int)l2));
                    if (stringArray != null) break block17;
                    n = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1537451100 - (char)-27356, -1537451100 - -((char)-27324), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1537451100 - (char)-27360, -1537451100 - -28813, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1537451100 - (char)-27320, 1537451100 - 23055, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1537451100 - (char)-27321, 1537451100 - 29257, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u0004{6\u00eby\u00f2`e\u0014\u00919\u00bcD\u00d6\u008f:\u00d0$W.V)\"\u00a1\u0018yv\u0082i\u0006S\u0088\u00dc\u0095N|\u0018\u00d6\u00044\u00d3E\u00b8J\u00f6\u00e2\u00ee\u00f9\u0011\u00b55`x\u00e8\u0013\u009eX\u000f\u007f\u0098\u00a3\t\u00a1.D' \u00b9\u00fe\u009eH\u0005\u00b4\u00ef y\u00cb\b$\u00112\u00d7\u00abS<\u00b3\u0014\u00c5\u00d6N\"\u00e5Ki\u00df k\u0005e\u0006\u00e7\u00ffM\u00a0\u000f@\u0004\u0005\u00e5\u00a0\n\u0090\u008e\u001e\u001eK`\u0089^7\u008b}\u007f\u008b\u0001:\u00e6p\u00a8\u00b4\u0010\u001bS\u00ad\u001a\u00ee6\\;\u0092\u00df`\u00abT\u0010\t\u00c8f<\u00c9\u00b3\u008f\u0014\u0082\u001434\u00a6\u00e4\u000f\u00b9\tT\u0002,\u00b3~\f\u0013\u00b7\u001b\u0010\u0098\u00dbT^\u008f\u00ffG\u009d\u009b%\u0010\u0012\u00c2 \u0083!?c\u0081\u00c7\u00d0\u00a7\u00151UY_\u0080[i\u00aad\u00d6L2\u00a5MJ\u00a0G\u00f3\u0005\u008f\u0015w\u00c5\u00e0\u0087\u00ef\u00c3\u0085Q\u00ce_\u008a=\u00e3\u000f\u00b65t\u007f\b\u00b2\u00f1\u0095\u00bb\u0012\u00e1\u008d\u00d2+k\u00a1\u0012\u00dc\u009b\u0084|6\bZF\u00fd=R\u000e\u0003\u0018\f\u00a1\u000b\u0092\u008f\u00a2:\u00f3\u0099$\u00ed\u00b5\u000fF\u0002H\u00e6\u00e7,7\"8\u001e\u00d5\u00f8\u00cc\u00f0PH\u00af5z\u008a\u00eb\u00bd&\u00ba\u0011\u008c\u00f8\u00d7\u0092\"uAa'\u00e2\u000f\u0003N~\u00b4\u00b9\u00ad\u00e8\u00eaDZ\u008bB\u00fcl\u00e2K`It\u00a5\u00a4\u00ef\u009f\u0083\u0096\\\u00b4qb\u00e1P\u0000\u001a\r\u0003\u001f\u00c1\u008b\u009b\u0091!4d\u001d\u0082\u0087\u00be\u00bb\u0011]]\u00a0\u00d5q\u0096*i\u009e\u008f\u00f9m\u00f6\u0002 \r\u00ad\u00a6\u000b\u00f4&8*\u00f7\u008eY\u000fq3\u0015\u0015]j\r\u00a0V\u00b7\u0081UT\u0098y\u0093W\u00f4\u0088\u00c3\u0094\u0089cL\u00e1)\u00f1T\u009dj\u00e1K|\u00f2\u0081z\u00de\u0004\u0019\u00a0\u00c2\u001ay\u00ae\u00d8vPmn\u009f>s\u00bf\u00e8\u0095@7\u00f9\u0017ToX\\\b}\u00de7\u0007\u00a1@\u009d\u00f2\u00c5\u0005c\u00074KK\u00ff\u00f8K\u00d2(\u008a\u00f6\u00be\u001f5\u008f\u0010M|ZK6\u0088g\u00b2aplWm\u00c00\u0013\u00ff\u0001\u00c3\u00ee\u0085\u0088\u008dOY\u00e3+o\u001a\u00e6=\u00b9\u008b\u000f\u009flRe@\u00ac\u001b\u00eah#hHL\u00fc\u00b4\"(7\u00a6\u0006\u0086\u00c6\u0090C\u001cLm\u00c2lt\bN\u00cb\r\u0004@!\u00ab\u00e0\u0017|6:\u009e\u0001\u00bc\u0007a?\u00b4\u000e=\u00e8\u0006\u00f5\u00ca\u00beJ\u00a8Bk-A\u00e8\u00d7\u001b\u00cb\u00bf\u00df\u001a\n\u00f6\u00c7\u00fd\u00a4F|\u00e5\u0092u\u00f1x\\aKQ\u00f3\u00bd\u00c9s\u0012\u00d7\u00a2\n\u009f*\u0091\u00af\u00d7\u00a4\u00af\u009d\u0002(\u0018\u008fIW\u00c9\u001a0\u00e4{\u00de_\u00f1Y\u009a\u00b1\f\u00c1\u0094W\u0085\u00eeR\u0001\u00a6\u00b7)\u00a3`\u00d7\u00ec\u00a8\u009bU\u00e8\u00a49zl\u0089\u00a4O\u00e1\u00b6\u00a4\u00fe\u00f2\u00ae\u00ed\u00f8\u0083\u0099b\u00d6&\u00eb\u00c5C\u00d8\u00bc\u00ae\u00cf\u0093\u0096U$u\u001c\t/7C\u000b\u0099\u00d4\u00b9\u00f7\u00f3";
                var4_3 = "\u0004{6\u00eby\u00f2`e\u0014\u00919\u00bcD\u00d6\u008f:\u00d0$W.V)\"\u00a1\u0018yv\u0082i\u0006S\u0088\u00dc\u0095N|\u0018\u00d6\u00044\u00d3E\u00b8J\u00f6\u00e2\u00ee\u00f9\u0011\u00b55`x\u00e8\u0013\u009eX\u000f\u007f\u0098\u00a3\t\u00a1.D' \u00b9\u00fe\u009eH\u0005\u00b4\u00ef y\u00cb\b$\u00112\u00d7\u00abS<\u00b3\u0014\u00c5\u00d6N\"\u00e5Ki\u00df k\u0005e\u0006\u00e7\u00ffM\u00a0\u000f@\u0004\u0005\u00e5\u00a0\n\u0090\u008e\u001e\u001eK`\u0089^7\u008b}\u007f\u008b\u0001:\u00e6p\u00a8\u00b4\u0010\u001bS\u00ad\u001a\u00ee6\\;\u0092\u00df`\u00abT\u0010\t\u00c8f<\u00c9\u00b3\u008f\u0014\u0082\u001434\u00a6\u00e4\u000f\u00b9\tT\u0002,\u00b3~\f\u0013\u00b7\u001b\u0010\u0098\u00dbT^\u008f\u00ffG\u009d\u009b%\u0010\u0012\u00c2 \u0083!?c\u0081\u00c7\u00d0\u00a7\u00151UY_\u0080[i\u00aad\u00d6L2\u00a5MJ\u00a0G\u00f3\u0005\u008f\u0015w\u00c5\u00e0\u0087\u00ef\u00c3\u0085Q\u00ce_\u008a=\u00e3\u000f\u00b65t\u007f\b\u00b2\u00f1\u0095\u00bb\u0012\u00e1\u008d\u00d2+k\u00a1\u0012\u00dc\u009b\u0084|6\bZF\u00fd=R\u000e\u0003\u0018\f\u00a1\u000b\u0092\u008f\u00a2:\u00f3\u0099$\u00ed\u00b5\u000fF\u0002H\u00e6\u00e7,7\"8\u001e\u00d5\u00f8\u00cc\u00f0PH\u00af5z\u008a\u00eb\u00bd&\u00ba\u0011\u008c\u00f8\u00d7\u0092\"uAa'\u00e2\u000f\u0003N~\u00b4\u00b9\u00ad\u00e8\u00eaDZ\u008bB\u00fcl\u00e2K`It\u00a5\u00a4\u00ef\u009f\u0083\u0096\\\u00b4qb\u00e1P\u0000\u001a\r\u0003\u001f\u00c1\u008b\u009b\u0091!4d\u001d\u0082\u0087\u00be\u00bb\u0011]]\u00a0\u00d5q\u0096*i\u009e\u008f\u00f9m\u00f6\u0002 \r\u00ad\u00a6\u000b\u00f4&8*\u00f7\u008eY\u000fq3\u0015\u0015]j\r\u00a0V\u00b7\u0081UT\u0098y\u0093W\u00f4\u0088\u00c3\u0094\u0089cL\u00e1)\u00f1T\u009dj\u00e1K|\u00f2\u0081z\u00de\u0004\u0019\u00a0\u00c2\u001ay\u00ae\u00d8vPmn\u009f>s\u00bf\u00e8\u0095@7\u00f9\u0017ToX\\\b}\u00de7\u0007\u00a1@\u009d\u00f2\u00c5\u0005c\u00074KK\u00ff\u00f8K\u00d2(\u008a\u00f6\u00be\u001f5\u008f\u0010M|ZK6\u0088g\u00b2aplWm\u00c00\u0013\u00ff\u0001\u00c3\u00ee\u0085\u0088\u008dOY\u00e3+o\u001a\u00e6=\u00b9\u008b\u000f\u009flRe@\u00ac\u001b\u00eah#hHL\u00fc\u00b4\"(7\u00a6\u0006\u0086\u00c6\u0090C\u001cLm\u00c2lt\bN\u00cb\r\u0004@!\u00ab\u00e0\u0017|6:\u009e\u0001\u00bc\u0007a?\u00b4\u000e=\u00e8\u0006\u00f5\u00ca\u00beJ\u00a8Bk-A\u00e8\u00d7\u001b\u00cb\u00bf\u00df\u001a\n\u00f6\u00c7\u00fd\u00a4F|\u00e5\u0092u\u00f1x\\aKQ\u00f3\u00bd\u00c9s\u0012\u00d7\u00a2\n\u009f*\u0091\u00af\u00d7\u00a4\u00af\u009d\u0002(\u0018\u008fIW\u00c9\u001a0\u00e4{\u00de_\u00f1Y\u009a\u00b1\f\u00c1\u0094W\u0085\u00eeR\u0001\u00a6\u00b7)\u00a3`\u00d7\u00ec\u00a8\u009bU\u00e8\u00a49zl\u0089\u00a4O\u00e1\u00b6\u00a4\u00fe\u00f2\u00ae\u00ed\u00f8\u0083\u0099b\u00d6&\u00eb\u00c5C\u00d8\u00bc\u00ae\u00cf\u0093\u0096U$u\u001c\t/7C\u000b\u0099\u00d4\u00b9\u00f7\u00f3".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 66;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0098f\u00d5I\u008dJ\u0094\u00b7\u00f9\u00b7\u00b4\u00d85W\u00bd\u00fa\u008d\u00ae\u00acR\u00d4\u00a3!\u00f1lU\u009c\u00e0W\u0014\u0093\u009e\u0099\u00d5\u0017\u00d8g_\u00ea\u00c3\u0092\u00a1\u00db\u00b9\u009a\u000e{\u00d1\u00a7\u00f8";
                    var4_3 = "\u0098f\u00d5I\u008dJ\u0094\u00b7\u00f9\u00b7\u00b4\u00d85W\u00bd\u00fa\u008d\u00ae\u00acR\u00d4\u00a3!\u00f1lU\u009c\u00e0W\u0014\u0093\u009e\u0099\u00d5\u0017\u00d8g_\u00ea\u00c3\u0092\u00a1\u00db\u00b9\u009a\u000e{\u00d1\u00a7\u00f8".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 42;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 61;
                            break;
                        }
                        case 1: {
                            v15 = 100;
                            break;
                        }
                        case 2: {
                            v15 = 21;
                            break;
                        }
                        case 3: {
                            v15 = 35;
                            break;
                        }
                        case 4: {
                            v15 = 57;
                            break;
                        }
                        case 5: {
                            v15 = 73;
                            break;
                        }
                        default: {
                            v15 = 76;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n, int n2, int n3) {
        int n4 = (n ^ n3 ^ 0x68A3) & 0xFFFF;
        if (d[n4] == null) {
            int n5;
            char[] cArray = c[n4].toCharArray();
            int n6 = switch (cArray[0] & 0xFF) {
                case 0 -> 80;
                case 1 -> 97;
                case 2 -> 252;
                case 3 -> 190;
                case 4 -> 23;
                case 5 -> 129;
                case 6 -> 162;
                case 7 -> 194;
                case 8 -> 220;
                case 9 -> 159;
                case 10 -> 22;
                case 11 -> 240;
                case 12 -> 16;
                case 13 -> 118;
                case 14 -> 144;
                case 15 -> 205;
                case 16 -> 115;
                case 17 -> 166;
                case 18 -> 217;
                case 19 -> 132;
                case 20 -> 75;
                case 21 -> 96;
                case 22 -> 211;
                case 23 -> 130;
                case 24 -> 71;
                case 25 -> 34;
                case 26 -> 250;
                case 27 -> 98;
                case 28 -> 20;
                case 29 -> 6;
                case 30 -> 243;
                case 31 -> 66;
                case 32 -> 225;
                case 33 -> 180;
                case 34 -> 161;
                case 35 -> 206;
                case 36 -> 48;
                case 37 -> 172;
                case 38 -> 136;
                case 39 -> 153;
                case 40 -> 137;
                case 41 -> 116;
                case 42 -> 89;
                case 43 -> 59;
                case 44 -> 158;
                case 45 -> 151;
                case 46 -> 246;
                case 47 -> 235;
                case 48 -> 138;
                case 49 -> 241;
                case 50 -> 62;
                case 51 -> 27;
                case 52 -> 107;
                case 53 -> 117;
                case 54 -> 67;
                case 55 -> 65;
                case 56 -> 236;
                case 57 -> 239;
                case 58 -> 149;
                case 59 -> 143;
                case 60 -> 141;
                case 61 -> 242;
                case 62 -> 135;
                case 63 -> 43;
                case 64 -> 0;
                case 65 -> 245;
                case 66 -> 189;
                case 67 -> 216;
                case 68 -> 24;
                case 69 -> 100;
                case 70 -> 14;
                case 71 -> 90;
                case 72 -> 55;
                case 73 -> 193;
                case 74 -> 254;
                case 75 -> 156;
                case 76 -> 74;
                case 77 -> 176;
                case 78 -> 32;
                case 79 -> 148;
                case 80 -> 1;
                case 81 -> 248;
                case 82 -> 140;
                case 83 -> 121;
                case 84 -> 229;
                case 85 -> 33;
                case 86 -> 108;
                case 87 -> 41;
                case 88 -> 124;
                case 89 -> 207;
                case 90 -> 11;
                case 91 -> 185;
                case 92 -> 73;
                case 93 -> 133;
                case 94 -> 8;
                case 95 -> 3;
                case 96 -> 203;
                case 97 -> 184;
                case 98 -> 39;
                case 99 -> 228;
                case 100 -> 52;
                case 101 -> 212;
                case 102 -> 102;
                case 103 -> 174;
                case 104 -> 105;
                case 105 -> 69;
                case 106 -> 147;
                case 107 -> 81;
                case 108 -> 142;
                case 109 -> 125;
                case 110 -> 160;
                case 111 -> 191;
                case 112 -> 199;
                case 113 -> 200;
                case 114 -> 182;
                case 115 -> 237;
                case 116 -> 208;
                case 117 -> 94;
                case 118 -> 78;
                case 119 -> 127;
                case 120 -> 91;
                case 121 -> 226;
                case 122 -> 93;
                case 123 -> 46;
                case 124 -> 171;
                case 125 -> 82;
                case 126 -> 112;
                case 127 -> 25;
                case 128 -> 26;
                case 129 -> 49;
                case 130 -> 155;
                case 131 -> 170;
                case 132 -> 183;
                case 133 -> 238;
                case 134 -> 61;
                case 135 -> 29;
                case 136 -> 51;
                case 137 -> 84;
                case 138 -> 44;
                case 139 -> 15;
                case 140 -> 218;
                case 141 -> 215;
                case 142 -> 157;
                case 143 -> 37;
                case 144 -> 247;
                case 145 -> 40;
                case 146 -> 251;
                case 147 -> 253;
                case 148 -> 230;
                case 149 -> 103;
                case 150 -> 87;
                case 151 -> 68;
                case 152 -> 35;
                case 153 -> 60;
                case 154 -> 188;
                case 155 -> 28;
                case 156 -> 99;
                case 157 -> 167;
                case 158 -> 192;
                case 159 -> 123;
                case 160 -> 58;
                case 161 -> 50;
                case 162 -> 111;
                case 163 -> 54;
                case 164 -> 152;
                case 165 -> 119;
                case 166 -> 178;
                case 167 -> 42;
                case 168 -> 139;
                case 169 -> 204;
                case 170 -> 196;
                case 171 -> 64;
                case 172 -> 5;
                case 173 -> 173;
                case 174 -> 57;
                case 175 -> 219;
                case 176 -> 198;
                case 177 -> 104;
                case 178 -> 38;
                case 179 -> 244;
                case 180 -> 72;
                case 181 -> 13;
                case 182 -> 169;
                case 183 -> 221;
                case 184 -> 19;
                case 185 -> 197;
                case 186 -> 79;
                case 187 -> 31;
                case 188 -> 249;
                case 189 -> 179;
                case 190 -> 2;
                case 191 -> 168;
                case 192 -> 224;
                case 193 -> 30;
                case 194 -> 163;
                case 195 -> 88;
                case 196 -> 209;
                case 197 -> 85;
                case 198 -> 106;
                case 199 -> 77;
                case 200 -> 213;
                case 201 -> 53;
                case 202 -> 234;
                case 203 -> 36;
                case 204 -> 164;
                case 205 -> 113;
                case 206 -> 109;
                case 207 -> 222;
                case 208 -> 63;
                case 209 -> 120;
                case 210 -> 126;
                case 211 -> 83;
                case 212 -> 210;
                case 213 -> 76;
                case 214 -> 201;
                case 215 -> 92;
                case 216 -> 7;
                case 217 -> 17;
                case 218 -> 21;
                case 219 -> 95;
                case 220 -> 186;
                case 221 -> 86;
                case 222 -> 122;
                case 223 -> 187;
                case 224 -> 233;
                case 225 -> 181;
                case 226 -> 4;
                case 227 -> 18;
                case 228 -> 227;
                case 229 -> 232;
                case 230 -> 131;
                case 231 -> 255;
                case 232 -> 202;
                case 233 -> 165;
                case 234 -> 70;
                case 235 -> 231;
                case 236 -> 114;
                case 237 -> 175;
                case 238 -> 223;
                case 239 -> 145;
                case 240 -> 128;
                case 241 -> 45;
                case 242 -> 110;
                case 243 -> 9;
                case 244 -> 146;
                case 245 -> 101;
                case 246 -> 56;
                case 247 -> 154;
                case 248 -> 195;
                case 249 -> 214;
                case 250 -> 134;
                case 251 -> 12;
                case 252 -> 47;
                case 253 -> 150;
                case 254 -> 10;
                default -> 177;
            };
            int n7 = ((n2 ^= n3) & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n5 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            WindowsNamedPipeAgentIpc.d[n4] = new String(cArray).intern();
        }
        return d[n4];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 25752365212684L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(258732180 - (char)-29539, -258732180 - -((char)-24279), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String[] stringArray;
                        block4: {
                            l2 = 7720967456319L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            stringArray = SshAgentIpcService.z();
                            try {
                                hANDLE2 = hANDLE;
                                if (stringArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (stringArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1383705990 + 21567, -1383705990 + -((char)-11878), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1383705990 + 21568, 1383705990 + (char)-25535, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1383705990 + 21569, 1383705990 + (char)-24930, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00bcE\u00b3/0z\u0016R\u0010\u00d9\u0017\u00ee\u00c4!\u00bc\u00cd\u00d3\u00d5~\u00da\u0080\u008b-\u008c\u009f";
                    var4_3 = "\u00bcE\u00b3/0z\u0016R\u0010\u00d9\u0017\u00ee\u00c4!\u00bc\u00cd\u00d3\u00d5~\u00da\u0080\u008b-\u008c\u009f".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 14;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00a6Ar-\u00fa5\u00b0\\\u00a7\u00e2\u0092\u00c3!\u0015\u00bd\u009f\u00c7\u00fe]\u008a\u00d1c\u00f4\u00cc^\u0091\u00f4\u001a\u00a1\u00e099\u001fV\u00b0i\u00e8\u0018\u00a9U\u00c51\u0095O\u00a1K\u00beQ0\u00fd\u009aS\u0087\u009aZ\u0084e3\u00a7";
                        var4_3 = "\u00a6Ar-\u00fa5\u00b0\\\u00a7\u00e2\u0092\u00c3!\u0015\u00bd\u009f\u00c7\u00fe]\u008a\u00d1c\u00f4\u00cc^\u0091\u00f4\u001a\u00a1\u00e099\u001fV\u00b0i\u00e8\u0018\u00a9U\u00c51\u0095O\u00a1K\u00beQ0\u00fd\u009aS\u0087\u009aZ\u0084e3\u00a7".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 97;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 85;
                                break;
                            }
                            case 1: {
                                v15 = 48;
                                break;
                            }
                            case 2: {
                                v15 = 79;
                                break;
                            }
                            case 3: {
                                v15 = 111;
                                break;
                            }
                            case 4: {
                                v15 = 78;
                                break;
                            }
                            case 5: {
                                v15 = 21;
                                break;
                            }
                            default: {
                                v15 = 56;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0xFFFFC7FB) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 71;
                    case 1 -> 28;
                    case 2 -> 14;
                    case 3 -> 8;
                    case 4 -> 156;
                    case 5 -> 141;
                    case 6 -> 77;
                    case 7 -> 200;
                    case 8 -> 75;
                    case 9 -> 147;
                    case 10 -> 45;
                    case 11 -> 241;
                    case 12 -> 99;
                    case 13 -> 196;
                    case 14 -> 102;
                    case 15 -> 5;
                    case 16 -> 173;
                    case 17 -> 158;
                    case 18 -> 204;
                    case 19 -> 20;
                    case 20 -> 248;
                    case 21 -> 191;
                    case 22 -> 103;
                    case 23 -> 229;
                    case 24 -> 249;
                    case 25 -> 220;
                    case 26 -> 138;
                    case 27 -> 231;
                    case 28 -> 143;
                    case 29 -> 217;
                    case 30 -> 86;
                    case 31 -> 150;
                    case 32 -> 142;
                    case 33 -> 149;
                    case 34 -> 165;
                    case 35 -> 203;
                    case 36 -> 177;
                    case 37 -> 222;
                    case 38 -> 163;
                    case 39 -> 186;
                    case 40 -> 61;
                    case 41 -> 33;
                    case 42 -> 127;
                    case 43 -> 56;
                    case 44 -> 247;
                    case 45 -> 219;
                    case 46 -> 139;
                    case 47 -> 230;
                    case 48 -> 116;
                    case 49 -> 232;
                    case 50 -> 76;
                    case 51 -> 38;
                    case 52 -> 46;
                    case 53 -> 9;
                    case 54 -> 233;
                    case 55 -> 44;
                    case 56 -> 50;
                    case 57 -> 216;
                    case 58 -> 228;
                    case 59 -> 135;
                    case 60 -> 133;
                    case 61 -> 43;
                    case 62 -> 67;
                    case 63 -> 65;
                    case 64 -> 238;
                    case 65 -> 195;
                    case 66 -> 66;
                    case 67 -> 167;
                    case 68 -> 132;
                    case 69 -> 26;
                    case 70 -> 53;
                    case 71 -> 192;
                    case 72 -> 64;
                    case 73 -> 6;
                    case 74 -> 131;
                    case 75 -> 114;
                    case 76 -> 144;
                    case 77 -> 189;
                    case 78 -> 51;
                    case 79 -> 198;
                    case 80 -> 0;
                    case 81 -> 72;
                    case 82 -> 155;
                    case 83 -> 171;
                    case 84 -> 214;
                    case 85 -> 10;
                    case 86 -> 18;
                    case 87 -> 159;
                    case 88 -> 208;
                    case 89 -> 244;
                    case 90 -> 82;
                    case 91 -> 154;
                    case 92 -> 57;
                    case 93 -> 1;
                    case 94 -> 181;
                    case 95 -> 30;
                    case 96 -> 151;
                    case 97 -> 47;
                    case 98 -> 201;
                    case 99 -> 108;
                    case 100 -> 254;
                    case 101 -> 168;
                    case 102 -> 126;
                    case 103 -> 87;
                    case 104 -> 96;
                    case 105 -> 124;
                    case 106 -> 78;
                    case 107 -> 211;
                    case 108 -> 185;
                    case 109 -> 109;
                    case 110 -> 251;
                    case 111 -> 160;
                    case 112 -> 190;
                    case 113 -> 12;
                    case 114 -> 49;
                    case 115 -> 80;
                    case 116 -> 106;
                    case 117 -> 111;
                    case 118 -> 130;
                    case 119 -> 182;
                    case 120 -> 120;
                    case 121 -> 117;
                    case 122 -> 227;
                    case 123 -> 42;
                    case 124 -> 180;
                    case 125 -> 205;
                    case 126 -> 178;
                    case 127 -> 122;
                    case 128 -> 234;
                    case 129 -> 68;
                    case 130 -> 250;
                    case 131 -> 239;
                    case 132 -> 93;
                    case 133 -> 60;
                    case 134 -> 218;
                    case 135 -> 175;
                    case 136 -> 240;
                    case 137 -> 97;
                    case 138 -> 202;
                    case 139 -> 162;
                    case 140 -> 183;
                    case 141 -> 74;
                    case 142 -> 13;
                    case 143 -> 27;
                    case 144 -> 73;
                    case 145 -> 69;
                    case 146 -> 22;
                    case 147 -> 213;
                    case 148 -> 119;
                    case 149 -> 172;
                    case 150 -> 236;
                    case 151 -> 19;
                    case 152 -> 206;
                    case 153 -> 39;
                    case 154 -> 41;
                    case 155 -> 170;
                    case 156 -> 95;
                    case 157 -> 125;
                    case 158 -> 221;
                    case 159 -> 107;
                    case 160 -> 225;
                    case 161 -> 194;
                    case 162 -> 36;
                    case 163 -> 145;
                    case 164 -> 215;
                    case 165 -> 223;
                    case 166 -> 37;
                    case 167 -> 209;
                    case 168 -> 79;
                    case 169 -> 157;
                    case 170 -> 187;
                    case 171 -> 101;
                    case 172 -> 252;
                    case 173 -> 176;
                    case 174 -> 48;
                    case 175 -> 91;
                    case 176 -> 118;
                    case 177 -> 179;
                    case 178 -> 169;
                    case 179 -> 197;
                    case 180 -> 140;
                    case 181 -> 237;
                    case 182 -> 121;
                    case 183 -> 137;
                    case 184 -> 226;
                    case 185 -> 115;
                    case 186 -> 85;
                    case 187 -> 210;
                    case 188 -> 52;
                    case 189 -> 21;
                    case 190 -> 245;
                    case 191 -> 242;
                    case 192 -> 32;
                    case 193 -> 123;
                    case 194 -> 166;
                    case 195 -> 146;
                    case 196 -> 24;
                    case 197 -> 100;
                    case 198 -> 17;
                    case 199 -> 153;
                    case 200 -> 152;
                    case 201 -> 104;
                    case 202 -> 253;
                    case 203 -> 84;
                    case 204 -> 174;
                    case 205 -> 83;
                    case 206 -> 59;
                    case 207 -> 3;
                    case 208 -> 98;
                    case 209 -> 16;
                    case 210 -> 54;
                    case 211 -> 81;
                    case 212 -> 164;
                    case 213 -> 224;
                    case 214 -> 31;
                    case 215 -> 235;
                    case 216 -> 110;
                    case 217 -> 113;
                    case 218 -> 70;
                    case 219 -> 199;
                    case 220 -> 193;
                    case 221 -> 105;
                    case 222 -> 90;
                    case 223 -> 94;
                    case 224 -> 4;
                    case 225 -> 246;
                    case 226 -> 188;
                    case 227 -> 55;
                    case 228 -> 58;
                    case 229 -> 129;
                    case 230 -> 15;
                    case 231 -> 2;
                    case 232 -> 89;
                    case 233 -> 11;
                    case 234 -> 148;
                    case 235 -> 161;
                    case 236 -> 35;
                    case 237 -> 255;
                    case 238 -> 25;
                    case 239 -> 207;
                    case 240 -> 112;
                    case 241 -> 88;
                    case 242 -> 62;
                    case 243 -> 40;
                    case 244 -> 136;
                    case 245 -> 184;
                    case 246 -> 134;
                    case 247 -> 23;
                    case 248 -> 243;
                    case 249 -> 212;
                    case 250 -> 34;
                    case 251 -> 92;
                    case 252 -> 128;
                    case 253 -> 63;
                    case 254 -> 29;
                    default -> 7;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 116206281637339L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u000e||b=&2W\t\tvohpd/K0";
                    var5_4 = "\u000e||b=&2W\t\tvohpd/K0".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 37;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 64;
                                    break;
                                }
                                case 1: {
                                    v11 = 60;
                                    break;
                                }
                                case 2: {
                                    v11 = 43;
                                    break;
                                }
                                case 3: {
                                    v11 = 41;
                                    break;
                                }
                                case 4: {
                                    v11 = 125;
                                    break;
                                }
                                case 5: {
                                    v11 = 111;
                                    break;
                                }
                                default: {
                                    v11 = 36;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 37060520003606L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "^\u0000(\u0018 j\u000b\u0004X\u001e$\u0002\nT\u0001/\u0002,h\u0013~\u0000&\tT\u0001/\u0002,h\u0013r\n\rS\u00072\u000f&e\tr\r5\u0005'l";
                    var5_4 = "^\u0000(\u0018 j\u000b\u0004X\u001e$\u0002\nT\u0001/\u0002,h\u0013~\u0000&\tT\u0001/\u0002,h\u0013r\n\rS\u00072\u000f&e\tr\r5\u0005'l".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 18;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "/yUd[\u001e{\u0006/yUdW\u0014";
                        var5_4 = "/yUd[\u001e{\u0006/yUdW\u0014".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 105;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 5;
                                break;
                            }
                            case 1: {
                                v15 = 124;
                                break;
                            }
                            case 2: {
                                v15 = 83;
                                break;
                            }
                            case 3: {
                                v15 = 126;
                                break;
                            }
                            case 4: {
                                v15 = 91;
                                break;
                            }
                            case 5: {
                                v15 = 25;
                                break;
                            }
                            default: {
                                v15 = 117;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 126351191606267L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1843761690 - (char)-21948, 1843761690 - (char)-18743, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 36671994869601L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00b58\u0088y\u00ec\u0003\u00c9>\u00b3\u0005$g\u009cV\u008d\r\u00da\u0014urE{\u00bdI\u00f7\u0095@\u0098\u00ba\u0010F2!]\u00f0\u000b z\u008dw\u00ec\u0089\u00c9\u00db\u009b\u00a4\u0005\u0084\u00f0\u0088\u00a4\u000f3\u00b5\u00b2\u00bf\u009b\u00f6\u0097\u00d0\u00fd\u00eez\u000b\u0001\u00f3\u009b\u00f0\u00b3^r\u00d6@\u0017\u00fb\u00dc\u00ea\u00e2M\u008b\u00dbA\u000bW\u00b65 \u00e3)\u00cc\u00b0\u0085\u0014\u00a1\u00b5\u001f4\u00b0\u00a7\u0006(\u00b6?o";
                    var4_3 = "\u00b58\u0088y\u00ec\u0003\u00c9>\u00b3\u0005$g\u009cV\u008d\r\u00da\u0014urE{\u00bdI\u00f7\u0095@\u0098\u00ba\u0010F2!]\u00f0\u000b z\u008dw\u00ec\u0089\u00c9\u00db\u009b\u00a4\u0005\u0084\u00f0\u0088\u00a4\u000f3\u00b5\u00b2\u00bf\u009b\u00f6\u0097\u00d0\u00fd\u00eez\u000b\u0001\u00f3\u009b\u00f0\u00b3^r\u00d6@\u0017\u00fb\u00dc\u00ea\u00e2M\u008b\u00dbA\u000bW\u00b65 \u00e3)\u00cc\u00b0\u0085\u0014\u00a1\u00b5\u001f4\u00b0\u00a7\u0006(\u00b6?o".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 116;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00df*\u00f9\u00b5\u0000\u00fd\u00d5O\u00d8:\u00ad\u00cb\nx\b;LF?=\u00dd\u00b28\u00ed\u0099Vs\u00d0[\u00ab\u00e4\u00af\u00d1[\u0004b\u0093\u0002\u000e\u00bf\u001dF\u00b3\u00d1)\u001b\u00f7\u0018\u00ad'F;\u0012\u000e\u00e2\f\u00d3M[\u00a6\u007fy\u00fb\u001fp\u008c\u00eb+\u001fP\u00ee\u0010}P\u0015h\u0097\u001c\u00fa\u00eeLv\u00d0\u00ddQ`^\u0080VQ\u00cb.\u00fd";
                        var4_3 = "\u00df*\u00f9\u00b5\u0000\u00fd\u00d5O\u00d8:\u00ad\u00cb\nx\b;LF?=\u00dd\u00b28\u00ed\u0099Vs\u00d0[\u00ab\u00e4\u00af\u00d1[\u0004b\u0093\u0002\u000e\u00bf\u001dF\u00b3\u00d1)\u001b\u00f7\u0018\u00ad'F;\u0012\u000e\u00e2\f\u00d3M[\u00a6\u007fy\u00fb\u001fp\u008c\u00eb+\u001fP\u00ee\u0010}P\u0015h\u0097\u001c\u00fa\u00eeLv\u00d0\u00ddQ`^\u0080VQ\u00cb.\u00fd".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 90;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 21;
                                break;
                            }
                            case 1: {
                                v15 = 72;
                                break;
                            }
                            case 2: {
                                v15 = 78;
                                break;
                            }
                            case 3: {
                                v15 = 104;
                                break;
                            }
                            case 4: {
                                v15 = 115;
                                break;
                            }
                            case 5: {
                                v15 = 68;
                                break;
                            }
                            default: {
                                v15 = 125;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0x642D) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 49;
                    case 1 -> 126;
                    case 2 -> 230;
                    case 3 -> 140;
                    case 4 -> 6;
                    case 5 -> 116;
                    case 6 -> 130;
                    case 7 -> 157;
                    case 8 -> 175;
                    case 9 -> 161;
                    case 10 -> 44;
                    case 11 -> 210;
                    case 12 -> 97;
                    case 13 -> 65;
                    case 14 -> 91;
                    case 15 -> 122;
                    case 16 -> 36;
                    case 17 -> 9;
                    case 18 -> 227;
                    case 19 -> 125;
                    case 20 -> 127;
                    case 21 -> 113;
                    case 22 -> 89;
                    case 23 -> 105;
                    case 24 -> 171;
                    case 25 -> 167;
                    case 26 -> 101;
                    case 27 -> 114;
                    case 28 -> 243;
                    case 29 -> 154;
                    case 30 -> 160;
                    case 31 -> 16;
                    case 32 -> 149;
                    case 33 -> 198;
                    case 34 -> 242;
                    case 35 -> 11;
                    case 36 -> 47;
                    case 37 -> 255;
                    case 38 -> 129;
                    case 39 -> 218;
                    case 40 -> 66;
                    case 41 -> 10;
                    case 42 -> 83;
                    case 43 -> 29;
                    case 44 -> 169;
                    case 45 -> 120;
                    case 46 -> 187;
                    case 47 -> 2;
                    case 48 -> 48;
                    case 49 -> 38;
                    case 50 -> 189;
                    case 51 -> 214;
                    case 52 -> 241;
                    case 53 -> 137;
                    case 54 -> 235;
                    case 55 -> 206;
                    case 56 -> 184;
                    case 57 -> 0;
                    case 58 -> 156;
                    case 59 -> 67;
                    case 60 -> 200;
                    case 61 -> 62;
                    case 62 -> 150;
                    case 63 -> 209;
                    case 64 -> 146;
                    case 65 -> 158;
                    case 66 -> 174;
                    case 67 -> 201;
                    case 68 -> 73;
                    case 69 -> 41;
                    case 70 -> 5;
                    case 71 -> 181;
                    case 72 -> 4;
                    case 73 -> 124;
                    case 74 -> 110;
                    case 75 -> 228;
                    case 76 -> 179;
                    case 77 -> 85;
                    case 78 -> 238;
                    case 79 -> 234;
                    case 80 -> 112;
                    case 81 -> 19;
                    case 82 -> 92;
                    case 83 -> 173;
                    case 84 -> 247;
                    case 85 -> 248;
                    case 86 -> 108;
                    case 87 -> 95;
                    case 88 -> 20;
                    case 89 -> 75;
                    case 90 -> 240;
                    case 91 -> 132;
                    case 92 -> 94;
                    case 93 -> 208;
                    case 94 -> 119;
                    case 95 -> 138;
                    case 96 -> 213;
                    case 97 -> 53;
                    case 98 -> 152;
                    case 99 -> 88;
                    case 100 -> 121;
                    case 101 -> 32;
                    case 102 -> 168;
                    case 103 -> 151;
                    case 104 -> 84;
                    case 105 -> 251;
                    case 106 -> 115;
                    case 107 -> 204;
                    case 108 -> 15;
                    case 109 -> 226;
                    case 110 -> 72;
                    case 111 -> 222;
                    case 112 -> 70;
                    case 113 -> 215;
                    case 114 -> 50;
                    case 115 -> 96;
                    case 116 -> 131;
                    case 117 -> 68;
                    case 118 -> 74;
                    case 119 -> 82;
                    case 120 -> 147;
                    case 121 -> 145;
                    case 122 -> 236;
                    case 123 -> 27;
                    case 124 -> 249;
                    case 125 -> 148;
                    case 126 -> 193;
                    case 127 -> 117;
                    case 128 -> 211;
                    case 129 -> 61;
                    case 130 -> 219;
                    case 131 -> 135;
                    case 132 -> 191;
                    case 133 -> 165;
                    case 134 -> 224;
                    case 135 -> 104;
                    case 136 -> 205;
                    case 137 -> 207;
                    case 138 -> 128;
                    case 139 -> 141;
                    case 140 -> 90;
                    case 141 -> 59;
                    case 142 -> 3;
                    case 143 -> 220;
                    case 144 -> 252;
                    case 145 -> 170;
                    case 146 -> 93;
                    case 147 -> 40;
                    case 148 -> 25;
                    case 149 -> 55;
                    case 150 -> 143;
                    case 151 -> 69;
                    case 152 -> 51;
                    case 153 -> 229;
                    case 154 -> 186;
                    case 155 -> 177;
                    case 156 -> 231;
                    case 157 -> 87;
                    case 158 -> 197;
                    case 159 -> 180;
                    case 160 -> 246;
                    case 161 -> 35;
                    case 162 -> 22;
                    case 163 -> 58;
                    case 164 -> 109;
                    case 165 -> 45;
                    case 166 -> 14;
                    case 167 -> 86;
                    case 168 -> 7;
                    case 169 -> 232;
                    case 170 -> 60;
                    case 171 -> 172;
                    case 172 -> 21;
                    case 173 -> 233;
                    case 174 -> 8;
                    case 175 -> 18;
                    case 176 -> 28;
                    case 177 -> 153;
                    case 178 -> 212;
                    case 179 -> 100;
                    case 180 -> 31;
                    case 181 -> 142;
                    case 182 -> 221;
                    case 183 -> 106;
                    case 184 -> 253;
                    case 185 -> 30;
                    case 186 -> 52;
                    case 187 -> 102;
                    case 188 -> 133;
                    case 189 -> 196;
                    case 190 -> 159;
                    case 191 -> 17;
                    case 192 -> 185;
                    case 193 -> 144;
                    case 194 -> 71;
                    case 195 -> 63;
                    case 196 -> 26;
                    case 197 -> 64;
                    case 198 -> 23;
                    case 199 -> 202;
                    case 200 -> 136;
                    case 201 -> 192;
                    case 202 -> 13;
                    case 203 -> 237;
                    case 204 -> 42;
                    case 205 -> 78;
                    case 206 -> 34;
                    case 207 -> 43;
                    case 208 -> 46;
                    case 209 -> 77;
                    case 210 -> 80;
                    case 211 -> 37;
                    case 212 -> 245;
                    case 213 -> 111;
                    case 214 -> 139;
                    case 215 -> 164;
                    case 216 -> 254;
                    case 217 -> 183;
                    case 218 -> 118;
                    case 219 -> 107;
                    case 220 -> 123;
                    case 221 -> 24;
                    case 222 -> 223;
                    case 223 -> 76;
                    case 224 -> 39;
                    case 225 -> 190;
                    case 226 -> 176;
                    case 227 -> 203;
                    case 228 -> 239;
                    case 229 -> 54;
                    case 230 -> 162;
                    case 231 -> 79;
                    case 232 -> 199;
                    case 233 -> 1;
                    case 234 -> 134;
                    case 235 -> 33;
                    case 236 -> 194;
                    case 237 -> 12;
                    case 238 -> 57;
                    case 239 -> 195;
                    case 240 -> 244;
                    case 241 -> 250;
                    case 242 -> 178;
                    case 243 -> 98;
                    case 244 -> 155;
                    case 245 -> 182;
                    case 246 -> 217;
                    case 247 -> 81;
                    case 248 -> 103;
                    case 249 -> 225;
                    case 250 -> 188;
                    case 251 -> 99;
                    case 252 -> 216;
                    case 253 -> 163;
                    case 254 -> 56;
                    default -> 166;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeReadableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 45921677732648L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(112589130 + 25521, 112589130 + 15268, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 111852792112863L;
                    String[] stringArray = SshAgentIpcService.z();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1041220080 - 28899, 1041220080 - (char)-30349, (int)l2));
                    String[] stringArray2 = stringArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (stringArray2 != null) break block7;
                            if (n != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n = intByReference.getValue();
            }
            return n;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 104195734782919L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00da\u00c9\u00e4\u009c\u00a0\u0003\u00e7\u00a6\u0015";
                var4_3 = "\u00da\u00c9\u00e4\u009c\u00a0\u0003\u00e7\u00a6\u0015".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 97;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 126;
                                break;
                            }
                            case 1: {
                                v11 = 114;
                                break;
                            }
                            case 2: {
                                v11 = 21;
                                break;
                            }
                            case 3: {
                                v11 = 67;
                                break;
                            }
                            case 4: {
                                v11 = 110;
                                break;
                            }
                            case 5: {
                                v11 = 89;
                                break;
                            }
                            default: {
                                v11 = 16;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0xFFFFB7D3) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 89;
                    case 1 -> 110;
                    case 2 -> 11;
                    case 3 -> 186;
                    case 4 -> 99;
                    case 5 -> 135;
                    case 6 -> 46;
                    case 7 -> 106;
                    case 8 -> 13;
                    case 9 -> 83;
                    case 10 -> 175;
                    case 11 -> 96;
                    case 12 -> 200;
                    case 13 -> 139;
                    case 14 -> 191;
                    case 15 -> 171;
                    case 16 -> 32;
                    case 17 -> 124;
                    case 18 -> 159;
                    case 19 -> 91;
                    case 20 -> 157;
                    case 21 -> 199;
                    case 22 -> 45;
                    case 23 -> 8;
                    case 24 -> 194;
                    case 25 -> 29;
                    case 26 -> 249;
                    case 27 -> 239;
                    case 28 -> 213;
                    case 29 -> 79;
                    case 30 -> 150;
                    case 31 -> 147;
                    case 32 -> 144;
                    case 33 -> 123;
                    case 34 -> 118;
                    case 35 -> 3;
                    case 36 -> 242;
                    case 37 -> 120;
                    case 38 -> 246;
                    case 39 -> 121;
                    case 40 -> 154;
                    case 41 -> 27;
                    case 42 -> 208;
                    case 43 -> 67;
                    case 44 -> 132;
                    case 45 -> 203;
                    case 46 -> 166;
                    case 47 -> 116;
                    case 48 -> 141;
                    case 49 -> 168;
                    case 50 -> 49;
                    case 51 -> 167;
                    case 52 -> 25;
                    case 53 -> 12;
                    case 54 -> 156;
                    case 55 -> 181;
                    case 56 -> 37;
                    case 57 -> 170;
                    case 58 -> 131;
                    case 59 -> 207;
                    case 60 -> 255;
                    case 61 -> 50;
                    case 62 -> 223;
                    case 63 -> 196;
                    case 64 -> 4;
                    case 65 -> 182;
                    case 66 -> 97;
                    case 67 -> 226;
                    case 68 -> 103;
                    case 69 -> 189;
                    case 70 -> 68;
                    case 71 -> 163;
                    case 72 -> 165;
                    case 73 -> 117;
                    case 74 -> 188;
                    case 75 -> 54;
                    case 76 -> 254;
                    case 77 -> 85;
                    case 78 -> 251;
                    case 79 -> 142;
                    case 80 -> 146;
                    case 81 -> 62;
                    case 82 -> 94;
                    case 83 -> 61;
                    case 84 -> 151;
                    case 85 -> 215;
                    case 86 -> 133;
                    case 87 -> 220;
                    case 88 -> 95;
                    case 89 -> 9;
                    case 90 -> 77;
                    case 91 -> 109;
                    case 92 -> 221;
                    case 93 -> 198;
                    case 94 -> 82;
                    case 95 -> 39;
                    case 96 -> 161;
                    case 97 -> 230;
                    case 98 -> 65;
                    case 99 -> 22;
                    case 100 -> 204;
                    case 101 -> 14;
                    case 102 -> 53;
                    case 103 -> 64;
                    case 104 -> 40;
                    case 105 -> 136;
                    case 106 -> 185;
                    case 107 -> 128;
                    case 108 -> 206;
                    case 109 -> 180;
                    case 110 -> 179;
                    case 111 -> 243;
                    case 112 -> 17;
                    case 113 -> 107;
                    case 114 -> 19;
                    case 115 -> 138;
                    case 116 -> 245;
                    case 117 -> 247;
                    case 118 -> 129;
                    case 119 -> 113;
                    case 120 -> 143;
                    case 121 -> 216;
                    case 122 -> 240;
                    case 123 -> 6;
                    case 124 -> 33;
                    case 125 -> 229;
                    case 126 -> 72;
                    case 127 -> 197;
                    case 128 -> 88;
                    case 129 -> 41;
                    case 130 -> 176;
                    case 131 -> 173;
                    case 132 -> 252;
                    case 133 -> 43;
                    case 134 -> 227;
                    case 135 -> 28;
                    case 136 -> 212;
                    case 137 -> 126;
                    case 138 -> 193;
                    case 139 -> 2;
                    case 140 -> 122;
                    case 141 -> 219;
                    case 142 -> 231;
                    case 143 -> 56;
                    case 144 -> 158;
                    case 145 -> 202;
                    case 146 -> 111;
                    case 147 -> 75;
                    case 148 -> 153;
                    case 149 -> 0;
                    case 150 -> 115;
                    case 151 -> 233;
                    case 152 -> 38;
                    case 153 -> 225;
                    case 154 -> 228;
                    case 155 -> 178;
                    case 156 -> 24;
                    case 157 -> 104;
                    case 158 -> 98;
                    case 159 -> 172;
                    case 160 -> 35;
                    case 161 -> 192;
                    case 162 -> 105;
                    case 163 -> 1;
                    case 164 -> 241;
                    case 165 -> 224;
                    case 166 -> 125;
                    case 167 -> 81;
                    case 168 -> 60;
                    case 169 -> 100;
                    case 170 -> 250;
                    case 171 -> 183;
                    case 172 -> 58;
                    case 173 -> 130;
                    case 174 -> 134;
                    case 175 -> 222;
                    case 176 -> 86;
                    case 177 -> 70;
                    case 178 -> 44;
                    case 179 -> 10;
                    case 180 -> 127;
                    case 181 -> 78;
                    case 182 -> 209;
                    case 183 -> 201;
                    case 184 -> 210;
                    case 185 -> 7;
                    case 186 -> 18;
                    case 187 -> 66;
                    case 188 -> 59;
                    case 189 -> 235;
                    case 190 -> 238;
                    case 191 -> 137;
                    case 192 -> 155;
                    case 193 -> 232;
                    case 194 -> 253;
                    case 195 -> 164;
                    case 196 -> 195;
                    case 197 -> 34;
                    case 198 -> 76;
                    case 199 -> 36;
                    case 200 -> 149;
                    case 201 -> 174;
                    case 202 -> 236;
                    case 203 -> 93;
                    case 204 -> 162;
                    case 205 -> 214;
                    case 206 -> 119;
                    case 207 -> 114;
                    case 208 -> 217;
                    case 209 -> 26;
                    case 210 -> 47;
                    case 211 -> 234;
                    case 212 -> 80;
                    case 213 -> 87;
                    case 214 -> 73;
                    case 215 -> 152;
                    case 216 -> 57;
                    case 217 -> 90;
                    case 218 -> 177;
                    case 219 -> 21;
                    case 220 -> 5;
                    case 221 -> 187;
                    case 222 -> 205;
                    case 223 -> 248;
                    case 224 -> 42;
                    case 225 -> 108;
                    case 226 -> 160;
                    case 227 -> 55;
                    case 228 -> 102;
                    case 229 -> 218;
                    case 230 -> 69;
                    case 231 -> 16;
                    case 232 -> 101;
                    case 233 -> 48;
                    case 234 -> 184;
                    case 235 -> 237;
                    case 236 -> 71;
                    case 237 -> 15;
                    case 238 -> 211;
                    case 239 -> 31;
                    case 240 -> 140;
                    case 241 -> 112;
                    case 242 -> 30;
                    case 243 -> 20;
                    case 244 -> 190;
                    case 245 -> 63;
                    case 246 -> 51;
                    case 247 -> 74;
                    case 248 -> 23;
                    case 249 -> 145;
                    case 250 -> 169;
                    case 251 -> 84;
                    case 252 -> 244;
                    case 253 -> 92;
                    case 254 -> 52;
                    default -> 148;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeWritableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }
}

