/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.editor.KotlinEnterAfterUnmatchedBraceHandlerKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J \u0010\u0012\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\fH\u0014J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u001aH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinEnterAfterUnmatchedBraceHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler;", "<init>", "()V", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffsetRef", "Lcom/intellij/openapi/util/Ref;", "", "caretAdvance", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "getRBraceOffset", "caretOffset", "getRBraceForLambda", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "(Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;)Ljava/lang/Integer;", "isDeclarationInitializer", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.base.code-insight.minimal"})
public final class KotlinEnterAfterUnmatchedBraceHandler
extends EnterAfterUnmatchedBraceHandler {
    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(caretOffsetRef, (String)"caretOffsetRef");
        Intrinsics.checkNotNullParameter(caretAdvance, (String)"caretAdvance");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        int caretOffset = ((Number)caretOffsetRef.get()).intValue() - 1;
        PsiElement element = file.findElementAt(caretOffset);
        PsiElement psiElement = element;
        if (Intrinsics.areEqual((Object)(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)KtTokens.LBRACE)) {
            EnterHandlerDelegate.Result result = super.preprocessEnter(file, editor, caretOffsetRef, caretAdvance, dataContext, originalHandler);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"preprocessEnter(...)");
            return result;
        }
        if (!(element instanceof PsiWhiteSpace)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiElement prevElement = KotlinEnterAfterUnmatchedBraceHandlerKt.getElementAtOffsetIgnoreWhitespaceAfter(file, caretOffset);
        if (prevElement != null && Intrinsics.areEqual((Object)prevElement.getNode().getElementType(), (Object)KtTokens.LBRACE)) {
            EnterHandlerDelegate.Result result = super.preprocessEnter(file, editor, new Ref((Object)(PsiUtilsKt.getStartOffset((PsiElement)prevElement) + 1)), caretAdvance, dataContext, originalHandler);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"preprocessEnter(...)");
            return result;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    protected int getRBraceOffset(@NotNull PsiFile file, @NotNull Editor editor, int caretOffset) {
        Integer endOffset;
        Integer n;
        PsiElement parent;
        PsiElement nextSibling;
        PsiElement element;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        PsiElement psiElement = element = file.findElementAt(caretOffset - 1);
        Object object = nextSibling = psiElement != null ? psiElement.getNextSibling() : null;
        if (nextSibling instanceof PsiWhiteSpace && ((PsiWhiteSpace)nextSibling).textContains('\n')) {
            return super.getRBraceOffset(file, editor, caretOffset);
        }
        PsiElement psiElement2 = element;
        Object object2 = parent = psiElement2 != null ? psiElement2.getParent() : null;
        if (parent instanceof KtFunctionLiteral) {
            n = this.getRBraceForLambda((KtFunctionLiteral)parent);
        } else if (parent instanceof KtWhenExpression) {
            if (this.isDeclarationInitializer((KtExpression)parent)) {
                List list = ((KtWhenExpression)parent).getEntries();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntries(...)");
                Object[] objectArray = (Object[])CollectionsKt.firstOrNull((List)list);
                KtWhenCondition ktWhenCondition = objectArray != null && (objectArray = objectArray.getConditions()) != null ? (KtWhenCondition)ArraysKt.firstOrNull((Object[])objectArray) : null;
                KtWhenConditionWithExpression ktWhenConditionWithExpression = ktWhenCondition instanceof KtWhenConditionWithExpression ? (KtWhenConditionWithExpression)ktWhenCondition : null;
                n = ktWhenConditionWithExpression != null ? Integer.valueOf(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktWhenConditionWithExpression))) : null;
            } else {
                n = null;
            }
        } else {
            n = null;
        }
        Integer n2 = endOffset = n;
        return n2 != null ? n2.intValue() : super.getRBraceOffset(file, editor, caretOffset);
    }

    private final Integer getRBraceForLambda(KtFunctionLiteral functionLiteral) {
        PsiElement firstVisibleChild;
        PsiElement psiElement = functionLiteral.getParent();
        KtLambdaExpression ktLambdaExpression = psiElement instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement : null;
        if (ktLambdaExpression == null || (ktLambdaExpression = ktLambdaExpression.getBodyExpression()) == null) {
            return null;
        }
        KtLambdaExpression bodyExpression = ktLambdaExpression;
        PsiElement psiElement2 = bodyExpression.getFirstChild();
        PsiElement psiElement3 = firstVisibleChild = psiElement2 != null ? PsiUtilsKt.getNextSiblingIgnoringWhitespace((PsiElement)psiElement2, (boolean)true) : null;
        return psiElement3 != null ? Integer.valueOf(PsiUtilsKt.getEndOffset((PsiElement)psiElement3)) : null;
    }

    private final boolean isDeclarationInitializer(KtExpression $this$isDeclarationInitializer) {
        PsiElement psiElement = $this$isDeclarationInitializer.getParent();
        KtDeclarationWithInitializer ktDeclarationWithInitializer = psiElement instanceof KtDeclarationWithInitializer ? (KtDeclarationWithInitializer)psiElement : null;
        return Intrinsics.areEqual((Object)(ktDeclarationWithInitializer != null ? ktDeclarationWithInitializer.getInitializer() : null), (Object)$this$isDeclarationInitializer);
    }
}

