/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.nastradamus;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.TestCaseLoader;
import com.intellij.nastradamus.model.BuildInfo;
import com.intellij.nastradamus.model.ChangeEntity;
import com.intellij.nastradamus.model.SortRequestEntity;
import com.intellij.nastradamus.model.TestCaseEntity;
import com.intellij.nastradamus.model.TestClassResultEntity;
import com.intellij.nastradamus.model.TestResultEntity;
import com.intellij.nastradamus.model.TestResultRequestEntity;
import com.intellij.nastradamus.model.TestStatus;
import com.intellij.teamcity.TeamCityClient;
import com.intellij.tool.ErrorThresholdKt;
import com.intellij.tool.HttpClient;
import com.intellij.tool.RetryKt;
import com.intellij.tool.TaskKt;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aJ,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0005H\u0002J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0005J\u0006\u0010%\u001a\u00020&J\u0016\u0010'\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00130\u0012J\"\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\"2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001a0+R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00130\u0012X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/nastradamus/NastradamusClient;", "", "baseUrl", "Ljava/net/URI;", "unsortedClasses", "", "Ljava/lang/Class;", "teamCityClient", "Lcom/intellij/teamcity/TeamCityClient;", "<init>", "(Ljava/net/URI;Ljava/util/List;Lcom/intellij/teamcity/TeamCityClient;)V", "getBaseUrl", "()Ljava/net/URI;", "getUnsortedClasses", "()Ljava/util/List;", "sortedClassesInCurrentBucket", "", "allSortedClasses", "", "", "collectTestRunResults", "Lcom/intellij/nastradamus/model/TestResultRequestEntity;", "sendTestRunResults", "", "testResultRequestEntity", "wasNastradamusDataUsed", "", "sendSortingRequest", "Lcom/intellij/nastradamus/model/TestCaseEntity;", "sortRequestEntity", "Lcom/intellij/nastradamus/model/SortRequestEntity;", "bucketsCount", "currentBucketIndex", "getTeamCityChangesetPatch", "", "getTeamCityChangesDetails", "Lcom/intellij/nastradamus/model/ChangeEntity;", "getBuildInfo", "Lcom/intellij/nastradamus/model/BuildInfo;", "getRankedClasses", "isClassInBucket", "testIdentifier", "fallbackFunc", "Lkotlin/Function1;", "Companion", "intellij.platform.testFramework.core"})
@SourceDebugExtension(value={"SMAP\nNastradamusClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NastradamusClient.kt\ncom/intellij/nastradamus/NastradamusClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,300:1\n295#2,2:301\n295#2,2:303\n1563#2:305\n1634#2,3:306\n1563#2:322\n1634#2,3:323\n1056#2:326\n1285#2,2:327\n1299#2,4:329\n1563#2:333\n1634#2,3:334\n1193#2,2:337\n1267#2,4:339\n774#2:343\n865#2,2:344\n1285#2,2:346\n1299#2,4:348\n1761#2,3:352\n1#3:309\n350#4,12:310\n*S KotlinDebug\n*F\n+ 1 NastradamusClient.kt\ncom/intellij/nastradamus/NastradamusClient\n*L\n41#1:301,2\n43#1:303,2\n48#1:305\n48#1:306,3\n169#1:322\n169#1:323,3\n244#1:326\n244#1:327,2\n244#1:329,4\n253#1:333\n253#1:334,3\n262#1:337,2\n262#1:339,4\n264#1:343\n264#1:344,2\n266#1:346,2\n266#1:348,4\n287#1:352,3\n167#1:310,12\n*E\n"})
public final class NastradamusClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URI baseUrl;
    @NotNull
    private final List<Class<?>> unsortedClasses;
    @NotNull
    private final TeamCityClient teamCityClient;
    private Set<? extends Class<?>> sortedClassesInCurrentBucket;
    private Map<Class<?>, Integer> allSortedClasses;
    @NotNull
    private static final ObjectMapper jacksonMapper = ExtensionsKt.jacksonObjectMapper();

    public NastradamusClient(@NotNull URI baseUrl, @NotNull List<? extends Class<?>> unsortedClasses, @NotNull TeamCityClient teamCityClient) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter(unsortedClasses, (String)"unsortedClasses");
        Intrinsics.checkNotNullParameter((Object)teamCityClient, (String)"teamCityClient");
        this.baseUrl = baseUrl;
        this.unsortedClasses = unsortedClasses;
        this.teamCityClient = teamCityClient;
    }

    public /* synthetic */ NastradamusClient(URI uRI, List list, TeamCityClient teamCityClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            URI uRI2 = new URI(System.getProperty("idea.nastradamus.url")).normalize();
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"normalize(...)");
            uRI = uRI2;
        }
        if ((n & 4) != 0) {
            teamCityClient = new TeamCityClient(null, null, 3, null);
        }
        this(uRI, list, teamCityClient);
    }

    @NotNull
    public final URI getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    public final List<Class<?>> getUnsortedClasses() {
        return this.unsortedClasses;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TestResultRequestEntity collectTestRunResults() {
        void $this$mapTo$iv$iv;
        Object v3;
        Iterable $this$firstOrNull$iv;
        int bucketId;
        Object element$iv2;
        Iterable $this$firstOrNull$iv2;
        List<JsonNode> tests;
        block6: {
            Object object;
            List buildProperties;
            JsonNode jsonNode;
            block5: {
                Object object2;
                Sequence sequence;
                Iterator iterator;
                tests = this.teamCityClient.getTestRunInfo();
                JsonNode build = this.teamCityClient.getBuildInfo();
                JsonNode jsonNode2 = build.findValue("properties");
                buildProperties = jsonNode2 != null && (jsonNode = jsonNode2.findValue("property")) != null && (iterator = jsonNode.elements()) != null && (sequence = SequencesKt.asSequence((Iterator)iterator)) != null && (object2 = SequencesKt.toList((Sequence)sequence)) != null ? object2 : CollectionsKt.emptyList();
                $this$firstOrNull$iv2 = buildProperties;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv2) {
                    JsonNode it = (JsonNode)element$iv2;
                    boolean bl = false;
                    Object object3 = it.findValue("name");
                    if (object3 == null || (object3 = object3.asText()) == null) {
                        object3 = "";
                    }
                    if (!Intrinsics.areEqual((Object)object3, (Object)"system.pass.idea.test.runner.index")) continue;
                    object = element$iv2;
                    break block5;
                }
                object = null;
            }
            jsonNode = (JsonNode)object;
            bucketId = jsonNode != null && ($this$firstOrNull$iv2 = jsonNode.findValue("value")) != null ? $this$firstOrNull$iv2.asInt() : 0;
            $this$firstOrNull$iv = buildProperties;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv3 : $this$firstOrNull$iv) {
                JsonNode it = (JsonNode)element$iv3;
                boolean bl = false;
                Object object4 = it.findValue("name");
                if (object4 == null || (object4 = object4.asText()) == null) {
                    object4 = "";
                }
                if (!Intrinsics.areEqual((Object)object4, (Object)"system.pass.idea.test.runners.count")) continue;
                v3 = element$iv3;
                break block6;
            }
            v3 = null;
        }
        $this$firstOrNull$iv2 = v3;
        int bucketsNumber = $this$firstOrNull$iv2 != null && ($this$firstOrNull$iv = $this$firstOrNull$iv2.findValue("value")) != null ? $this$firstOrNull$iv.asInt() : 0;
        Map testResultEntities = new LinkedHashMap();
        Iterable $this$map$iv = tests;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void json;
            JsonNode jsonNode = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = json.findValue("name").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
            String string2 = json.findValue("status").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asText(...)");
            JsonNode jsonNode3 = json.findValue("duration");
            JsonNode jsonNode4 = json.findValue("currentlyInvestigated");
            JsonNode jsonNode5 = json.findValue("currentlyMuted");
            TestResultEntity testResult = new TestResultEntity(string, TestStatus.Companion.fromString(string2), json.findValue("runOrder").asInt(), jsonNode3 != null ? jsonNode3.asLong() : 0L, jsonNode4 != null ? jsonNode4.asBoolean() : false, jsonNode5 != null ? jsonNode5.asBoolean() : false);
            JsonNode parsedTestName = json.findValue("test").findValue("parsedTestName");
            String packageName = parsedTestName.findValue("testPackage").asText();
            String shortClassName = parsedTestName.findValue("testClass").asText();
            String fullClassName = packageName + "." + shortClassName;
            testResultEntities.computeIfPresent(fullClassName, (arg_0, arg_1) -> NastradamusClient.collectTestRunResults$lambda$7$lambda$4((arg_0, arg_1) -> NastradamusClient.collectTestRunResults$lambda$7$lambda$3(testResult, arg_0, arg_1), arg_0, arg_1));
            collection.add(testResultEntities.computeIfAbsent(fullClassName, arg_0 -> NastradamusClient.collectTestRunResults$lambda$7$lambda$6(arg_0 -> NastradamusClient.collectTestRunResults$lambda$7$lambda$5(fullClassName, testResult, bucketId, bucketsNumber, arg_0), arg_0)));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return new TestResultRequestEntity(this.getBuildInfo(), CollectionsKt.toList((Iterable)testResultEntities.values()), this.getTeamCityChangesDetails());
    }

    public final void sendTestRunResults(@NotNull TestResultRequestEntity testResultRequestEntity, boolean wasNastradamusDataUsed) {
        HttpPost httpPost;
        Intrinsics.checkNotNullParameter((Object)testResultRequestEntity, (String)"testResultRequestEntity");
        URI uri = new URIBuilder(this.baseUrl.resolve("/result/").normalize()).addParameter("was_nastradamus_data_used", String.valueOf(wasNastradamusDataUsed)).build();
        String stringJson = jacksonMapper.writeValueAsString((Object)testResultRequestEntity);
        HttpPost $this$sendTestRunResults_u24lambda_u248 = httpPost = new HttpPost(uri);
        boolean bl = false;
        $this$sendTestRunResults_u24lambda_u248.addHeader("Content-Type", "application/json");
        $this$sendTestRunResults_u24lambda_u248.addHeader("Accept", "application/json");
        $this$sendTestRunResults_u24lambda_u248.setEntity((HttpEntity)new StringEntity(stringJson, ContentType.APPLICATION_JSON));
        HttpPost httpPost2 = httpPost;
        System.out.println((Object)"Sending test run results to Nastradamus ...");
        if (TestCaseLoader.IS_VERBOSE_LOG_ENABLED) {
            System.out.println((Object)("Requesting " + uri + " with payload " + stringJson));
        }
        ErrorThresholdKt.withErrorThreshold$default("NastradamusClient-sendTestRunResults", 0, () -> NastradamusClient.sendTestRunResults$lambda$11(httpPost2), NastradamusClient::sendTestRunResults$lambda$12, 2, null);
    }

    @NotNull
    public final List<TestCaseEntity> sendSortingRequest(@NotNull SortRequestEntity sortRequestEntity, int bucketsCount, int currentBucketIndex, boolean wasNastradamusDataUsed) {
        HttpPost httpPost;
        Intrinsics.checkNotNullParameter((Object)sortRequestEntity, (String)"sortRequestEntity");
        URI uri = new URIBuilder(this.baseUrl.resolve("/sort/").normalize()).addParameter("buckets", String.valueOf(bucketsCount)).addParameter("was_nastradamus_data_used", String.valueOf(wasNastradamusDataUsed)).build();
        String stringJson = jacksonMapper.writeValueAsString((Object)sortRequestEntity);
        HttpPost $this$sendSortingRequest_u24lambda_u2413 = httpPost = new HttpPost(uri);
        boolean bl = false;
        $this$sendSortingRequest_u24lambda_u2413.addHeader("Content-Type", "application/json");
        $this$sendSortingRequest_u24lambda_u2413.addHeader("Accept", "application/json");
        $this$sendSortingRequest_u24lambda_u2413.setEntity((HttpEntity)new StringEntity(stringJson, ContentType.APPLICATION_JSON));
        HttpPost httpPost2 = httpPost;
        System.out.println((Object)"Fetching sorted test classes from Nastradamus ...");
        if (TestCaseLoader.IS_VERBOSE_LOG_ENABLED) {
            System.out.println((Object)("Requesting " + uri + " with payload " + stringJson));
        }
        return (List)ErrorThresholdKt.withErrorThreshold$default("NastradamusClient-sendSortingRequest", 0, () -> NastradamusClient.sendSortingRequest$lambda$19(uri, currentBucketIndex, httpPost2), NastradamusClient::sendSortingRequest$lambda$20, 2, null);
    }

    private final List<String> getTeamCityChangesetPatch() {
        System.out.println((Object)"Fetching changesets patches from TeamCity ...");
        List changesets2 = (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends String>>, Object>(this, null){
            int label;
            final /* synthetic */ NastradamusClient this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TaskKt.mapConcurrently((Iterable)NastradamusClient.access$getTeamCityClient$p(this.this$0).getChanges(), 5, (Function2)new Function2<JsonNode, Continuation<? super String>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ NastradamusClient this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                JsonNode jsonNode = (JsonNode)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void change;
                                        ResultKt.throwOnFailure((Object)$result);
                                        String modificationId = change.findValue("id").asText();
                                        JsonNode jsonNode2 = change.findValue("personal");
                                        boolean isPersonal = jsonNode2 != null ? jsonNode2.asBoolean(false) : false;
                                        TeamCityClient teamCityClient = NastradamusClient.access$getTeamCityClient$p(this.this$0);
                                        Intrinsics.checkNotNull((Object)modificationId);
                                        return teamCityClient.downloadChangesPatch(modificationId, isPersonal);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(JsonNode p1, Continuation<? super String> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        System.out.println((Object)"Fetching changesets patches completed");
        return changesets2;
    }

    @NotNull
    public final List<ChangeEntity> getTeamCityChangesDetails() {
        System.out.println((Object)"Getting changes details from TeamCity ...");
        List changeDetails2 = (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends ChangeEntity>>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ NastradamusClient this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        List<JsonNode> changes = NastradamusClient.access$getTeamCityClient$p(this.this$0).getChanges();
                        this.L$0 = SpillingKt.nullOutSpilledVariable(changes);
                        this.label = 1;
                        Object object2 = TaskKt.mapConcurrently((Iterable)changes, 5, (Function2)new Function2<JsonNode, Continuation<? super List<? extends ChangeEntity>>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ NastradamusClient this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                JsonNode jsonNode = (JsonNode)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void change;
                                        ResultKt.throwOnFailure((Object)$result);
                                        TeamCityClient teamCityClient = NastradamusClient.access$getTeamCityClient$p(this.this$0);
                                        String string = change.findValue("id").asText();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
                                        return teamCityClient.getChangeDetails(string);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(JsonNode p1, Continuation<? super List<ChangeEntity>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this);
                        if (object2 != object) return CollectionsKt.flatten((Iterable)((Iterable)object2));
                        return object;
                    }
                    case 1: {
                        List changes = (List)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return CollectionsKt.flatten((Iterable)((Iterable)object2));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<ChangeEntity>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        System.out.println((Object)"Fetching changes details completed");
        return changeDetails2;
    }

    @NotNull
    public final BuildInfo getBuildInfo() {
        Object object;
        String string;
        JsonNode triggeredByInfo = this.teamCityClient.getTriggeredByInfo();
        JsonNode triggeredByBuild = triggeredByInfo.findValue("build");
        if (triggeredByBuild == null) {
            string = this.teamCityClient.getBuildId();
        } else {
            String string2 = triggeredByBuild.findValue("id").asText(this.teamCityClient.getBuildId());
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asText(...)");
        }
        String aggregatorBuildId = string;
        JsonNode buildInfo = this.teamCityClient.getBuildInfo();
        Object object2 = buildInfo.findValue("branchName");
        if (object2 == null || (object2 = object2.asText("")) == null) {
            object2 = "";
        }
        Object branchName = object2;
        String string3 = this.teamCityClient.getBuildId();
        String string4 = this.teamCityClient.getOs();
        String string5 = this.teamCityClient.getBuildTypeId();
        Object object3 = buildInfo.findValue("status");
        if (object3 == null || (object3 = object3.asText("")) == null) {
            object3 = "";
        }
        if ((object = buildInfo.findValue("statusText")) == null || (object = object.asText("")) == null) {
            object = "";
        }
        return new BuildInfo(string3, aggregatorBuildId, (String)branchName, string4, string5, (String)object3, (String)object);
    }

    @NotNull
    public final Map<Class<?>, Integer> getRankedClasses() {
        Map<Class<?>, Integer> map;
        System.out.println((Object)"Getting sorted (& bucketed) test classes from Nastradamus ...");
        try {
            map = (Map<Class<?>, Integer>)ErrorThresholdKt.withErrorThreshold("NastradamusClient-getRankedClasses", 1, () -> NastradamusClient.getRankedClasses$lambda$27(this), () -> NastradamusClient.getRankedClasses$lambda$28(this));
        }
        catch (Throwable e) {
            System.err.println("Failure during sorting test classes via Nastradamus. Fallback to simple natural sorting.");
            this.allSortedClasses = NastradamusClient.getRankedClasses$fallback(this);
            Map<Class<?>, Integer> map2 = this.allSortedClasses;
            if (map2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"allSortedClasses");
                map2 = null;
            }
            map = map2;
        }
        return map;
    }

    public final boolean isClassInBucket(@NotNull String testIdentifier, @NotNull Function1<? super String, Boolean> fallbackFunc) {
        Intrinsics.checkNotNullParameter((Object)testIdentifier, (String)"testIdentifier");
        Intrinsics.checkNotNullParameter(fallbackFunc, (String)"fallbackFunc");
        if (this.allSortedClasses == null) {
            this.getRankedClasses();
        }
        boolean isMatch = (Boolean)ErrorThresholdKt.withErrorThreshold("NastradamusClient-isClassInBucket", 1, () -> NastradamusClient.isClassInBucket$lambda$30(this, testIdentifier), () -> NastradamusClient.isClassInBucket$lambda$31(testIdentifier, fallbackFunc));
        if (TestCaseLoader.IS_VERBOSE_LOG_ENABLED) {
            System.out.println((Object)("Nastradamus. Class " + testIdentifier + " matches current bucket " + TestCaseLoader.TEST_RUNNER_INDEX + " - " + isMatch));
        }
        return isMatch;
    }

    /*
     * WARNING - void declaration
     */
    private static final TestClassResultEntity collectTestRunResults$lambda$7$lambda$3(TestResultEntity $testResult, String string, TestClassResultEntity oldClassResult) {
        void $this$collectTestRunResults_u24lambda_u247_u24lambda_u243_u24lambda_u242;
        Set set;
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)oldClassResult, (String)"oldClassResult");
        Set set2 = set = CollectionsKt.toMutableSet((Iterable)oldClassResult.getTestResults());
        long l = oldClassResult.getDurationMs() + $testResult.getDurationMs();
        String string2 = null;
        TestClassResultEntity testClassResultEntity = oldClassResult;
        boolean bl = false;
        $this$collectTestRunResults_u24lambda_u247_u24lambda_u243_u24lambda_u242.add($testResult);
        Unit unit = Unit.INSTANCE;
        return TestClassResultEntity.copy$default(testClassResultEntity, string2, l, set, 0, 0, 25, null);
    }

    private static final TestClassResultEntity collectTestRunResults$lambda$7$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        return (TestClassResultEntity)$tmp0.invoke(p0, p1);
    }

    private static final TestClassResultEntity collectTestRunResults$lambda$7$lambda$5(String $fullClassName, TestResultEntity $testResult, int $bucketId, int $bucketsNumber, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new TestResultEntity[]{$testResult};
        return new TestClassResultEntity($fullClassName, $testResult.getDurationMs(), SetsKt.mutableSetOf((Object[])objectArray), $bucketId, $bucketsNumber);
    }

    private static final TestClassResultEntity collectTestRunResults$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        return (TestClassResultEntity)$tmp0.invoke(p0);
    }

    private static final Unit sendTestRunResults$lambda$11$lambda$10$lambda$9(HttpResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (response.getStatusLine().getStatusCode() != 200) {
            InputStream inputStream = response.getEntity().getContent();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getContent(...)");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            throw new RuntimeException(StringsKt.trimIndent((String)("\n                Couldn't store test run results on Nastradamus.\n                " + response + "\n                " + TextStreamsKt.readText((Reader)new InputStreamReader(inputStream2, charset)) + "\n                ")));
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendTestRunResults$lambda$11$lambda$10(HttpPost $httpPost) {
        HttpClient.INSTANCE.sendRequest((HttpUriRequest)$httpPost, NastradamusClient::sendTestRunResults$lambda$11$lambda$10$lambda$9);
        return Unit.INSTANCE;
    }

    private static final Unit sendTestRunResults$lambda$11(HttpPost $httpPost) {
        return (Unit)RetryKt.withRetry-exY8QGI$default(0, null, 0L, () -> NastradamusClient.sendTestRunResults$lambda$11$lambda$10($httpPost), 7, null);
    }

    private static final Unit sendTestRunResults$lambda$12() {
        return Unit.INSTANCE;
    }

    private static final JsonNode sendSortingRequest$lambda$19$lambda$15$lambda$14(HttpResponse it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return jacksonMapper.readTree(it.getEntity().getContent());
    }

    private static final JsonNode sendSortingRequest$lambda$19$lambda$15(HttpPost $httpPost) {
        return (JsonNode)HttpClient.INSTANCE.sendRequest((HttpUriRequest)$httpPost, NastradamusClient::sendSortingRequest$lambda$19$lambda$15$lambda$14);
    }

    /*
     * WARNING - void declaration
     */
    private static final List sendSortingRequest$lambda$19(URI $uri, int $currentBucketIndex, HttpPost $httpPost) {
        List list;
        JsonNode jsonTree = (JsonNode)RetryKt.withRetry-exY8QGI$default(0, null, 0L, () -> NastradamusClient.sendSortingRequest$lambda$19$lambda$15($httpPost), 7, null);
        if (jsonTree == null) {
            boolean $i$a$-requireNotNull-NastradamusClient$sendSortingRequest$1$22 = false;
            String $i$a$-requireNotNull-NastradamusClient$sendSortingRequest$1$22 = "Received data from " + $uri + " must not be null";
            throw new IllegalArgumentException($i$a$-requireNotNull-NastradamusClient$sendSortingRequest$1$22.toString());
        }
        if (TestCaseLoader.IS_VERBOSE_LOG_ENABLED) {
            System.out.println((Object)("Received data from " + $uri + ": " + jsonTree));
        }
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry it;
            void $this$single$iv;
            Iterator iterator = jsonTree.fields();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"fields(...)");
            Sequence sequence = SequencesKt.asSequence((Iterator)iterator);
            boolean $i$f$single22 = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getKey(), (Object)"sorted_tests")) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            Object $i$a$-requireNotNull-NastradamusClient$sendSortingRequest$1$22 = ((JsonNode)((Map.Entry)single$iv).getValue()).get(String.valueOf($currentBucketIndex));
            Intrinsics.checkNotNullExpressionValue((Object)$i$a$-requireNotNull-NastradamusClient$sendSortingRequest$1$22, (String)"get(...)");
            $i$a$-requireNotNull-NastradamusClient$sendSortingRequest$1$22 = (Iterable)$i$a$-requireNotNull-NastradamusClient$sendSortingRequest$1$22;
            boolean $i$f$map = false;
            void $i$f$single22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (JsonNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.findValue("name").asText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
                collection.add(new TestCaseEntity(string));
            }
            list = (List)destination$iv$iv;
        }
        catch (Throwable e) {
            throw new RuntimeException("Response from " + $uri + " with failure: " + jsonTree, e);
        }
        return list;
    }

    private static final List sendSortingRequest$lambda$20() {
        throw new RuntimeException("Couldn't get sorted test classes from Nastradamus");
    }

    private static final Map<Class<?>, Integer> getRankedClasses$fallback(NastradamusClient this$0) {
        int rank = 0;
        rank = 1;
        Iterable $this$sortedBy$iv = this$0.unsortedClasses;
        boolean $i$f$sortedBy = false;
        Iterable $this$associateWith$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Class it = (Class)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Class)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Class clazz = (Class)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            int n = rank;
            rank = n + 1;
            Integer n2 = n;
            map.put(t, n2);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map getRankedClasses$lambda$27(NastradamusClient this$0) {
        void $this$associateWith$iv;
        Class it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$associateTo$iv$iv;
        Object object;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        List<ChangeEntity> changesets2 = this$0.getTeamCityChangesDetails();
        Iterable $this$map$iv = this$0.unsortedClasses;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void it2;
            Class clazz = (Class)item$iv$iv2;
            object = destination$iv$iv;
            boolean bl = false;
            String string = it2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            object.add(new TestCaseEntity(string));
        }
        List cases = (List)destination$iv$iv;
        List<TestCaseEntity> sortedCases = this$0.sendSortingRequest(new SortRequestEntity(this$0.getBuildInfo(), changesets2, cases), TestCaseLoader.TEST_RUNNERS_COUNT, TestCaseLoader.TEST_RUNNER_INDEX, TestCaseLoader.IS_NASTRADAMUS_TEST_DISTRIBUTOR_ENABLED);
        int rank = 0;
        rank = 1;
        Iterable $this$associate$iv = sortedCases;
        boolean $i$f$associate = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        item$iv$iv2 = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            TestCaseEntity testCaseEntity = (TestCaseEntity)element$iv$iv;
            boolean bl = false;
            int n = rank;
            rank = n + 1;
            Pair pair = TuplesKt.to((Object)testCaseEntity.getName(), (Object)n);
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map rankedTestClassesForCurrentBucket = destination$iv$iv2;
        $this$associate$iv = this$0.unsortedClasses;
        object = this$0;
        boolean $i$f$filter = false;
        void capacity$iv22 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Class)element$iv$iv;
            boolean bl = false;
            if (!rankedTestClassesForCurrentBucket.keySet().contains(it.getName())) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        ((NastradamusClient)object).sortedClassesInCurrentBucket = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
        $this$filter$iv = this$0.unsortedClasses;
        object = this$0;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void clazz;
            it = (Class)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Integer n = (Integer)rankedTestClassesForCurrentBucket.get(clazz.getName());
            Integer n2 = n != null ? n : Integer.MAX_VALUE;
            map.put(t, n2);
        }
        ((NastradamusClient)object).allSortedClasses = result$iv;
        System.out.println((Object)"Fetching sorted test classes from Nastradamus completed");
        Map<Class<?>, Integer> map = this$0.allSortedClasses;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"allSortedClasses");
            map = null;
        }
        return map;
    }

    private static final Map getRankedClasses$lambda$28(NastradamusClient this$0) {
        return NastradamusClient.getRankedClasses$fallback(this$0);
    }

    private static final boolean isClassInBucket$lambda$30(NastradamusClient this$0, String $testIdentifier) {
        boolean bl;
        block4: {
            Set<Class<?>> set = this$0.sortedClassesInCurrentBucket;
            if (set == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sortedClassesInCurrentBucket");
                set = null;
            }
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Class it = (Class)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)$testIdentifier)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isClassInBucket$lambda$31(String $testIdentifier, Function1 $fallbackFunc) {
        System.err.println("Couldn't find appropriate bucket for " + $testIdentifier + " via Nastradamus");
        return (Boolean)$fallbackFunc.invoke((Object)$testIdentifier);
    }

    public static final /* synthetic */ TeamCityClient access$getTeamCityClient$p(NastradamusClient $this) {
        return $this.teamCityClient;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/nastradamus/NastradamusClient$Companion;", "", "<init>", "()V", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "intellij.platform.testFramework.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

