/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.file.PsiFileImplUtil;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.source.FileTrees;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.AstSpine;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.ReadOnlyLightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PatchedWeakReference;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiFileImpl
extends ElementBase
implements Queryable,
PsiFileEx,
PsiFileWithStubSupport,
Cloneable {
    private static final Logger LOG = Logger.getInstance(PsiFileImpl.class);
    private IElementType myElementType;
    protected IElementType myContentElementType;
    private long myModificationStamp;
    protected PsiFile myOriginalFile;
    private final AbstractFileViewProvider myViewProvider;
    private volatile FileTrees myTrees;
    private volatile boolean myPossiblyInvalidated;
    protected final PsiManagerEx myManager;
    public static final Key<Boolean> BUILDING_STUB = new Key("Don't use stubs mark!");
    private final PsiLock myPsiLock;
    private volatile boolean myLoadingAst;
    private static final Comparator<PsiFile> FILE_BY_LANGUAGE_ID = Comparator.comparing(o2 -> o2.getLanguage().getID());

    protected PsiFileImpl(@NotNull IElementType elementType, IElementType contentElementType, @NotNull FileViewProvider provider2) {
        if (elementType == null) {
            PsiFileImpl.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            PsiFileImpl.$$$reportNull$$$0(1);
        }
        this(provider2);
        this.init(elementType, contentElementType);
    }

    protected PsiFileImpl(@NotNull FileViewProvider provider2) {
        if (provider2 == null) {
            PsiFileImpl.$$$reportNull$$$0(2);
        }
        this.myTrees = FileTrees.noStub(null, this);
        this.myManager = (PsiManagerEx)provider2.getManager();
        this.myViewProvider = (AbstractFileViewProvider)provider2;
        this.myPsiLock = this.myViewProvider.getFilePsiLock();
    }

    public void setContentElementType(IElementType contentElementType) {
        LOG.assertTrue(contentElementType instanceof ILazyParseableElementType, contentElementType);
        this.myContentElementType = contentElementType;
    }

    public IElementType getContentElementType() {
        return this.myContentElementType;
    }

    protected void init(@NotNull IElementType elementType, IElementType contentElementType) {
        if (elementType == null) {
            PsiFileImpl.$$$reportNull$$$0(3);
        }
        this.myElementType = elementType;
        this.setContentElementType(contentElementType);
    }

    public TreeElement createContentLeafElement(CharSequence leafText) {
        if (this.myContentElementType instanceof ILazyParseableElementType) {
            return ASTFactory.lazy((ILazyParseableElementType)this.myContentElementType, leafText);
        }
        return ASTFactory.leaf(this.myContentElementType, leafText);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Nullable
    public FileElement getTreeElement() {
        FileElement node = this.derefTreeElement();
        if (node != null) {
            return node;
        }
        if (!this.getViewProvider().isPhysical()) {
            return this.loadTreeElement();
        }
        return null;
    }

    FileElement derefTreeElement() {
        return this.myTrees.derefTreeElement();
    }

    @Override
    public VirtualFile getVirtualFile() {
        VirtualFile indexingFile = IndexingDataKeys.VIRTUAL_FILE.get(this);
        if (indexingFile != null) {
            return indexingFile;
        }
        return this.getViewProvider().isEventSystemEnabled() ? this.getViewProvider().getVirtualFile() : null;
    }

    @Override
    public boolean processChildren(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        if (processor == null) {
            PsiFileImpl.$$$reportNull$$$0(4);
        }
        return true;
    }

    @Override
    public boolean isValid() {
        if (this.myManager.getProject().isDisposed()) {
            return false;
        }
        if (!this.myViewProvider.getVirtualFile().isValid()) {
            return false;
        }
        if (!this.myPossiblyInvalidated) {
            return true;
        }
        if (((FileManagerImpl)this.myManager.getFileManager()).evaluateValidity(this)) {
            this.myPossiblyInvalidated = false;
            PsiInvalidElementAccessException.setInvalidationTrace(this, null);
            return true;
        }
        return false;
    }

    @Override
    public final void markInvalidated() {
        this.myPossiblyInvalidated = true;
        DebugUtil.onInvalidated(this);
    }

    @Override
    public boolean isContentsLoaded() {
        return this.derefTreeElement() != null;
    }

    protected void assertReadAccessAllowed() {
        if (this.myViewProvider.getVirtualFile() instanceof ReadOnlyLightVirtualFile) {
            return;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private FileElement loadTreeElement() {
        FileElement treeElement;
        FileViewProvider viewProvider;
        block13: {
            FileElement fileElement;
            Object vFile;
            this.assertReadAccessAllowed();
            if (this.myPossiblyInvalidated) {
                PsiUtilCore.ensureValid(this);
            }
            if ((viewProvider = this.getViewProvider()).isPhysical()) {
                vFile = viewProvider.getVirtualFile();
                AstLoadingFilter.assertTreeLoadingAllowed((VirtualFile)vFile);
                if (this.myManager.isAssertOnFileLoading((VirtualFile)vFile)) {
                    PsiFileImpl.reportProhibitedAstAccess((VirtualFile)vFile);
                }
            }
            try {
                vFile = this.myPsiLock;
                // MONITORENTER : vFile
                treeElement = this.derefTreeElement();
                if (treeElement == null) break block13;
                fileElement = treeElement;
                // MONITOREXIT : vFile
            }
            catch (StubTreeLoader.StubTreeAndIndexUnmatchCoarseException e2) {
                throw e2.createCompleteException();
            }
            if (fileElement != null) return fileElement;
            PsiFileImpl.$$$reportNull$$$0(5);
            return fileElement;
        }
        treeElement = this.createFileElement(viewProvider.getContents());
        treeElement.setPsi(this);
        this.myLoadingAst = true;
        try {
            this.updateTrees(this.myTrees.withAst(this.createTreeElementPointer(treeElement)));
        }
        finally {
            this.myLoadingAst = false;
        }
        if (LOG.isDebugEnabled() && viewProvider.isPhysical()) {
            LOG.debug("Loaded text for file " + viewProvider.getVirtualFile().getPresentableUrl());
        }
        FileElement fileElement = treeElement;
        // MONITOREXIT : vFile
        if (fileElement != null) return fileElement;
        PsiFileImpl.$$$reportNull$$$0(6);
        return fileElement;
    }

    private static void reportProhibitedAstAccess(VirtualFile vFile) {
        LOG.error("Access to tree elements not allowed for '" + vFile.getPresentableUrl() + "'.\nTry using stub-based PSI API to avoid expensive AST loading for files that aren't already opened in the editor.\nConsult this method's javadoc for more details.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public StubbedSpine getStubbedSpine() {
        StubTree tree = this.getGreenStubTree();
        if (tree != null) {
            StubbedSpine stubbedSpine = tree.getSpine();
            if (stubbedSpine == null) {
                PsiFileImpl.$$$reportNull$$$0(7);
            }
            return stubbedSpine;
        }
        AstSpine astSpine = this.calcTreeElement().getStubbedSpine();
        if (!this.myTrees.useSpineRefs()) {
            PsiLock psiLock = this.myPsiLock;
            synchronized (psiLock) {
                this.updateTrees(this.myTrees.switchToSpineRefs(FileTrees.getAllSpinePsi(astSpine)));
            }
        }
        AstSpine astSpine2 = astSpine;
        if (astSpine2 == null) {
            PsiFileImpl.$$$reportNull$$$0(8);
        }
        return astSpine2;
    }

    @Nullable
    public IStubFileElementType<?> getElementTypeForStubBuilder() {
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.getLanguage());
        IFileElementType type = definition == null ? null : definition.getFileNodeType();
        return type instanceof IStubFileElementType ? (IStubFileElementType)type : null;
    }

    @NotNull
    protected FileElement createFileElement(CharSequence docText) {
        FileElement treeElement;
        TreeElement contentLeaf = this.createContentLeafElement(docText);
        if (contentLeaf instanceof FileElement) {
            treeElement = (FileElement)contentLeaf;
        } else {
            CompositeElement xxx = ASTFactory.composite(this.myElementType);
            assert (xxx instanceof FileElement) : "BUMM";
            treeElement = (FileElement)xxx;
            treeElement.rawAddChildrenWithoutNotifications(contentLeaf);
        }
        FileElement fileElement = treeElement;
        if (fileElement == null) {
            PsiFileImpl.$$$reportNull$$$0(9);
        }
        return fileElement;
    }

    @Override
    public void clearCaches() {
        ++this.myModificationStamp;
    }

    @Override
    public String getText() {
        FileElement tree = this.derefTreeElement();
        if (!this.isValid()) {
            ProgressManager.checkCanceled();
            if (tree != null) {
                return tree.getText();
            }
            throw new PsiInvalidElementAccessException(this);
        }
        String string = this.getViewProvider().getContents().toString();
        if (tree != null && string.length() != tree.getTextLength()) {
            throw new AssertionError((Object)("File text mismatch: tree.length=" + tree.getTextLength() + "; psi.length=" + string.length() + "; this=" + this + "; vp=" + this.getViewProvider()));
        }
        return string;
    }

    @Override
    public int getTextLength() {
        FileElement tree = this.derefTreeElement();
        if (tree != null) {
            return tree.getTextLength();
        }
        PsiUtilCore.ensureValid(this);
        return this.getViewProvider().getContents().length();
    }

    @Override
    public TextRange getTextRange() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public PsiElement getNextSibling() {
        return SharedPsiElementImplUtil.getNextSibling(this);
    }

    @Override
    public PsiElement getPrevSibling() {
        return SharedPsiElementImplUtil.getPrevSibling(this);
    }

    @Override
    public long getModificationStamp() {
        PsiElement context2 = this.getContext();
        PsiFile contextFile = context2 == null || !context2.isValid() ? null : context2.getContainingFile();
        long contextStamp = contextFile == null ? 0L : contextFile.getModificationStamp();
        return this.myModificationStamp + contextStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subtreeChanged() {
        FileElement tree = this.getTreeElement();
        if (tree != null) {
            tree.clearCaches();
        }
        PsiLock psiLock = this.myPsiLock;
        synchronized (psiLock) {
            if (this.myTrees.useSpineRefs()) {
                LOG.error("Somebody has requested stubbed spine during PSI operations; not only is this expensive, but will also cause stub PSI invalidation");
            }
            this.updateTrees(this.myTrees.clearStub("subtreeChanged"));
        }
        this.clearCaches();
        this.getViewProvider().rootChanged(this);
    }

    @Override
    protected PsiFileImpl clone() {
        FileViewProvider viewProvider = this.getViewProvider();
        FileViewProvider providerCopy = viewProvider.clone();
        Language language2 = this.getLanguage();
        if (providerCopy == null) {
            throw new AssertionError((Object)("Unable to clone the view provider: " + viewProvider + "; " + language2));
        }
        PsiFileImpl clone2 = BlockSupportImpl.getFileCopy(this, providerCopy);
        this.copyCopyableDataTo(clone2);
        if (this.getTreeElement() != null) {
            FileElement treeClone = (FileElement)this.calcTreeElement().clone();
            clone2.setTreeElementPointer(treeClone);
            treeClone.setPsi(clone2);
        } else {
            clone2.setTreeElementPointer(null);
        }
        if (viewProvider.isEventSystemEnabled()) {
            clone2.myOriginalFile = this;
        } else if (this.myOriginalFile != null) {
            clone2.myOriginalFile = this.myOriginalFile;
        }
        FileManagerImpl.clearPsiCaches(providerCopy);
        return clone2;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getViewProvider().getVirtualFile().getName();
        if (string == null) {
            PsiFileImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            PsiFileImpl.$$$reportNull$$$0(11);
        }
        this.checkSetName(name2);
        return PsiFileImplUtil.setName(this, name2);
    }

    @Override
    public void checkSetName(String name2) {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            return;
        }
        PsiFileImplUtil.checkSetName(this, name2);
    }

    @Override
    public boolean isWritable() {
        return this.getViewProvider().getVirtualFile().isWritable();
    }

    @Override
    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    @Override
    @Nullable
    public PsiDirectory getContainingDirectory() {
        VirtualFile file = this.getViewProvider().getVirtualFile();
        VirtualFile parentFile = file.getParent();
        if (parentFile == null) {
            return null;
        }
        if (!parentFile.isValid()) {
            LOG.error("Invalid parent: " + parentFile + " of file " + file + ", file.valid=" + file.isValid());
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        PsiFileImpl psiFileImpl = this;
        if (psiFileImpl == null) {
            PsiFileImpl.$$$reportNull$$$0(12);
        }
        return psiFileImpl;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        PsiFileImplUtil.doDelete(this);
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            if (PsiFileImplUtil.canDeleteNonPhysicalFile(this)) {
                return;
            }
            throw new IncorrectOperationException();
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    @NotNull
    public PsiFile getOriginalFile() {
        PsiFile psiFile = this.myOriginalFile == null ? this : this.myOriginalFile;
        if (psiFile == null) {
            PsiFileImpl.$$$reportNull$$$0(13);
        }
        return psiFile;
    }

    public void setOriginalFile(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            PsiFileImpl.$$$reportNull$$$0(14);
        }
        this.myOriginalFile = originalFile.getOriginalFile();
        FileViewProvider original = this.myOriginalFile.getViewProvider();
        ((AbstractFileViewProvider)original).registerAsCopy(this.myViewProvider);
    }

    @Override
    public PsiFile @NotNull [] getPsiRoots() {
        FileViewProvider viewProvider = this.getViewProvider();
        Set<Language> languages = viewProvider.getLanguages();
        PsiFile[] roots = new PsiFile[languages.size()];
        int i2 = 0;
        for (Language language2 : languages) {
            PsiFile psi = viewProvider.getPsi(language2);
            if (psi == null) {
                LOG.error("PSI is null for " + language2 + "; in file: " + this);
            }
            roots[i2++] = psi;
        }
        if (roots.length > 1) {
            Arrays.sort(roots, FILE_BY_LANGUAGE_ID);
        }
        if (roots == null) {
            PsiFileImpl.$$$reportNull$$$0(15);
        }
        return roots;
    }

    @Override
    public boolean isPhysical() {
        return this.getViewProvider().isEventSystemEnabled();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language2 = this.myElementType.getLanguage();
        if (language2 == null) {
            PsiFileImpl.$$$reportNull$$$0(16);
        }
        return language2;
    }

    @Override
    @Nullable
    public IFileElementType getFileElementType() {
        return this.myElementType instanceof IFileElementType ? (IFileElementType)this.myElementType : ObjectUtils.tryCast(this.myContentElementType, IFileElementType.class);
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        AbstractFileViewProvider abstractFileViewProvider = this.myViewProvider;
        if (abstractFileViewProvider == null) {
            PsiFileImpl.$$$reportNull$$$0(17);
        }
        return abstractFileViewProvider;
    }

    @Override
    @NotNull
    public final Document getFileDocument() {
        Document document = PsiFileEx.super.getFileDocument();
        if (document == null) {
            PsiFileImpl.$$$reportNull$$$0(18);
        }
        return document;
    }

    public void setTreeElementPointer(@Nullable FileElement element) {
        this.updateTrees(FileTrees.noStub(element, this));
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return this.getViewProvider().findElementAt(offset);
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        return this.getViewProvider().findReferenceAt(offset);
    }

    @Override
    public char @NotNull [] textToCharArray() {
        char[] cArray = CharArrayUtil.fromSequence(this.getViewProvider().getContents());
        if (cArray == null) {
            PsiFileImpl.$$$reportNull$$$0(19);
        }
        return cArray;
    }

    public <T> T @NotNull [] findChildrenByClass(Class<T> aClass) {
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement child : this.getChildren()) {
            if (!aClass.isInstance(child)) continue;
            result2.add(child);
        }
        T[] TArray = result2.toArray(ArrayUtil.newArray(aClass, result2.size()));
        if (TArray == null) {
            PsiFileImpl.$$$reportNull$$$0(20);
        }
        return TArray;
    }

    @Nullable
    public <T> T findChildByClass(Class<T> aClass) {
        for (PsiElement child : this.getChildren()) {
            if (!aClass.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    public boolean isTemplateDataFile() {
        return false;
    }

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    public void onContentReload() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.clearContent("onContentReload");
    }

    final void clearContent(String reason) {
        DebugUtil.performPsiModification(reason, () -> {
            PsiLock psiLock = this.myPsiLock;
            synchronized (psiLock) {
                FileElement treeElement = this.derefTreeElement();
                if (treeElement != null) {
                    treeElement.detachFromFile();
                    DebugUtil.onInvalidated(treeElement);
                }
                this.updateTrees(this.myTrees.clearStub(reason));
                this.setTreeElementPointer(null);
            }
        });
        this.clearCaches();
    }

    @Nullable
    public StubElement getStub() {
        StubTree stubHolder = this.getStubTree();
        return stubHolder != null ? stubHolder.getRoot() : null;
    }

    @Nullable
    public final StubElement<?> getGreenStub() {
        StubTree stubHolder = this.getGreenStubTree();
        return stubHolder != null ? stubHolder.getRoot() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public StubTree getStubTree() {
        this.assertReadAccessAllowed();
        if (this.getTreeElement() != null) {
            return null;
        }
        StubTree derefd = this.derefStub();
        if (derefd != null) {
            return derefd;
        }
        if (Boolean.TRUE.equals(this.getUserData(BUILDING_STUB)) || this.myLoadingAst || this.getElementTypeForStubBuilder() == null) {
            return null;
        }
        VirtualFile vFile = this.getVirtualFile();
        ObjectStubTree<?> tree = StubTreeLoader.getInstance().readOrBuild(this.getProject(), vFile, this);
        if (!(tree instanceof StubTree)) {
            return null;
        }
        FileViewProvider viewProvider = this.getViewProvider();
        List<Pair<IStubFileElementType, PsiFile>> roots = StubTreeBuilder.getStubbedRoots(viewProvider);
        try {
            PsiLock psiLock = this.myPsiLock;
            synchronized (psiLock) {
                if (this.getTreeElement() != null) {
                    return null;
                }
                StubTree derefdOnLock = this.derefStub();
                if (derefdOnLock != null) {
                    return derefdOnLock;
                }
                PsiFileStubImpl baseRoot = (PsiFileStubImpl)((StubTree)tree).getRoot();
                if (!baseRoot.rootsAreSet()) {
                    LOG.error("Stub roots must be set when stub tree was read or built with StubTreeLoader");
                    return null;
                }
                PsiFileStub[] stubRoots = baseRoot.getStubRoots();
                if (stubRoots.length != roots.size()) {
                    Function<PsiFileStub, String> stubToString = stub -> "{" + stub.getClass().getSimpleName() + " " + stub.getType().getLanguage() + "}";
                    LOG.error("readOrBuilt roots = " + StringUtil.join(stubRoots, stubToString, ", ") + "; " + StubTreeLoader.getFileViewProviderMismatchDiagnostics(viewProvider));
                    this.rebuildStub();
                    return null;
                }
                StubTree result2 = null;
                for (int i2 = 0; i2 < roots.size(); ++i2) {
                    PsiFileImpl eachPsiRoot = (PsiFileImpl)roots.get((int)i2).second;
                    if (eachPsiRoot.derefStub() != null) continue;
                    StubTree stubTree = eachPsiRoot.setStubTree(stubRoots[i2]);
                    if (eachPsiRoot != this) continue;
                    result2 = stubTree;
                }
                assert (result2 != null) : "Current file not in root list: " + roots + ", vp=" + viewProvider;
                return result2;
            }
        }
        catch (StubTreeLoader.StubTreeAndIndexUnmatchCoarseException e2) {
            throw e2.createCompleteException();
        }
    }

    @NotNull
    private StubTree setStubTree(PsiFileStub<?> root) throws StubTreeLoader.StubTreeAndIndexUnmatchCoarseException {
        ((StubBase)((Object)root)).setPsi(this);
        StubTree stubTree = new StubTree(root);
        FileElement fileElement = this.getTreeElement();
        stubTree.setDebugInfo("created in getStubTree(), with AST = " + (fileElement != null));
        this.updateTrees(this.myTrees.withStub(stubTree, fileElement));
        StubTree stubTree2 = stubTree;
        if (stubTree2 == null) {
            PsiFileImpl.$$$reportNull$$$0(21);
        }
        return stubTree2;
    }

    @ApiStatus.Internal
    @Nullable
    public final StubTree derefStub() {
        return this.myTrees.derefStub();
    }

    private void updateTrees(@NotNull FileTrees trees) {
        if (trees == null) {
            PsiFileImpl.$$$reportNull$$$0(22);
        }
        this.myTrees = trees;
    }

    protected PsiFileImpl cloneImpl(FileElement treeElementClone) {
        PsiFileImpl clone2 = (PsiFileImpl)super.clone();
        clone2.setTreeElementPointer(treeElementClone);
        treeElementClone.setPsi(clone2);
        return clone2;
    }

    private boolean isKeepTreeElementByHardReference() {
        return !this.getViewProvider().isEventSystemEnabled();
    }

    @NotNull
    private Supplier<FileElement> createTreeElementPointer(@NotNull FileElement treeElement) {
        if (treeElement == null) {
            PsiFileImpl.$$$reportNull$$$0(23);
        }
        if (this.isKeepTreeElementByHardReference()) {
            Supplier<FileElement> supplier = () -> treeElement;
            if (supplier == null) {
                PsiFileImpl.$$$reportNull$$$0(24);
            }
            return supplier;
        }
        return this.myManager.isBatchFilesProcessingMode() ? new PatchedWeakReference<FileElement>(treeElement) : new SoftReference<FileElement>(treeElement);
    }

    @Override
    public final PsiManager getManager() {
        return this.myManager;
    }

    @Override
    public PsiElement getNavigationElement() {
        return this;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this.getOriginalFile();
    }

    @NotNull
    public final FileElement calcTreeElement() {
        FileElement treeElement = this.getTreeElement();
        return treeElement != null ? treeElement : this.loadTreeElement();
    }

    @Override
    public PsiElement @NotNull [] getChildren() {
        PsiElement[] psiElementArray = this.calcTreeElement().getChildrenAsPsiElements(null, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            PsiFileImpl.$$$reportNull$$$0(25);
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getFirstChild() {
        return SharedImplUtil.getFirstChild(this.getNode());
    }

    @Override
    public PsiElement getLastChild() {
        return SharedImplUtil.getLastChild(this.getNode());
    }

    @Override
    public void acceptChildren(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiFileImpl.$$$reportNull$$$0(26);
        }
        SharedImplUtil.acceptChildren(visitor2, this.getNode());
    }

    @Override
    public int getStartOffsetInParent() {
        return 0;
    }

    @Override
    public int getTextOffset() {
        return 0;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            PsiFileImpl.$$$reportNull$$$0(27);
        }
        return this.calcTreeElement().textMatches(text);
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            PsiFileImpl.$$$reportNull$$$0(28);
        }
        return this.calcTreeElement().textMatches(element);
    }

    @Override
    public boolean textContains(char c2) {
        return this.calcTreeElement().textContains(c2);
    }

    @Override
    public final PsiElement copy() {
        return this.clone();
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiFileImpl.$$$reportNull$$$0(29);
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, null, null);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            PsiFileImpl.$$$reportNull$$$0(30);
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            PsiFileImpl.$$$reportNull$$$0(31);
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public final void checkAdd(@NotNull PsiElement element) {
        if (element == null) {
            PsiFileImpl.$$$reportNull$$$0(32);
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, null, null);
    }

    @Override
    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            PsiFileImpl.$$$reportNull$$$0(33);
        }
        if (last == null) {
            PsiFileImpl.$$$reportNull$$$0(34);
        }
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
    }

    @Override
    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        if (first == null) {
            LOG.assertTrue(last == null);
            return;
        }
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree(first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree(last);
        FileElement treeElement = this.calcTreeElement();
        LOG.assertTrue(firstElement.getTreeParent() == treeElement);
        LOG.assertTrue(lastElement.getTreeParent() == treeElement);
        CodeEditUtil.removeChildren(treeElement, firstElement, lastElement);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            PsiFileImpl.$$$reportNull$$$0(35);
        }
        FileElement treeElement = this.calcTreeElement();
        return SharedImplUtil.doReplace(this, treeElement, newElement);
    }

    @Override
    public PsiReference getReference() {
        return null;
    }

    @Override
    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences(this);
        if (psiReferenceArray == null) {
            PsiFileImpl.$$$reportNull$$$0(36);
        }
        return psiReferenceArray;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiFileImpl.$$$reportNull$$$0(37);
        }
        if (state == null) {
            PsiFileImpl.$$$reportNull$$$0(38);
        }
        if (place == null) {
            PsiFileImpl.$$$reportNull$$$0(39);
        }
        return true;
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementResolveScope(this);
        if (globalSearchScope == null) {
            PsiFileImpl.$$$reportNull$$$0(40);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope(this);
        if (globalSearchScope == null) {
            PsiFileImpl.$$$reportNull$$$0(41);
        }
        return globalSearchScope;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return PsiFileImpl.this.getName();
            }

            @Override
            public String getLocationString() {
                VirtualFile file = PsiFileImpl.this.getViewProvider().getVirtualFile().getParent();
                if (file != null && file.isValid() && file.isDirectory()) {
                    return file.getPresentableUrl();
                }
                return null;
            }

            @Override
            public Icon getIcon(boolean open) {
                return PsiFileImpl.this.getIcon(0);
            }
        };
    }

    @Override
    public void navigate(boolean requestFocus) {
        assert (this.canNavigate()) : this;
        PsiNavigationSupport.getInstance().getDescriptor(this).navigate(requestFocus);
    }

    @Override
    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate(this);
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    @NotNull
    public final Project getProject() {
        Project project = this.getManager().getProject();
        if (project == null) {
            PsiFileImpl.$$$reportNull$$$0(42);
        }
        return project;
    }

    @Override
    @NotNull
    public FileASTNode getNode() {
        return this.calcTreeElement();
    }

    @Nullable
    public FileASTNode getNodeIfLoaded() {
        return this.getTreeElement();
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }

    @Nullable
    public final StubTree getGreenStubTree() {
        StubTree result2 = this.derefStub();
        return result2 != null ? result2 : this.getStubTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public StubTree calcStubTree() {
        StubTree stubTree;
        StubTree tree = this.derefStub();
        if (tree != null) {
            StubTree stubTree2 = tree;
            if (stubTree2 == null) {
                PsiFileImpl.$$$reportNull$$$0(43);
            }
            return stubTree2;
        }
        FileElement fileElement = this.calcTreeElement();
        try {
            PsiLock psiLock = this.myPsiLock;
            synchronized (psiLock) {
                tree = this.derefStub();
                if (tree == null) {
                    this.assertReadAccessAllowed();
                    IStubFileElementType<?> contentElementType = this.getElementTypeForStubBuilder();
                    if (contentElementType == null) {
                        VirtualFile vFile = this.getVirtualFile();
                        String message2 = "ContentElementType: " + this.getContentElementType() + "; file: " + this + (vFile.isValid() ? "" : " (" + vFile + " invalid)") + "\n\tBoolean.TRUE.equals(getUserData(BUILDING_STUB)) = " + Boolean.TRUE.equals(this.getUserData(BUILDING_STUB)) + "\n\tgetTreeElement() = " + this.getTreeElement() + "\n\tvFile instanceof VirtualFileWithId = " + (vFile instanceof VirtualFileWithId) + "\n\tStubUpdatingIndex.canHaveStub(vFile) = " + StubTreeLoader.getInstance().canHaveStub(vFile);
                        this.rebuildStub();
                        throw new AssertionError((Object)message2);
                    }
                    StubElement currentStubTree = contentElementType.getBuilder().buildStubTree(this);
                    if (currentStubTree == null) {
                        throw new AssertionError((Object)("Stub tree wasn't built for " + contentElementType + "; file: " + this));
                    }
                    tree = new StubTree((PsiFileStub)currentStubTree);
                    tree.setDebugInfo("created in calcStubTree");
                    this.updateTrees(this.myTrees.withStub(tree, fileElement));
                }
                stubTree = tree;
            }
        }
        catch (StubTreeLoader.StubTreeAndIndexUnmatchCoarseException e2) {
            throw e2.createCompleteException();
        }
        if (stubTree == null) {
            PsiFileImpl.$$$reportNull$$$0(44);
        }
        return stubTree;
    }

    final void rebuildStub() {
        AppUIExecutor.onWriteThread(ModalityState.nonModal()).later().submit(() -> {
            VirtualFile vFile;
            if (!this.myManager.isDisposed()) {
                this.myManager.dropPsiCaches();
            }
            if ((vFile = this.getVirtualFile()) != null && vFile.isValid()) {
                Document doc = FileDocumentManager.getInstance().getCachedDocument(vFile);
                if (doc != null) {
                    FileDocumentManager.getInstance().saveDocument(doc);
                }
                FileContentUtilCore.reparseFiles(vFile);
                StubTreeLoader.getInstance().rebuildStubTree(vFile);
            }
        });
    }

    @Override
    public void putInfo(@NotNull Map<? super String, ? super String> info) {
        if (info == null) {
            PsiFileImpl.$$$reportNull$$$0(45);
        }
        PsiFileImpl.putInfo(this, info);
    }

    public static void putInfo(@NotNull PsiFile psiFile, @NotNull Map<? super String, ? super String> info) {
        if (psiFile == null) {
            PsiFileImpl.$$$reportNull$$$0(46);
        }
        if (info == null) {
            PsiFileImpl.$$$reportNull$$$0(47);
        }
        info.put("fileName", psiFile.getName());
        info.put("fileType", psiFile.getFileType().toString());
    }

    @Override
    public String toString() {
        return this.myElementType.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void beforeAstChange() {
        this.checkWritable();
        PsiLock psiLock = this.myPsiLock;
        synchronized (psiLock) {
            FileTrees updated = this.myTrees.switchToStrongRefs();
            if (updated != this.myTrees) {
                this.updateTrees(updated);
            }
        }
    }

    private void checkWritable() {
        PsiDocumentManager docManager = PsiDocumentManager.getInstance(this.getProject());
        if (docManager instanceof PsiDocumentManagerBase && !((PsiDocumentManagerBase)docManager).isCommitInProgress() && !(this.myViewProvider instanceof FreeThreadedFileViewProvider)) {
            CheckUtil.checkWritable(this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiFileImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trees";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeElement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiFileImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTreeElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubbedSpine";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiRoots";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewProvider";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileDocument";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findChildrenByClass";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "setStubTree";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreeElementPointer";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "calcStubTree";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setOriginalFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateTrees";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createTreeElementPointer";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkAdd";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addRangeBefore";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

