/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.codeInsight.intention.impl.QuickEditHandlerUtils;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.ReadActionCachedValue;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.TextRangeUtils;
import java.io.Serializable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarImplKt;
import org.jetbrains.yaml.psi.impl.YAMLScalarImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0016J\u0006\u0010\u0018\u001a\u00020\u000bJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001bJ\"\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110!0\r2\u0006\u0010\"\u001a\u00020#H\u0014R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u001d\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR \u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\r0\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lorg/jetbrains/yaml/psi/impl/YAMLBlockScalarImpl;", "Lorg/jetbrains/yaml/psi/impl/YAMLScalarImpl;", "node", "Lcom/intellij/lang/ASTNode;", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "contentType", "Lcom/intellij/psi/tree/IElementType;", "getContentType", "()Lcom/intellij/psi/tree/IElementType;", "isMultiline", "", "getContentRanges", "", "Lcom/intellij/openapi/util/TextRange;", "textCache", "Lcom/intellij/psi/util/ReadActionCachedValue;", "", "getText", "validCache", "isValid", "includeFirstLineInContent", "getIncludeFirstLineInContent", "()Z", "hasExplicitIndent", "getNthContentTypeChild", "nth", "", "locateIndent", "indentString", "getIndentString", "()Ljava/lang/String;", "getEncodeReplacements", "Lcom/intellij/openapi/util/Pair;", "input", "", "linesNodes", "getLinesNodes", "()Ljava/util/List;", "explicitIndent", "getExplicitIndent", "()I", "intellij.yaml"})
@SourceDebugExtension(value={"SMAP\nYAMLBlockScalarImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YAMLBlockScalarImpl.kt\norg/jetbrains/yaml/psi/impl/YAMLBlockScalarImpl\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n1292#2,3:169\n1#3:172\n*S KotlinDebug\n*F\n+ 1 YAMLBlockScalarImpl.kt\norg/jetbrains/yaml/psi/impl/YAMLBlockScalarImpl\n*L\n35#1:169,3\n*E\n"})
public abstract class YAMLBlockScalarImpl
extends YAMLScalarImpl {
    @NotNull
    private final ReadActionCachedValue<String> textCache;
    @NotNull
    private final ReadActionCachedValue<Boolean> validCache;

    public YAMLBlockScalarImpl(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
        this.textCache = new ReadActionCachedValue(() -> YAMLBlockScalarImpl.textCache$lambda$5(this));
        this.validCache = new ReadActionCachedValue(() -> YAMLBlockScalarImpl.validCache$lambda$6(this));
    }

    @NotNull
    protected abstract IElementType getContentType();

    @Override
    public boolean isMultiline() {
        return true;
    }

    @Override
    @NotNull
    public List<TextRange> getContentRanges() {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)this), () -> YAMLBlockScalarImpl.getContentRanges$lambda$4(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    @NotNull
    public String getText() {
        return (String)this.textCache.getCachedOrEvaluate();
    }

    public boolean isValid() {
        return (Boolean)this.validCache.getCachedOrEvaluate();
    }

    protected boolean getIncludeFirstLineInContent() {
        return false;
    }

    public final boolean hasExplicitIndent() {
        return this.getExplicitIndent() != -1;
    }

    @Nullable
    public final ASTNode getNthContentTypeChild(int nth) {
        int number = 0;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() != this.getContentType()) continue;
            if (number == nth) {
                return child;
            }
            ++number;
        }
        return null;
    }

    public final int locateIndent() {
        Integer n = QuickEditHandlerUtils.reuseFragmentEditorIndent((PsiLanguageInjectionHost)this, () -> YAMLBlockScalarImpl.locateIndent$lambda$9(this));
        return n != null ? n : -1;
    }

    @NotNull
    public final String getIndentString() {
        String string = StringUtil.repeatSymbol((char)' ', (int)this.locateIndent());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repeatSymbol(...)");
        return string;
    }

    @Override
    @NotNull
    protected List<Pair<TextRange, String>> getEncodeReplacements(@NotNull CharSequence input) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String indentString = this.getIndentString();
        return SequencesKt.toList((Sequence)SequencesKt.zipWithNext((Sequence)TextRangeUtils.splitLineRanges((CharSequence)input), (arg_0, arg_1) -> YAMLBlockScalarImpl.getEncodeReplacements$lambda$10(indentString, arg_0, arg_1)));
    }

    @NotNull
    protected final List<List<ASTNode>> getLinesNodes() {
        List result = (List)new SmartList();
        List currentLine = (List)new SmartList();
        for (ASTNode child = this.getFirstContentNode(); child != null; child = child.getTreeNext()) {
            currentLine.add(child);
            if (!YAMLBlockScalarImplKt.isEol(child)) continue;
            result.add(currentLine);
            currentLine = (List)new SmartList();
        }
        if (!currentLine.isEmpty()) {
            result.add(currentLine);
        }
        return result;
    }

    private final int getExplicitIndent() {
        if (this.getIncludeFirstLineInContent()) {
            return -1;
        }
        ASTNode aSTNode = this.getNthContentTypeChild(0);
        if (aSTNode == null) {
            return -1;
        }
        ASTNode headerNode = aSTNode;
        String string = headerNode.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String header = string;
        int n = ((CharSequence)header).length();
        for (int i = 0; i < n; ++i) {
            if (!Character.isDigit(header.charAt(i))) continue;
            int k = i + 1;
            if (k < header.length() && Character.isDigit(header.charAt(k))) {
                return -1;
            }
            String string2 = header.substring(i, k);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            int res = Integer.parseInt(string2);
            return res == 0 ? -1 : res;
        }
        return -1;
    }

    private static final TextRange getContentRanges$lambda$4$lambda$0(int $myStart, int $indent, List line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        ASTNode first = (ASTNode)CollectionsKt.first((List)line);
        int start = first.getTextRange().getStartOffset() - $myStart + (Intrinsics.areEqual((Object)first.getElementType(), (Object)((Object)YAMLTokenTypes.INDENT)) ? Math.min(first.getTextLength(), $indent) : 0);
        int end = ((ASTNode)CollectionsKt.last((List)line)).getTextRange().getEndOffset() - $myStart;
        return start <= end ? TextRange.create((int)start, (int)end) : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final CachedValueProvider.Result getContentRanges$lambda$4(YAMLBlockScalarImpl this$0) {
        List list;
        void $this$fold$iv;
        int myStart = this$0.getTextRange().getStartOffset();
        int indent = this$0.locateIndent();
        Object[] objectArray = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this$0.getLinesNodes()), arg_0 -> YAMLBlockScalarImpl.getContentRanges$lambda$4$lambda$0(myStart, indent, arg_0));
        SmartList initial$iv = new SmartList();
        boolean $i$f$fold = false;
        SmartList accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void range;
            SmartList smartList;
            TextRange textRange = (TextRange)element$iv;
            SmartList list2 = accumulator$iv;
            boolean bl = false;
            SmartList $this$getContentRanges_u24lambda_u244_u24lambda_u242_u24lambda_u241 = smartList = list2;
            boolean bl2 = false;
            Serializable serializable = $this$getContentRanges_u24lambda_u244_u24lambda_u242_u24lambda_u241.size() > 1 && ((TextRange)CollectionsKt.last((List)((List)$this$getContentRanges_u24lambda_u244_u24lambda_u242_u24lambda_u241))).getEndOffset() == range.getStartOffset() ? (Serializable)$this$getContentRanges_u24lambda_u244_u24lambda_u242_u24lambda_u241.set(CollectionsKt.getLastIndex((List)((List)$this$getContentRanges_u24lambda_u244_u24lambda_u242_u24lambda_u241)), (Object)new TextRange(((TextRange)CollectionsKt.last((List)((List)$this$getContentRanges_u24lambda_u244_u24lambda_u242_u24lambda_u241))).getStartOffset(), range.getEndOffset())) : (Serializable)Boolean.valueOf($this$getContentRanges_u24lambda_u244_u24lambda_u242_u24lambda_u241.add((Object)range));
            accumulator$iv = smartList;
        }
        SmartList contentRanges = accumulator$iv;
        if (!this$0.getIncludeFirstLineInContent() && contentRanges.size() == 1) {
            TextRange it = (TextRange)CollectionsKt.single((List)((List)contentRanges));
            boolean bl = false;
            list = CollectionsKt.listOf((Object)TextRange.create((int)it.getEndOffset(), (int)it.getEndOffset()));
        } else {
            list = contentRanges.isEmpty() ? CollectionsKt.emptyList() : (this$0.getIncludeFirstLineInContent() ? (List)contentRanges : CollectionsKt.drop((Iterable)((Iterable)contentRanges), (int)1));
        }
        objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create((Object)list, (Object[])objectArray);
    }

    private static final String textCache$lambda$5(YAMLBlockScalarImpl this$0) {
        String string = super.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final boolean validCache$lambda$6(YAMLBlockScalarImpl this$0) {
        return super.isValid();
    }

    private static final boolean locateIndent$lambda$9$lambda$7(ASTNode l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        return Intrinsics.areEqual((Object)l.getElementType(), (Object)((Object)YAMLTokenTypes.INDENT));
    }

    private static final boolean locateIndent$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final int locateIndent$lambda$9(YAMLBlockScalarImpl this$0) {
        ASTNode lineIndentElement;
        int indent = this$0.getExplicitIndent();
        if (indent != -1) {
            return indent;
        }
        ASTNode firstLine = this$0.getNthContentTypeChild(this$0.getIncludeFirstLineInContent() ? 0 : 1);
        if (firstLine != null) {
            return YAMLUtil.getIndentInThisLine(firstLine.getPsi());
        }
        List line = (List)CollectionsKt.getOrNull(this$0.getLinesNodes(), (int)1);
        if (line != null && (lineIndentElement = (ASTNode)ContainerUtil.find((Iterable)line, arg_0 -> YAMLBlockScalarImpl.locateIndent$lambda$9$lambda$8(YAMLBlockScalarImpl::locateIndent$lambda$9$lambda$7, arg_0))) != null) {
            return lineIndentElement.getTextLength();
        }
        return 0;
    }

    private static final Pair getEncodeReplacements$lambda$10(String $indentString, TextRange a, TextRange b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Pair.create((Object)TextRange.create((int)a.getEndOffset(), (int)b.getStartOffset()), (Object)$indentString);
    }
}

