/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ModuleLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.TestGenerator;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/GenerateWasmTests;", "Lorg/jetbrains/kotlin/backend/common/ModuleLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "lower", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "makeTestFunctionDeclarator", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "containerFunction", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nGenerateWasmTests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateWasmTests.kt\norg/jetbrains/kotlin/backend/wasm/lower/GenerateWasmTests\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,64:1\n1869#2,2:65\n244#3:67\n238#3,10:68\n*S KotlinDebug\n*F\n+ 1 GenerateWasmTests.kt\norg/jetbrains/kotlin/backend/wasm/lower/GenerateWasmTests\n*L\n30#1:65,2\n50#1:67\n50#1:68,10\n*E\n"})
public final class GenerateWasmTests
implements ModuleLoweringPass {
    @NotNull
    private final WasmBackendContext context;

    public GenerateWasmTests(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
    }

    @Override
    public void lower(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter(irModule, "irModule");
        TestGenerator generator = new TestGenerator(this.context);
        Iterable $this$forEach$iv = irModule.getFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFile irFile = (IrFile)element$iv;
            boolean bl = false;
            IrSimpleFunction testContainerIfAny = generator.createTestContainer(irFile);
            if (testContainerIfAny == null) continue;
            IrSimpleFunction declarator = this.makeTestFunctionDeclarator(irFile, testContainerIfAny);
            this.context.getFileContext(irFile).setTestFunctionDeclarator(declarator);
        }
    }

    private final IrSimpleFunction makeTestFunctionDeclarator(IrFile irFile, IrSimpleFunction containerFunction) {
        IrFunctionReferenceImpl testFunReference = BuildersKt.IrFunctionReferenceImpl$default(-1, -1, IrUtilsKt.getDefaultType(this.context.getIrBuiltIns().kFunctionN(0)), containerFunction.getSymbol(), 0, null, null, 96, null);
        IrConst suitName = IrUtilsKt.toIrConst$default(irFile.getPackageFqName().asString(), this.context.getIrBuiltIns().getStringType(), 0, 0, 6, null);
        IrSimpleFunction testFunctionDeclarator = this.context.getIrFactory().getStageController().restrictTo(containerFunction, () -> GenerateWasmTests.makeTestFunctionDeclarator$lambda$4(this, irFile, suitName, testFunReference));
        return testFunctionDeclarator;
    }

    private static final IrSimpleFunction makeTestFunctionDeclarator$lambda$4(GenerateWasmTests this$0, IrFile $irFile, IrConst $suitName, IrFunctionReferenceImpl $testFunReference) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        Object object;
        IrFactory $this$addFunction$iv = this$0.context.getIrFactory();
        boolean $i$f$addFunction = false;
        Object $this$buildFun$iv$iv = $this$addFunction$iv;
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$makeTestFunctionDeclarator_u24lambda_u244_u24lambda_u241 = $this$buildFun_u24lambda_u2420$iv$iv;
        boolean bl2 = false;
        Name name2 = Name.identifier("declare test fun");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        $this$makeTestFunctionDeclarator_u24lambda_u244_u24lambda_u241.setName(name2);
        $this$makeTestFunctionDeclarator_u24lambda_u244_u24lambda_u241.setReturnType(this$0.context.getIrBuiltIns().getUnitType());
        $this$makeTestFunctionDeclarator_u24lambda_u244_u24lambda_u241.setOrigin(JsIrBuilder.INSTANCE.getSYNTHESIZED_DECLARATION());
        Object function$iv = $this$buildFun$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv, $this$buildFun_u24lambda_u2420$iv$iv);
        boolean bl3 = false;
        ((IrDeclarationContainer)$irFile).getDeclarations().add((IrDeclaration)function$iv);
        ((IrDeclarationBase)function$iv).setParent($irFile);
        Object $this$makeTestFunctionDeclarator_u24lambda_u244_u24lambda_u243 = object = $this$buildFun$iv$iv;
        boolean bl4 = false;
        IrBuilderWithScope irBuilderWithScope = LowerUtilsKt.createIrBuilder$default(this$0.context, (IrSymbol)((IrSimpleFunction)$this$makeTestFunctionDeclarator_u24lambda_u244_u24lambda_u243).getSymbol(), 0, 0, 6, null);
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this$0.context.getWasmSymbols().getRegisterRootSuiteBlock();
        Intrinsics.checkNotNull(irSimpleFunctionSymbol);
        IrFunctionAccessExpression call2 = irFunctionAccessExpression = ExpressionHelpersKt.irCall(irBuilderWithScope, irSimpleFunctionSymbol.getOwner());
        boolean bl5 = false;
        call2.putValueArgument(0, $suitName);
        call2.putValueArgument(1, $testFunReference);
        IrFunctionAccessExpression call3 = irFunctionAccessExpression;
        ((IrFunction)$this$makeTestFunctionDeclarator_u24lambda_u244_u24lambda_u243).setBody(IrFactoryHelpersKt.createBlockBody(this$0.context.getIrFactory(), -1, -1, CollectionsKt.listOf(call3)));
        return object;
    }
}

