/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jupyter.kotlin.JavaRuntime;
import jupyter.kotlin.VariablesReportKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ScriptDiagnostic;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.api.SourceCodeCompletionVariant;
import kotlin.script.experimental.jvm.util.SourceCodeUtilsKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.ResultsKt;
import org.jetbrains.kotlinx.jupyter.common.CommandsUtilKt;
import org.jetbrains.kotlinx.jupyter.common.ReplCommand;
import org.jetbrains.kotlinx.jupyter.common.ReplEnum;
import org.jetbrains.kotlinx.jupyter.common.ReplLineMagic;
import org.jetbrains.kotlinx.jupyter.compiler.util.SourceCodeImpl;
import org.jetbrains.kotlinx.jupyter.config.RuntimePropertiesKt;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryDescriptor;
import org.jetbrains.kotlinx.jupyter.messaging.ErrorJupyterResponse;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterResponse;
import org.jetbrains.kotlinx.jupyter.messaging.OkJupyterResponse;
import org.jetbrains.kotlinx.jupyter.repl.CompletionResult;
import org.jetbrains.kotlinx.jupyter.repl.KotlinCompleter;
import org.jetbrains.kotlinx.jupyter.repl.ListErrorsResult;
import org.jetbrains.kotlinx.jupyter.repl.ReplForJupyter;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"joinToStringIndented", "", "T", "", "transform", "Lkotlin/Function1;", "", "reportCommandErrors", "Lorg/jetbrains/kotlinx/jupyter/repl/ListErrorsResult;", "code", "doCommandCompletion", "Lorg/jetbrains/kotlinx/jupyter/repl/CompletionResult;", "cursor", "", "runCommand", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterResponse;", "repl", "Lorg/jetbrains/kotlinx/jupyter/repl/ReplForJupyter;", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nCommandsProcessing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandsProcessing.kt\norg/jetbrains/kotlinx/jupyter/commands/CommandsProcessingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,114:1\n774#2:115\n865#2,2:116\n1563#2:118\n1634#2,3:119\n774#2:122\n865#2,2:123\n126#3:125\n153#3,3:126\n*S KotlinDebug\n*F\n+ 1 CommandsProcessing.kt\norg/jetbrains/kotlinx/jupyter/commands/CommandsProcessingKt\n*L\n52#1:115\n52#1:116,2\n54#1:118\n54#1:119,3\n80#1:122\n80#1:123,2\n88#1:125\n88#1:126,3\n*E\n"})
public final class CommandsProcessingKt {
    @NotNull
    public static final <T> String joinToStringIndented(@NotNull Iterable<? extends T> $this$joinToStringIndented, @Nullable Function1<? super T, ? extends CharSequence> transform) {
        Intrinsics.checkNotNullParameter($this$joinToStringIndented, (String)"<this>");
        return CollectionsKt.joinToString$default($this$joinToStringIndented, (CharSequence)"\n|    ", (CharSequence)"    ", null, (int)0, null, transform, (int)28, null);
    }

    public static /* synthetic */ String joinToStringIndented$default(Iterable iterable, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return CommandsProcessingKt.joinToStringIndented(iterable, function1);
    }

    @NotNull
    public static final ListErrorsResult reportCommandErrors(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Pair<ReplCommand, String> pair2 = CommandsUtilKt.replCommandOrNull(code);
        ReplCommand command = (ReplCommand)((Object)pair2.component1());
        String commandString = (String)pair2.component2();
        if (command != null) {
            return new ListErrorsResult(code, null, 2, null);
        }
        SourceCodeImpl sourceCode = new SourceCodeImpl(0, code);
        SourceCode.Location location = new SourceCode.Location(SourceCodeUtilsKt.toSourceCodePosition((int)0, (SourceCode)sourceCode), SourceCodeUtilsKt.toSourceCodePosition((int)(commandString.length() + 1), (SourceCode)sourceCode));
        return new ListErrorsResult(code, (Sequence<ScriptDiagnostic>)SequencesKt.sequenceOf((Object)new ScriptDiagnostic(-1, "Unknown command", null, null, location, null, 44, null)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CompletionResult doCommandCompletion(@NotNull String code, int cursor) {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        CommandsUtilKt.assertLooksLikeReplCommand(code);
        String string = code.substring(1, cursor);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String prefix = string;
        Iterable $this$filter$iv = (Iterable)ReplCommand.getEntries();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ReplCommand it = (ReplCommand)((Object)element$iv$iv);
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it.getNameForUser(), (String)prefix, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List suitableCommands = (List)destination$iv$iv;
        Iterable $this$map$iv = suitableCommands;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ReplCommand bl = (ReplCommand)((Object)item$iv$iv);
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new SourceCodeCompletionVariant(it.getNameForUser(), it.getNameForUser(), "command", "command", null, 16, null));
        }
        List completions = (List)destination$iv$iv2;
        return KotlinCompleter.Companion.getResult(code, cursor, completions);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JupyterResponse runCommand(@NotNull String code, @NotNull ReplForJupyter repl) {
        JupyterResponse jupyterResponse;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)repl, (String)"repl");
        CommandsUtilKt.assertLooksLikeReplCommand(code);
        String string = ((Object)StringsKt.trim((CharSequence)code)).toString().substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String[] stringArray = new String[]{" "};
        List args = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Object object = ReplCommand.Companion.valueOfOrNull((String)args.get(0));
        if (object == null || (object = ((ReplEnum.CodeInsightValue)object).getValue()) == null) {
            return new ErrorJupyterResponse("Unknown command: " + code + "\nTo see available commands, enter :help", null, null, 6, null);
        }
        Object cmd = object;
        switch (WhenMappings.$EnumSwitchMapping$0[((Enum)cmd).ordinal()]) {
            case 1: {
                Collection<String> cp = repl.getCurrentClasspath();
                jupyterResponse = new OkJupyterResponse(ResultsKt.textResult("Current classpath (" + cp.size() + " paths):\n" + CollectionsKt.joinToString$default((Iterable)cp, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)), null, 2, null);
                break;
            }
            case 2: {
                jupyterResponse = new OkJupyterResponse(VariablesReportKt.getVariablesReportAsHTML(repl.getNotebook()), null, 2, null);
                break;
            }
            case 3: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map<String, LibraryDescriptor> libraryDescriptors;
                Map<String, LibraryDescriptor> $this$filterTo$iv$iv;
                void $this$filter$iv;
                String commands = CommandsProcessingKt.joinToStringIndented((Iterable)ReplCommand.getEntries(), CommandsProcessingKt::runCommand$lambda$0);
                Iterable iterable = (Iterable)ReplLineMagic.getEntries();
                boolean $i$f$filter = false;
                void var8_9 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo22 = false;
                Iterator iterator = $this$filterTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv = iterator.next();
                    ReplLineMagic it = (ReplLineMagic)((Object)element$iv$iv);
                    boolean bl = false;
                    if (!it.getVisibleInHelp()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                String magics = CommandsProcessingKt.joinToStringIndented((List)destination$iv$iv, CommandsProcessingKt::runCommand$lambda$2);
                $this$filterTo$iv$iv = libraryDescriptors = repl.getLibraryDescriptorsProvider().getDescriptors();
                boolean $i$f$map = false;
                void $i$f$filterTo22 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    String libraryName = (String)entry.getKey();
                    LibraryDescriptor descriptor = (LibraryDescriptor)entry.getValue();
                    String link = descriptor.getLink() != null ? " (" + descriptor.getLink() + ")" : "";
                    String description = descriptor.getDescription() != null ? " - " + descriptor.getDescription() : "";
                    collection.add(libraryName + link + description);
                }
                String libraries = CommandsProcessingKt.joinToStringIndented$default((List)destination$iv$iv2, null, 1, null);
                jupyterResponse = new OkJupyterResponse(ResultsKt.textResult(StringsKt.trimMargin((String)(" |Kotlin Jupyter kernel.\n                        |Kernel version: " + RuntimePropertiesKt.getCurrentKernelVersion() + "\n                        |Kotlin version: " + RuntimePropertiesKt.getCurrentKotlinVersion() + "\n                        |JVM version: " + JavaRuntime.INSTANCE.getVersion() + "\n                        |\n                        |Commands:\n                        |" + commands + "\n                        |\n                        |Magics:\n                        |" + magics + "\n                        |\n                        |Supported libraries:\n                        |" + libraries + "\n                    "), (String)"|")), null, 2, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jupyterResponse;
    }

    private static final CharSequence runCommand$lambda$0(ReplCommand it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return ":" + it.getNameForUser() + " - " + it.getDesc();
    }

    private static final CharSequence runCommand$lambda$2(ReplLineMagic it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        String s = "%" + it.getNameForUser() + " - " + it.getDesc();
        if (it.getArgumentsUsage() != null) {
            s = s + "\n        Usage: %" + it.getNameForUser() + " " + it.getArgumentsUsage();
        }
        return s;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReplCommand.values().length];
            try {
                nArray[ReplCommand.CLASSPATH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplCommand.VARS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplCommand.HELP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

