/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.api.exceptions.ReplException;
import org.jetbrains.kotlinx.jupyter.config.LoggingKt;
import org.jetbrains.kotlinx.jupyter.config.RuntimePropertiesKt;
import org.jetbrains.kotlinx.jupyter.libraries.DefaultLibraryDescriptorGlobalOptions;
import org.jetbrains.kotlinx.jupyter.libraries.DescriptorOptionsParsingKt;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryDescriptor;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryDescriptorGlobalOptions;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryDescriptorsProvider;
import org.jetbrains.kotlinx.jupyter.libraries.ParsingKt;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/ResourceLibraryDescriptorsProvider;", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryDescriptorsProvider;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;)V", "logger", "Lorg/slf4j/Logger;", "librariesFromResources", "", "", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryDescriptor;", "getLibrariesFromResources", "()Ljava/util/Map;", "librariesFromResources$delegate", "Lkotlin/Lazy;", "descriptorOptionsFromResources", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryDescriptorGlobalOptions;", "getDescriptorOptionsFromResources", "()Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryDescriptorGlobalOptions;", "descriptorOptionsFromResources$delegate", "getDescriptors", "getDescriptorGlobalOptions", "Companion", "shared-compiler"})
public class ResourceLibraryDescriptorsProvider
implements LibraryDescriptorsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy librariesFromResources$delegate;
    @NotNull
    private final Lazy descriptorOptionsFromResources$delegate;
    @NotNull
    private static final String RESOURCES_LIBRARY_PATH = "jupyterLibraries";

    public ResourceLibraryDescriptorsProvider(@NotNull KernelLoggerFactory loggerFactory) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        this.logger = KernelLoggerFactoryKt.getLogger(loggerFactory, Reflection.getOrCreateKotlinClass(this.getClass()));
        this.librariesFromResources$delegate = LazyKt.lazy(() -> ResourceLibraryDescriptorsProvider.librariesFromResources_delegate$lambda$0(this));
        this.descriptorOptionsFromResources$delegate = LazyKt.lazy(ResourceLibraryDescriptorsProvider::descriptorOptionsFromResources_delegate$lambda$0);
    }

    private final Map<String, LibraryDescriptor> getLibrariesFromResources() {
        Lazy lazy = this.librariesFromResources$delegate;
        return (Map)lazy.getValue();
    }

    private final LibraryDescriptorGlobalOptions getDescriptorOptionsFromResources() {
        Lazy lazy = this.descriptorOptionsFromResources$delegate;
        return (LibraryDescriptorGlobalOptions)lazy.getValue();
    }

    @Override
    @NotNull
    public Map<String, LibraryDescriptor> getDescriptors() {
        return this.getLibrariesFromResources();
    }

    @Override
    @NotNull
    public LibraryDescriptorGlobalOptions getDescriptorGlobalOptions() {
        return this.getDescriptorOptionsFromResources();
    }

    private static final Map librariesFromResources_delegate$lambda$0(ResourceLibraryDescriptorsProvider this$0) {
        Sequence sequence;
        Sequence sequence2;
        URL listText = RuntimePropertiesKt.getKernelClassLoader().getResource("jupyterLibraries/libraries.list");
        if (listText != null) {
            URL uRL = listText;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
            sequence2 = StringsKt.lineSequence((CharSequence)new String(byArray, charset));
        } else {
            sequence2 = sequence = null;
        }
        if (sequence2 == null) {
            sequence = SequencesKt.emptySequence();
        }
        return MapsKt.toMap((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)sequence, ResourceLibraryDescriptorsProvider::librariesFromResources_delegate$lambda$0$0), arg_0 -> ResourceLibraryDescriptorsProvider.librariesFromResources_delegate$lambda$0$1(this$0, arg_0)));
    }

    private static final boolean librariesFromResources_delegate$lambda$0$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() > 0;
    }

    private static final Pair librariesFromResources_delegate$lambda$0$1(ResourceLibraryDescriptorsProvider this$0, String descriptorFile) {
        Pair pair2;
        Intrinsics.checkNotNullParameter((Object)descriptorFile, (String)"descriptorFile");
        URL uRL = RuntimePropertiesKt.getKernelClassLoader().getResource("jupyterLibraries/" + descriptorFile);
        if (uRL != null) {
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            String text2 = new String(byArray, charset);
            boolean bl = false;
            String libraryName = StringsKt.removeSuffix((String)descriptorFile, (CharSequence)".json");
            this$0.logger.info("Parsing library " + libraryName + " from resources");
            pair2 = (Pair)LoggingKt.catchAll$default(this$0.logger, null, "Parsing descriptor for library '" + libraryName + "' failed", () -> ResourceLibraryDescriptorsProvider.librariesFromResources_delegate$lambda$0$1$0$0(libraryName, text2), 1, null);
        } else {
            pair2 = null;
        }
        return pair2;
    }

    private static final Pair librariesFromResources_delegate$lambda$0$1$0$0(String $libraryName, String $text) {
        return TuplesKt.to((Object)$libraryName, (Object)ParsingKt.parseLibraryDescriptor($text));
    }

    private static final LibraryDescriptorGlobalOptions descriptorOptionsFromResources_delegate$lambda$0() {
        Object object = RuntimePropertiesKt.getKernelClassLoader().getResource("jupyterLibraries/global.options");
        if (object == null) {
            return DefaultLibraryDescriptorGlobalOptions.INSTANCE;
        }
        URL uRL = object;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
        String optionsText = new String(byArray, charset);
        try {
            object = DescriptorOptionsParsingKt.parseLibraryDescriptorGlobalOptions(optionsText);
        }
        catch (ReplException replException) {
            object = DefaultLibraryDescriptorGlobalOptions.INSTANCE;
        }
        return object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/ResourceLibraryDescriptorsProvider$Companion;", "", "<init>", "()V", "RESOURCES_LIBRARY_PATH", "", "shared-compiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

