/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.utils;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0000\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\"\u0018\u0010\u000b\u001a\u00020\u0001*\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"isCanonical", "", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "isAbstractOrSealed", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "getFunctionalInterfaceSlot", "", "iFace", "fitsLatin1", "", "getFitsLatin1", "(Ljava/lang/String;)Z", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlin/backend/wasm/utils/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,40:1\n1786#2,3:41\n1088#3,2:44\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlin/backend/wasm/utils/UtilsKt\n*L\n28#1:41,3\n40#1:44,2\n*E\n"})
public final class UtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCanonical(@NotNull IrTry $this$isCanonical, @NotNull WasmBackendContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isCanonical, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if ($this$isCanonical.getCatches().size() > 1) return false;
        Iterable $this$all$iv = $this$isCanonical.getCatches();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                IrCatch it = (IrCatch)element$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)it.getCatchParameter().getType(), (Object)context.getIrBuiltIns().getThrowableType())) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if ($this$isCanonical.getFinallyExpression() != null) return false;
        return true;
    }

    public static final boolean isAbstractOrSealed(@NotNull IrClass $this$isAbstractOrSealed) {
        Intrinsics.checkNotNullParameter((Object)$this$isAbstractOrSealed, (String)"<this>");
        return $this$isAbstractOrSealed.getModality() == Modality.ABSTRACT || $this$isAbstractOrSealed.getModality() == Modality.SEALED;
    }

    public static final int getFunctionalInterfaceSlot(@NotNull IrClass iFace) {
        Intrinsics.checkNotNullParameter((Object)iFace, (String)"iFace");
        if (!IrTypeUtilsKt.isFunction((IrClassifierSymbol)((IrClassifierSymbol)iFace.getSymbol()))) {
            throw new IllegalStateException("Check failed.");
        }
        if (IrTypeUtilsKt.isFunctionMarker((IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)iFace)))) {
            return 0;
        }
        return iFace.getTypeParameters().size();
    }

    public static final boolean getFitsLatin1(@NotNull String $this$fitsLatin1) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$fitsLatin1, (String)"<this>");
            CharSequence $this$all$iv = $this$fitsLatin1;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                char c = it;
                if ('\u0000' <= c ? c < '\u0100' : false) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }
}

