/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.NoSuchElementException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIntrinsics;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.js.config.JSConfigurationKeysKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J]\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2$\u0010\r\u001a \u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\b0\u0012\"\u0002H\bH\u0002\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ConstTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "lowerConst", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "C", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "irClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "carrierFactory", "Lkotlin/Function4;", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "args", "", "(Lorg/jetbrains/kotlin/ir/expressions/IrConst;Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;Lkotlin/jvm/functions/Function4;[Ljava/lang/Object;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "createLong", "v", "", "visitConst", "backend.js"})
@SourceDebugExtension(value={"SMAP\nConstLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ConstTransformer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,116:1\n351#2,12:117\n*S KotlinDebug\n*F\n+ 1 ConstLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ConstTransformer\n*L\n36#1:117,12\n*E\n"})
public final class ConstTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final JsIrBackendContext context;

    public ConstTransformer(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    private final <C> IrExpression lowerConst(IrConst expression2, IrClassSymbol irClass, Function4<? super Integer, ? super Integer, ? super IrType, ? super C, ? extends IrExpression> carrierFactory, C ... args) {
        IrConstructorCallImpl irConstructorCallImpl;
        Sequence $this$single$iv = IrUtilsKt.getConstructors((IrClassSymbol)irClass);
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrConstructorSymbol it = (IrConstructorSymbol)element$iv;
            boolean bl = false;
            if (!((IrConstructor)it.getOwner()).isPrimary()) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrConstructorSymbol constructor = single$iv;
        IrType argType = ((IrValueParameter)((IrConstructor)constructor.getOwner()).getParameters().get(0)).getType();
        IrConstructorCallImpl $this$lowerConst_u24lambda_u241 = irConstructorCallImpl = BuildersKt.fromSymbolOwner$default((IrConstructorCallImpl.Companion)IrConstructorCallImpl.Companion, (int)expression2.getStartOffset(), (int)expression2.getEndOffset(), (IrType)((IrType)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)irClass))), (IrConstructorSymbol)constructor, null, (int)16, null);
        boolean bl = false;
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            $this$lowerConst_u24lambda_u241.getArguments().set(i, carrierFactory.invoke((Object)$this$lowerConst_u24lambda_u241.getStartOffset(), (Object)$this$lowerConst_u24lambda_u241.getEndOffset(), (Object)argType, args[i]));
        }
        return (IrExpression)irConstructorCallImpl;
    }

    private final IrExpression createLong(IrConst expression2, long v) {
        if (JSConfigurationKeysKt.getCompileLongAsBigint((CompilerConfiguration)this.context.getConfiguration())) {
            return (IrExpression)IrConstImpl.Companion.long(expression2.getStartOffset(), expression2.getEndOffset(), this.context.getIrBuiltIns().getLongType(), v);
        }
        Integer[] integerArray = new Integer[]{(int)v, (int)(v >> 32)};
        return this.lowerConst(expression2, this.context.getIntrinsics().getLongClassSymbol(), (Function4)new Function4<Integer, Integer, IrType, Integer, IrConstImpl>((Object)IrConstImpl.Companion){

            public final IrConstImpl invoke(int p0, int p1, IrType p2, int p3) {
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                return ((IrConstImpl.Companion)this.receiver).int(p0, p1, p2, p3);
            }
        }, integerArray);
    }

    @NotNull
    public IrExpression visitConst(@NotNull IrConst expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        JsIntrinsics $this$visitConst_u24lambda_u240 = this.context.getIntrinsics();
        boolean bl = false;
        if (IrTypeUtilsKt.isUnsigned((IrType)expression2.getType()) && !Intrinsics.areEqual((Object)expression2.getKind(), (Object)IrConstKind.Null.INSTANCE)) {
            IrExpression irExpression2;
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull((IrType)expression2.getType());
            if (Intrinsics.areEqual((Object)irClassifierSymbol, (Object)$this$visitConst_u24lambda_u240.getUByteClassSymbol())) {
                IrClassSymbol irClassSymbol = $this$visitConst_u24lambda_u240.getUByteClassSymbol();
                Function4 function4 = (Function4)new Function4<Integer, Integer, IrType, Byte, IrConstImpl>((Object)IrConstImpl.Companion){

                    public final IrConstImpl invoke(int p0, int p1, IrType p2, byte p3) {
                        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                        return ((IrConstImpl.Companion)this.receiver).byte(p0, p1, p2, p3);
                    }
                };
                Byte[] byteArray = new Byte[1];
                Intrinsics.checkNotNull((Object)expression2.getValue(), (String)"null cannot be cast to non-null type kotlin.Byte");
                irExpression2 = this.lowerConst(expression2, irClassSymbol, function4, byteArray);
            } else if (Intrinsics.areEqual((Object)irClassifierSymbol, (Object)$this$visitConst_u24lambda_u240.getUShortClassSymbol())) {
                IrClassSymbol irClassSymbol = $this$visitConst_u24lambda_u240.getUShortClassSymbol();
                Function4 function4 = (Function4)new Function4<Integer, Integer, IrType, Short, IrConstImpl>((Object)IrConstImpl.Companion){

                    public final IrConstImpl invoke(int p0, int p1, IrType p2, short p3) {
                        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                        return ((IrConstImpl.Companion)this.receiver).short(p0, p1, p2, p3);
                    }
                };
                Short[] shortArray = new Short[1];
                Intrinsics.checkNotNull((Object)expression2.getValue(), (String)"null cannot be cast to non-null type kotlin.Short");
                irExpression2 = this.lowerConst(expression2, irClassSymbol, function4, shortArray);
            } else if (Intrinsics.areEqual((Object)irClassifierSymbol, (Object)$this$visitConst_u24lambda_u240.getUIntClassSymbol())) {
                IrClassSymbol irClassSymbol = $this$visitConst_u24lambda_u240.getUIntClassSymbol();
                Function4 function4 = (Function4)new Function4<Integer, Integer, IrType, Integer, IrConstImpl>((Object)IrConstImpl.Companion){

                    public final IrConstImpl invoke(int p0, int p1, IrType p2, int p3) {
                        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                        return ((IrConstImpl.Companion)this.receiver).int(p0, p1, p2, p3);
                    }
                };
                Integer[] integerArray = new Integer[1];
                Intrinsics.checkNotNull((Object)expression2.getValue(), (String)"null cannot be cast to non-null type kotlin.Int");
                irExpression2 = this.lowerConst(expression2, irClassSymbol, function4, integerArray);
            } else if (Intrinsics.areEqual((Object)irClassifierSymbol, (Object)$this$visitConst_u24lambda_u240.getULongClassSymbol())) {
                IrClassSymbol irClassSymbol = $this$visitConst_u24lambda_u240.getULongClassSymbol();
                Function4 function4 = (arg_0, arg_1, arg_2, arg_3) -> ConstTransformer.visitConst$lambda$0$0(this, expression2, arg_0, arg_1, arg_2, arg_3);
                Long[] longArray = new Long[1];
                Intrinsics.checkNotNull((Object)expression2.getValue(), (String)"null cannot be cast to non-null type kotlin.Long");
                irExpression2 = this.lowerConst(expression2, irClassSymbol, function4, longArray);
            } else {
                CompilationExceptionKt.compilationException((String)"Unknown unsigned type", (IrElement)((IrElement)expression2));
                throw new KotlinNothingValueException();
            }
            return irExpression2;
        }
        if (expression2.getKind() instanceof IrConstKind.Char) {
            IrClassSymbol irClassSymbol = $this$visitConst_u24lambda_u240.getCharClassSymbol();
            Function4 function4 = (Function4)new Function4<Integer, Integer, IrType, Integer, IrConstImpl>((Object)IrConstImpl.Companion){

                public final IrConstImpl invoke(int p0, int p1, IrType p2, int p3) {
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    return ((IrConstImpl.Companion)this.receiver).int(p0, p1, p2, p3);
                }
            };
            Integer[] integerArray = new Integer[1];
            Object object = expression2.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Char");
            integerArray[0] = ((Character)object).charValue();
            irExpression = this.lowerConst(expression2, irClassSymbol, function4, integerArray);
        } else if (expression2.getKind() instanceof IrConstKind.Long) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
            irExpression = this.createLong(expression2, (Long)object);
        } else {
            irExpression = super.visitConst(expression2);
        }
        return irExpression;
    }

    private static final IrExpression visitConst$lambda$0$0(ConstTransformer this$0, IrConst $expression, int n, int n2, IrType irType, long v) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"<unused var>");
        return this$0.createLong($expression, v);
    }
}

