/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrPropertyBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrMutableAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\bH\u0016J\u0014\u0010\n\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\bH\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\bH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsStaticLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "generateStaticPropertyProxy", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "proxyParent", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateStaticMethodProxy", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isJsStaticDeclaration", "", "excludeFromJsExport", "", "generateJsExportIgnoreCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsStaticLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsStaticLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsStaticLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 IrExceptionUtils.kt\norg/jetbrains/kotlin/ir/util/IrExceptionUtilsKt\n+ 4 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 7 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n*L\n1#1,101:1\n1#2:102\n1#2:104\n28#3:103\n29#3:105\n122#4,4:106\n269#4,4:110\n1586#5:114\n1661#5,3:115\n1661#5,3:129\n418#6,10:118\n76#7:128\n77#7:132\n*S KotlinDebug\n*F\n+ 1 JsStaticLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsStaticLowering\n*L\n31#1:104\n31#1:103\n31#1:105\n45#1:106,4\n58#1:110,4\n69#1:114\n69#1:115,3\n78#1:129,3\n71#1:118,10\n71#1:128\n71#1:132\n*E\n"})
public final class JsStaticLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;

    public JsStaticLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        IrElement irElement;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)declaration);
        if (!(irClass != null ? irClass.isCompanion() : false) || !this.isJsStaticDeclaration(declaration)) {
            return null;
        }
        IrClass containingClass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)IrUtilsKt.getParentAsClass((IrDeclaration)declaration)));
        IrDeclaration irDeclaration = declaration;
        if (irDeclaration instanceof IrSimpleFunction) {
            IrDeclaration irDeclaration2 = declaration;
            IrSimpleFunction it = (IrSimpleFunction)irDeclaration2;
            boolean bl = false;
            IrSimpleFunction irSimpleFunction = (IrSimpleFunction)(it.getCorrespondingPropertySymbol() == null ? irDeclaration2 : null);
            irElement = (IrElement)(irSimpleFunction != null ? this.generateStaticMethodProxy(irSimpleFunction, containingClass) : null);
        } else if (irDeclaration instanceof IrProperty) {
            irElement = (IrElement)this.generateStaticPropertyProxy((IrProperty)declaration, containingClass);
        } else {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = "Unexpected declaration type";
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$transformFlat_u24lambda_u241 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$transformFlat_u24lambda_u241.withIrEntry("declaration", (IrElement)declaration);
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        if (irElement == null) {
            return null;
        }
        IrElement proxyDeclaration = irElement;
        containingClass.getDeclarations().add(proxyDeclaration);
        this.excludeFromJsExport(declaration);
        return null;
    }

    private final IrProperty generateStaticPropertyProxy(IrProperty $this$generateStaticPropertyProxy, IrClass proxyParent) {
        IrSimpleFunction irSimpleFunction;
        IrSimpleFunction irSimpleFunction2;
        IrSimpleFunction it;
        IrProperty irProperty;
        IrProperty originalProperty = $this$generateStaticPropertyProxy;
        IrFactory $this$buildProperty$iv = this.context.getIrFactory();
        boolean $i$f$buildProperty = false;
        IrPropertyBuilder $this$buildProperty_u24lambda_u241$iv = new IrPropertyBuilder();
        boolean bl = false;
        IrPropertyBuilder $this$generateStaticPropertyProxy_u24lambda_u240 = $this$buildProperty_u24lambda_u241$iv;
        boolean bl2 = false;
        $this$generateStaticPropertyProxy_u24lambda_u240.updateFrom(originalProperty);
        $this$generateStaticPropertyProxy_u24lambda_u240.setName(originalProperty.getName());
        IrProperty $this$generateStaticPropertyProxy_u24lambda_u241 = irProperty = DeclarationBuildersKt.buildProperty((IrFactory)$this$buildProperty$iv, (IrPropertyBuilder)$this$buildProperty_u24lambda_u241$iv);
        boolean bl3 = false;
        IrUtilsKt.copyAnnotationsFrom((IrMutableAnnotationContainer)((IrMutableAnnotationContainer)$this$generateStaticPropertyProxy_u24lambda_u241), (IrAnnotationContainer)((IrAnnotationContainer)originalProperty));
        $this$generateStaticPropertyProxy_u24lambda_u241.setParent((IrDeclarationParent)proxyParent);
        IrProperty irProperty2 = $this$generateStaticPropertyProxy_u24lambda_u241;
        IrSimpleFunction irSimpleFunction3 = originalProperty.getGetter();
        if (irSimpleFunction3 != null && (irSimpleFunction3 = this.generateStaticMethodProxy(irSimpleFunction3, proxyParent)) != null) {
            IrSimpleFunction irSimpleFunction4 = irSimpleFunction3;
            $this$generateStaticPropertyProxy_u24lambda_u240 = irSimpleFunction4;
            IrProperty irProperty3 = irProperty2;
            boolean bl4 = false;
            it.setCorrespondingPropertySymbol($this$generateStaticPropertyProxy_u24lambda_u241.getSymbol());
            irProperty2 = irProperty3;
            irSimpleFunction2 = irSimpleFunction4;
        } else {
            irSimpleFunction2 = null;
        }
        irProperty2.setGetter(irSimpleFunction2);
        IrProperty irProperty4 = $this$generateStaticPropertyProxy_u24lambda_u241;
        IrSimpleFunction irSimpleFunction5 = originalProperty.getSetter();
        if (irSimpleFunction5 != null && (irSimpleFunction5 = this.generateStaticMethodProxy(irSimpleFunction5, proxyParent)) != null) {
            IrSimpleFunction irSimpleFunction6;
            it = irSimpleFunction6 = irSimpleFunction5;
            IrProperty irProperty5 = irProperty4;
            boolean bl5 = false;
            it.setCorrespondingPropertySymbol($this$generateStaticPropertyProxy_u24lambda_u241.getSymbol());
            irProperty4 = irProperty5;
            irSimpleFunction = irSimpleFunction6;
        } else {
            irSimpleFunction = null;
        }
        irProperty4.setSetter(irSimpleFunction);
        return irProperty;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction generateStaticMethodProxy(IrSimpleFunction $this$generateStaticMethodProxy, IrClass proxyParent) {
        void $this$mapTo$iv;
        void $this$generateStaticMethodProxy_u24lambda_u241_u241;
        IrFunctionAccessExpression irFunctionAccessExpression;
        void this_$iv$iv;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrSimpleFunction irSimpleFunction;
        IrSimpleFunction originalFun = $this$generateStaticMethodProxy;
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u240$iv = new IrFunctionBuilder();
        boolean bl = false;
        Object $this$generateStaticMethodProxy_u24lambda_u240 = $this$buildFun_u24lambda_u240$iv;
        boolean bl2 = false;
        $this$generateStaticMethodProxy_u24lambda_u240.updateFrom((IrFunction)originalFun);
        $this$generateStaticMethodProxy_u24lambda_u240.setName(originalFun.getName());
        $this$generateStaticMethodProxy_u24lambda_u240.setReturnType(originalFun.getReturnType());
        IrSimpleFunction $this$generateStaticMethodProxy_u24lambda_u241 = irSimpleFunction = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u240$iv);
        boolean bl3 = false;
        IrUtilsKt.copyTypeParametersFrom$default((IrTypeParametersContainer)((IrTypeParametersContainer)$this$generateStaticMethodProxy_u24lambda_u241), (IrTypeParametersContainer)((IrTypeParametersContainer)originalFun), null, null, (int)6, null);
        IrUtilsKt.copyAnnotationsFrom((IrMutableAnnotationContainer)((IrMutableAnnotationContainer)$this$generateStaticMethodProxy_u24lambda_u241), (IrAnnotationContainer)((IrAnnotationContainer)originalFun));
        $this$generateStaticMethodProxy_u24lambda_u241.setParent((IrDeclarationParent)proxyParent);
        Map substitutionMap = IrUtilsKt.makeTypeParameterSubstitutionMap((IrTypeParametersContainer)((IrTypeParametersContainer)originalFun), (IrTypeParametersContainer)((IrTypeParametersContainer)$this$generateStaticMethodProxy_u24lambda_u241));
        $this$generateStaticMethodProxy_u24lambda_u240 = IrUtilsKt.getNonDispatchParameters((IrFunction)((IrFunction)originalFun));
        IrSimpleFunction irSimpleFunction2 = $this$generateStaticMethodProxy_u24lambda_u241;
        boolean $i$f$map = false;
        void var11_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(IrUtilsKt.copyTo$default((IrValueParameter)it, (IrFunction)((IrFunction)$this$generateStaticMethodProxy_u24lambda_u241), null, (int)0, (int)0, null, null, (IrType)IrTypeUtilsKt.substitute((IrType)it.getType(), (Map)substitutionMap), null, null, (boolean)false, (boolean)false, (boolean)false, null, null, (int)16318, null));
        }
        irSimpleFunction2.setParameters((List)destination$iv$iv);
        IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)LowerUtilsKt.createIrBuilder$default((LoweringContext)((LoweringContext)this.context), (IrSymbol)((IrSymbol)$this$generateStaticMethodProxy_u24lambda_u241.getSymbol()), (int)0, (int)0, (int)6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder $i$f$mapTo22 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        item$iv$iv2 = this_$iv$iv;
        irSimpleFunction2 = $this$generateStaticMethodProxy_u24lambda_u241;
        boolean bl5 = false;
        IrFunctionAccessExpression $this$generateStaticMethodProxy_u24lambda_u241_u241_u240 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$generateStaticMethodProxy_u24lambda_u241_u241), (IrFunction)((IrFunction)originalFun));
        boolean bl6 = false;
        IrUtilsKt.passTypeArgumentsFrom$default((IrFunctionAccessExpression)$this$generateStaticMethodProxy_u24lambda_u241_u241_u240, (IrTypeParametersContainer)((IrTypeParametersContainer)$this$generateStaticMethodProxy_u24lambda_u241), (int)0, (int)2, null);
        $this$generateStaticMethodProxy_u24lambda_u241_u241_u240.getArguments().clear();
        if (originalFun.getDispatchReceiverParameter() != null) {
            $this$generateStaticMethodProxy_u24lambda_u241_u241_u240.getArguments().add((Object)IrBuilderKt.irGetObject((IrBuilderWithScope)((IrBuilderWithScope)$this$generateStaticMethodProxy_u24lambda_u241_u241), (IrClassSymbol)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)originalFun)).getSymbol()));
        }
        Iterable iterable = $this$generateStaticMethodProxy_u24lambda_u241.getParameters();
        Collection destination$iv = (Collection)$this$generateStaticMethodProxy_u24lambda_u241_u241_u240.getArguments();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            Collection collection = destination$iv;
            boolean bl7 = false;
            collection.add(ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$generateStaticMethodProxy_u24lambda_u241_u241), (IrValueDeclaration)((IrValueDeclaration)it)));
        }
        IrFunctionAccessExpression delegatingCall = irFunctionAccessExpression;
        $this$generateStaticMethodProxy_u24lambda_u241_u241.unaryPlus((IrStatement)ExpressionHelpersKt.irReturn((IrBuilderWithScope)((IrBuilderWithScope)$this$generateStaticMethodProxy_u24lambda_u241_u241), (IrExpression)((IrExpression)delegatingCall)));
        irSimpleFunction2.setBody((IrBody)this_$iv$iv.doBuild());
        return irSimpleFunction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isJsStaticDeclaration(IrDeclaration $this$isJsStaticDeclaration) {
        boolean bl;
        if (IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)$this$isJsStaticDeclaration), (ClassId)JsStandardClassIds.Annotations.JsStatic)) return true;
        IrSimpleFunction irSimpleFunction = $this$isJsStaticDeclaration instanceof IrSimpleFunction ? (IrSimpleFunction)$this$isJsStaticDeclaration : null;
        if (irSimpleFunction != null && (irSimpleFunction = irSimpleFunction.getCorrespondingPropertySymbol()) != null && (irSimpleFunction = (IrProperty)irSimpleFunction.getOwner()) != null) {
            if (IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)irSimpleFunction), (ClassId)JsStandardClassIds.Annotations.JsStatic)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (!($this$isJsStaticDeclaration instanceof IrProperty)) return false;
        IrProperty irProperty = (IrProperty)$this$isJsStaticDeclaration;
        IrProperty irProperty2 = irProperty;
        if (irProperty == null) return false;
        IrSimpleFunction irSimpleFunction2 = irProperty2.getGetter();
        irProperty2 = irSimpleFunction2;
        if (irSimpleFunction2 == null) return false;
        if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)irProperty2), (ClassId)JsStandardClassIds.Annotations.JsStatic)) return false;
        return true;
    }

    private final void excludeFromJsExport(IrDeclaration $this$excludeFromJsExport) {
        $this$excludeFromJsExport.setAnnotations(CollectionsKt.plus((Collection)$this$excludeFromJsExport.getAnnotations(), (Object)this.generateJsExportIgnoreCall()));
    }

    private final IrConstructorCall generateJsExportIgnoreCall() {
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor((IrClass)((IrClass)this.context.getIntrinsics().getJsExportIgnoreAnnotationSymbol().getOwner()));
        Intrinsics.checkNotNull((Object)irConstructor);
        return JsIrBuilder.buildConstructorCall$default(JsIrBuilder.INSTANCE, irConstructor.getSymbol(), null, null, null, 0, 0, 62, null);
    }
}

