/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.assertj.core.util.Preconditions;

public class Paths {
    private Paths() {
    }

    public static List<String> linesOf(Path path, Charset charset) {
        Objects.requireNonNull(charset, "The charset should not be null");
        try {
            return Files.readAllLines(path, charset);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read " + String.valueOf(path), e);
        }
    }

    public static List<String> linesOf(Path path, String charsetName) {
        Paths.checkArgumentCharsetIsSupported(charsetName);
        return Paths.linesOf(path, Charset.forName(charsetName));
    }

    private static void checkArgumentCharsetIsSupported(String charsetName) {
        Preconditions.checkArgument(Charset.isSupported(charsetName), "Charset:<'%s'> is not supported on this system", charsetName);
    }
}

