/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.backend.highlighting;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.text.StringSearcher;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShTextOccurrencesUtil {
    private ShTextOccurrencesUtil() {
    }

    @Nullable
    public static TextRange findTextRangeOfIdentifierAtCaret(@NotNull Editor editor) {
        Caret caret;
        if (editor == null) {
            ShTextOccurrencesUtil.$$$reportNull$$$0(0);
        }
        if ((caret = editor.getCaretModel().getPrimaryCaret()).hasSelection()) {
            TextRange textRange = TextRange.create((int)caret.getSelectionStart(), (int)caret.getSelectionEnd());
            CharSequence subSequence = textRange.subSequence(editor.getDocument().getCharsSequence());
            return StringUtil.isEmptyOrSpaces((CharSequence)subSequence) || StringUtil.contains((CharSequence)subSequence, (CharSequence)"\n") ? null : textRange;
        }
        return SelectWordUtil.getWordSelectionRange((CharSequence)editor.getDocument().getImmutableCharSequence(), (int)caret.getOffset(), ShTextOccurrencesUtil::isWordPartCondition);
    }

    private static boolean isWordPartCondition(char ch) {
        return ch == '_' || Character.isLetterOrDigit(ch);
    }

    @NotNull
    public static Collection<TextRange> findAllOccurrences(@NotNull CharSequence documentText, @NotNull CharSequence textToFind, boolean matchExactWordsOnly) {
        if (documentText == null) {
            ShTextOccurrencesUtil.$$$reportNull$$$0(1);
        }
        if (textToFind == null) {
            ShTextOccurrencesUtil.$$$reportNull$$$0(2);
        }
        CollectConsumer consumer = new CollectConsumer();
        ShTextOccurrencesUtil.consumeAllOccurrences(documentText, textToFind, matchExactWordsOnly, (Consumer<? super TextRange>)consumer);
        Collection collection = consumer.getResult();
        if (collection == null) {
            ShTextOccurrencesUtil.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public static void consumeAllOccurrences(@NotNull CharSequence documentText, @NotNull CharSequence textToFind, boolean matchExactWordsOnly, Consumer<? super TextRange> consumer) {
        if (documentText == null) {
            ShTextOccurrencesUtil.$$$reportNull$$$0(4);
        }
        if (textToFind == null) {
            ShTextOccurrencesUtil.$$$reportNull$$$0(5);
        }
        String pattern = textToFind.toString();
        int length = pattern.length();
        StringSearcher searcher = new StringSearcher(pattern, true, true);
        searcher.processOccurrences(documentText, value -> {
            TextRange tr = TextRange.create((int)value, (int)(value + length));
            if (matchExactWordsOnly && ShTextOccurrencesUtil.isWordExpandableOutside(documentText, (Segment)tr)) {
                return true;
            }
            consumer.consume((Object)tr);
            return true;
        });
    }

    private static boolean isWordExpandableOutside(@NotNull CharSequence documentText, @NotNull Segment textRange) {
        char ch;
        if (documentText == null) {
            ShTextOccurrencesUtil.$$$reportNull$$$0(6);
        }
        if (textRange == null) {
            ShTextOccurrencesUtil.$$$reportNull$$$0(7);
        }
        if (textRange.getStartOffset() > 0 && ShTextOccurrencesUtil.isWordPartCondition(ch = documentText.charAt(textRange.getStartOffset() - 1))) {
            return true;
        }
        if (textRange.getEndOffset() < documentText.length()) {
            ch = documentText.charAt(textRange.getEndOffset());
            return ShTextOccurrencesUtil.isWordPartCondition(ch);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentText";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToFind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/backend/highlighting/ShTextOccurrencesUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/backend/highlighting/ShTextOccurrencesUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllOccurrences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findTextRangeOfIdentifierAtCaret";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findAllOccurrences";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "consumeAllOccurrences";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isWordExpandableOutside";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

