/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.common.WordSet;
import ai.grazie.rules.util.regex.RegexMatcher;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public class PosEnumerator {
    private static final short[] EMPTY_SHORT_ARRAY = new short[0];
    private static final Map<Language, PosEnumerator> instances = new ConcurrentHashMap<Language, PosEnumerator>();
    @VisibleForTesting
    public static final String FREQUENT_POS_TAGS_TXT = "frequent_pos_tags.txt";
    private final Language language;
    private final int maxStaticId;
    private volatile Mapping mapping;
    private final Object lock = new Object();

    private PosEnumerator(Language language) {
        this.language = language;
        List<String> tags = WordSet.loadLines(String.valueOf(language.getIso()) + "/frequent_pos_tags.txt");
        this.maxStaticId = tags.size();
        this.mapping = new Mapping(Map.of(), Collections.singletonList(null), language).ensureEnumerated(tags);
        assert (this.mapping.byPos.size() == this.maxStaticId);
    }

    int maxStaticId() {
        return this.maxStaticId;
    }

    static PosEnumerator forLanguage(Language language) {
        return instances.computeIfAbsent(language, PosEnumerator::new);
    }

    short enumerate(String posTag) {
        return this.enumerate(List.of(posTag))[0];
    }

    String byId(short id) {
        return this.mapping.byId.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    short[] enumerate(List<String> posTags) {
        short[] result = this.mapping.tryEnumerate(posTags);
        if (result != null) {
            return result;
        }
        Object object = this.lock;
        synchronized (object) {
            this.mapping = this.mapping.ensureEnumerated(posTags);
        }
        return Objects.requireNonNull(this.mapping.tryEnumerate(posTags));
    }

    MatchedBitSet matchTags(List<String> posTags) {
        BitSet bits = new BitSet();
        for (short id : this.enumerate(posTags)) {
            bits.set(id);
        }
        return new MatchedBitSet(null, bits.toLongArray());
    }

    MatchedBitSet growMatchedSet(RegexMatcher matcher, @Nullable MatchedBitSet prev) {
        int i;
        if (prev != null && prev.source.language != this.language) {
            throw new AssertionError((Object)("POS patterns should not be shared between languages (" + String.valueOf(prev.source.language) + " and " + String.valueOf(this.language) + ")"));
        }
        Mapping mapping = this.mapping;
        List<String> posTags = mapping.byId();
        BitSet bits = prev != null ? BitSet.valueOf(prev.matched) : new BitSet();
        int n = i = prev == null ? 1 : prev.source.byId.size();
        while (i < posTags.size()) {
            if (matcher.matches(posTags.get(i))) {
                bits.set(i);
            }
            ++i;
        }
        return new MatchedBitSet(mapping, bits.toLongArray());
    }

    record Mapping(Map<String, Short> byPos, List<String> byId, Language language) {
        private short @Nullable [] tryEnumerate(List<String> posTags) {
            int size = posTags.size();
            if (size == 0) {
                return EMPTY_SHORT_ARRAY;
            }
            short[] result = new short[size];
            for (int i = 0; i < size; ++i) {
                Short id = this.byPos.get(posTags.get(i));
                if (id == null) {
                    return null;
                }
                result[i] = id;
            }
            return result;
        }

        Mapping ensureEnumerated(List<String> posTags) {
            List<String> missing = posTags.stream().filter(s -> !this.byPos.containsKey(s)).toList();
            if (missing.isEmpty()) {
                return this;
            }
            if (this.byPos.size() + missing.size() > Short.MAX_VALUE) {
                throw new IllegalStateException("Too many pos tags (time to change short to int?), cannot add " + String.valueOf(missing));
            }
            ArrayList<String> newById = new ArrayList<String>(this.byId);
            Object2ObjectOpenHashMap newByPos = new Object2ObjectOpenHashMap(this.byPos);
            newById.addAll(missing);
            for (String pos : missing) {
                newByPos.put(pos, (short)(newByPos.size() + 1));
            }
            return new Mapping((Map<String, Short>)newByPos, newById, this.language);
        }
    }

    class MatchedBitSet {
        private final Mapping source;
        private final long[] matched;

        MatchedBitSet(Mapping source, long[] matched) {
            this.source = source;
            this.matched = matched;
        }

        boolean needsUpdate() {
            return this.source != null && PosEnumerator.this.mapping != this.source;
        }

        boolean matchIds(short[] sortedIds) {
            for (short id : sortedIds) {
                int longIndex = id >> 6;
                if (longIndex >= this.matched.length) {
                    return false;
                }
                if ((this.matched[longIndex] & 1L << (id & 0x3F)) == 0L) continue;
                return true;
            }
            return false;
        }
    }
}

