/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.jediterm.terminal.emulator.mouse.MouseFormat;
import com.jediterm.terminal.emulator.mouse.MouseMode;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.output.TerminalEventsHandler;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.TerminalModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0010\u0018\u0000 82\u00020\u0001:\u00018B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010$\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010%\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010&\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010'\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020(H\u0016J!\u0010)\u001a\u00020\r2\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020,0+\"\u00020,H\u0002\u00a2\u0006\u0002\u0010-J\u0010\u0010.\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010/\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u00100\u001a\u00020 H\u0002J \u00101\u001a\u0002022\u0006\u00103\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\u0010\u00104\u001a\u00020\u00152\u0006\u00105\u001a\u000206H\u0002J\u0010\u00104\u001a\u00020\u00152\u0006\u00107\u001a\u000202H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00069"}, d2={"Lorg/jetbrains/plugins/terminal/block/SimpleTerminalEventsHandler;", "Lorg/jetbrains/plugins/terminal/block/output/TerminalEventsHandler;", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;)V", "getOutputModel", "()Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "ignoreNextKeyTypedEvent", "", "lastMotionReport", "Ljava/awt/Point;", "model", "Lorg/jetbrains/plugins/terminal/block/session/TerminalModel;", "getModel", "()Lorg/jetbrains/plugins/terminal/block/session/TerminalModel;", "keyTyped", "", "e", "Ljava/awt/event/KeyEvent;", "keyPressed", "processTerminalKeyPressed", "processCharacter", "isAltPressedOnly", "simpleMapKeyCodeToChar", "", "mousePressed", "x", "", "y", "event", "Ljava/awt/event/MouseEvent;", "mouseReleased", "mouseMoved", "mouseDragged", "mouseWheelMoved", "Ljava/awt/event/MouseWheelEvent;", "shouldSendMouseData", "eligibleModes", "", "Lcom/jediterm/terminal/emulator/mouse/MouseMode;", "([Lcom/jediterm/terminal/emulator/mouse/MouseMode;)Z", "createButtonCode", "applyModifierKeys", "cb", "mouseReport", "", "button", "sendUserInput", "data", "", "bytes", "Companion", "intellij.terminal"})
public class SimpleTerminalEventsHandler
implements TerminalEventsHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final TerminalOutputModel outputModel;
    private boolean ignoreNextKeyTypedEvent;
    @Nullable
    private Point lastMotionReport;
    @NotNull
    private static final Logger LOG;

    public SimpleTerminalEventsHandler(@NotNull BlockTerminalSession session2, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalOutputModel outputModel) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        this.session = session2;
        this.settings = settings;
        this.outputModel = outputModel;
    }

    @NotNull
    protected final TerminalOutputModel getOutputModel() {
        return this.outputModel;
    }

    private final TerminalModel getModel() {
        return this.session.getModel();
    }

    @Override
    public void keyTyped(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        SelectionModel selectionModel = this.outputModel.getEditor().getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        if (selectionModel2.hasSelection()) {
            selectionModel2.removeSelection();
        }
        if (this.ignoreNextKeyTypedEvent) {
            e.consume();
            return;
        }
        if (!Character.isISOControl(e.getKeyChar())) {
            try {
                if (this.processCharacter(e)) {
                    e.consume();
                }
            }
            catch (Exception ex) {
                LOG.error("Error sending typed key to emulator", (Throwable)ex);
            }
        }
    }

    @Override
    public void keyPressed(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.ignoreNextKeyTypedEvent = false;
        if (this.processTerminalKeyPressed(e)) {
            e.consume();
            this.ignoreNextKeyTypedEvent = true;
        }
    }

    private final boolean processTerminalKeyPressed(KeyEvent e) {
        try {
            int keyCode = e.getKeyCode();
            char keyChar = e.getKeyChar();
            if (keyCode == 127 && keyChar == '.') {
                byte[] byArray = new byte[]{46};
                this.sendUserInput(byArray);
                return true;
            }
            if (keyChar == ' ' && (e.getModifiersEx() & 0x80) != 0) {
                byte[] byArray = new byte[]{0};
                this.sendUserInput(byArray);
                return true;
            }
            byte[] code = this.session.getController().getCodeForKey(keyCode, e.getModifiers());
            if (code != null) {
                this.sendUserInput(code);
                return true;
            }
            if (this.isAltPressedOnly(e) && Character.isDefined(keyChar) && this.settings.altSendsEscape()) {
                char[] cArray = new char[]{'\u001b', this.simpleMapKeyCodeToChar(e)};
                String string = new String(cArray);
                this.sendUserInput(string);
                return true;
            }
            if (Character.isISOControl(keyChar)) {
                return this.processCharacter(e);
            }
        }
        catch (Exception ex) {
            LOG.error("Error sending pressed key to emulator", (Throwable)ex);
        }
        return false;
    }

    private final boolean processCharacter(KeyEvent e) {
        if (this.isAltPressedOnly(e) && this.settings.altSendsEscape()) {
            return false;
        }
        char keyChar = e.getKeyChar();
        if (keyChar == '`' && (e.getModifiersEx() & 0x100) != 0) {
            return false;
        }
        this.sendUserInput(String.valueOf(keyChar));
        return true;
    }

    private final boolean isAltPressedOnly(KeyEvent e) {
        int modifiersEx = e.getModifiersEx();
        return (modifiersEx & 0x200) != 0 && (modifiersEx & 0x2000) == 0 && (modifiersEx & 0x80) == 0 && (modifiersEx & 0x40) == 0;
    }

    private final char simpleMapKeyCodeToChar(KeyEvent e) {
        char keyChar = (char)e.getKeyCode();
        return (e.getModifiersEx() & 0x40) != 0 ? Character.toUpperCase(keyChar) : Character.toLowerCase(keyChar);
    }

    @Override
    public void mousePressed(int x, int y, @NotNull MouseEvent event) {
        int code;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MouseMode[] mouseModeArray = new MouseMode[]{MouseMode.MOUSE_REPORTING_NORMAL, MouseMode.MOUSE_REPORTING_BUTTON_MOTION};
        if (this.shouldSendMouseData(mouseModeArray) && (code = this.createButtonCode(event)) != -1) {
            switch (code) {
                case 4: 
                case 5: {
                    int offset = 4;
                    code -= offset;
                    code |= 0x40;
                }
            }
            code = this.applyModifierKeys(event, code);
            this.sendUserInput(this.mouseReport(code, x + 1, y + 1));
        }
    }

    @Override
    public void mouseReleased(int x, int y, @NotNull MouseEvent event) {
        int code;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MouseMode[] mouseModeArray = new MouseMode[]{MouseMode.MOUSE_REPORTING_NORMAL, MouseMode.MOUSE_REPORTING_BUTTON_MOTION};
        if (this.shouldSendMouseData(mouseModeArray) && (code = this.createButtonCode(event)) != -1) {
            code = this.getModel().getMouseFormat() == MouseFormat.MOUSE_FORMAT_SGR ? code | 0x80 : 3;
            code = this.applyModifierKeys(event, code);
            this.sendUserInput(this.mouseReport(code, x + 1, y + 1));
        }
        this.lastMotionReport = null;
    }

    @Override
    public void mouseMoved(int x, int y, @NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)this.lastMotionReport, (Object)new Point(x, y))) {
            return;
        }
        MouseMode[] mouseModeArray = new MouseMode[]{MouseMode.MOUSE_REPORTING_ALL_MOTION};
        if (this.shouldSendMouseData(mouseModeArray)) {
            this.sendUserInput(this.mouseReport(3, x + 1, y + 1));
        }
        this.lastMotionReport = new Point(x, y);
    }

    @Override
    public void mouseDragged(int x, int y, @NotNull MouseEvent event) {
        int code;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)this.lastMotionReport, (Object)new Point(x, y))) {
            return;
        }
        MouseMode[] mouseModeArray = new MouseMode[]{MouseMode.MOUSE_REPORTING_BUTTON_MOTION};
        if (this.shouldSendMouseData(mouseModeArray) && (code = this.createButtonCode(event)) != -1) {
            code |= 0x20;
            code = this.applyModifierKeys(event, code);
            this.sendUserInput(this.mouseReport(code, x + 1, y + 1));
        }
        this.lastMotionReport = new Point(x, y);
    }

    @Override
    public void mouseWheelMoved(int x, int y, @NotNull MouseWheelEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.settings.enableMouseReporting() && this.getModel().getMouseMode() != MouseMode.MOUSE_REPORTING_NONE && !event.isShiftDown()) {
            this.outputModel.getEditor().getSelectionModel().removeSelection();
            this.mousePressed(x, y, event);
        }
        if (this.getModel().getUseAlternateBuffer() && this.settings.simulateMouseScrollWithArrowKeysInAlternativeScreen()) {
            byte[] arrowKeys = event.getWheelRotation() < 0 ? this.session.getController().getCodeForKey(38, 0) : this.session.getController().getCodeForKey(40, 0);
            int n = Math.abs(event.getUnitsToScroll());
            for (int i = 0; i < n; ++i) {
                Intrinsics.checkNotNull((Object)arrowKeys);
                this.sendUserInput(arrowKeys);
            }
            event.consume();
        }
    }

    private final boolean shouldSendMouseData(MouseMode ... eligibleModes) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getModel().getMouseMode().ordinal()]) {
            case 1 -> false;
            case 2 -> true;
            default -> ArraysKt.contains((Object[])eligibleModes, (Object)this.getModel().getMouseMode());
        };
    }

    private final int createButtonCode(MouseEvent event) {
        int n;
        if (SwingUtilities.isLeftMouseButton(event)) {
            n = 0;
        } else if (SwingUtilities.isMiddleMouseButton(event)) {
            n = 1;
        } else if (SwingUtilities.isRightMouseButton(event)) {
            n = -1;
        } else if (event instanceof MouseWheelEvent) {
            n = ((MouseWheelEvent)event).getWheelRotation() > 0 ? 5 : 4;
        } else {
            return -1;
        }
        return n;
    }

    private final int applyModifierKeys(MouseEvent event, int cb) {
        int code = cb;
        if (event.isControlDown()) {
            code |= 0x10;
        }
        if (event.isShiftDown()) {
            code |= 4;
        }
        if ((event.getModifiersEx() & 4) != 0) {
            code |= 8;
        }
        return code;
    }

    private final byte[] mouseReport(int button2, int x, int y) {
        String string;
        String charset = "UTF-8";
        switch (WhenMappings.$EnumSwitchMapping$1[this.getModel().getMouseFormat().ordinal()]) {
            case 1: {
                String string2 = "\u001b[M%c%c%c";
                Object[] objectArray = new Object[]{Character.valueOf((char)(32 + button2)), Character.valueOf((char)(32 + x)), Character.valueOf((char)(32 + y))};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                break;
            }
            case 2: {
                String string2 = "\u001b[%d;%d;%dM";
                Object[] objectArray = new Object[]{32 + button2, x, y};
                String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                break;
            }
            case 3: {
                Object[] objectArray;
                String string2;
                if ((button2 & 0x80) != 0) {
                    string2 = "\u001b[<%d;%d;%dm";
                    objectArray = new Object[]{button2 ^ 0x80, x, y};
                    String string5 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
                    break;
                }
                string2 = "\u001b[<%d;%d;%dM";
                objectArray = new Object[]{button2, x, y};
                String string6 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
                break;
            }
            default: {
                charset = "ISO-8859-1";
                String string2 = "\u001b[M%c%c%c";
                Object[] objectArray = new Object[]{Character.valueOf((char)(32 + button2)), Character.valueOf((char)(32 + x)), Character.valueOf((char)(32 + y))};
                String string7 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
            }
        }
        String command2 = string;
        LOG.debug(this.getModel().getMouseFormat() + " (" + charset + ") report : " + button2 + ", " + x + "x" + y + " = " + command2);
        String string8 = command2;
        Charset charset2 = Charset.forName(charset);
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(...)");
        byte[] byArray = string8.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    private final void sendUserInput(String data) {
        this.session.getTerminalOutputStream().sendString(data, true);
    }

    private final void sendUserInput(byte[] bytes) {
        this.session.getTerminalOutputStream().sendBytes(bytes, true);
    }

    static {
        Logger logger = Logger.getInstance(SimpleTerminalEventsHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/terminal/block/SimpleTerminalEventsHandler$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MouseMode.values().length];
            try {
                nArray[MouseMode.MOUSE_REPORTING_NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseMode.MOUSE_REPORTING_ALL_MOTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MouseFormat.values().length];
            try {
                nArray[MouseFormat.MOUSE_FORMAT_XTERM_EXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseFormat.MOUSE_FORMAT_URXVT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseFormat.MOUSE_FORMAT_SGR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

