/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style.inference.search;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.PsiSearchRequest;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.style.inference.search.ScopeFilteringRequestProcessor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001c\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a8\u0006\u000f"}, d2={"searchForInnerReferences", "", "Lcom/intellij/psi/PsiReference;", "referencedMethod", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "searchForOuterReferences", "originalMethod", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "adoptSearchRequest", "", "Lcom/intellij/psi/search/SearchRequestCollector;", "request", "Lcom/intellij/psi/search/PsiSearchRequest;", "target", "intellij.groovy"})
@SourceDebugExtension(value={"SMAP\nsearchUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 searchUtils.kt\norg/jetbrains/plugins/groovy/intentions/style/inference/search/SearchUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n1869#2,2:158\n1869#2,2:160\n*S KotlinDebug\n*F\n+ 1 searchUtils.kt\norg/jetbrains/plugins/groovy/intentions/style/inference/search/SearchUtilsKt\n*L\n62#1:158,2\n63#1:160,2\n*E\n"})
public final class SearchUtilsKt {
    @NotNull
    public static final List<PsiReference> searchForInnerReferences(@NotNull GrMethod referencedMethod) {
        Intrinsics.checkNotNullParameter((Object)referencedMethod, (String)"referencedMethod");
        String string = referencedMethod.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String methodIdentifier = string;
        List collector = new ArrayList();
        referencedMethod.accept(new GroovyRecursiveElementVisitor(methodIdentifier, referencedMethod, collector){
            final /* synthetic */ String $methodIdentifier;
            final /* synthetic */ GrMethod $referencedMethod;
            final /* synthetic */ List<PsiReference> $collector;
            {
                this.$methodIdentifier = $methodIdentifier;
                this.$referencedMethod = $referencedMethod;
                this.$collector = $collector;
            }

            public void visitReferenceExpression(GrReferenceExpression referenceExpression) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)referenceExpression, (String)"referenceExpression");
                    if (!Intrinsics.areEqual((Object)referenceExpression.getReferenceName(), (Object)this.$methodIdentifier)) {
                        return;
                    }
                    if (referenceExpression.resolve() != this.$referencedMethod) break block2;
                    PsiReference psiReference = referenceExpression.getReference();
                    if (psiReference != null) {
                        PsiReference psiReference2 = psiReference;
                        List<PsiReference> list = this.$collector;
                        PsiReference p0 = psiReference2;
                        boolean bl = false;
                        list.add(p0);
                    }
                }
            }
        });
        return collector;
    }

    @NotNull
    public static final List<PsiReference> searchForOuterReferences(@NotNull GrMethod originalMethod, @NotNull SearchScope searchScope) {
        QuerySearchRequest query;
        Intrinsics.checkNotNullParameter((Object)originalMethod, (String)"originalMethod");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        PsiElement[] psiElementArray = new PsiElement[]{originalMethod};
        SearchRequestCollector requestsCollector = new SearchRequestCollector(new SearchSession(psiElementArray));
        List collector = new ArrayList();
        ReferencesSearch.searchOptimized((PsiElement)originalMethod, (SearchScope)searchScope, (boolean)false, (SearchRequestCollector)requestsCollector, arg_0 -> SearchUtilsKt.searchForOuterReferences$lambda$1(arg_0 -> SearchUtilsKt.searchForOuterReferences$lambda$0(collector, arg_0), arg_0));
        List list = requestsCollector.takeQueryRequests();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"takeQueryRequests(...)");
        List queries = CollectionsKt.toMutableList((Collection)list);
        while (!((Collection)queries).isEmpty() && (query = (QuerySearchRequest)queries.remove(CollectionsKt.getLastIndex((List)queries))).runQuery()) {
            QuerySearchRequest it;
            List list2 = query.collector.takeQueryRequests();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"takeQueryRequests(...)");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (QuerySearchRequest)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                queries.add(it);
            }
            List list3 = query.collector.takeSearchRequests();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"takeSearchRequests(...)");
            $this$forEach$iv = list3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PsiSearchRequest)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                SearchUtilsKt.adoptSearchRequest(requestsCollector, (PsiSearchRequest)it, originalMethod);
            }
        }
        PsiSearchHelper.getInstance((Project)originalMethod.getProject()).processRequests(requestsCollector, arg_0 -> SearchUtilsKt.searchForOuterReferences$lambda$5(arg_0 -> SearchUtilsKt.searchForOuterReferences$lambda$4(collector, arg_0), arg_0));
        return collector;
    }

    private static final void adoptSearchRequest(SearchRequestCollector $this$adoptSearchRequest, PsiSearchRequest request, GrMethod target) {
        PsiSearchRequest $this$adoptSearchRequest_u24lambda_u240 = request;
        boolean bl = false;
        String string = $this$adoptSearchRequest_u24lambda_u240.word;
        SearchScope searchScope = $this$adoptSearchRequest_u24lambda_u240.searchScope;
        short s = $this$adoptSearchRequest_u24lambda_u240.searchContext;
        boolean bl2 = $this$adoptSearchRequest_u24lambda_u240.caseSensitive;
        PsiElement psiElement = target;
        RequestResultProcessor requestResultProcessor = $this$adoptSearchRequest_u24lambda_u240.processor;
        Intrinsics.checkNotNullExpressionValue((Object)requestResultProcessor, (String)"processor");
        $this$adoptSearchRequest.searchWord(string, searchScope, s, bl2, psiElement, (RequestResultProcessor)new ScopeFilteringRequestProcessor(target, requestResultProcessor));
    }

    private static final boolean searchForOuterReferences$lambda$0(List $collector, PsiReference ref2) {
        Intrinsics.checkNotNull((Object)ref2);
        $collector.add(ref2);
        return true;
    }

    private static final boolean searchForOuterReferences$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean searchForOuterReferences$lambda$4(List $collector, PsiReference ref2) {
        Intrinsics.checkNotNull((Object)ref2);
        $collector.add(ref2);
        return true;
    }

    private static final boolean searchForOuterReferences$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

