/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0012J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ:\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MirrorOfStackTraceElement;", "", "declaringClass", "", "methodName", "fileName", "lineNumber", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)V", "getDeclaringClass", "()Ljava/lang/String;", "getMethodName", "getFileName", "getLineNumber", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "stackTraceElement", "Ljava/lang/StackTraceElement;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MirrorOfStackTraceElement;", "equals", "", "other", "hashCode", "toString", "intellij.kotlin.jvm.debugger.coroutines"})
public final class MirrorOfStackTraceElement {
    @NotNull
    private final String declaringClass;
    @NotNull
    private final String methodName;
    @Nullable
    private final String fileName;
    @Nullable
    private final Integer lineNumber;

    public MirrorOfStackTraceElement(@NotNull String declaringClass, @NotNull String methodName, @Nullable String fileName, @Nullable Integer lineNumber) {
        Intrinsics.checkNotNullParameter((Object)declaringClass, (String)"declaringClass");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        this.declaringClass = declaringClass;
        this.methodName = methodName;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    @NotNull
    public final String getDeclaringClass() {
        return this.declaringClass;
    }

    @NotNull
    public final String getMethodName() {
        return this.methodName;
    }

    @Nullable
    public final String getFileName() {
        return this.fileName;
    }

    @Nullable
    public final Integer getLineNumber() {
        return this.lineNumber;
    }

    @NotNull
    public final StackTraceElement stackTraceElement() {
        Integer n = this.lineNumber;
        return new StackTraceElement(this.declaringClass, this.methodName, this.fileName, n != null ? n : -1);
    }

    @NotNull
    public final String component1() {
        return this.declaringClass;
    }

    @NotNull
    public final String component2() {
        return this.methodName;
    }

    @Nullable
    public final String component3() {
        return this.fileName;
    }

    @Nullable
    public final Integer component4() {
        return this.lineNumber;
    }

    @NotNull
    public final MirrorOfStackTraceElement copy(@NotNull String declaringClass, @NotNull String methodName, @Nullable String fileName, @Nullable Integer lineNumber) {
        Intrinsics.checkNotNullParameter((Object)declaringClass, (String)"declaringClass");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        return new MirrorOfStackTraceElement(declaringClass, methodName, fileName, lineNumber);
    }

    public static /* synthetic */ MirrorOfStackTraceElement copy$default(MirrorOfStackTraceElement mirrorOfStackTraceElement, String string, String string2, String string3, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = mirrorOfStackTraceElement.declaringClass;
        }
        if ((n2 & 2) != 0) {
            string2 = mirrorOfStackTraceElement.methodName;
        }
        if ((n2 & 4) != 0) {
            string3 = mirrorOfStackTraceElement.fileName;
        }
        if ((n2 & 8) != 0) {
            n = mirrorOfStackTraceElement.lineNumber;
        }
        return mirrorOfStackTraceElement.copy(string, string2, string3, n);
    }

    @NotNull
    public String toString() {
        return "MirrorOfStackTraceElement(declaringClass=" + this.declaringClass + ", methodName=" + this.methodName + ", fileName=" + this.fileName + ", lineNumber=" + this.lineNumber + ")";
    }

    public int hashCode() {
        int result2 = this.declaringClass.hashCode();
        result2 = result2 * 31 + this.methodName.hashCode();
        result2 = result2 * 31 + (this.fileName == null ? 0 : this.fileName.hashCode());
        result2 = result2 * 31 + (this.lineNumber == null ? 0 : ((Object)this.lineNumber).hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MirrorOfStackTraceElement)) {
            return false;
        }
        MirrorOfStackTraceElement mirrorOfStackTraceElement = (MirrorOfStackTraceElement)other;
        if (!Intrinsics.areEqual((Object)this.declaringClass, (Object)mirrorOfStackTraceElement.declaringClass)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.methodName, (Object)mirrorOfStackTraceElement.methodName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fileName, (Object)mirrorOfStackTraceElement.fileName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.lineNumber, (Object)mirrorOfStackTraceElement.lineNumber);
    }
}

