/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting;

import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameElementFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.siyeh.ig.psiutils.SerializationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaResolverKt;
import org.jetbrains.kotlin.analysis.api.components.KaSymbolInformationProviderKt;
import org.jetbrains.kotlin.analysis.api.components.KaSymbolRelationProviderKt;
import org.jetbrains.kotlin.analysis.api.components.KaTypeInformationProviderKt;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.signatures.KaVariableSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassifierSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolModality;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolProviderKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolVisibility;
import org.jetbrains.kotlin.analysis.api.symbols.KaTypeAliasSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.pointers.KaSymbolPointer;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ExplicitApiMode;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.idea.base.codeInsight.EnumValuesSoftDeprecateKt;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinMainFunctionDetector;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.base.psi.JavaPsiUtils;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.searching.usages.KotlinFindUsagesHandlerFactory;
import org.jetbrains.kotlin.idea.base.searching.usages.handlers.KotlinFindClassUsagesHandler;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.AnalysisUtilsKt;
import org.jetbrains.kotlin.idea.codeinsight.utils.EnumUtilsKt;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.UtilsKt;
import org.jetbrains.kotlin.idea.highlighting.SafeDeleteFix;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReferencesSearchParameters;
import org.jetbrains.kotlin.idea.searching.inheritors.KotlinSearchUtilKt;
import org.jetbrains.kotlin.idea.util.AnnotationModificationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DataClassResolver;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\f*\u00020\u000eH\u0002J\u001f\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ)\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eR\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u001fJ\u001d\u0010 \u001a\u00020\f*\u00020!H\u0002R\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\"J\f\u0010#\u001a\u00020\f*\u00020$H\u0002J\f\u0010%\u001a\u00020\f*\u00020&H\u0002J\u0010\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020)H\u0002J-\u0010*\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00060,R\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010-J)\u0010.\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\u000eH\u0002R\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u00100J7\u00101\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u00102\u001a\u0004\u0018\u0001032\n\b\u0002\u00104\u001a\u0004\u0018\u000105H\u0002R\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u00106JE\u00101\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u00102\u001a\u0004\u0018\u0001032\f\u00107\u001a\b\u0012\u0004\u0012\u000209082\n\b\u0002\u00104\u001a\u0004\u0018\u000105H\u0002R\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010:J3\u0010=\u001a\u00020\f2\u0006\u0010>\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010?\u001a\u0004\u0018\u00010\u000eH\u0002R\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010@JE\u0010A\u001a\u00020\f2\u0006\u0010B\u001a\u00020C2\u0006\u0010\r\u001a\u00020\u000e2\b\u00102\u001a\u0004\u0018\u0001032\b\u00104\u001a\u0004\u0018\u0001052\u0006\u0010D\u001a\u00020EH\u0002R\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010FJ \u0010G\u001a\u00020\f2\u0006\u0010H\u001a\u00020I2\u0006\u0010\r\u001a\u00020J2\u0006\u0010B\u001a\u00020CH\u0002J5\u0010K\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u00104\u001a\u0004\u0018\u0001052\b\u0010?\u001a\u0004\u0018\u00010\u000eH\u0002R\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010LJ,\u0010M\u001a\u00020\f2\u0006\u0010N\u001a\u00020\u001c2\u0006\u0010O\u001a\u00020E2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020R\u0012\u0004\u0012\u00020\f0QH\u0002J+\u0010S\u001a\u00020\f2\b\u0010T\u001a\u0004\u0018\u0001032\u0006\u0010D\u001a\u00020EH\u0002R\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010UJ\u001d\u0010V\u001a\u00020\f*\u00020WH\u0002R\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010XJ!\u0010Y\u001a\u00020\f2\u0006\u0010T\u001a\u000203H\u0002R\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010ZJ)\u0010S\u001a\u00020\f2\u0006\u0010[\u001a\u00020R2\u0006\u0010T\u001a\u000203H\u0002R\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\\J\u000e\u0010]\u001a\u0004\u0018\u00010^*\u00020_H\u0002J\u0016\u0010`\u001a\u0004\u0018\u00010a*\u00020a2\u0006\u0010T\u001a\u000203H\u0002J\u0016\u0010b\u001a\u0004\u0018\u00010c*\u00020a2\u0006\u0010T\u001a\u000203H\u0002J\f\u0010d\u001a\u00020\f*\u00020eH\u0002J\u001f\u0010f\u001a\u0004\u0018\u00010g*\u00020^H\u0002R\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010hJ\u001d\u0010d\u001a\u00020\f*\u00020^H\u0002R\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010iJ\f\u0010j\u001a\u00020\f*\u00020kH\u0002J\u0014\u0010j\u001a\u00020\f*\u00020l2\u0006\u0010T\u001a\u000203H\u0002J'\u0010m\u001a\u00020\f*\u00020J2\b\u00104\u001a\u0004\u0018\u000105H\u0002R\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010nJ\u001d\u0010o\u001a\u00020\f*\u00020pH\u0002R\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010qJ\u0010\u0010r\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010s\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010t\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010u\u001a\u00020\f2\u0006\u0010v\u001a\u00020wH\u0002J%\u0010x\u001a\b\u0012\u0004\u0012\u00020y0\u00052\u0006\u0010\r\u001a\u00020\u000eR\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010zJ7\u0010{\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u00107\u001a\b\u0012\u0004\u0012\u000209082\u0006\u0010|\u001a\u00020\u001eH\u0002R\u00020\u0017j\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010}R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010;\u001a\u00020\f*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<\u00a8\u0006~"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/K2UnusedSymbolUtil;", "", "<init>", "()V", "KOTLIN_ADDITIONAL_ANNOTATIONS", "", "", "DEPRECATION_LEVEL_HIDDEN", "Lorg/jetbrains/kotlin/name/FqName;", "DEPRECATION_LEVEL_PARAMETER_NAME", "Lorg/jetbrains/kotlin/name/Name;", "isApplicableByPsi", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "isExpectedOrActual", "owner", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "isEffectivelyAbstractFunction", "ownerFunction", "Lorg/jetbrains/kotlin/psi/KtFunction;", "isScriptTopLevelPublicDeclaration", "isHiddenFromResolution", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)Z", "isLocalDeclaration", "getPsiToReportProblem", "Lcom/intellij/psi/PsiElement;", "isJavaEntryPointInspection", "Lcom/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lcom/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase;)Lcom/intellij/psi/PsiElement;", "hasKotlinAdditionalAnnotation", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtDeclaration;)Z", "isSerializationImplicitlyUsedField", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isSerializationImplicitlyUsedMethod", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isAnnotationParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "checkAnnotatedUsingPatterns", "annotationPatterns", "", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Ljava/util/Collection;)Z", "checkDeclaration", "importedDeclaration", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)Z", "hasNonTrivialUsages", "declarationContainingClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/psi/KtClass;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;)Z", "isCheapEnough", "Lkotlin/Lazy;", "Lcom/intellij/psi/search/PsiSearchHelper$SearchCostResult;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/psi/KtClass;Lkotlin/Lazy;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;)Z", "isObjectOrEnum", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)Z", "checkReference", "refElement", "originalDeclaration", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)Z", "hasReferences", "project", "Lcom/intellij/openapi/project/Project;", "useScope", "Lcom/intellij/psi/search/SearchScope;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/psi/KtClass;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;Lcom/intellij/psi/search/SearchScope;)Z", "isTooManyOccurrencesToCheck", "method", "Lcom/intellij/psi/PsiMethod;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "checkPrivateDeclaration", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)Z", "referenceExists", "psiElement", "scope", "predicate", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiReference;", "hasBuiltInEnumFunctionReference", "enumClass", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtClass;Lcom/intellij/psi/search/SearchScope;)Z", "isReferenceToBuiltInEnumEntries", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;)Z", "hasEnumFunctionReferenceInEnumClass", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtClass;)Z", "reference", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lcom/intellij/psi/PsiReference;Lorg/jetbrains/kotlin/psi/KtClass;)Z", "normalizeImportDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "Lorg/jetbrains/kotlin/psi/KtElement;", "normalizeEnumQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "normalizeEnumCallableReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "isUsedStarImportOfEnumStaticFunctions", "Lcom/intellij/psi/PsiImportStaticStatement;", "resolveReferenceToSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtImportDirective;)Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtImportDirective;)Z", "isReferenceToBuiltInEnumFunction", "Lcom/intellij/psi/PsiImportStaticReferenceElement;", "Lcom/intellij/psi/PsiReferenceExpression;", "canBeHandledByLightMethods", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;)Z", "hasInlineClassParameters", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedFunctionSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedFunctionSymbol;)Z", "hasOverrides", "hasFakeOverrides", "hasPlatformImplementations", "classOrObjectHasTextUsages", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "createQuickFixes", "Lcom/intellij/codeInsight/intention/IntentionAction;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)Ljava/util/List;", "isEntryPoint", "isJavaEntryPoint", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lkotlin/Lazy;Lcom/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase;)Z", "intellij.kotlin.highlighting"})
@SourceDebugExtension(value={"SMAP\nK2UnusedSymbolUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2UnusedSymbolUtil.kt\norg/jetbrains/kotlin/idea/highlighting/K2UnusedSymbolUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 7 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 8 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,859:1\n1#2:860\n1#2:878\n1#2:901\n253#3:861\n253#3:862\n232#3:884\n420#3:910\n431#3,10:911\n453#3:921\n420#3:922\n431#3,10:923\n453#3:933\n420#3:934\n431#3,10:935\n453#3:945\n420#3:946\n431#3,10:947\n453#3:957\n261#3:958\n420#3:963\n431#3,10:964\n453#3:974\n249#3:1054\n249#3:1055\n249#3:1074\n249#3:1075\n12970#4,2:863\n12767#4,2:1039\n12970#4,2:1041\n1761#5,3:865\n1617#5,9:868\n1869#5:877\n1870#5:879\n1626#5:880\n1761#5,3:881\n2746#5,3:885\n1761#5,3:888\n1617#5,9:891\n1869#5:900\n1870#5:902\n1626#5:903\n774#5:904\n865#5,2:905\n1761#5,3:907\n1563#5:959\n1634#5,3:960\n1563#5:975\n1634#5,3:976\n1563#5:979\n1634#5,3:980\n1761#5,3:983\n1761#5,3:1031\n1761#5,2:1037\n1763#5:1043\n1761#5,3:1045\n1761#5,3:1048\n1761#5,3:1051\n1563#5:1056\n1634#5,3:1057\n2746#5,3:1060\n1563#5:1097\n1634#5,3:1098\n30#6,2:986\n30#6,2:1004\n30#6,2:1063\n30#6,2:1080\n36#7,15:988\n36#7,14:1006\n50#7:1034\n46#7,2:1035\n36#7,9:1065\n49#7,2:1076\n46#7,2:1078\n36#7,15:1082\n1255#8:1003\n385#8,11:1020\n1256#8:1044\n*S KotlinDebug\n*F\n+ 1 K2UnusedSymbolUtil.kt\norg/jetbrains/kotlin/idea/highlighting/K2UnusedSymbolUtil\n*L\n240#1:878\n498#1:901\n218#1:861\n220#1:862\n357#1:884\n531#1:910\n531#1:911,10\n531#1:921\n536#1:922\n536#1:923,10\n536#1:933\n542#1:934\n542#1:935,10\n542#1:945\n599#1:946\n599#1:947,10\n599#1:957\n605#1:958\n624#1:963\n624#1:964,10\n624#1:974\n324#1:1054\n325#1:1055\n411#1:1074\n412#1:1075\n224#1:863,2\n710#1:1039,2\n711#1:1041,2\n228#1:865,3\n240#1:868,9\n240#1:877\n240#1:879\n240#1:880\n250#1:881,3\n367#1:885,3\n422#1:888,3\n498#1:891,9\n498#1:900\n498#1:902\n498#1:903\n499#1:904\n499#1:905,2\n500#1:907,3\n615#1:959\n615#1:960,3\n636#1:975\n636#1:976,3\n642#1:979\n642#1:980,3\n661#1:983,3\n704#1:1031,3\n708#1:1037,2\n708#1:1043\n795#1:1045,3\n833#1:1048,3\n839#1:1051,3\n328#1:1056\n328#1:1057,3\n330#1:1060,3\n596#1:1097\n596#1:1098,3\n681#1:986,2\n692#1:1004,2\n410#1:1063,2\n514#1:1080,2\n681#1:988,15\n692#1:1006,14\n692#1:1034\n692#1:1035,2\n410#1:1065,9\n410#1:1076,2\n410#1:1078,2\n514#1:1082,15\n689#1:1003\n699#1:1020,11\n689#1:1044\n*E\n"})
public final class K2UnusedSymbolUtil {
    @NotNull
    public static final K2UnusedSymbolUtil INSTANCE = new K2UnusedSymbolUtil();
    @NotNull
    private static final List<String> KOTLIN_ADDITIONAL_ANNOTATIONS;
    @NotNull
    private static final FqName DEPRECATION_LEVEL_HIDDEN;
    @NotNull
    private static final Name DEPRECATION_LEVEL_PARAMETER_NAME;

    private K2UnusedSymbolUtil() {
    }

    public final boolean isApplicableByPsi(@NotNull KtNamedDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.isScriptTopLevelPublicDeclaration(declaration)) {
            return false;
        }
        if (declaration instanceof KtObjectDeclaration && ((KtObjectDeclaration)declaration).isCompanion()) {
            return false;
        }
        if (declaration instanceof KtParameter) {
            KtClassOrObject containingClass;
            KtDeclaration ownerFunction;
            if (UtilsKt.isExplicitlyIgnoredByName(declaration)) {
                return false;
            }
            if (((KtParameter)declaration).isFunctionTypeParameter()) {
                return false;
            }
            KtDeclaration ktDeclaration = ownerFunction = ((KtParameter)declaration).getOwnerDeclaration();
            boolean bl = ktDeclaration != null ? ktDeclaration.hasModifier(KtTokens.EXTERNAL_KEYWORD) : false;
            if (bl) {
                return false;
            }
            KtDeclaration ktDeclaration2 = ownerFunction;
            Object object = containingClass = ktDeclaration2 != null ? KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)ktDeclaration2) : null;
            if (ownerFunction instanceof KtConstructor) {
                if (containingClass != null) {
                    if (containingClass.isData()) {
                        return false;
                    }
                    if (containingClass instanceof KtClass) {
                        if (((KtClass)containingClass).isValue() && ((KtParameter)declaration).hasValOrVar()) {
                            return false;
                        }
                        if (((KtClass)containingClass).isInline() && ((KtParameter)declaration).hasValOrVar()) {
                            return false;
                        }
                    }
                    if (this.isExpectedOrActual((KtModifierListOwner)containingClass)) {
                        return false;
                    }
                }
            } else if (ownerFunction instanceof KtFunction) {
                if (((KtFunction)ownerFunction).getName() == null) {
                    return false;
                }
                if (((KtFunction)ownerFunction).hasModifier(KtTokens.OPERATOR_KEYWORD)) {
                    return false;
                }
                if (this.isEffectivelyAbstractFunction((KtFunction)ownerFunction) || this.isExpectedOrActual((KtModifierListOwner)ownerFunction)) {
                    return false;
                }
                if (containingClass != null && this.isExpectedOrActual((KtModifierListOwner)containingClass)) {
                    return false;
                }
            }
            while (containingClass != null) {
                if (containingClass.hasModifier(KtTokens.EXTERNAL_KEYWORD)) {
                    return false;
                }
                containingClass = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)containingClass));
            }
        }
        KtNamedDeclaration owner = null;
        if (declaration instanceof KtTypeParameter) {
            PsiElement psiElement;
            PsiElement parent = ((KtTypeParameter)declaration).getParent();
            if (parent != null && !(parent instanceof KtTypeParameterListOwner)) {
                parent = parent.getParent();
            }
            KtTypeParameterListOwner ktTypeParameterListOwner = (psiElement = parent) instanceof KtTypeParameterListOwner ? (KtTypeParameterListOwner)psiElement : null;
            owner = ktTypeParameterListOwner != null ? (KtNamedDeclaration)ktTypeParameterListOwner : declaration;
        } else {
            owner = declaration;
        }
        return !owner.hasModifier(KtTokens.OVERRIDE_KEYWORD);
    }

    private final boolean isExpectedOrActual(KtModifierListOwner owner) {
        KtModifierList modifierList = owner.getModifierList();
        return modifierList != null && (modifierList.hasModifier(KtTokens.EXPECT_KEYWORD) || modifierList.hasModifier(KtTokens.ACTUAL_KEYWORD));
    }

    private final boolean isEffectivelyAbstractFunction(KtFunction ownerFunction) {
        KtModifierList modifierList = ownerFunction.getModifierList();
        if (modifierList != null && (modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD) || modifierList.hasModifier(KtTokens.EXPECT_KEYWORD) || modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD) || modifierList.hasModifier(KtTokens.OPEN_KEYWORD))) {
            return true;
        }
        KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)ownerFunction));
        return ktClass != null ? ktClass.isInterface() : false;
    }

    private final boolean isScriptTopLevelPublicDeclaration(KtNamedDeclaration $this$isScriptTopLevelPublicDeclaration) {
        return $this$isScriptTopLevelPublicDeclaration.getParent().getParent() instanceof KtScript && !$this$isScriptTopLevelPublicDeclaration.hasModifier(KtTokens.PRIVATE_KEYWORD) && !($this$isScriptTopLevelPublicDeclaration.getContainingFile().getVirtualFile() instanceof VirtualFileWindow);
    }

    public final boolean isHiddenFromResolution(@NotNull KaSession kaSession, @NotNull KtNamedDeclaration declaration) {
        Object v2;
        block5: {
            Intrinsics.checkNotNullParameter((Object)kaSession, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            KtAnnotationEntry ktAnnotationEntry = AnnotationModificationUtilsKt.findAnnotation((KtAnnotated)declaration, StandardClassIds.Annotations.INSTANCE.getDeprecated(), null, false);
            if (ktAnnotationEntry == null) {
                return false;
            }
            KtAnnotationEntry anno = ktAnnotationEntry;
            KaLifetimeOwner kaLifetimeOwner = KaResolverKt.resolveToCall(kaSession, (KtElement)anno);
            if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.successfulFunctionCallOrNull((KaCallInfo)kaLifetimeOwner)) == null) {
                return false;
            }
            KaLifetimeOwner call2 = kaLifetimeOwner;
            Iterable iterable = call2.getArgumentMapping().entrySet();
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((KaValueParameterSymbol)((KaVariableSignature)it.getValue()).getSymbol()).getName(), (Object)DEPRECATION_LEVEL_PARAMETER_NAME)) continue;
                v2 = t;
                break block5;
            }
            v2 = null;
        }
        Map.Entry entry = v2;
        if (entry == null) {
            return false;
        }
        Map.Entry levelArgument = entry;
        KaLifetimeOwner kaLifetimeOwner = KaResolverKt.resolveToCall(kaSession, (KtElement)levelArgument.getKey());
        if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.successfulVariableAccessCall(kaLifetimeOwner)) == null) {
            return false;
        }
        KaLifetimeOwner levelArgumentCall = kaLifetimeOwner;
        return Intrinsics.areEqual((Object)KaSymbolInformationProviderKt.getImportableFqName(kaSession, (KaSymbol)KaCallKt.getSymbol((KaCallableMemberCall)levelArgumentCall)), (Object)DEPRECATION_LEVEL_HIDDEN);
    }

    public final boolean isLocalDeclaration(@NotNull KtNamedDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof KtProperty && ((KtProperty)declaration).isLocal()) {
            return true;
        }
        return declaration instanceof KtParameter && (!(((KtParameter)declaration).getParent().getParent() instanceof KtPrimaryConstructor) || !((KtParameter)declaration).hasValOrVar());
    }

    @Nullable
    public final PsiElement getPsiToReportProblem(@NotNull KaSession kaSession, @NotNull KtNamedDeclaration declaration, @NotNull UnusedDeclarationInspectionBase isJavaEntryPointInspection) {
        Lazy isCheapEnough;
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)isJavaEntryPointInspection, (String)"isJavaEntryPointInspection");
        KaDeclarationSymbol symbol = KaSymbolProviderKt.getSymbol(kaSession, (KtDeclaration)declaration);
        if (LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)declaration).getFlag(AnalysisFlags.getExplicitApiMode()) != ExplicitApiMode.DISABLED && symbol.getCompilerVisibility().isPublicAPI()) {
            return null;
        }
        if (symbol instanceof KaNamedFunctionSymbol && ((KaNamedFunctionSymbol)symbol).isOperator()) {
            boolean bl;
            String string = declaration.getName();
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                bl = DataClassResolver.INSTANCE.isComponentLike(it);
            } else {
                bl = false;
            }
            if (!bl) {
                return null;
            }
        }
        if (this.isEntryPoint(kaSession, declaration, (Lazy<? extends PsiSearchHelper.SearchCostResult>)(isCheapEnough = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> K2UnusedSymbolUtil.getPsiToReportProblem$lambda$1(declaration))), isJavaEntryPointInspection)) {
            return null;
        }
        if (AnalysisUtilsKt.isFinalizeMethod(kaSession, (KtDeclaration)declaration)) {
            return null;
        }
        if (declaration instanceof KtProperty && this.isSerializationImplicitlyUsedField((KtProperty)declaration)) {
            return null;
        }
        if (declaration instanceof KtNamedFunction && this.isSerializationImplicitlyUsedMethod((KtNamedFunction)declaration)) {
            return null;
        }
        KtClass declarationContainingClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)declaration));
        if (KotlinPsiUtils.isConstructorDeclaredProperty(declaration)) {
            KtClass ktClass = declarationContainingClass;
            boolean bl = ktClass != null ? KotlinPsiUtils.mustHaveNonEmptyPrimaryConstructor(ktClass) : false;
            if (bl) {
                return null;
            }
        }
        if (symbol instanceof KaClassSymbol && ((KaClassSymbol)symbol).getClassKind() == KaClassKind.ANNOTATION_CLASS) {
            String string = KaClassLikeSymbolKt.getNameOrAnonymous((KaClassifierSymbol)symbol).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String fqName2 = string;
            LanguageVersionSettings languageVersionSettings = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)declaration);
            if (((List)languageVersionSettings.getFlag(AnalysisFlags.getOptIn())).contains(fqName2)) {
                return null;
            }
        }
        if (this.hasNonTrivialUsages(kaSession, declaration, declarationContainingClass, (Lazy<? extends PsiSearchHelper.SearchCostResult>)isCheapEnough, symbol)) {
            return null;
        }
        if (declaration instanceof KtClassOrObject && this.classOrObjectHasTextUsages((KtClassOrObject)declaration)) {
            return null;
        }
        Object object = declaration.getNameIdentifier();
        if (object == null) {
            KtConstructor ktConstructor = declaration instanceof KtConstructor ? (KtConstructor)declaration : null;
            object = ktConstructor != null ? ktConstructor.getConstructorKeyword() : null;
        }
        return object;
    }

    private final boolean hasKotlinAdditionalAnnotation(KaSession kaSession, KtDeclaration $this$hasKotlinAdditionalAnnotation) {
        return $this$hasKotlinAdditionalAnnotation instanceof KtNamedDeclaration && this.checkAnnotatedUsingPatterns(kaSession, (KtNamedDeclaration)$this$hasKotlinAdditionalAnnotation, (Collection<String>)KOTLIN_ADDITIONAL_ANNOTATIONS);
    }

    private final boolean isSerializationImplicitlyUsedField(KtProperty $this$isSerializationImplicitlyUsedField) {
        boolean bl;
        block5: {
            Object object;
            PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)$this$isSerializationImplicitlyUsedField;
            boolean $i$f$getNonStrictParentOfType = false;
            PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClassOrObject.class, (boolean)false);
            KtObjectDeclaration ktObjectDeclaration = psiElement instanceof KtObjectDeclaration ? (KtObjectDeclaration)psiElement : null;
            if (ktObjectDeclaration == null) {
                return false;
            }
            KtObjectDeclaration ownerObject = ktObjectDeclaration;
            if (ownerObject.isCompanion()) {
                PsiElement $this$getNonStrictParentOfType$iv2 = (PsiElement)ownerObject;
                boolean $i$f$getNonStrictParentOfType2 = false;
                KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv2, KtClass.class, (boolean)false);
                object = ktClass != null ? LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)ktClass)) : null;
            } else {
                object = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)ownerObject));
            }
            if (object == null) {
                return false;
            }
            KtLightClass lightClass = object;
            PsiField[] psiFieldArray = lightClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
            Object[] $this$any$iv = psiFieldArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiField it = (PsiField)element$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)$this$isSerializationImplicitlyUsedField.getName()) && SerializationUtils.isSerializationImplicitlyUsedField((PsiField)it))) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isSerializationImplicitlyUsedMethod(KtNamedFunction $this$isSerializationImplicitlyUsedMethod) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = LightClassUtilsKt.toLightMethods((PsiElement)((PsiElement)$this$isSerializationImplicitlyUsedMethod));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiMethod it = (PsiMethod)element$iv;
                    boolean bl2 = false;
                    if (!JavaHighlightUtil.isSerializationRelatedMethod((PsiMethod)it, (PsiClass)it.getContainingClass())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isAnnotationParameter(KtParameter parameter) {
        KtDeclarationWithBody ktDeclarationWithBody = parameter.getOwnerFunction();
        KtConstructor ktConstructor = ktDeclarationWithBody instanceof KtConstructor ? (KtConstructor)ktDeclarationWithBody : null;
        if (ktConstructor == null) {
            return false;
        }
        KtConstructor constructor = ktConstructor;
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)constructor));
        return ktClassOrObject != null ? ktClassOrObject.isAnnotation() : false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkAnnotatedUsingPatterns(@NotNull KaSession kaSession, @NotNull KtNamedDeclaration declaration, @NotNull Collection<String> annotationPatterns) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(annotationPatterns, (String)"annotationPatterns");
        if (declaration.getAnnotationEntries().isEmpty()) {
            return false;
        }
        List list2 = declaration.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            KaConstructorSymbol constructorSymbol;
            ClassId classId;
            KaSymbol symbol;
            KtAnnotationEntry reference;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtAnnotationEntry it = (KtAnnotationEntry)element$iv$iv;
            boolean bl2 = false;
            KtAnnotationEntry ktAnnotationEntry = it;
            if ((ktAnnotationEntry == null || (ktAnnotationEntry = ktAnnotationEntry.getCalleeExpression()) == null || (ktAnnotationEntry = ktAnnotationEntry.getConstructorReferenceExpression()) == null || (ktAnnotationEntry = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)ktAnnotationEntry)) == null ? null : (KaResolverKt.resolveToSymbol(kaSession, (KtReference)(reference = ktAnnotationEntry)) == null ? null : ((symbol instanceof KaConstructorSymbol ? (KaConstructorSymbol)symbol : null) == null ? null : ((classId = (constructorSymbol = constructorSymbol).getContainingClassId()) != null && (classId = classId.asSingleFqName()) != null ? classId.asString() : null)))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List annotationsPresent = (List)destination$iv$iv;
        if (annotationsPresent.isEmpty()) {
            return false;
        }
        for (String pattern2 : annotationPatterns) {
            boolean hasAnnotation;
            boolean bl;
            block9: {
                if (StringsKt.endsWith$default((String)pattern2, (String)".*", (boolean)false, (int)2, null)) {
                    Iterable $this$any$iv = annotationsPresent;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl4 = false;
                            if (!StringsKt.startsWith$default((String)it, (String)StringsKt.dropLast((String)pattern2, (int)1), (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                } else {
                    bl = annotationsPresent.contains(pattern2);
                }
            }
            if (!(hasAnnotation = bl)) continue;
            return true;
        }
        return false;
    }

    private final boolean checkDeclaration(KaSession kaSession, KtNamedDeclaration declaration, KtNamedDeclaration importedDeclaration) {
        return !SequencesKt.contains((Sequence)PsiUtilsKt.getParentsWithSelf((PsiElement)((PsiElement)importedDeclaration)), (Object)declaration) && !K2UnusedSymbolUtil.hasNonTrivialUsages$default(this, kaSession, importedDeclaration, KtPsiUtilKt.containingClass((KtElement)((KtElement)importedDeclaration)), null, 8, null);
    }

    private final boolean hasNonTrivialUsages(KaSession kaSession, KtNamedDeclaration declaration, KtClass declarationContainingClass, KaDeclarationSymbol symbol) {
        Lazy isCheapEnough = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> K2UnusedSymbolUtil.hasNonTrivialUsages$lambda$0(declaration));
        return this.hasNonTrivialUsages(kaSession, declaration, declarationContainingClass, (Lazy<? extends PsiSearchHelper.SearchCostResult>)isCheapEnough, symbol);
    }

    static /* synthetic */ boolean hasNonTrivialUsages$default(K2UnusedSymbolUtil k2UnusedSymbolUtil, KaSession kaSession, KtNamedDeclaration ktNamedDeclaration, KtClass ktClass, KaDeclarationSymbol kaDeclarationSymbol, int n, Object object) {
        if ((n & 8) != 0) {
            kaDeclarationSymbol = null;
        }
        return k2UnusedSymbolUtil.hasNonTrivialUsages(kaSession, ktNamedDeclaration, ktClass, kaDeclarationSymbol);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasNonTrivialUsages(KaSession kaSession, KtNamedDeclaration declaration, KtClass declarationContainingClass, Lazy<? extends PsiSearchHelper.SearchCostResult> isCheapEnough, KaDeclarationSymbol symbol) {
        SearchScope restrictedScope;
        Project project = declaration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)psiSearchHelper, (String)"getInstance(...)");
        PsiSearchHelper psiSearchHelper2 = psiSearchHelper;
        SearchScope searchScope = psiSearchHelper2.getUseScope((PsiElement)declaration);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getUseScope(...)");
        SearchScope useScope = searchScope;
        if (useScope instanceof GlobalSearchScope) {
            boolean bl;
            switch (WhenMappings.$EnumSwitchMapping$0[((PsiSearchHelper.SearchCostResult)isCheapEnough.getValue()).ordinal()]) {
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    bl = false;
                    break;
                }
                case 3: {
                    return true;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            boolean zeroOccurrences = bl;
            if (zeroOccurrences && !PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)declaration))) {
                if (!(declaration instanceof KtObjectDeclaration)) return false;
                if (!((KtObjectDeclaration)declaration).isCompanion()) {
                    return false;
                }
            }
            v4 = (SearchScope)(PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)declaration)) ? KotlinSourceFilterScope.Companion.projectSourcesAndResources(KotlinScopeUtils.projectScope(project2), project2) : KotlinSourceFilterScope.Companion.projectSourcesAndResources((GlobalSearchScope)useScope, project2));
        } else {
            v4 = restrictedScope = useScope;
        }
        if (declaration instanceof KtTypeParameter && declarationContainingClass != null) {
            boolean isOpenClass;
            boolean bl = isOpenClass = declarationContainingClass.isInterface() || declarationContainingClass.hasModifier(KtTokens.ABSTRACT_KEYWORD) || declarationContainingClass.hasModifier(KtTokens.SEALED_KEYWORD) || declarationContainingClass.hasModifier(KtTokens.OPEN_KEYWORD);
            if (isOpenClass && this.hasOverrides((KtNamedDeclaration)declarationContainingClass)) {
                return true;
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
            GlobalSearchScope containingClassSearchScope = globalSearchScope;
            boolean isRequiredToCallFunction = this.referenceExists((PsiElement)declarationContainingClass, (SearchScope)containingClassSearchScope, (Function1<? super PsiReference, Boolean>)((Function1)arg_0 -> K2UnusedSymbolUtil.hasNonTrivialUsages$lambda$1(containingClassSearchScope, arg_0)));
            if (isRequiredToCallFunction) {
                return true;
            }
        }
        if (declaration instanceof KtObjectDeclaration && ((KtObjectDeclaration)declaration).isCompanion()) {
            boolean bl;
            Object object = ((KtObjectDeclaration)declaration).getBody();
            if (object != null && (object = object.getDeclarations()) != null) {
                if (!((Collection)object).isEmpty()) {
                    return true;
                }
                boolean bl2 = false;
                if (bl2) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
        }
        if (this.hasOverrides(declaration)) return true;
        if (this.hasReferences(kaSession, project2, declaration, declarationContainingClass, symbol, restrictedScope)) return true;
        if (this.hasFakeOverrides(declaration, restrictedScope)) return true;
        if (!this.hasPlatformImplementations(declaration)) return false;
        return true;
    }

    static /* synthetic */ boolean hasNonTrivialUsages$default(K2UnusedSymbolUtil k2UnusedSymbolUtil, KaSession kaSession, KtNamedDeclaration ktNamedDeclaration, KtClass ktClass, Lazy lazy, KaDeclarationSymbol kaDeclarationSymbol, int n, Object object) {
        if ((n & 0x10) != 0) {
            kaDeclarationSymbol = null;
        }
        return k2UnusedSymbolUtil.hasNonTrivialUsages(kaSession, ktNamedDeclaration, ktClass, (Lazy<? extends PsiSearchHelper.SearchCostResult>)lazy, kaDeclarationSymbol);
    }

    private final boolean isObjectOrEnum(KtNamedDeclaration $this$isObjectOrEnum) {
        return $this$isObjectOrEnum instanceof KtObjectDeclaration || $this$isObjectOrEnum instanceof KtClass && ((KtClass)$this$isObjectOrEnum).isEnum();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkReference(KaSession kaSession, PsiElement refElement, KtNamedDeclaration declaration, KtNamedDeclaration originalDeclaration) {
        KtExpression ktExpression;
        FqName declarationFqName;
        void $this$getParentOfType$iv;
        if (PsiUtilsKt.isAncestor$default((PsiElement)((PsiElement)declaration), (PsiElement)refElement, (boolean)false, (int)2, null)) {
            return true;
        }
        if (refElement.getParent() instanceof KtValueArgumentName) {
            return true;
        }
        PsiElement psiElement = refElement;
        boolean strict$iv = false;
        boolean $i$f$getParentOfType2 = false;
        KtImportDirective ktImportDirective = (KtImportDirective)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtImportDirective.class, (boolean)strict$iv);
        if (ktImportDirective == null) {
            return false;
        }
        KtImportDirective ktImportDirective2 = ktImportDirective;
        String aliasName = ktImportDirective2.getAliasName();
        if (aliasName != null && !Intrinsics.areEqual((Object)aliasName, (Object)declaration.getName())) {
            return false;
        }
        if (!(declaration instanceof KtClassOrObject) && !(originalDeclaration instanceof KtClassOrObject)) {
            return true;
        }
        if (ktImportDirective2.isAllUnder()) {
            boolean bl;
            block16: {
                KtExpression ktExpression2 = ktImportDirective2.getImportedReference();
                PsiElement $i$f$getParentOfType2 = ktExpression2 != null && (ktExpression2 = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)ktExpression2))) != null && (ktExpression2 = ReferenceUtilsKt.getMainReference((KtElement)ktExpression2)) != null ? ktExpression2.resolve() : null;
                KtClassOrObject ktClassOrObject = $i$f$getParentOfType2 instanceof KtClassOrObject ? (KtClassOrObject)$i$f$getParentOfType2 : null;
                if (ktClassOrObject == null) {
                    return true;
                }
                KtClassOrObject importedFrom = ktClassOrObject;
                Iterable $this$none$iv = importedFrom.getDeclarations();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        KtDeclaration it = (KtDeclaration)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof KtNamedDeclaration && K2UnusedSymbolUtil.hasNonTrivialUsages$default(INSTANCE, kaSession, (KtNamedDeclaration)it, KtPsiUtilKt.containingClass((KtElement)((KtElement)it)), null, 8, null))) continue;
                        bl = false;
                        break block16;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        FqName importedFqName = ktImportDirective2.getImportedFqName();
        if (Intrinsics.areEqual((Object)importedFqName, (Object)(declarationFqName = declaration.getFqName()))) {
            return true;
        }
        if (declarationFqName != null) {
            FqName fqName2 = importedFqName;
            boolean bl = fqName2 != null ? fqName2.startsWith(declarationFqName) : false;
            if (bl) {
                return false;
            }
        }
        PsiElement psiElement2 = (ktExpression = ktImportDirective2.getImportedReference()) != null && (ktExpression = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)ktExpression))) != null && (ktExpression = ReferenceUtilsKt.getMainReference((KtElement)ktExpression)) != null ? ktExpression.resolve() : null;
        KtNamedDeclaration ktNamedDeclaration = psiElement2 instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement2 : null;
        if (ktNamedDeclaration == null) {
            return true;
        }
        KtNamedDeclaration importedDeclaration = ktNamedDeclaration;
        if (this.isObjectOrEnum(declaration) || KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)importedDeclaration)) instanceof KtObjectDeclaration) {
            return this.checkDeclaration(kaSession, declaration, importedDeclaration);
        }
        KtNamedDeclaration ktNamedDeclaration2 = originalDeclaration;
        boolean bl = ktNamedDeclaration2 != null ? this.isObjectOrEnum(ktNamedDeclaration2) : false;
        if (bl) {
            return this.checkDeclaration(kaSession, originalDeclaration, importedDeclaration);
        }
        return true;
    }

    private final boolean hasReferences(KaSession kaSession, Project project, KtNamedDeclaration declaration, KtClass declarationContainingClass, KaDeclarationSymbol symbol, SearchScope useScope) {
        KtNamedDeclaration originalDeclaration;
        KaLifetimeOwner kaLifetimeOwner = symbol instanceof KaTypeAliasSymbol ? (KaTypeAliasSymbol)symbol : null;
        PsiElement psiElement = kaLifetimeOwner != null && (kaLifetimeOwner = ((KaTypeAliasSymbol)kaLifetimeOwner).getExpandedType()) != null && (kaLifetimeOwner = KaTypeInformationProviderKt.getExpandedSymbol(kaSession, (KaType)kaLifetimeOwner)) != null ? kaLifetimeOwner.getPsi() : null;
        KtNamedDeclaration ktNamedDeclaration = originalDeclaration = psiElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement : null;
        if (!(symbol instanceof KaNamedFunctionSymbol) || !((KaNamedFunctionSymbol)symbol).getAnnotations().contains(JvmStandardClassIds.Annotations.INSTANCE.getJvmName())) {
            List lightMethods;
            KaSymbolPointer<KaDeclarationSymbol> symbolPointer2;
            KaDeclarationSymbol kaDeclarationSymbol = symbol;
            KaSymbolPointer<KaDeclarationSymbol> kaSymbolPointer = symbolPointer2 = kaDeclarationSymbol != null ? kaDeclarationSymbol.createPointer() : null;
            if (declaration instanceof KtSecondaryConstructor && declarationContainingClass != null && (UtilsKt.isCheapEnoughToSearchUsages((KtNamedDeclaration)declarationContainingClass) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES || this.referenceExists((PsiElement)declarationContainingClass, useScope, (Function1<? super PsiReference, Boolean>)((Function1)arg_0 -> K2UnusedSymbolUtil.hasReferences$lambda$0(symbolPointer2, arg_0))))) {
                return true;
            }
            if (declaration instanceof KtCallableDeclaration && this.canBeHandledByLightMethods(kaSession, (KtCallableDeclaration)declaration, symbol) && !((Collection)(lightMethods = LightClassUtilsKt.toLightMethods((PsiElement)((PsiElement)declaration)))).isEmpty()) {
                boolean lightMethodsUsed;
                block14: {
                    Iterable $this$any$iv = lightMethods;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PsiMethod method = (PsiMethod)element$iv;
                            boolean bl = false;
                            boolean bl2 = INSTANCE.isTooManyOccurrencesToCheck(method, (KtCallableDeclaration)declaration, project) || !MethodReferencesSearch.search((PsiMethod)method).forEach(arg_0 -> K2UnusedSymbolUtil.hasReferences$lambda$1$0(kaSession, declaration, originalDeclaration, arg_0));
                            if (!bl2) continue;
                            v4 = true;
                            break block14;
                        }
                        v4 = lightMethodsUsed = false;
                    }
                }
                if (lightMethodsUsed) {
                    return true;
                }
                if (!PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)declaration))) {
                    return false;
                }
            }
            if (declaration instanceof KtEnumEntry) {
                KtClass enumClass;
                KtClass ktClass = declarationContainingClass;
                if (ktClass != null) {
                    KtClass lightMethodsUsed;
                    KtClass it = lightMethodsUsed = ktClass;
                    boolean bl = false;
                    v7 = it.isEnum() ? lightMethodsUsed : null;
                } else {
                    v7 = enumClass = null;
                }
                if (this.hasBuiltInEnumFunctionReference(kaSession, enumClass, useScope)) {
                    return true;
                }
            }
        }
        FindManager findManager = FindManager.getInstance((Project)project);
        Intrinsics.checkNotNull((Object)findManager, (String)"null cannot be cast to non-null type com.intellij.find.impl.FindManagerImpl");
        FindUsagesHandler handler2 = ((FindManagerImpl)findManager).getFindUsagesManager().getFindUsagesHandler((PsiElement)declaration, true);
        if (handler2 != null) {
            FindUsagesOptions findUsagesOptions = handler2.getFindUsagesOptions();
            Intrinsics.checkNotNullExpressionValue((Object)findUsagesOptions, (String)"getFindUsagesOptions(...)");
            FindUsagesOptions options2 = findUsagesOptions;
            options2.isSearchForTextOccurrences = false;
            boolean result2 = handler2.processElementUsages((PsiElement)declaration, arg_0 -> K2UnusedSymbolUtil.hasReferences$lambda$3(kaSession, declaration, originalDeclaration, arg_0), options2);
            if (!result2) {
                return true;
            }
        }
        return this.checkPrivateDeclaration(kaSession, declaration, symbol, originalDeclaration);
    }

    private final boolean isTooManyOccurrencesToCheck(PsiMethod method, KtCallableDeclaration declaration, Project project) {
        SearchScope searchScope = method.getUseScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getUseScope(...)");
        SearchScope searchScope2 = searchScope;
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name2 = string;
        return !StringsKt.equals$default((String)declaration.getName(), (String)name2, (boolean)false, (int)2, null) && searchScope2 instanceof GlobalSearchScope && PsiSearchHelper.getInstance((Project)project).isCheapEnoughToSearch(name2, (GlobalSearchScope)searchScope2, null) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkPrivateDeclaration(KaSession kaSession, KtNamedDeclaration declaration, KaDeclarationSymbol symbol, KtNamedDeclaration originalDeclaration) {
        boolean bl;
        block7: {
            void $this$any$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            if (symbol == null || !KtPsiUtilKt.isPrivateNestedClassOrObject((KtNamedDeclaration)declaration)) {
                return false;
            }
            HashSet setOfImportedDeclarations = new HashSet();
            KtImportList ktImportList = declaration.getContainingKtFile().getImportList();
            if (ktImportList != null) {
                ktImportList.acceptChildren((PsiElementVisitor)VisitorWrappersKt.simpleNameExpressionRecursiveVisitor(arg_0 -> K2UnusedSymbolUtil.checkPrivateDeclaration$lambda$0(setOfImportedDeclarations, arg_0)));
            }
            Iterable $this$mapNotNull$iv = setOfImportedDeclarations;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                KtReferenceExpression it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                KtSimpleNameExpression it = (KtSimpleNameExpression)element$iv$iv;
                boolean bl3 = false;
                if (KtPsiUtilKt.referenceExpression((KtExpression)((KtExpression)it)) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtReferenceExpression it = (KtReferenceExpression)element$iv$iv;
                boolean bl5 = false;
                if (!KaResolverKt.resolveToSymbols(kaSession, ReferenceUtilsKt.getMainReference((KtReferenceExpression)it)).contains(symbol)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtReferenceExpression it = (KtReferenceExpression)element$iv;
                    boolean bl6 = false;
                    if (!(!INSTANCE.checkReference(kaSession, (PsiElement)ReferenceUtilsKt.getMainReference((KtReferenceExpression)it).getElement(), declaration, originalDeclaration))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean referenceExists(PsiElement psiElement, SearchScope scope, Function1<? super PsiReference, Boolean> predicate2) {
        return !ReferencesSearch.search((ReferencesSearch.SearchParameters)new KotlinReferencesSearchParameters(psiElement, scope, false, null, null, 28, null)).forEach(arg_0 -> K2UnusedSymbolUtil.referenceExists$lambda$0(predicate2, arg_0));
    }

    private final boolean hasBuiltInEnumFunctionReference(KaSession kaSession, KtClass enumClass, SearchScope useScope) {
        if (enumClass == null) {
            return false;
        }
        boolean isFoundEnumFunctionReferenceViaSearch = this.referenceExists((PsiElement)enumClass, useScope, (Function1<? super PsiReference, Boolean>)((Function1)arg_0 -> K2UnusedSymbolUtil.hasBuiltInEnumFunctionReference$lambda$0(enumClass, arg_0)));
        return isFoundEnumFunctionReferenceViaSearch || this.hasEnumFunctionReferenceInEnumClass(kaSession, enumClass);
    }

    private final boolean isReferenceToBuiltInEnumEntries(KaSession kaSession, KtSimpleNameExpression $this$isReferenceToBuiltInEnumEntries) {
        return EnumValuesSoftDeprecateKt.isEnumValuesSoftDeprecateEnabled((PsiElement)$this$isReferenceToBuiltInEnumEntries) && Intrinsics.areEqual((Object)$this$isReferenceToBuiltInEnumEntries.getReferencedNameAsName(), (Object)StandardNames.ENUM_ENTRIES) && KotlinPsiUtilsKt.isSynthesizedFunction(kaSession, (KtExpression)$this$isReferenceToBuiltInEnumEntries);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasEnumFunctionReferenceInEnumClass(KaSession kaSession, KtClass enumClass) {
        boolean isFoundSimpleNameExpression;
        PsiElement $this$findDescendantOfType$iv$iv$iv;
        PsiElement $this$findDescendantOfType$iv$iv;
        PsiElement $this$anyDescendantOfType$iv;
        boolean isFoundCallableReference;
        void $this$findDescendantOfType$iv$iv$iv2;
        void $this$findDescendantOfType$iv$iv2;
        void $this$anyDescendantOfType$iv2;
        PsiElement psiElement = (PsiElement)enumClass;
        Function1 predicate$iv = arg_0 -> K2UnusedSymbolUtil.hasEnumFunctionReferenceInEnumClass$lambda$0(enumClass, kaSession, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void var7_8 = $this$anyDescendantOfType$iv2;
        Function1 predicate$iv$iv = predicate$iv;
        boolean $i$f$findDescendantOfType = false;
        void var10_13 = $this$findDescendantOfType$iv$iv2;
        Function1 predicate$iv$iv$iv = predicate$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv2);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv$iv$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtCallableReferenceExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        boolean bl = isFoundCallableReference = (PsiElement)result$iv$iv$iv.element != null;
        if (isFoundCallableReference) {
            return true;
        }
        predicate$iv = (PsiElement)enumClass;
        Function1 predicate$iv2 = arg_0 -> K2UnusedSymbolUtil.hasEnumFunctionReferenceInEnumClass$lambda$1(enumClass, kaSession, arg_0);
        boolean $i$f$anyDescendantOfType2 = false;
        predicate$iv$iv = $this$anyDescendantOfType$iv;
        Function1 predicate$iv$iv2 = predicate$iv2;
        boolean $i$f$findDescendantOfType3 = false;
        predicate$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        Function1 predicate$iv$iv$iv2 = predicate$iv$iv2;
        boolean $i$f$findDescendantOfType4 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv2 = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv$iv$iv2, result$iv$iv$iv2){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtSimpleNameExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        boolean bl2 = isFoundSimpleNameExpression = (PsiElement)result$iv$iv$iv2.element != null;
        if (isFoundSimpleNameExpression) {
            return true;
        }
        $this$anyDescendantOfType$iv = (PsiElement)enumClass;
        predicate$iv2 = arg_0 -> K2UnusedSymbolUtil.hasEnumFunctionReferenceInEnumClass$lambda$2(enumClass, kaSession, arg_0);
        $i$f$anyDescendantOfType2 = false;
        $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        predicate$iv$iv2 = predicate$iv2;
        $i$f$findDescendantOfType3 = false;
        $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        predicate$iv$iv$iv2 = predicate$iv$iv2;
        $i$f$findDescendantOfType4 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        result$iv$iv$iv2 = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv$iv$iv2, result$iv$iv$iv2){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtCallExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv2.element != null;
    }

    private final boolean hasBuiltInEnumFunctionReference(KaSession kaSession, PsiReference reference, KtClass enumClass) {
        KtQualifiedExpression ktQualifiedExpression;
        PsiElement parent = reference.getElement().getParent();
        if (parent instanceof KtQualifiedExpression) {
            ktQualifiedExpression = this.normalizeEnumQualifiedExpression((KtQualifiedExpression)parent, enumClass);
            boolean bl = ktQualifiedExpression != null ? EnumUtilsKt.canBeReferenceToBuiltInEnumFunction(ktQualifiedExpression) : false;
            if (bl) {
                return true;
            }
            ktQualifiedExpression = this.normalizeEnumCallableReferenceExpression((KtQualifiedExpression)parent, enumClass);
            boolean bl2 = ktQualifiedExpression != null ? EnumUtilsKt.canBeReferenceToBuiltInEnumFunction((KtCallableReferenceExpression)ktQualifiedExpression) : false;
            if (bl2) {
                return true;
            }
        }
        KtCallableReferenceExpression ktCallableReferenceExpression = parent instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)parent : null;
        boolean bl = ktCallableReferenceExpression != null ? EnumUtilsKt.canBeReferenceToBuiltInEnumFunction(ktCallableReferenceExpression) : false;
        if (bl) {
            return true;
        }
        KtTypeElement ktTypeElement = parent instanceof KtTypeElement ? (KtTypeElement)parent : null;
        PsiElement psiElement = ktTypeElement != null ? ktTypeElement.getParent() : null;
        KtTypeReference ktTypeReference = psiElement instanceof KtTypeReference ? (KtTypeReference)psiElement : null;
        boolean bl3 = ktTypeReference != null ? KotlinPsiUtilsKt.isReferenceToBuiltInEnumFunction(kaSession, ktTypeReference) : false;
        if (bl3) {
            return true;
        }
        PsiImportStaticReferenceElement psiImportStaticReferenceElement = parent instanceof PsiImportStaticReferenceElement ? (PsiImportStaticReferenceElement)parent : null;
        boolean bl4 = psiImportStaticReferenceElement != null ? this.isReferenceToBuiltInEnumFunction(psiImportStaticReferenceElement) : false;
        if (bl4) {
            return true;
        }
        PsiReferenceExpression psiReferenceExpression = parent instanceof PsiReferenceExpression ? (PsiReferenceExpression)parent : null;
        boolean bl5 = psiReferenceExpression != null ? this.isReferenceToBuiltInEnumFunction(psiReferenceExpression, enumClass) : false;
        if (bl5) {
            return true;
        }
        KtElement ktElement = ktQualifiedExpression = parent instanceof KtElement ? (KtElement)parent : null;
        boolean bl6 = ktQualifiedExpression != null && (psiElement = this.normalizeImportDirective((KtElement)ktQualifiedExpression)) != null ? this.isUsedStarImportOfEnumStaticFunctions(kaSession, (KtImportDirective)psiElement) : false;
        if (bl6) {
            return true;
        }
        PsiImportStaticStatement psiImportStaticStatement = parent instanceof PsiImportStaticStatement ? (PsiImportStaticStatement)parent : null;
        return psiImportStaticStatement != null ? this.isUsedStarImportOfEnumStaticFunctions(psiImportStaticStatement) : false;
    }

    private final KtImportDirective normalizeImportDirective(KtElement $this$normalizeImportDirective) {
        if ($this$normalizeImportDirective instanceof KtImportDirective) {
            return (KtImportDirective)$this$normalizeImportDirective;
        }
        PsiElement psiElement = $this$normalizeImportDirective.getParent();
        return psiElement instanceof KtImportDirective ? (KtImportDirective)psiElement : null;
    }

    private final KtQualifiedExpression normalizeEnumQualifiedExpression(KtQualifiedExpression $this$normalizeEnumQualifiedExpression, KtClass enumClass) {
        if (Intrinsics.areEqual((Object)$this$normalizeEnumQualifiedExpression.getReceiverExpression().getText(), (Object)enumClass.getName())) {
            return $this$normalizeEnumQualifiedExpression;
        }
        KtExpression ktExpression = $this$normalizeEnumQualifiedExpression.getSelectorExpression();
        if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)enumClass.getName())) {
            PsiElement psiElement = $this$normalizeEnumQualifiedExpression.getParent();
            return psiElement instanceof KtQualifiedExpression ? (KtQualifiedExpression)psiElement : null;
        }
        return null;
    }

    private final KtCallableReferenceExpression normalizeEnumCallableReferenceExpression(KtQualifiedExpression $this$normalizeEnumCallableReferenceExpression, KtClass enumClass) {
        KtExpression ktExpression = $this$normalizeEnumCallableReferenceExpression.getSelectorExpression();
        if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)enumClass.getName())) {
            PsiElement psiElement = $this$normalizeEnumCallableReferenceExpression.getParent();
            return psiElement instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)psiElement : null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isUsedStarImportOfEnumStaticFunctions(PsiImportStaticStatement $this$isUsedStarImportOfEnumStaticFunctions) {
        void $this$findDescendantOfType$iv$iv$iv;
        void $this$findDescendantOfType$iv$iv;
        void $this$anyDescendantOfType$iv;
        Object object = $this$isUsedStarImportOfEnumStaticFunctions.getImportReference();
        if (object == null || (object = object.getQualifiedName()) == null) {
            return false;
        }
        Object importedEnumQualifiedName = object;
        PsiClass psiClass = $this$isUsedStarImportOfEnumStaticFunctions.resolveTargetClass();
        KtLightClass ktLightClass = psiClass instanceof KtLightClass ? (KtLightClass)psiClass : null;
        if (!(ktLightClass != null ? ktLightClass.isEnum() : false)) {
            return false;
        }
        PsiFile psiFile = $this$isUsedStarImportOfEnumStaticFunctions.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiElement psiElement = (PsiElement)psiFile;
        Function1 predicate$iv = (Function1)new Function1<PsiReferenceExpression, Boolean>((String)importedEnumQualifiedName){
            final /* synthetic */ String $importedEnumQualifiedName;
            {
                this.$importedEnumQualifiedName = $importedEnumQualifiedName;
                super(1, Intrinsics.Kotlin.class, "isQualifiedNameInEnumStaticMethods", "isUsedStarImportOfEnumStaticFunctions$isQualifiedNameInEnumStaticMethods(Lcom/intellij/psi/PsiReference;Ljava/lang/String;)Z", 0);
            }

            public final Boolean invoke(PsiReferenceExpression p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return K2UnusedSymbolUtil.access$isUsedStarImportOfEnumStaticFunctions$isQualifiedNameInEnumStaticMethods((PsiReference)p0, this.$importedEnumQualifiedName);
            }
        };
        boolean $i$f$anyDescendantOfType = false;
        void var6_6 = $this$anyDescendantOfType$iv;
        Function1 predicate$iv$iv = predicate$iv;
        boolean $i$f$findDescendantOfType = false;
        void var9_9 = $this$findDescendantOfType$iv$iv;
        Function1 predicate$iv$iv$iv = predicate$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv$iv$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof PsiReferenceExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    private final KaSymbol resolveReferenceToSymbol(KaSession kaSession, KtImportDirective $this$resolveReferenceToSymbol) {
        KtReference ktReference;
        KtReferenceExpression ktReferenceExpression;
        if ($this$resolveReferenceToSymbol.getImportedReference() instanceof KtReferenceExpression) {
            KtExpression ktExpression = $this$resolveReferenceToSymbol.getImportedReference();
            Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtReferenceExpression");
            ktReferenceExpression = (KtReferenceExpression)ktExpression;
        } else {
            KtExpression ktExpression = $this$resolveReferenceToSymbol.getImportedReference();
            if (ktExpression != null) {
                PsiElement $this$getChildOfType$iv = (PsiElement)ktExpression;
                boolean $i$f$getChildOfType = false;
                ktReferenceExpression = (KtReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtReferenceExpression.class);
            } else {
                ktReferenceExpression = null;
            }
        }
        KtReferenceExpression ktReferenceExpression2 = ktReferenceExpression;
        return ktReferenceExpression2 != null && (ktReference = ReferenceUtilsKt.getMainReference((KtReferenceExpression)ktReferenceExpression2)) != null ? KaResolverKt.resolveToSymbol(kaSession, ktReference) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isUsedStarImportOfEnumStaticFunctions(KaSession kaSession, KtImportDirective $this$isUsedStarImportOfEnumStaticFunctions) {
        void $this$findDescendantOfType$iv$iv$iv;
        void $this$findDescendantOfType$iv$iv;
        void $this$anyDescendantOfType$iv;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        ImportPath importPath = $this$isUsedStarImportOfEnumStaticFunctions.getImportPath();
        if (!(importPath != null ? importPath.isAllUnder() : false)) {
            return false;
        }
        FqName fqName2 = $this$isUsedStarImportOfEnumStaticFunctions.getImportedFqName();
        if (fqName2 == null) {
            return false;
        }
        FqName importedEnumFqName = fqName2;
        KaSymbol kaSymbol = this.resolveReferenceToSymbol(kaSession, $this$isUsedStarImportOfEnumStaticFunctions);
        KaClassSymbol kaClassSymbol = kaSymbol instanceof KaClassSymbol ? (KaClassSymbol)kaSymbol : null;
        if (kaClassSymbol == null) {
            return false;
        }
        KaClassSymbol importedClass = kaClassSymbol;
        if (importedClass.getClassKind() != KaClassKind.ENUM_CLASS) {
            return false;
        }
        Iterable $this$map$iv = EnumUtilsKt.getENUM_STATIC_METHOD_NAMES_WITH_ENTRIES();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void it;
            Name name2 = (Name)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new FqName(importedEnumFqName + "." + (Name)it));
        }
        List enumStaticMethods = (List)destination$iv$iv;
        PsiFile psiFile = $this$isUsedStarImportOfEnumStaticFunctions.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        $this$map$iv = (PsiElement)psiFile;
        Function1 predicate$iv = arg_0 -> K2UnusedSymbolUtil.isUsedStarImportOfEnumStaticFunctions$lambda$2(kaSession, enumStaticMethods, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        destination$iv$iv = $this$anyDescendantOfType$iv;
        Function1 predicate$iv$iv = predicate$iv;
        boolean $i$f$findDescendantOfType = false;
        item$iv$iv2 = $this$findDescendantOfType$iv$iv;
        Function1 predicate$iv$iv$iv = predicate$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv$iv$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isReferenceToBuiltInEnumFunction(PsiImportStaticReferenceElement $this$isReferenceToBuiltInEnumFunction) {
        void $this$mapTo$iv$iv;
        String importedEnumQualifiedName = $this$isReferenceToBuiltInEnumFunction.getClassReference().getQualifiedName();
        Iterable $this$map$iv = EnumUtilsKt.getENUM_STATIC_METHOD_NAMES_WITH_ENTRIES_IN_JAVA();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Name name2 = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new FqName(importedEnumQualifiedName + "." + (Name)it));
        }
        List enumStaticMethods = (List)destination$iv$iv;
        String string = $this$isReferenceToBuiltInEnumFunction.getQualifiedName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedName(...)");
        return enumStaticMethods.contains(new FqName(string));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isReferenceToBuiltInEnumFunction(PsiReferenceExpression $this$isReferenceToBuiltInEnumFunction, KtClass enumClass) {
        void $this$mapTo$iv$iv;
        PsiElement psiElement = $this$isReferenceToBuiltInEnumFunction.resolve();
        if (!(psiElement instanceof KtLightMethod)) return false;
        KtLightMethod ktLightMethod = (KtLightMethod)psiElement;
        if (ktLightMethod == null) {
            return false;
        }
        KtLightMethod reference = ktLightMethod;
        if (!Intrinsics.areEqual((Object)((KtLightClass)reference.getContainingClass()).getName(), (Object)enumClass.getName())) return false;
        if (!(reference instanceof SyntheticElement)) return false;
        Iterable $this$map$iv = EnumUtilsKt.getENUM_STATIC_METHOD_NAMES_WITH_ENTRIES_IN_JAVA();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Name name2 = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asString());
        }
        if (!((List)destination$iv$iv).contains(reference.getName())) return false;
        return true;
    }

    private final boolean canBeHandledByLightMethods(KaSession kaSession, KtCallableDeclaration $this$canBeHandledByLightMethods, KaDeclarationSymbol symbol) {
        boolean bl;
        if (symbol instanceof KaConstructorSymbol) {
            KaDeclarationSymbol kaDeclarationSymbol = KaSymbolRelationProviderKt.getContainingDeclaration(kaSession, symbol);
            KaNamedClassSymbol kaNamedClassSymbol = kaDeclarationSymbol instanceof KaNamedClassSymbol ? (KaNamedClassSymbol)kaDeclarationSymbol : null;
            if (kaNamedClassSymbol == null) {
                return false;
            }
            KaNamedClassSymbol classSymbol = kaNamedClassSymbol;
            bl = !classSymbol.isInline() && classSymbol.getVisibility() != KaSymbolVisibility.PRIVATE;
        } else {
            bl = $this$canBeHandledByLightMethods.hasModifier(KtTokens.INTERNAL_KEYWORD) ? false : (!(symbol instanceof KaNamedFunctionSymbol) ? true : !this.hasInlineClassParameters(kaSession, (KaNamedFunctionSymbol)symbol));
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasInlineClassParameters(KaSession kaSession, KaNamedFunctionSymbol $this$hasInlineClassParameters) {
        boolean bl;
        boolean bl2;
        KaNamedClassSymbol receiverParameterClassSymbol;
        KaType kaType = KaCallableSymbolKt.getReceiverType($this$hasInlineClassParameters);
        KaClassSymbol kaClassSymbol = kaType != null ? KaTypeInformationProviderKt.getExpandedSymbol(kaSession, kaType) : null;
        KaNamedClassSymbol kaNamedClassSymbol = receiverParameterClassSymbol = kaClassSymbol instanceof KaNamedClassSymbol ? (KaNamedClassSymbol)kaClassSymbol : null;
        if (kaNamedClassSymbol != null) {
            if (kaNamedClassSymbol.isInline()) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        Iterable $this$any$iv = $this$hasInlineClassParameters.getValueParameters();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            KaNamedClassSymbol namedClassOrObjectSymbol;
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            KaValueParameterSymbol it = (KaValueParameterSymbol)element$iv;
            boolean bl3 = false;
            KaClassSymbol kaClassSymbol2 = KaTypeInformationProviderKt.getExpandedSymbol(kaSession, it.getReturnType());
            if ((kaClassSymbol2 instanceof KaNamedClassSymbol ? (KaNamedClassSymbol)kaClassSymbol2 : null) == null) {
                bl = false;
                continue;
            }
            namedClassOrObjectSymbol = namedClassOrObjectSymbol;
            bl = namedClassOrObjectSymbol.isInline();
        } while (!bl);
        return true;
    }

    private final boolean hasOverrides(KtNamedDeclaration declaration) {
        KtNamedDeclaration ktNamedDeclaration = declaration;
        boolean overrides2 = ktNamedDeclaration instanceof KtCallableDeclaration ? KotlinSearchUtilKt.hasAnyOverridings((KtCallableDeclaration)declaration) : (ktNamedDeclaration instanceof KtClass ? KotlinSearchUtilKt.hasAnyInheritors((KtClass)declaration) : false);
        return overrides2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean hasFakeOverrides(KtNamedDeclaration declaration, SearchScope useScope) {
        var5_3 = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration));
        if (var5_3 instanceof KtClass == false) return false;
        v0 = (KtClass)var5_3;
        if (v0 == null) {
            return false;
        }
        ownerClass = v0;
        if (!KotlinPsiUtilsKt.isInheritable(ownerClass)) {
            return false;
        }
        useSiteElement$iv = (KtElement)declaration;
        $i$f$analyze = false;
        v1 = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getProject(...)");
        var8_9 = KaSessionProvider.Companion.getInstance(v1);
        useSiteElement$iv$iv = useSiteElement$iv;
        $i$f$analyze = false;
        analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        try {
            var13_14 = lock$iv$iv = new Object();
            synchronized (var13_14) {
                $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv = false;
                $this$hasFakeOverrides_u24lambda_u240 = analysisSession$iv$iv;
                $i$a$-analyze-K2UnusedSymbolUtil$hasFakeOverrides$callableName$1 = false;
                symbol = $this$hasFakeOverrides_u24lambda_u240.getSymbol((KtDeclaration)declaration);
                if (!(symbol instanceof KaCallableSymbol)) {
                    var22_27 = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 38, 14] lbl29 : MonitorExitStatement: MONITOREXIT : var13_14
                    var23_29 = var22_27;
                    return var23_29;
                }
                modality = symbol.getModality();
                if (modality == KaSymbolModality.ABSTRACT) {
                    var20_35 = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 37, 14] lbl35 : MonitorExitStatement: MONITOREXIT : var13_14
                    var21_37 = var20_35;
                    return var21_37;
                }
                v2 = ((KaCallableSymbol)symbol).getCallableId();
                $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv /* !! */  = v2 != null ? v2.getCallableName() : null;
            }
            lock$iv$iv = $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv /* !! */ ;
        }
        catch (Throwable throwable$iv$iv) {
            this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
            throw new KotlinNothingValueException();
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        }
        v3 = lock$iv$iv;
        if (v3 == null) {
            return false;
        }
        callableName = v3;
        $this$any$iv = KotlinSearchUtilKt.findAllInheritors(ownerClass, useScope);
        $i$f$any = false;
        var7_8 = $this$any$iv.iterator();
        do {
            block50: {
                if (!var7_8.hasNext()) {
                    return false;
                }
                element$iv = var7_8.next();
                element = (PsiElement)element$iv;
                $i$a$-any-K2UnusedSymbolUtil$hasFakeOverrides$1 = false;
                var11_12 = element;
                if (!(var11_12 instanceof KtClassOrObject)) break block50;
                useSiteElement$iv = (KtElement)element;
                $i$f$analyze = false;
                v4 = useSiteElement$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getProject(...)");
                $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv /* !! */  = KaSessionProvider.Companion.getInstance(v4);
                useSiteElement$iv$iv = useSiteElement$iv;
                $i$f$analyze = false;
                analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                try {
                    var19_41 = lock$iv$iv = new Object();
                    synchronized (var19_41) {
                        block51: {
                            block46: {
                                $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv = false;
                                $this$hasFakeOverrides_u24lambda_u241_u240 = analysisSession$iv$iv;
                                $i$a$-analyze-K2UnusedSymbolUtil$hasFakeOverrides$1$1 = false;
                                if (!$this$hasFakeOverrides_u24lambda_u241_u240.canBeAnalysed(element)) {
                                    var23_30 = false;
                                    // MONITOREXIT @DISABLED, blocks:[34, 22, 7, 15] lbl86 : MonitorExitStatement: MONITOREXIT : var19_41
                                    var24_44 = var23_30;
                                    v5 = var24_44;
                                    continue;
                                }
                                v6 = $this$hasFakeOverrides_u24lambda_u241_u240.getSymbol((KtDeclaration)declaration);
                                Intrinsics.checkNotNull((Object)v6, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol");
                                callableSymbol = (KaCallableSymbol)v6;
                                var26_46 = $this$hasFakeOverrides_u24lambda_u241_u240.getClassSymbol((KtClassOrObject)element);
                                if (var26_46 == null || (var27_47 = $this$hasFakeOverrides_u24lambda_u241_u240.getMemberScope(var26_46)) == null || (var29_51 = var27_47.callables(var28_50 /* !! */  = new Name[]{callableName})) == null) break block51;
                                var30_52 = var29_51;
                                $i$f$singleOrNull = false;
                                single$iv = null;
                                found$iv = false;
                                for (E element$iv : $this$singleOrNull$iv) {
                                    it = (KaCallableSymbol)element$iv;
                                    $i$a$-singleOrNull-K2UnusedSymbolUtil$hasFakeOverrides$1$1$overridingCallableSymbol$1 = false;
                                    if (!Intrinsics.areEqual((Object)$this$hasFakeOverrides_u24lambda_u241_u240.getFakeOverrideOriginal(it), (Object)callableSymbol)) continue;
                                    if (found$iv) {
                                        v7 = null;
                                        break block46;
                                    }
                                    single$iv = element$iv;
                                    found$iv = true;
                                }
                                v7 = found$iv == false ? null : single$iv;
                            }
                            var28_50 /* !! */  = v7;
                            if (var28_50 /* !! */  == null) break block51;
                            overridingCallableSymbol /* !! */  = var28_50 /* !! */ ;
                            if (Intrinsics.areEqual((Object)overridingCallableSymbol /* !! */ , (Object)callableSymbol)) ** GOTO lbl-1000
                            ** break block52
                        }
                        var38_60 = false;
                    }
                    var39_61 = var38_60;
                    v5 = var39_61;
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        block47: {
                            $this$any$iv = $this$hasFakeOverrides_u24lambda_u241_u240.getIntersectionOverriddenSymbols((KaCallableSymbol)overridingCallableSymbol /* !! */ );
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v8 = false;
                            } else {
                                var29_51 = $this$any$iv.iterator();
                                while (var29_51.hasNext()) {
                                    element$iv = var29_51.next();
                                    it = (KaCallableSymbol)element$iv;
                                    $i$a$-any-K2UnusedSymbolUtil$hasFakeOverrides$1$1$1 = false;
                                    if (!(Intrinsics.areEqual((Object)it, (Object)callableSymbol) == false)) continue;
                                    v8 = true;
                                    break block47;
                                }
                                v8 = false;
                            }
                        }
                        if (v8) {
                            v9 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v9 = false;
                        }
                        $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv = v9;
                    }
                    lock$iv$iv = $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv;
                }
                catch (Throwable throwable$iv$iv) {
                    this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                    throw new KotlinNothingValueException();
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                }
                v5 = lock$iv$iv;
                continue;
            }
            if (var11_12 instanceof PsiClass) {
                $this$any$iv = LightClassUtilsKt.toLightMethods((PsiElement)((PsiElement)declaration));
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v5 = false;
                    continue;
                }
                for (T element$iv : $this$any$iv) {
                    block49: {
                        lightMethod = (PsiMethod)element$iv;
                        $i$a$-any-K2UnusedSymbolUtil$hasFakeOverrides$1$2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)((PsiClass)element).findMethodsBySignature(lightMethod, true), (String)"findMethodsBySignature(...)");
                        $this$all$iv = sameMethods;
                        $i$f$all = false;
                        var22_28 = $this$all$iv.length;
                        for (var21_39 = 0; var21_39 < var22_28; ++var21_39) {
                            it = element$iv = $this$all$iv[var21_39];
                            $i$a$-all-K2UnusedSymbolUtil$hasFakeOverrides$1$2$1 = false;
                            if (Intrinsics.areEqual((Object)it.getContainingClass(), (Object)element) == false) continue;
                            v10 = false;
                            break block49;
                        }
                        v10 = true;
                    }
                    if (v10) {
                        $this$any$iv = sameMethods;
                        $i$f$any = false;
                        var22_28 = $this$any$iv.length;
                        for (var21_39 = 0; var21_39 < var22_28; ++var21_39) {
                            it = element$iv = $this$any$iv[var21_39];
                            $i$a$-any-K2UnusedSymbolUtil$hasFakeOverrides$1$2$2 = false;
                            if (!Intrinsics.areEqual((Object)it.getContainingClass(), (Object)lightMethod.getContainingClass())) {
                                return true;
                            }
                            v11 = false;
                            if (!v11) continue;
                            return true;
                        }
                        v12 = false;
                        if (v12) {
                            return true;
                        }
                    }
                    v13 = false;
                    if (!v13) continue;
                    return true;
                }
                v5 = false;
                continue;
            }
            v5 = false;
        } while (!v5);
        return true;
    }

    private final boolean hasPlatformImplementations(KtNamedDeclaration declaration) {
        return PsiUtilsKt.hasExpectModifier((KtModifierListOwner)((KtModifierListOwner)declaration));
    }

    private final boolean classOrObjectHasTextUsages(KtClassOrObject classOrObject) {
        Ref.BooleanRef hasTextUsages = new Ref.BooleanRef();
        if (classOrObject.getUseScope() instanceof GlobalSearchScope) {
            Project project = classOrObject.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KotlinFindClassUsagesHandler findClassUsagesHandler = new KotlinFindClassUsagesHandler(classOrObject, new KotlinFindUsagesHandlerFactory(project));
            findClassUsagesHandler.processUsagesInText((PsiElement)classOrObject, arg_0 -> K2UnusedSymbolUtil.classOrObjectHasTextUsages$lambda$1(arg_0 -> K2UnusedSymbolUtil.classOrObjectHasTextUsages$lambda$0(hasTextUsages, arg_0), arg_0), GlobalSearchScope.projectScope((Project)classOrObject.getProject()));
        }
        return hasTextUsages.element;
    }

    @NotNull
    public final List<IntentionAction> createQuickFixes(@NotNull KaSession kaSession, @NotNull KtNamedDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof KtParameter) {
            if (((KtParameter)declaration).isLoopParameter()) {
                return CollectionsKt.emptyList();
            }
            if (((KtParameter)declaration).isCatchParameter()) {
                return Intrinsics.areEqual((Object)((KtParameter)declaration).getName(), (Object)"_") ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new RenameElementFix((PsiNamedElement)declaration, "_"));
            }
            KtDeclarationWithBody ownerFunction = ((KtParameter)declaration).getOwnerFunction();
            if (ownerFunction instanceof KtPropertyAccessor && ((KtPropertyAccessor)ownerFunction).isSetter()) {
                return CollectionsKt.emptyList();
            }
            if (ownerFunction instanceof KtFunctionLiteral) {
                return CollectionsKt.listOf((Object)new RenameElementFix((PsiNamedElement)declaration, "_"));
            }
        }
        List fixes = new ArrayList();
        ((Collection)fixes).add(new SafeDeleteFix(declaration));
        for (KtAnnotationEntry annotationEntry2 : declaration.getAnnotationEntries()) {
            KaLifetimeOwner annotationClassId;
            String fqName2;
            Intrinsics.checkNotNull((Object)annotationEntry2);
            KaLifetimeOwner kaLifetimeOwner = KaResolverKt.resolveToCall(kaSession, (KtElement)annotationEntry2);
            if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.singleConstructorCallOrNull((KaCallInfo)kaLifetimeOwner)) == null || (kaLifetimeOwner = (KaConstructorSymbol)KaCallKt.getSymbol((KaCallableMemberCall)kaLifetimeOwner)) == null) continue;
            if ((kaLifetimeOwner = ((KaConstructorSymbol)kaLifetimeOwner).getContainingClassId()) == null || StringsKt.startsWith$default((String)(fqName2 = (annotationClassId = kaLifetimeOwner).asSingleFqName().asString()), (String)"kotlin.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)fqName2, (String)"java.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)fqName2, (String)"javax.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)fqName2, (String)"org.jetbrains.annotations.", (boolean)false, (int)2, null)) continue;
            ((Collection)fixes).add(QuickFixFactory.getInstance().createAddToDependencyInjectionAnnotationsFix(declaration.getProject(), fqName2));
        }
        return fixes;
    }

    private final boolean isEntryPoint(KaSession kaSession, KtNamedDeclaration declaration, Lazy<? extends PsiSearchHelper.SearchCostResult> isCheapEnough, UnusedDeclarationInspectionBase isJavaEntryPoint) {
        PsiElement psiElement;
        if (this.hasKotlinAdditionalAnnotation(kaSession, (KtDeclaration)declaration)) {
            return true;
        }
        KtNamedDeclaration ktNamedDeclaration = declaration;
        if (ktNamedDeclaration instanceof KtEnumEntry) {
            psiElement = (PsiElement)LightClassUtil.INSTANCE.getLightClassBackingField((KtDeclaration)declaration);
        } else if (ktNamedDeclaration instanceof KtClass) {
            boolean bl;
            block34: {
                Iterable $this$any$iv = ((KtClass)declaration).getDeclarations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtDeclaration it = (KtDeclaration)element$iv;
                        boolean bl2 = false;
                        if (!INSTANCE.hasKotlinAdditionalAnnotation(kaSession, it)) continue;
                        bl = true;
                        break block34;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
            psiElement = (PsiElement)LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)declaration));
        } else if (ktNamedDeclaration instanceof KtObjectDeclaration) {
            psiElement = (PsiElement)LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)declaration));
        } else if (ktNamedDeclaration instanceof KtNamedFunction) {
            if (KotlinMainFunctionDetector.isMain$default(KotlinMainFunctionDetector.Companion.getInstance(), (KtNamedFunction)declaration, null, 2, null)) {
                return true;
            }
            KtNamedDeclaration ktNamedDeclaration2 = declaration;
            Intrinsics.checkNotNull((Object)ktNamedDeclaration2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            psiElement = (PsiElement)LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)ktNamedDeclaration2);
        } else if (ktNamedDeclaration instanceof KtSecondaryConstructor) {
            KtNamedDeclaration ktNamedDeclaration3 = declaration;
            Intrinsics.checkNotNull((Object)ktNamedDeclaration3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            psiElement = (PsiElement)LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)ktNamedDeclaration3);
        } else {
            if (ktNamedDeclaration instanceof KtProperty || ktNamedDeclaration instanceof KtParameter) {
                if (declaration instanceof KtParameter) {
                    KtDeclarationWithBody ownerFunction = ((KtParameter)declaration).getOwnerFunction();
                    if (ownerFunction instanceof KtNamedFunction && KotlinMainFunctionDetector.isMain$default(KotlinMainFunctionDetector.Companion.getInstance(), (KtNamedFunction)ownerFunction, null, 2, null)) {
                        return AnnotationModificationUtilsKt.findAnnotation$default((KtAnnotated)ownerFunction, JvmStandardClassIds.Annotations.INSTANCE.getJvmStatic(), null, false, 6, null) != null;
                    }
                    if (!((KtParameter)declaration).hasValOrVar()) {
                        return false;
                    }
                }
                if (declaration instanceof KtParameter && this.isAnnotationParameter((KtParameter)declaration)) {
                    List lightAnnotationMethods = CollectionsKt.toList((Iterable)((Iterable)LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtParameter)declaration)));
                    for (PsiMethod javaParameterPsi : lightAnnotationMethods) {
                        if (!isJavaEntryPoint.isEntryPoint((PsiElement)javaParameterPsi)) continue;
                        return true;
                    }
                }
                if (declaration instanceof KtProperty) {
                    boolean getterOrSetterSiteTargetAnnotationPresent;
                    block35: {
                        PsiField javaFieldPsi = LightClassUtil.INSTANCE.getLightClassBackingField((KtDeclaration)declaration);
                        if (javaFieldPsi != null && isJavaEntryPoint.isEntryPoint((PsiElement)javaFieldPsi)) {
                            return true;
                        }
                        List list2 = ((KtProperty)declaration).getAnnotationEntries();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
                        Iterable $this$any$iv = list2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            v5 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                                boolean bl = false;
                                KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = it.getUseSiteTarget();
                                Object target = ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null;
                                if (!(target == AnnotationUseSiteTarget.PROPERTY_GETTER || target == AnnotationUseSiteTarget.PROPERTY_SETTER)) continue;
                                v5 = true;
                                break block35;
                            }
                            v5 = getterOrSetterSiteTargetAnnotationPresent = false;
                        }
                    }
                    if (getterOrSetterSiteTargetAnnotationPresent) {
                        boolean bl;
                        block36: {
                            LightClassUtil.PropertyAccessorsPsiMethods psiMethods = LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtProperty)declaration);
                            Iterable $this$any$iv = (Iterable)psiMethods;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    PsiMethod it = (PsiMethod)element$iv;
                                    boolean bl3 = false;
                                    if (!isJavaEntryPoint.isEntryPoint((PsiElement)it)) continue;
                                    bl = true;
                                    break block36;
                                }
                                bl = false;
                            }
                        }
                        if (bl) {
                            return true;
                        }
                    }
                }
                EntryPointsManager entryPointsManager = EntryPointsManager.getInstance((Project)declaration.getProject());
                Intrinsics.checkNotNull((Object)entryPointsManager, (String)"null cannot be cast to non-null type com.intellij.codeInspection.ex.EntryPointsManagerBase");
                EntryPointsManagerBase entryPointsManager2 = (EntryPointsManagerBase)entryPointsManager;
                Collection collection = entryPointsManager2.getAdditionalAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAdditionalAnnotations(...)");
                JDOMExternalizableStringList jDOMExternalizableStringList = entryPointsManager2.ADDITIONAL_ANNOTATIONS;
                Intrinsics.checkNotNullExpressionValue((Object)jDOMExternalizableStringList, (String)"ADDITIONAL_ANNOTATIONS");
                return this.checkAnnotatedUsingPatterns(kaSession, declaration, CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)jDOMExternalizableStringList)));
            }
            return false;
        }
        if (psiElement == null) {
            return false;
        }
        PsiElement lightElement = psiElement;
        if (isCheapEnough.getValue() == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
            return false;
        }
        return isJavaEntryPoint.isEntryPoint(lightElement);
    }

    private static final PsiSearchHelper.SearchCostResult getPsiToReportProblem$lambda$1(KtNamedDeclaration $declaration) {
        return UtilsKt.isCheapEnoughToSearchUsages($declaration);
    }

    private static final PsiSearchHelper.SearchCostResult hasNonTrivialUsages$lambda$0(KtNamedDeclaration $declaration) {
        return UtilsKt.isCheapEnoughToSearchUsages($declaration);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean hasNonTrivialUsages$lambda$1(GlobalSearchScope $containingClassSearchScope, PsiReference ref) {
        boolean bl;
        KtCallableDeclaration callableDeclaration;
        block13: {
            void $this$mapTo$iv$iv;
            Object it;
            KtCallableDeclaration ktCallableDeclaration;
            List typeArguments2;
            block15: {
                block14: {
                    Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                    PsiElement psiElement = ref.getElement().getParent();
                    KtUserType ktUserType = psiElement instanceof KtUserType ? (KtUserType)psiElement : null;
                    if (ktUserType == null) {
                        return false;
                    }
                    KtUserType userType = ktUserType;
                    List list2 = userType.getTypeArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeArguments(...)");
                    typeArguments2 = list2;
                    if (typeArguments2.isEmpty()) {
                        return false;
                    }
                    PsiElement $this$getStrictParentOfType$iv = (PsiElement)userType;
                    boolean $i$f$getStrictParentOfType = false;
                    KtParameter ktParameter = (KtParameter)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtParameter.class, (boolean)true);
                    if (ktParameter == null) {
                        return false;
                    }
                    KtParameter parameter = ktParameter;
                    PsiElement $this$getStrictParentOfType$iv2 = (PsiElement)parameter;
                    boolean $i$f$getStrictParentOfType2 = false;
                    ktCallableDeclaration = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, KtCallableDeclaration.class, (boolean)true);
                    if (ktCallableDeclaration == null) break block14;
                    it = ktCallableDeclaration;
                    boolean bl2 = false;
                    KtNamedFunction ktNamedFunction = it instanceof KtNamedFunction ? (KtNamedFunction)it : null;
                    KtTypeParameterListOwnerStub ktTypeParameterListOwnerStub = ktNamedFunction != null ? (KtTypeParameterListOwnerStub)ktNamedFunction : (KtTypeParameterListOwnerStub)KtPsiUtilKt.containingClass((KtElement)((KtElement)it));
                    ktCallableDeclaration = ktTypeParameterListOwnerStub;
                    if (ktTypeParameterListOwnerStub != null) break block15;
                }
                return false;
            }
            callableDeclaration = ktCallableDeclaration;
            List list3 = callableDeclaration.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getTypeParameters(...)");
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                KtTypeParameter ktTypeParameter = (KtTypeParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it2.getName());
            }
            List typeParameters2 = (List)destination$iv$iv;
            if (typeParameters2.isEmpty()) {
                return false;
            }
            Iterable $this$none$iv = typeArguments2;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    KtTypeProjection it3 = (KtTypeProjection)element$iv;
                    boolean bl4 = false;
                    if (!typeParameters2.contains(it3.getText())) continue;
                    bl = false;
                    break block13;
                }
                bl = true;
            }
        }
        if (bl) {
            return false;
        }
        return INSTANCE.referenceExists((PsiElement)callableDeclaration, (SearchScope)$containingClassSearchScope, (Function1<? super PsiReference, Boolean>)((Function1)K2UnusedSymbolUtil::hasNonTrivialUsages$lambda$1$3));
    }

    private static final boolean hasNonTrivialUsages$lambda$1$3(PsiReference it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiElement psiElement = it.getElement().getParent();
        KtCallElement callElement = psiElement instanceof KtCallElement ? (KtCallElement)psiElement : null;
        return callElement != null && callElement.getTypeArgumentList() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static final boolean hasReferences$lambda$0(KaSymbolPointer $symbolPointer, PsiReference it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        v0 = it.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getElement(...)");
        refElement = v0;
        if (!(refElement instanceof KtElement)) ** GOTO lbl-1000
        useSiteElement$iv = (KtElement)refElement;
        $i$f$analyze = false;
        v1 = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getProject(...)");
        var5_5 = KaSessionProvider.Companion.getInstance(v1);
        useSiteElement$iv$iv = useSiteElement$iv;
        $i$f$analyze = false;
        analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        try {
            var10_11 = lock$iv$iv = new Object();
            synchronized (var10_11) {
                $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv = false;
                $this$hasReferences_u24lambda_u240_u240 = analysisSession$iv$iv;
                $i$a$-analyze-K2UnusedSymbolUtil$hasReferences$1$1 = false;
                $this$getStrictParentOfType$iv = refElement;
                $i$f$getStrictParentOfType = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtTypeAlias.class, (boolean)true) != null) ** GOTO lbl-1000
                $this$getStrictParentOfType$iv = refElement;
                $i$f$getStrictParentOfType = false;
                var14_17 = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallExpression.class, (boolean)true);
                v2 = var14_17 != null && (var15_19 = $this$hasReferences_u24lambda_u240_u240.resolveToCall((KtElement)var14_17)) != null && (var16_21 = KaCallInfoKt.singleFunctionCallOrNull(var15_19)) != null && (var17_22 = var16_21.getPartiallyAppliedSymbol()) != null ? (KaFunctionSymbol)KaPartiallyAppliedSymbolKt.getSymbol(var17_22) : null;
                v3 = $symbolPointer;
                if (Intrinsics.areEqual(v2, v3 != null ? (KaDeclarationSymbol)$this$hasReferences_u24lambda_u240_u240.restoreSymbol(v3) : null)) lbl-1000:
                // 2 sources

                {
                    v4 = true;
                } else {
                    v4 = false;
                }
                var11_14 = v4;
            }
            var9_10 = var11_14;
        }
        catch (Throwable throwable$iv$iv) {
            this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
            throw new KotlinNothingValueException();
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        }
        if (var9_10) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        return v5;
    }

    private static final boolean hasReferences$lambda$1$0(KaSession kaSession, KtNamedDeclaration $declaration, KtNamedDeclaration $originalDeclaration, PsiReference it) {
        PsiElement psiElement = it.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        boolean checkReference = INSTANCE.checkReference(kaSession, psiElement, $declaration, $originalDeclaration);
        return checkReference;
    }

    private static final boolean hasReferences$lambda$3(KaSession kaSession, KtNamedDeclaration $declaration, KtNamedDeclaration $originalDeclaration, UsageInfo it) {
        PsiElement refElement = it.getElement();
        return refElement == null || INSTANCE.checkReference(kaSession, refElement, $declaration, $originalDeclaration);
    }

    private static final Unit checkPrivateDeclaration$lambda$0(HashSet $setOfImportedDeclarations, KtSimpleNameExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((Collection)$setOfImportedDeclarations).add(it);
        return Unit.INSTANCE;
    }

    private static final boolean referenceExists$lambda$0(Function1 $predicate, PsiReference it) {
        Intrinsics.checkNotNull((Object)it);
        return (Boolean)$predicate.invoke((Object)it) == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final boolean hasBuiltInEnumFunctionReference$lambda$0(KtClass $enumClass, PsiReference it) {
        boolean bl;
        void this_$iv$iv;
        KtElement ktElement;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiElement psiElement = it.getElement();
        KtElement ktElement2 = psiElement instanceof KtElement ? (KtElement)psiElement : null;
        if (ktElement2 == null) {
            return false;
        }
        KtElement useSiteElement$iv = ktElement = ktElement2;
        boolean $i$f$analyze = false;
        Project project = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        KtElement useSiteElement$iv$iv = useSiteElement$iv;
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        try {
            boolean bl2;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                boolean bl3 = false;
                KaSession $this$hasBuiltInEnumFunctionReference_u24lambda_u240_u240 = analysisSession$iv$iv;
                boolean bl4 = false;
                bl2 = INSTANCE.hasBuiltInEnumFunctionReference($this$hasBuiltInEnumFunctionReference_u24lambda_u240_u240, it, $enumClass);
            }
            bl = bl2;
        }
        catch (Throwable throwable$iv$iv) {
            this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
            throw new KotlinNothingValueException();
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        }
        return bl;
    }

    private static final boolean hasEnumFunctionReferenceInEnumClass$lambda$0(KtClass $enumClass, KaSession kaSession, KtCallableReferenceExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getReceiverExpression() == null && Intrinsics.areEqual((Object)KtPsiUtilKt.containingClass((KtElement)((KtElement)it)), (Object)$enumClass) && KotlinPsiUtilsKt.isReferenceToBuiltInEnumFunction(kaSession, it);
    }

    private static final boolean hasEnumFunctionReferenceInEnumClass$lambda$1(KtClass $enumClass, KaSession kaSession, KtSimpleNameExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it.getParent() instanceof KtCallableReferenceExpression) && Intrinsics.areEqual((Object)KtPsiUtilKt.containingClass((KtElement)((KtElement)it)), (Object)$enumClass) && KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)it)) == null && INSTANCE.isReferenceToBuiltInEnumEntries(kaSession, it);
    }

    private static final boolean hasEnumFunctionReferenceInEnumClass$lambda$2(KtClass $enumClass, KaSession kaSession, KtCallExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)it)) == null && Intrinsics.areEqual((Object)KtPsiUtilKt.containingClass((KtElement)((KtElement)it)), (Object)$enumClass) && KotlinPsiUtilsKt.isReferenceToBuiltInEnumFunction(kaSession, it);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isUsedStarImportOfEnumStaticFunctions$isQualifiedNameInEnumStaticMethods(PsiReference $this$isUsedStarImportOfEnumStaticFunctions_u24isQualifiedNameInEnumStaticMethods, String importedEnumQualifiedName) {
        void $this$mapTo$iv$iv;
        PsiElement psiElement = $this$isUsedStarImportOfEnumStaticFunctions_u24isQualifiedNameInEnumStaticMethods.resolve();
        if (!(psiElement instanceof PsiMember)) return false;
        PsiMember psiMember = (PsiMember)psiElement;
        if (psiMember == null) {
            return false;
        }
        PsiMember referenceExpression = psiMember;
        PsiClass psiClass = referenceExpression.getContainingClass();
        if (!Intrinsics.areEqual((Object)(psiClass != null ? JavaPsiUtils.getKotlinFqName((PsiElement)psiClass) : null), (Object)new FqName(importedEnumQualifiedName))) return false;
        Iterable $this$map$iv = EnumUtilsKt.getENUM_STATIC_METHOD_NAMES_WITH_ENTRIES_IN_JAVA();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Name name2 = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asString());
        }
        if (!CollectionsKt.contains((Iterable)((List)destination$iv$iv), (Object)referenceExpression.getName())) return false;
        return true;
    }

    private static final boolean isUsedStarImportOfEnumStaticFunctions$isNameInEnumStaticMethods(KtExpression $this$isUsedStarImportOfEnumStaticFunctions_u24isNameInEnumStaticMethods, KaSession kaSession, List<FqName> enumStaticMethods) {
        if (KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)$this$isUsedStarImportOfEnumStaticFunctions_u24isNameInEnumStaticMethods)) != null) {
            return false;
        }
        KtNameReferenceExpression ktNameReferenceExpression = $this$isUsedStarImportOfEnumStaticFunctions_u24isNameInEnumStaticMethods instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)$this$isUsedStarImportOfEnumStaticFunctions_u24isNameInEnumStaticMethods : null;
        PsiElement psiElement = ktNameReferenceExpression != null ? ktNameReferenceExpression.getParent() : null;
        KtCallableReferenceExpression ktCallableReferenceExpression = psiElement instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)psiElement : null;
        if ((ktCallableReferenceExpression != null ? ktCallableReferenceExpression.getReceiverExpression() : null) != null) {
            return false;
        }
        KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)$this$isUsedStarImportOfEnumStaticFunctions_u24isNameInEnumStaticMethods));
        KaSymbol kaSymbol = ktReference != null ? KaResolverKt.resolveToSymbol(kaSession, ktReference) : null;
        KaCallableSymbol kaCallableSymbol = kaSymbol instanceof KaCallableSymbol ? (KaCallableSymbol)kaSymbol : null;
        if (kaCallableSymbol == null) {
            return false;
        }
        KaCallableSymbol symbol = kaCallableSymbol;
        CallableId callableId = symbol.getCallableId();
        return CollectionsKt.contains((Iterable)enumStaticMethods, (Object)(callableId != null ? callableId.asSingleFqName() : null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isUsedStarImportOfEnumStaticFunctions$lambda$2(KaSession kaSession, List $enumStaticMethods, KtExpression it) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KtCallExpression ktCallExpression = it instanceof KtCallExpression ? (KtCallExpression)it : null;
        if (ktCallExpression != null) {
            if (K2UnusedSymbolUtil.isUsedStarImportOfEnumStaticFunctions$isNameInEnumStaticMethods((KtExpression)ktCallExpression, kaSession, $enumStaticMethods)) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        KtCallableReferenceExpression ktCallableReferenceExpression = it instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)it : null;
        if (ktCallableReferenceExpression != null && (ktCallableReferenceExpression = ktCallableReferenceExpression.getCallableReference()) != null) {
            if (K2UnusedSymbolUtil.isUsedStarImportOfEnumStaticFunctions$isNameInEnumStaticMethods((KtExpression)ktCallableReferenceExpression, kaSession, $enumStaticMethods)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (!(it instanceof KtReferenceExpression)) return false;
        KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)it;
        if (ktReferenceExpression == null) return false;
        if (!K2UnusedSymbolUtil.isUsedStarImportOfEnumStaticFunctions$isNameInEnumStaticMethods((KtExpression)ktReferenceExpression, kaSession, $enumStaticMethods)) return false;
        return true;
    }

    private static final boolean classOrObjectHasTextUsages$lambda$0(Ref.BooleanRef $hasTextUsages, UsageInfo it) {
        $hasTextUsages.element = true;
        return false;
    }

    private static final boolean classOrObjectHasTextUsages$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isUsedStarImportOfEnumStaticFunctions$isQualifiedNameInEnumStaticMethods(PsiReference $receiver, String importedEnumQualifiedName) {
        return K2UnusedSymbolUtil.isUsedStarImportOfEnumStaticFunctions$isQualifiedNameInEnumStaticMethods($receiver, importedEnumQualifiedName);
    }

    static {
        Object[] objectArray = new String[]{"kotlin.test.*", "kotlin.js.JsExport"};
        KOTLIN_ADDITIONAL_ANNOTATIONS = CollectionsKt.listOf((Object[])objectArray);
        Name name2 = Name.identifier((String)"HIDDEN");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        DEPRECATION_LEVEL_HIDDEN = StandardNames.FqNames.deprecationLevel.child(name2);
        Name name3 = Name.identifier((String)"level");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        DEPRECATION_LEVEL_PARAMETER_NAME = name3;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PsiSearchHelper.SearchCostResult.values().length];
            try {
                nArray[PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

