/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.k1.scratch.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.impl.ProjectTaskManagerImpl;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.kotlin.idea.core.script.k1.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.jvm.k1.scratch.K1KotlinScratchFile;
import org.jetbrains.kotlin.idea.jvm.k1.scratch.SequentialScratchExecutor;
import org.jetbrains.kotlin.idea.jvm.shared.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.actions.ScratchAction;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.actions.ScratchCompilationSupport;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/actions/RunScratchAction;", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/actions/ScratchAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Handler", "kotlin.jvm.k1"})
public final class RunScratchAction
extends ScratchAction {
    public RunScratchAction() {
        block0: {
            Supplier<String> supplier = KotlinJvmBundle.messagePointer("scratch.run.button", new Object[0]);
            Icon icon2 = AllIcons.Actions.Execute;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Execute");
            super(supplier, icon2);
            Shortcut[] shortcutArray = KeymapManager.getInstance().getActiveKeymap().getShortcuts("Kotlin.RunScratch");
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
            Shortcut shortcut = (Shortcut)ArraysKt.firstOrNull((Object[])shortcutArray);
            if (shortcut == null) break block0;
            Shortcut it = shortcut;
            boolean bl = false;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(presentation.getText() + " (" + KeymapUtil.getShortcutText((Shortcut)it) + ")");
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ScratchFile scratchFile2 = this.getCurrentScratchFile(e);
        K1KotlinScratchFile k1KotlinScratchFile = scratchFile2 instanceof K1KotlinScratchFile ? (K1KotlinScratchFile)scratchFile2 : null;
        if (k1KotlinScratchFile == null) {
            return;
        }
        K1KotlinScratchFile scratchFile3 = k1KotlinScratchFile;
        Handler.INSTANCE.doAction(scratchFile3, false);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        ScratchFile scratchFile2 = this.getCurrentScratchFile(e);
        if (scratchFile2 == null) {
            return;
        }
        ScratchFile scratchFile3 = scratchFile2;
        e.getPresentation().setEnabled(!ScratchCompilationSupport.INSTANCE.isAnyInProgress() && !scratchFile3.getOptions().isInteractiveMode());
        if (e.getPresentation().isEnabled()) {
            e.getPresentation().setText(this.getTemplatePresentation().getText());
        } else {
            e.getPresentation().setText(KotlinJvmBundle.message("other.scratch.file.execution.is.in.progress", new Object[0]));
        }
        e.getPresentation().setVisible(!ScratchCompilationSupport.INSTANCE.isAnyInProgress() && !scratchFile3.getOptions().isInteractiveMode());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/actions/RunScratchAction$Handler;", "", "<init>", "()V", "doAction", "", "scratchFile", "Lorg/jetbrains/kotlin/idea/jvm/k1/scratch/K1KotlinScratchFile;", "isAutoRun", "", "kotlin.jvm.k1"})
    public static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();

        private Handler() {
        }

        public final void doAction(@NotNull K1KotlinScratchFile scratchFile2, boolean isAutoRun) {
            Intrinsics.checkNotNullParameter((Object)scratchFile2, (String)"scratchFile");
            Project project = scratchFile2.getProject();
            boolean isRepl = scratchFile2.getOptions().isRepl();
            ScratchExecutor scratchExecutor = isRepl ? (ScratchExecutor)scratchFile2.getReplScratchExecutor() : scratchFile2.getCompilingScratchExecutor();
            if (scratchExecutor == null) {
                return;
            }
            ScratchExecutor executor = scratchExecutor;
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Run Action: isRepl = " + isRepl);
            boolean isMakeBeforeRun = scratchFile2.getOptions().isMakeBeforeRun();
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Run Action: isMakeBeforeRun = " + isMakeBeforeRun);
            ScriptConfigurationManager.Companion.getInstance(project).updateScriptDependenciesIfNeeded(scratchFile2.getVirtualFile());
            Module module = scratchFile2.getCurrentModule();
            Module module2 = module;
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Run Action: module = " + (module2 != null ? module2.getName() : null));
            if (!isAutoRun && module != null && isMakeBeforeRun) {
                ProjectTaskManagerImpl.putBuildOriginator((Project)project, this.getClass());
                Module[] moduleArray = new Module[]{module};
                Promise promise = ProjectTaskManager.getInstance((Project)project).build(moduleArray).onSuccess(arg_0 -> Handler.doAction$lambda$1(arg_0 -> Handler.doAction$lambda$0(executor, module, project, isAutoRun, arg_0), arg_0));
                Intrinsics.checkNotNull((Object)promise);
            } else {
                Handler.doAction$executeScratch(isAutoRun, executor);
            }
        }

        private static final void doAction$executeScratch(boolean $isAutoRun, ScratchExecutor executor) {
            try {
                if ($isAutoRun && executor instanceof SequentialScratchExecutor) {
                    ((SequentialScratchExecutor)executor).executeNew();
                } else {
                    executor.execute();
                }
            }
            catch (Throwable ex) {
                executor.errorOccurs(KotlinJvmBundle.message("exception.occurs.during.run.scratch.action", new Object[0]), ex, true);
            }
        }

        private static final Unit doAction$lambda$0(ScratchExecutor $executor, Module $module, Project $project, boolean $isAutoRun, ProjectTaskManager.Result executionResult) {
            if (executionResult.isAborted() || executionResult.hasErrors()) {
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)$module.getName(), (String)"getName(...)");
                ScratchExecutor.errorOccurs$default($executor, KotlinJvmBundle.message("there.were.compilation.errors.in.module.0", objectArray), null, false, 6, null);
            }
            if (DumbService.Companion.isDumb($project)) {
                DumbService.Companion.getInstance($project).smartInvokeLater(() -> Handler.doAction$lambda$0$0($isAutoRun, $executor));
            } else {
                Handler.doAction$executeScratch($isAutoRun, $executor);
            }
            return Unit.INSTANCE;
        }

        private static final void doAction$lambda$0$0(boolean $isAutoRun, ScratchExecutor $executor) {
            Handler.doAction$executeScratch($isAutoRun, $executor);
        }

        private static final void doAction$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }
    }
}

