/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.conversions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.j2k.ConverterContext;
import org.jetbrains.kotlin.lang.BinaryOperationPrecedence;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.nj2k.ExpressionsKt;
import org.jetbrains.kotlin.nj2k.RecursiveConversion;
import org.jetbrains.kotlin.nj2k.tree.FormattingKt;
import org.jetbrains.kotlin.nj2k.tree.JKArgument;
import org.jetbrains.kotlin.nj2k.tree.JKArrayAccessExpression;
import org.jetbrains.kotlin.nj2k.tree.JKAssignmentChainAlsoLink;
import org.jetbrains.kotlin.nj2k.tree.JKAssignmentChainLetLink;
import org.jetbrains.kotlin.nj2k.tree.JKBinaryExpression;
import org.jetbrains.kotlin.nj2k.tree.JKBlockImpl;
import org.jetbrains.kotlin.nj2k.tree.JKCallExpression;
import org.jetbrains.kotlin.nj2k.tree.JKDelegationConstructorCall;
import org.jetbrains.kotlin.nj2k.tree.JKDoWhileStatement;
import org.jetbrains.kotlin.nj2k.tree.JKElement;
import org.jetbrains.kotlin.nj2k.tree.JKExpression;
import org.jetbrains.kotlin.nj2k.tree.JKExpressionStatement;
import org.jetbrains.kotlin.nj2k.tree.JKField;
import org.jetbrains.kotlin.nj2k.tree.JKForInStatement;
import org.jetbrains.kotlin.nj2k.tree.JKFormattingOwner;
import org.jetbrains.kotlin.nj2k.tree.JKIfElseExpression;
import org.jetbrains.kotlin.nj2k.tree.JKIfElseStatement;
import org.jetbrains.kotlin.nj2k.tree.JKIsExpression;
import org.jetbrains.kotlin.nj2k.tree.JKKtAssignmentStatement;
import org.jetbrains.kotlin.nj2k.tree.JKKtWhenCase;
import org.jetbrains.kotlin.nj2k.tree.JKKtWordOperatorToken;
import org.jetbrains.kotlin.nj2k.tree.JKLabeledExpression;
import org.jetbrains.kotlin.nj2k.tree.JKLambdaExpression;
import org.jetbrains.kotlin.nj2k.tree.JKLocalVariable;
import org.jetbrains.kotlin.nj2k.tree.JKMethodReferenceExpression;
import org.jetbrains.kotlin.nj2k.tree.JKOperatorToken;
import org.jetbrains.kotlin.nj2k.tree.JKParenthesizedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKPostfixExpression;
import org.jetbrains.kotlin.nj2k.tree.JKPrefixExpression;
import org.jetbrains.kotlin.nj2k.tree.JKQualifiedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKReturnStatement;
import org.jetbrains.kotlin.nj2k.tree.JKSuperExpression;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;
import org.jetbrains.kotlin.nj2k.tree.JKWhileStatement;
import org.jetbrains.kotlin.nj2k.tree.TreeUtilsKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/nj2k/conversions/RemoveUnnecessaryParenthesesConversion;", "Lorg/jetbrains/kotlin/nj2k/RecursiveConversion;", "context", "Lorg/jetbrains/kotlin/j2k/ConverterContext;", "<init>", "(Lorg/jetbrains/kotlin/j2k/ConverterContext;)V", "applyToElement", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "element", "areParenthesesNecessary", "", "expression", "Lorg/jetbrains/kotlin/nj2k/tree/JKParenthesizedExpression;", "getPriority", "", "Lorg/jetbrains/kotlin/nj2k/tree/JKElement;", "kotlin.j2k.shared"})
public final class RemoveUnnecessaryParenthesesConversion
extends RecursiveConversion {
    public RemoveUnnecessaryParenthesesConversion(@NotNull ConverterContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
    }

    @Override
    @NotNull
    public JKTreeElement applyToElement(@NotNull JKTreeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof JKParenthesizedExpression)) {
            return this.recurse(element);
        }
        if (this.areParenthesesNecessary((JKParenthesizedExpression)element)) {
            return this.recurse(element);
        }
        return this.recurse((JKTreeElement)FormattingKt.withFormattingFrom((JKFormattingOwner)TreeUtilsKt.detached((KProperty0)new MutablePropertyReference0Impl(element){

            public Object get() {
                return ((JKParenthesizedExpression)this.receiver).getExpression();
            }

            public void set(Object value) {
                ((JKParenthesizedExpression)this.receiver).setExpression((JKExpression)value);
            }
        }), (JKFormattingOwner)element));
    }

    private final boolean areParenthesesNecessary(JKParenthesizedExpression expression) {
        int parentPriority;
        JKExpression innerExpression = expression.getExpression();
        JKElement parent = expression.getParent();
        if (parent instanceof JKKtAssignmentStatement && Intrinsics.areEqual((Object)((JKKtAssignmentStatement)parent).getField(), (Object)expression) || parent instanceof JKAssignmentChainLetLink && Intrinsics.areEqual((Object)((JKAssignmentChainLetLink)parent).getReceiver(), (Object)expression)) {
            return false;
        }
        if (expression.getShouldBePreserved()) {
            return true;
        }
        if (parent == null) {
            return true;
        }
        if (innerExpression instanceof JKParenthesizedExpression || parent instanceof JKParenthesizedExpression) {
            return false;
        }
        if (parent instanceof JKIfElseExpression && ((JKIfElseExpression)parent).getCondition() == expression || parent instanceof JKIfElseStatement && ((JKIfElseStatement)parent).getCondition() == expression || parent instanceof JKWhileStatement && ((JKWhileStatement)parent).getCondition() == expression || parent instanceof JKDoWhileStatement && ((JKDoWhileStatement)parent).getCondition() == expression || parent instanceof JKArgument) {
            return false;
        }
        if (innerExpression instanceof JKBinaryExpression && ExpressionsKt.recursivelyContainsNewlineBeforeOperator((JKBinaryExpression)innerExpression)) {
            return true;
        }
        if (parent instanceof JKDelegationConstructorCall || parent instanceof JKKtWhenCase || parent instanceof JKReturnStatement) {
            return false;
        }
        if (parent instanceof JKQualifiedExpression && Intrinsics.areEqual((Object)((JKQualifiedExpression)parent).getReceiver(), (Object)expression) || parent instanceof JKAssignmentChainAlsoLink && Intrinsics.areEqual((Object)((JKAssignmentChainAlsoLink)parent).getReceiver(), (Object)expression)) {
            return !ExpressionsKt.isAtomic(innerExpression);
        }
        if (parent instanceof JKForInStatement && Intrinsics.areEqual((Object)((JKForInStatement)parent).getIterationExpression(), (Object)expression)) {
            return false;
        }
        if (parent instanceof JKIsExpression && Intrinsics.areEqual((Object)((JKIsExpression)parent).getExpression(), (Object)expression)) {
            return false;
        }
        JKElement grandparent = parent.getParent();
        if (parent instanceof JKExpressionStatement && (grandparent instanceof JKLambdaExpression || grandparent instanceof JKBlockImpl)) {
            return false;
        }
        if (parent instanceof JKLocalVariable && Intrinsics.areEqual((Object)((JKLocalVariable)parent).getInitializer(), (Object)expression) || parent instanceof JKField && Intrinsics.areEqual((Object)((JKField)parent).getInitializer(), (Object)expression) || parent instanceof JKKtAssignmentStatement && Intrinsics.areEqual((Object)((JKKtAssignmentStatement)parent).getExpression(), (Object)expression)) {
            return false;
        }
        if (parent instanceof JKPrefixExpression || parent instanceof JKPostfixExpression) {
            return !ExpressionsKt.isAtomic(innerExpression);
        }
        int innerPriority = this.getPriority(innerExpression);
        if (innerPriority == (parentPriority = this.getPriority(parent))) {
            if (!(parent instanceof JKBinaryExpression)) {
                return false;
            }
            if (innerExpression instanceof JKBinaryExpression && (Intrinsics.areEqual((Object)((JKBinaryExpression)innerExpression).getOperator().getToken(), (Object)JKOperatorToken.Companion.getANDAND()) || Intrinsics.areEqual((Object)((JKBinaryExpression)innerExpression).getOperator().getToken(), (Object)JKOperatorToken.Companion.getOROR()))) {
                return false;
            }
            return Intrinsics.areEqual((Object)((JKBinaryExpression)parent).getRight(), (Object)expression);
        }
        return innerPriority < parentPriority;
    }

    private final int getPriority(JKElement expression) {
        if (expression instanceof JKSuperExpression) {
            return KtPsiUtil.MAX_PRIORITY;
        }
        if (expression instanceof JKPostfixExpression || expression instanceof JKQualifiedExpression || expression instanceof JKCallExpression || expression instanceof JKMethodReferenceExpression || expression instanceof JKArrayAccessExpression) {
            return KtPsiUtil.MAX_PRIORITY - 1;
        }
        if (expression instanceof JKPrefixExpression || expression instanceof JKLabeledExpression || expression instanceof JKIfElseExpression) {
            return KtPsiUtil.MAX_PRIORITY - 2;
        }
        if (expression instanceof JKBinaryExpression) {
            KtToken binaryOperation;
            BinaryOperationPrecedence binaryOperationPrecedence;
            JKOperatorToken operatorToken = ((JKBinaryExpression)expression).getOperator().getToken();
            KtToken operatorElementType = JKOperatorToken.Companion.toKtElementType(operatorToken);
            Object object = operatorElementType;
            if (object == null) {
                object = operatorToken instanceof JKKtWordOperatorToken ? KtTokens.IDENTIFIER : null;
            }
            if ((binaryOperationPrecedence = (BinaryOperationPrecedence)BinaryOperationPrecedence.TOKEN_TO_BINARY_PRECEDENCE_MAP.get(binaryOperation = object)) != null) {
                return KtPsiUtil.MAX_PRIORITY - 3 - binaryOperationPrecedence.ordinal();
            }
        }
        return KtPsiUtil.MAX_PRIORITY;
    }
}

