/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.hunspell;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.languagetool.JLanguageTool;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.rules.spelling.hunspell.DumontsHunspellDictionary;
import org.languagetool.rules.spelling.hunspell.HunspellDictionary;

public final class Hunspell {
    static final boolean FORCE_TEMP_FILES = "true".equals(System.getenv("HUNSPELL_FORCE_TEMP_FILES"));
    private static final Map<LanguageAndPath, HunspellDictionary> map = new HashMap<LanguageAndPath, HunspellDictionary>();
    private static BiFunction<Path, Path, HunspellDictionary> hunspellDictionaryFactory = DumontsHunspellDictionary::new;
    private static Factory hunspellDictionaryStreamFactory = Hunspell.viaTempFiles(DumontsHunspellDictionary::new);

    @Deprecated
    public static void setHunspellDictionaryFactory(BiFunction<Path, Path, HunspellDictionary> factory) {
        if (FORCE_TEMP_FILES) {
            hunspellDictionaryFactory = factory;
        } else {
            hunspellDictionaryStreamFactory = Hunspell.viaTempFiles(factory);
        }
    }

    private static Factory viaTempFiles(final BiFunction<Path, Path, HunspellDictionary> factory) {
        return new Factory(){

            @Override
            public HunspellDictionary createFromLocalFiles(String languageCode, Path dictionary, Path affix) {
                return (HunspellDictionary)factory.apply(dictionary, affix);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HunspellDictionary createFromStreams(String language, InputStream dictionaryStream, InputStream affixStream) throws IOException {
                Path dictionary = Files.createTempFile(language, ".dic", new FileAttribute[0]);
                Path affix = Files.createTempFile(language, ".aff", new FileAttribute[0]);
                Files.copy(dictionaryStream, dictionary, StandardCopyOption.REPLACE_EXISTING);
                Files.copy(affixStream, affix, StandardCopyOption.REPLACE_EXISTING);
                try {
                    HunspellDictionary hunspellDictionary = (HunspellDictionary)factory.apply(dictionary, affix);
                    return hunspellDictionary;
                }
                finally {
                    Files.deleteIfExists(dictionary);
                    Files.deleteIfExists(affix);
                }
            }
        };
    }

    public static void setHunspellStreamFactory(Factory factory) {
        hunspellDictionaryStreamFactory = factory;
    }

    public static synchronized HunspellDictionary getDictionary(Path dictionary, Path affix) {
        LanguageAndPath key = new LanguageAndPath(dictionary, affix);
        HunspellDictionary hunspell = map.get(key);
        if (hunspell != null && !hunspell.isClosed()) {
            return hunspell;
        }
        if (FORCE_TEMP_FILES) {
            HunspellDictionary newHunspell = hunspellDictionaryFactory.apply(dictionary, affix);
            map.put(key, newHunspell);
            return newHunspell;
        }
        try {
            HunspellDictionary newHunspell = hunspellDictionaryStreamFactory.createFromLocalFiles(dictionary.getFileName().toString(), dictionary, affix);
            map.put(key, newHunspell);
            return newHunspell;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static HunspellDictionary forDictionaryInResources(String language, String resourcePath) {
        return Hunspell.forDictionaryInResources(language, resourcePath + language + ".dic", resourcePath + language + ".aff");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static HunspellDictionary forDictionaryInResources(String language, String dicPath, String affPath) {
        if (FORCE_TEMP_FILES) {
            try {
                ResourceDataBroker broker = JLanguageTool.getDataBroker();
                InputStream dictionaryStream = broker.getAsStream(dicPath);
                InputStream affixStream = broker.getAsStream(affPath);
                if (dictionaryStream == null || affixStream == null) {
                    throw new RuntimeException("Could not find dictionary for language \"" + language + "\" in classpath");
                }
                Path dictionary = Files.createTempFile(language, ".dic", new FileAttribute[0]);
                Path affix = Files.createTempFile(language, ".aff", new FileAttribute[0]);
                Files.copy(dictionaryStream, dictionary, StandardCopyOption.REPLACE_EXISTING);
                Files.copy(affixStream, affix, StandardCopyOption.REPLACE_EXISTING);
                return hunspellDictionaryFactory.apply(dictionary, affix);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create temporary dictionaries for language \"" + language + "\"", e);
            }
        }
        ResourceDataBroker broker = JLanguageTool.getDataBroker();
        URL dicUrl = broker.getFromResourceDirAsUrl(dicPath);
        URL affUrl = broker.getFromResourceDirAsUrl(affPath);
        if (dicUrl != null && affUrl != null && dicUrl.getProtocol().equals("file") && affUrl.getProtocol().equals("file")) {
            try {
                return hunspellDictionaryStreamFactory.createFromLocalFiles(language, Path.of(dicUrl.toURI()), Path.of(affUrl.toURI()));
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        try (InputStream dic = broker.getFromResourceDirAsStream(dicPath);){
            HunspellDictionary hunspellDictionary;
            block22: {
                InputStream aff = broker.getFromResourceDirAsStream(affPath);
                try {
                    if (dic == null || aff == null) {
                        throw new RuntimeException("Could not find the dictionary for language \"" + language + "\" in the classpath");
                    }
                    hunspellDictionary = hunspellDictionaryStreamFactory.createFromStreams(language, dic, aff);
                    if (aff == null) break block22;
                }
                catch (Throwable throwable) {
                    if (aff != null) {
                        try {
                            aff.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                aff.close();
            }
            return hunspellDictionary;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create temporary dictionaries for language \"" + language + "\"", e);
        }
    }

    public static HunspellDictionary forDictionaryInResources(String language) {
        return Hunspell.forDictionaryInResources(language, "");
    }

    public static interface Factory {
        default public HunspellDictionary createFromLocalFiles(String languageCode, Path dictionary, Path affix) throws IOException {
            try (InputStream dic = Files.newInputStream(dictionary, new OpenOption[0]);){
                HunspellDictionary hunspellDictionary;
                block12: {
                    InputStream aff = Files.newInputStream(affix, new OpenOption[0]);
                    try {
                        hunspellDictionary = this.createFromStreams(languageCode, dic, aff);
                        if (aff == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (aff != null) {
                            try {
                                aff.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    aff.close();
                }
                return hunspellDictionary;
            }
        }

        public HunspellDictionary createFromStreams(String var1, InputStream var2, InputStream var3) throws IOException;
    }

    static class LanguageAndPath {
        private final Path dictionary;
        private final Path affix;

        LanguageAndPath(Path dictionary, Path affix) {
            this.dictionary = Objects.requireNonNull(dictionary);
            this.affix = Objects.requireNonNull(affix);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LanguageAndPath that = (LanguageAndPath)o;
            return Objects.equals(this.dictionary, that.dictionary) && Objects.equals(this.affix, that.affix);
        }

        public int hashCode() {
            return Objects.hash(this.dictionary, this.affix);
        }
    }
}

