/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.modelSerialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;

public final class DefaultSerializationService
implements SerializationService {
    public byte[] write(Object object, Class modelClazz) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (ObjectOutputStream outputStream = new ObjectOutputStream(os);){
            outputStream.writeObject(object);
        }
        catch (NotSerializableException e) {
            throw new IOException(String.format("Implement Serializable or provide related org.jetbrains.plugins.gradle.tooling.serialization.SerializationService for the tooling model: '%s'", object.getClass().getName()), e);
        }
        return os.toByteArray();
    }

    public Object read(byte[] object, Class modelClazz) throws IOException {
        Object object2;
        ClassLoaderObjectInputStream inputStream = new ClassLoaderObjectInputStream(modelClazz.getClassLoader(), (InputStream)new ByteArrayInputStream(object));
        try {
            object2 = inputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }
        inputStream.close();
        return object2;
    }

    public Class<Object> getModelClass() {
        throw new IllegalStateException("The method should never be called for this serializer service implementation");
    }
}

