/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.impl.source.parsing.xml.HtmlBuilderDriver;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilder;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CharsetDetector {
    @NonNls
    private static final String CHARSET = "charset";
    @NonNls
    private static final String CHARSET_PREFIX = "charset=";

    private CharsetDetector() {
    }

    public static Charset detectCharsetFromMetaTag(@NotNull CharSequence content) {
        String name;
        if (content == null) {
            CharsetDetector.$$$reportNull$$$0(0);
        }
        int charPrefix = StringUtil.indexOf((CharSequence)content, (CharSequence)CHARSET);
        while (true) {
            int charsetPrefixEnd;
            if (charPrefix == -1) {
                return null;
            }
            for (charsetPrefixEnd = charPrefix + CHARSET.length(); charsetPrefixEnd < content.length() && Character.isWhitespace(content.charAt(charsetPrefixEnd)); ++charsetPrefixEnd) {
            }
            if (charsetPrefixEnd < content.length() && content.charAt(charsetPrefixEnd) == '=') break;
            charPrefix = StringUtil.indexOf((CharSequence)content, (CharSequence)CHARSET, (int)charsetPrefixEnd);
        }
        if (content.length() > charPrefix + 200 && (name = CharsetDetector.tryFetchCharsetFromFileContent(content.subSequence(0, charPrefix + 200))) != null) {
            return CharsetToolkit.forName((String)name);
        }
        String name2 = CharsetDetector.tryFetchCharsetFromFileContent(content);
        return CharsetToolkit.forName((String)name2);
    }

    private static String tryFetchCharsetFromFileContent(@NotNull CharSequence content) {
        if (content == null) {
            CharsetDetector.$$$reportNull$$$0(1);
        }
        final Ref charsetNameRef = new Ref();
        try {
            new HtmlBuilderDriver(content).build(new XmlBuilder(){
                @NonNls
                final Set<String> inTag = new HashSet<String>();
                boolean metHttpEquiv;
                boolean metHtml5Charset;
                private String contentAttributeValue;

                public void doctype(@Nullable CharSequence publicId, @Nullable CharSequence systemId, int startOffset, int endOffset) {
                }

                @NotNull
                public XmlBuilder.ProcessingOrder startTag(@NotNull CharSequence localName, @NotNull String namespace, int startOffset, int endOffset, int headerEndOffset) {
                    if (localName == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (namespace == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    @NonNls String name = StringUtil.toLowerCase((String)localName.toString());
                    this.inTag.add(name);
                    if (!this.inTag.contains("head") && !"html".equals(name)) {
                        1.terminate();
                    }
                    XmlBuilder.ProcessingOrder processingOrder = XmlBuilder.ProcessingOrder.TAGS_AND_ATTRIBUTES;
                    if (processingOrder == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return processingOrder;
                }

                private static void terminate() {
                    throw TerminateException.INSTANCE;
                }

                public void endTag(@NotNull CharSequence localName, @NotNull String namespace, int startOffset, int endOffset) {
                    String name;
                    if (localName == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (namespace == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if ("meta".equals(name = StringUtil.toLowerCase((String)localName.toString())) && (this.metHttpEquiv || this.metHtml5Charset) && this.contentAttributeValue != null) {
                        String charsetName;
                        if (this.metHttpEquiv) {
                            int start = this.contentAttributeValue.indexOf(CharsetDetector.CHARSET_PREFIX);
                            if (start == -1) {
                                return;
                            }
                            int end = this.contentAttributeValue.indexOf(59, start += CharsetDetector.CHARSET_PREFIX.length());
                            if (end == -1) {
                                end = this.contentAttributeValue.length();
                            }
                            charsetName = this.contentAttributeValue.substring(start, end);
                        } else {
                            charsetName = StringUtil.unquoteString((String)this.contentAttributeValue);
                        }
                        charsetNameRef.set((Object)charsetName);
                        1.terminate();
                    }
                    if ("head".equals(name)) {
                        1.terminate();
                    }
                    this.inTag.remove(name);
                    this.metHttpEquiv = false;
                    this.metHtml5Charset = false;
                    this.contentAttributeValue = null;
                }

                public void attribute(@NotNull CharSequence localName, @NotNull CharSequence v, int startOffset, int endOffset) {
                    if (localName == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    if (v == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    @NonNls String name = StringUtil.toLowerCase((String)localName.toString());
                    if (this.inTag.contains("meta")) {
                        @NonNls String value = StringUtil.toLowerCase((String)v.toString());
                        if (name.equals("http-equiv")) {
                            this.metHttpEquiv |= value.equals("content-type");
                        } else if (name.equals(CharsetDetector.CHARSET)) {
                            this.metHtml5Charset = true;
                            this.contentAttributeValue = value;
                        }
                        if (name.equals("content")) {
                            this.contentAttributeValue = value;
                        }
                    }
                }

                public void textElement(@NotNull CharSequence display, @NotNull CharSequence physical, int startOffset, int endOffset) {
                    if (display == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    if (physical == null) {
                        1.$$$reportNull$$$0(8);
                    }
                }

                public void entityRef(@NotNull CharSequence ref, int startOffset, int endOffset) {
                    if (ref == null) {
                        1.$$$reportNull$$$0(9);
                    }
                }

                public void error(@NotNull String message, int startOffset, int endOffset) {
                    if (message == null) {
                        1.$$$reportNull$$$0(10);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "localName";
                            break;
                        }
                        case 1: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "namespace";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/util/CharsetDetector$1";
                            break;
                        }
                        case 6: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "v";
                            break;
                        }
                        case 7: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "display";
                            break;
                        }
                        case 8: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "physical";
                            break;
                        }
                        case 9: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "ref";
                            break;
                        }
                        case 10: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "message";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/util/CharsetDetector$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "startTag";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "startTag";
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: 
                        case 4: {
                            objectArray = objectArray;
                            objectArray[2] = "endTag";
                            break;
                        }
                        case 5: 
                        case 6: {
                            objectArray = objectArray;
                            objectArray[2] = "attribute";
                            break;
                        }
                        case 7: 
                        case 8: {
                            objectArray = objectArray;
                            objectArray[2] = "textElement";
                            break;
                        }
                        case 9: {
                            objectArray = objectArray;
                            objectArray[2] = "entityRef";
                            break;
                        }
                        case 10: {
                            objectArray = objectArray;
                            objectArray[2] = "error";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2 -> new IllegalStateException(string);
                    };
                }
            });
        }
        catch (TerminateException terminateException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (String)charsetNameRef.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "content";
        objectArray2[1] = "com/intellij/util/CharsetDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "detectCharsetFromMetaTag";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "tryFetchCharsetFromFileContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TerminateException
    extends RuntimeException {
        private static final TerminateException INSTANCE = new TerminateException();

        private TerminateException() {
        }
    }
}

