/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.uast.testFramework.env;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.UsefulTestCase;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0018H\u0014J\b\u0010\u001a\u001a\u00020\u0010H\u0002J&\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u0002J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R,\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\t0\n0\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/intellij/platform/uast/testFramework/env/AbstractLargeProjectTest;", "Lcom/intellij/testFramework/UsefulTestCase;", "<init>", "()V", "testProjectPath", "Ljava/nio/file/Path;", "getTestProjectPath", "()Ljava/nio/file/Path;", "projectLibraries", "", "Lkotlin/Pair;", "", "Ljava/io/File;", "getProjectLibraries", "()Ljava/util/List;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "runInDispatchThread", "", "setUp", "", "tearDown", "openTestProject", "addLibrary", "tableModel", "Lcom/intellij/openapi/roots/libraries/LibraryTable$ModifiableModel;", "libName", "libRoots", "disposeOnTearDownInEdt", "runnable", "Ljava/lang/Runnable;", "intellij.platform.uast.testFramework"})
@SourceDebugExtension(value={"SMAP\nAbstractLargeProjectTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractLargeProjectTest.kt\ncom/intellij/platform/uast/testFramework/env/AbstractLargeProjectTest\n+ 2 readWriteActionsInTests.kt\ncom/intellij/openapi/application/ReadWriteActionsInTestsKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,118:1\n11#2:119\n11#2:123\n29#3,3:120\n*S KotlinDebug\n*F\n+ 1 AbstractLargeProjectTest.kt\ncom/intellij/platform/uast/testFramework/env/AbstractLargeProjectTest\n*L\n47#1:119\n76#1:123\n61#1:120,3\n*E\n"})
public abstract class AbstractLargeProjectTest
extends UsefulTestCase {
    protected Project project;

    @NotNull
    public abstract Path getTestProjectPath();

    @NotNull
    protected List<Pair<String, List<File>>> getProjectLibraries() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected final Project getProject() {
        Project project = this.project;
        if (project != null) {
            return project;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        return null;
    }

    protected final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @Override
    protected boolean runInDispatchThread() {
        return false;
    }

    @Override
    protected void setUp() {
        super.setUp();
        TestApplicationManager.Companion.getInstance();
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable(this){
            final /* synthetic */ AbstractLargeProjectTest this$0;
            {
                this.this$0 = abstractLargeProjectTest;
            }

            public final T compute() {
                boolean bl = false;
                JavaSdk javaSdk = JavaSdk.getInstance();
                String string = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk().getHomePath();
                Intrinsics.checkNotNull((Object)string);
                Sdk sdk = javaSdk.createJdk("1.8", string, false);
                Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"createJdk(...)");
                Sdk j8 = sdk;
                ProjectJdkTable.getInstance().addJdk(j8, this.this$0.getTestRootDisposable());
                JavaSdk javaSdk2 = JavaSdk.getInstance();
                String string2 = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk().getHomePath();
                Intrinsics.checkNotNull((Object)string2);
                Sdk sdk2 = javaSdk2.createJdk("IDEA jdk", string2, false);
                Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"createJdk(...)");
                Sdk internal = sdk2;
                ProjectJdkTable.getInstance().addJdk(internal, this.this$0.getTestRootDisposable());
                return (T)Unit.INSTANCE;
            }
        });
        InspectionProfileImpl.INIT_INSPECTIONS = true;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        this.setProject(this.openTestProject());
        long projectOpenTime = System.currentTimeMillis() - start$iv;
        UsefulTestCase.LOG.warn("Project has been opened successfully in " + projectOpenTime + " ms");
    }

    @Override
    protected void tearDown() {
        InspectionProfileImpl.INIT_INSPECTIONS = false;
        super.tearDown();
    }

    private final Project openTestProject() {
        Project project = ProjectManagerEx.Companion.getInstanceEx().openProject(this.getTestProjectPath(), new OpenProjectTask(false, null, false, false, 15, null));
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        this.disposeOnTearDownInEdt(() -> AbstractLargeProjectTest.openTestProject$lambda$0(project2));
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable(project2, this){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ AbstractLargeProjectTest this$0;
            {
                this.$project$inlined = project;
                this.this$0 = abstractLargeProjectTest;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T compute() {
                boolean bl = false;
                LibraryTable.ModifiableModel modifiableModel = LibraryTablesRegistrar.getInstance().getLibraryTable(this.$project$inlined).getModifiableModel();
                Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"getModifiableModel(...)");
                LibraryTable.ModifiableModel tableModel = modifiableModel;
                try {
                    for (Pair<String, List<File>> pair : this.this$0.getProjectLibraries()) {
                        String libName = (String)pair.component1();
                        List libRoots = (List)pair.component2();
                        AbstractLargeProjectTest.access$addLibrary(this.this$0, tableModel, libName, libRoots);
                    }
                }
                finally {
                    tableModel.commit();
                }
                return (T)Unit.INSTANCE;
            }
        });
        ApplicationManager.getApplication().invokeAndWait(AbstractLargeProjectTest::openTestProject$lambda$2);
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.Companion.getInstance(project2);
        Intrinsics.checkNotNull((Object)projectLevelVcsManager, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl");
        ((ProjectLevelVcsManagerImpl)projectLevelVcsManager).waitForInitialized();
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
        Intrinsics.checkNotNull((Object)changeListManager, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.changes.ChangeListManagerImpl");
        ((ChangeListManagerImpl)changeListManager).waitUntilRefreshed();
        return project2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addLibrary(LibraryTable.ModifiableModel tableModel, String libName, List<? extends File> libRoots) {
        Library library = tableModel.createLibrary(libName, null);
        Intrinsics.checkNotNullExpressionValue((Object)library, (String)"createLibrary(...)");
        Library library2 = library;
        Library.ModifiableModel modifiableModel = library2.getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"getModifiableModel(...)");
        Library.ModifiableModel libModel = modifiableModel;
        try {
            for (File file : libRoots) {
                libModel.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
            }
        }
        finally {
            libModel.commit();
        }
    }

    private final void disposeOnTearDownInEdt(Runnable runnable) {
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> AbstractLargeProjectTest.disposeOnTearDownInEdt$lambda$0(runnable));
    }

    private static final void openTestProject$lambda$0(Project $project) {
        ProjectManager.getInstance().closeAndDispose($project);
    }

    private static final void openTestProject$lambda$2() {
    }

    private static final void disposeOnTearDownInEdt$lambda$0(Runnable $runnable) {
        ApplicationManager.getApplication().invokeAndWait($runnable);
    }

    public static final /* synthetic */ void access$addLibrary(AbstractLargeProjectTest $this, LibraryTable.ModifiableModel tableModel, String libName, List libRoots) {
        $this.addLibrary(tableModel, libName, libRoots);
    }
}

