/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion.util;

import com.amazon.ion.util.InputStreamInterceptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public enum GzipStreamInterceptor implements InputStreamInterceptor
{
    INSTANCE;

    private static final byte[] GZIP_HEADER;

    @Override
    public String formatName() {
        return "gzip";
    }

    @Override
    public int numberOfBytesNeededToDetermineMatch() {
        return GZIP_HEADER.length;
    }

    @Override
    public boolean isMatch(byte[] candidate, int offset, int length) {
        if (candidate == null || length < GZIP_HEADER.length) {
            return false;
        }
        for (int i = 0; i < GZIP_HEADER.length; ++i) {
            if (GZIP_HEADER[i] == candidate[offset + i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public InputStream newInputStream(InputStream interceptedStream) throws IOException {
        return new GZIPInputStream(interceptedStream);
    }

    static {
        GZIP_HEADER = new byte[]{31, -117};
    }
}

