/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.LocationInformation;
import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNull;
import com.dd.plist.NSNumber;
import com.dd.plist.NSSet;
import com.dd.plist.NSString;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class NSObject
implements Cloneable,
Comparable<NSObject> {
    static final String NEWLINE = System.lineSeparator();
    static final int ASCII_LINE_LENGTH = 80;
    private static final String INDENT = "\t";
    private LocationInformation locationInformation;

    public LocationInformation getLocationInformation() {
        return this.locationInformation;
    }

    void setLocationInformation(LocationInformation locationInformation) {
        this.locationInformation = locationInformation;
    }

    public abstract NSObject clone();

    public abstract Object toJavaObject();

    public String toXMLPropertyList() {
        StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(NEWLINE).append("<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">").append(NEWLINE).append("<plist version=\"1.0\">").append(NEWLINE);
        this.toXML(xml, 0);
        xml.append(NEWLINE).append("</plist>");
        return xml.toString();
    }

    abstract void toXML(StringBuilder var1, int var2);

    void assignIDs(BinaryPropertyListWriter out) {
        out.assignID(this);
    }

    abstract void toBinary(BinaryPropertyListWriter var1) throws IOException;

    abstract void toASCII(StringBuilder var1, int var2);

    abstract void toASCIIGnuStep(StringBuilder var1, int var2);

    protected void indent(StringBuilder xml, int level) {
        for (int i2 = 0; i2 < level; ++i2) {
            xml.append(INDENT);
        }
    }

    public <T> T toJavaObject(Class<T> clazz) {
        return (T)this.toJavaObject(this, clazz, null);
    }

    public static NSObject fromJavaObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof NSObject) {
            return (NSObject)object;
        }
        Class<?> objClass = object.getClass();
        if (objClass.isArray()) {
            return NSObject.fromArray(object, objClass);
        }
        if (NSObject.isSimple(objClass)) {
            return NSObject.fromSimple(object, objClass);
        }
        if (Set.class.isAssignableFrom(objClass)) {
            return NSObject.fromSet((Set)object);
        }
        if (Map.class.isAssignableFrom(objClass)) {
            return NSObject.fromMap((Map)object);
        }
        if (Collection.class.isAssignableFrom(objClass)) {
            return NSObject.fromCollection((Collection)object);
        }
        return NSObject.fromPojo(object, objClass);
    }

    private static boolean isSimple(Class<?> clazz) {
        return clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || clazz == String.class || Date.class.isAssignableFrom(clazz);
    }

    private static Object getInstance(Class<?> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
            throw new IllegalArgumentException("Could not instantiate class " + clazz.getSimpleName());
        }
    }

    private static Class<?> getClassForName(String className) {
        int spaceIndex = className.indexOf(32);
        if (spaceIndex != -1) {
            className = className.substring(spaceIndex + 1);
        }
        if ("double".equals(className)) {
            return Double.TYPE;
        }
        if ("float".equals(className)) {
            return Float.TYPE;
        }
        if ("int".equals(className)) {
            return Integer.TYPE;
        }
        if ("long".equals(className)) {
            return Long.TYPE;
        }
        if ("short".equals(className)) {
            return Short.TYPE;
        }
        if ("boolean".equals(className)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(className)) {
            return Byte.TYPE;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e2) {
            throw new IllegalArgumentException("Could not load class " + className, e2);
        }
    }

    private static String makeFirstCharLowercase(String input) {
        char[] chars = input.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private Object toJavaObject(NSObject payload, Class<?> clazz, Type[] types) {
        if (payload == null || payload instanceof NSNull) {
            return null;
        }
        if (clazz.isArray()) {
            return this.deserializeArray(payload, clazz);
        }
        if (NSObject.isSimple(clazz)) {
            return NSObject.deserializeSimple(payload, clazz);
        }
        if (clazz == Object.class && !(payload instanceof NSSet) && !(payload instanceof NSArray)) {
            return NSObject.deserializeSimple(payload, clazz);
        }
        if (payload instanceof NSSet && Collection.class.isAssignableFrom(clazz)) {
            return this.deserializeCollection(payload, clazz, types);
        }
        if (payload instanceof NSArray && Collection.class.isAssignableFrom(clazz)) {
            return this.deserializeCollection(payload, clazz, types);
        }
        if (payload instanceof NSDictionary) {
            return this.deserializeObject((NSDictionary)payload, clazz, types);
        }
        if (payload instanceof NSData && Collection.class.isAssignableFrom(clazz)) {
            return this.deserializeCollection(payload, clazz, types);
        }
        throw new IllegalArgumentException("Cannot process " + clazz.getSimpleName());
    }

    private Object deserializeObject(NSDictionary payload, Class<?> clazz, Type[] types) {
        HashMap<String, NSObject> map2 = payload.getHashMap();
        if (Map.class.isAssignableFrom(clazz)) {
            return this.deserializeMap(clazz, types, map2);
        }
        Object result2 = NSObject.getInstance(clazz);
        HashMap<String, Method> getters = new HashMap<String, Method>();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        for (Method method : clazz.getMethods()) {
            String name = method.getName();
            if (name.startsWith("get")) {
                getters.put(NSObject.makeFirstCharLowercase(name.substring(3)), method);
                continue;
            }
            if (name.startsWith("set")) {
                setters.put(NSObject.makeFirstCharLowercase(name.substring(3)), method);
                continue;
            }
            if (!name.startsWith("is")) continue;
            getters.put(NSObject.makeFirstCharLowercase(name.substring(2)), method);
        }
        for (Map.Entry entry : map2.entrySet()) {
            Method setter = (Method)setters.get(NSObject.makeFirstCharLowercase((String)entry.getKey()));
            Method getter = (Method)getters.get(NSObject.makeFirstCharLowercase((String)entry.getKey()));
            if (setter == null || getter == null) continue;
            Class<?> elemClass = getter.getReturnType();
            Type[] elemTypes = null;
            Type type = getter.getGenericReturnType();
            if (type instanceof ParameterizedType) {
                elemTypes = ((ParameterizedType)type).getActualTypeArguments();
            }
            try {
                setter.invoke(result2, this.toJavaObject((NSObject)entry.getValue(), elemClass, elemTypes));
            }
            catch (IllegalAccessException e2) {
                throw new IllegalArgumentException("Could not access setter " + setter);
            }
            catch (InvocationTargetException e3) {
                throw new IllegalArgumentException("Could not invoke setter " + setter);
            }
        }
        return result2;
    }

    private Object deserializeMap(Class<?> clazz, Type[] types, Map<String, NSObject> map2) {
        Map<String, Object> result2;
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            result2 = new HashMap();
        } else {
            Map temp = (Map)NSObject.getInstance(clazz);
            result2 = temp;
        }
        Class elemClass = Object.class;
        Type[] elemParams = null;
        if (types != null && types.length > 1) {
            Type elemType = types[1];
            if (elemType instanceof ParameterizedType) {
                elemClass = NSObject.getClassForName(((ParameterizedType)elemType).getRawType().toString());
                elemParams = ((ParameterizedType)elemType).getActualTypeArguments();
            } else {
                elemClass = NSObject.getClassForName(elemType.toString());
            }
        }
        for (Map.Entry<String, NSObject> entry : map2.entrySet()) {
            result2.put(entry.getKey(), this.toJavaObject(entry.getValue(), elemClass, elemParams));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object deserializeCollection(NSObject payload, Class<?> clazz, Type[] types) {
        void var5_9;
        Collection<Byte> result2;
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            if (List.class.isAssignableFrom(clazz)) {
                result2 = new ArrayList();
            } else {
                if (!Set.class.isAssignableFrom(clazz)) throw new IllegalArgumentException("Could not find a proper implementation for " + clazz.getSimpleName());
                result2 = new HashSet();
            }
        } else {
            Collection collection = (Collection)NSObject.getInstance(clazz);
            result2 = collection;
        }
        Class<Object> clazz2 = Object.class;
        Type[] elemTypes = null;
        if (types != null && types.length > 0) {
            if (types[0] instanceof ParameterizedType) {
                Class<?> clazz3 = NSObject.getClassForName(((ParameterizedType)types[0]).getRawType().toString());
                elemTypes = ((ParameterizedType)types[0]).getActualTypeArguments();
            } else {
                Class<?> clazz4 = NSObject.getClassForName(types[0].toString());
            }
        }
        if (payload instanceof NSArray) {
            for (NSObject nsObject : ((NSArray)payload).getArray()) {
                result2.add((Byte)this.toJavaObject(nsObject, (Class<?>)var5_9, elemTypes));
            }
            return result2;
        }
        if (payload instanceof NSData) {
            if (var5_9 == null || !var5_9.isAssignableFrom(Byte.class)) throw new IllegalArgumentException("NSData cannot be converted to " + clazz.getName());
            byte[] byArray = ((NSData)payload).bytes();
            int n = byArray.length;
            for (int j = 0; j < n; ++j) {
                Byte b = byArray[j];
                result2.add(b);
            }
            return result2;
        }
        if (!(payload instanceof NSSet)) throw new IllegalArgumentException("Unknown NS* type " + payload.getClass().getSimpleName());
        for (NSObject nsObject : ((NSSet)payload).allObjects()) {
            result2.add((Byte)this.toJavaObject(nsObject, (Class<?>)var5_9, elemTypes));
        }
        return result2;
    }

    private Object deserializeArray(NSObject payload, Class<?> clazz) {
        Class<?> elementClass = NSObject.getClassForName(clazz.getComponentType().getName());
        if (payload instanceof NSArray) {
            NSObject[] array = ((NSArray)payload).getArray();
            Object result2 = Array.newInstance(elementClass, array.length);
            for (int i2 = 0; i2 < array.length; ++i2) {
                Array.set(result2, i2, this.toJavaObject(array[i2], elementClass, null));
            }
            return result2;
        }
        if (payload instanceof NSSet) {
            NSSet set = (NSSet)payload;
            Object result3 = Array.newInstance(elementClass, set.count());
            int i3 = 0;
            for (NSObject entry : set.allObjects()) {
                Array.set(result3, i3, this.toJavaObject(entry, elementClass, null));
                ++i3;
            }
            return result3;
        }
        if (payload instanceof NSData) {
            return NSObject.deserializeData((NSData)payload, elementClass);
        }
        throw new IllegalArgumentException("Unable to map " + payload.getClass().getSimpleName() + " to " + clazz.getName());
    }

    private static Object deserializeData(NSData payload, Class<?> elementClass) {
        if (elementClass == Byte.TYPE) {
            return payload.bytes();
        }
        if (elementClass == Byte.class) {
            byte[] bytes = payload.bytes();
            Object result2 = Array.newInstance(elementClass, bytes.length);
            for (int i2 = 0; i2 < bytes.length; ++i2) {
                Array.set(result2, i2, bytes[i2]);
            }
            return result2;
        }
        throw new IllegalArgumentException("NSData can only be mapped to byte[] or Byte[].");
    }

    private static Object deserializeSimple(NSObject payload, Class<?> clazz) {
        if (payload instanceof NSNumber) {
            return NSObject.deserializeNumber((NSNumber)payload, clazz);
        }
        if (payload instanceof NSDate) {
            return NSObject.deserializeDate((NSDate)payload, clazz);
        }
        if (payload instanceof NSString) {
            return ((NSString)payload).getContent();
        }
        throw new IllegalArgumentException("Cannot map " + payload.getClass().getSimpleName() + " to " + clazz.getSimpleName());
    }

    private static Date deserializeDate(NSDate date, Class<?> clazz) {
        if (clazz == Date.class) {
            return date.getDate();
        }
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            return date.getDate();
        }
        Date result2 = (Date)NSObject.getInstance(clazz);
        result2.setTime(date.getDate().getTime());
        return result2;
    }

    private static Object deserializeNumber(NSNumber number, Class<?> clazz) {
        if (number.isInteger()) {
            if (clazz == Long.TYPE || clazz == Long.class) {
                return number.longValue();
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return number.intValue();
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (short)number.intValue();
            }
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (byte)number.intValue();
            }
        }
        if (number.isInteger() || number.isReal()) {
            if (clazz == Double.TYPE || clazz == Double.class) {
                return number.doubleValue();
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return Float.valueOf(number.floatValue());
            }
        }
        if (number.isBoolean() && (clazz == Boolean.TYPE || clazz == Boolean.class)) {
            return number.boolValue();
        }
        throw new IllegalArgumentException("Cannot map NSNumber to " + clazz.getSimpleName());
    }

    private static NSObject fromSimple(Object object, Class<?> objClass) {
        if (object instanceof Long || objClass == Long.TYPE) {
            return new NSNumber((Long)object);
        }
        if (object instanceof Integer || objClass == Integer.TYPE) {
            return new NSNumber((Integer)object);
        }
        if (object instanceof Short || objClass == Short.TYPE) {
            return new NSNumber(((Short)object).shortValue());
        }
        if (object instanceof Byte || objClass == Byte.TYPE) {
            return new NSNumber(((Byte)object).byteValue());
        }
        if (object instanceof Double || objClass == Double.TYPE) {
            return new NSNumber((Double)object);
        }
        if (object instanceof Float || objClass == Float.TYPE) {
            return new NSNumber(((Float)object).floatValue());
        }
        if (object instanceof Boolean || objClass == Boolean.TYPE) {
            return new NSNumber((Boolean)object);
        }
        if (object instanceof Date) {
            return new NSDate((Date)object);
        }
        if (objClass == String.class) {
            return new NSString((String)object);
        }
        throw new IllegalArgumentException("Cannot map " + objClass.getSimpleName() + " as a simple type.");
    }

    private static NSDictionary fromPojo(Object object, Class<?> objClass) {
        NSDictionary result2 = new NSDictionary();
        for (Method method : objClass.getMethods()) {
            if (Modifier.isNative(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
            String name = method.getName();
            if (name.startsWith("get")) {
                name = NSObject.makeFirstCharLowercase(name.substring(3));
            } else {
                if (!name.startsWith("is")) continue;
                name = NSObject.makeFirstCharLowercase(name.substring(2));
            }
            try {
                result2.put(name, NSObject.fromJavaObject(method.invoke(object, new Object[0])));
            }
            catch (IllegalAccessException e2) {
                throw new IllegalArgumentException("Could not access getter " + method.getName());
            }
            catch (InvocationTargetException e3) {
                throw new IllegalArgumentException("Could not invoke getter " + method.getName());
            }
        }
        for (AccessibleObject accessibleObject : objClass.getFields()) {
            if (Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            try {
                result2.put(((Field)accessibleObject).getName(), NSObject.fromJavaObject(((Field)accessibleObject).get(object)));
            }
            catch (IllegalAccessException e4) {
                throw new IllegalArgumentException("Could not access field " + ((Field)accessibleObject).getName());
            }
        }
        return result2;
    }

    private static NSDictionary fromMap(Map<?, ?> map2) {
        NSDictionary result2 = new NSDictionary();
        for (Map.Entry<?, ?> entry : map2.entrySet()) {
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("Maps need a String key for mapping to NSDictionary.");
            }
            result2.put((String)entry.getKey(), NSObject.fromJavaObject(entry.getValue()));
        }
        return result2;
    }

    private static NSObject fromArray(Object object, Class<?> objClass) {
        Class<?> elementClass = objClass.getComponentType();
        if (elementClass == Byte.TYPE || elementClass == Byte.class) {
            return NSObject.fromData(object);
        }
        int size = Array.getLength(object);
        NSObject[] array = new NSObject[size];
        for (int i2 = 0; i2 < size; ++i2) {
            array[i2] = NSObject.fromJavaObject(Array.get(object, i2));
        }
        return new NSArray(array);
    }

    private static NSData fromData(Object object) {
        int size = Array.getLength(object);
        byte[] array = new byte[size];
        for (int i2 = 0; i2 < size; ++i2) {
            array[i2] = (Byte)Array.get(object, i2);
        }
        return new NSData(array);
    }

    private static NSArray fromCollection(Collection<?> collection) {
        ArrayList<NSObject> payload = new ArrayList<NSObject>(collection.size());
        for (Object elem : collection) {
            payload.add(NSObject.fromJavaObject(elem));
        }
        return new NSArray(payload.toArray(new NSObject[0]));
    }

    private static NSSet fromSet(Set<?> set) {
        NSSet result2 = new NSSet();
        for (Object elem : set) {
            result2.addObject(NSObject.fromJavaObject(elem));
        }
        return result2;
    }
}

