/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.AsyncUtils;
import com.jetbrains.jdi.ClassTypeImpl;
import com.jetbrains.jdi.CommandSender;
import com.jetbrains.jdi.JDWP;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.MethodImpl;
import com.jetbrains.jdi.MonitorInfoImpl;
import com.jetbrains.jdi.ObjectReferenceImpl;
import com.jetbrains.jdi.PacketStream;
import com.jetbrains.jdi.StackFrameImpl;
import com.jetbrains.jdi.ThreadAction;
import com.jetbrains.jdi.ThreadListener;
import com.jetbrains.jdi.VMAction;
import com.jetbrains.jdi.VMState;
import com.jetbrains.jdi.ValueImpl;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Location;
import com.sun.jdi.MonitorInfo;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.BreakpointRequest;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;

public class ThreadReferenceImpl
extends ObjectReferenceImpl
implements ThreadReference {
    static final int SUSPEND_STATUS_SUSPENDED = 1;
    static final int SUSPEND_STATUS_BREAK = 2;
    private int suspendedZombieCount = 0;
    private volatile ThreadGroupReference threadGroup;
    private volatile boolean isVirtual;
    private volatile boolean isVirtualCached;
    private volatile LocalCache localCache;
    private final List<WeakReference<ThreadListener>> listeners = new ArrayList<WeakReference<ThreadListener>>();

    private void resetLocalCache() {
        this.localCache = new LocalCache();
    }

    @Override
    protected ObjectReferenceImpl.Cache newCache() {
        return new Cache();
    }

    ThreadReferenceImpl(VirtualMachine aVm, long aRef) {
        super(aVm, aRef);
        this.resetLocalCache();
        this.vm.state().addListener(this);
    }

    @Override
    protected String description() {
        return "ThreadReference " + this.uniqueID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean vmNotSuspended(VMAction action) {
        if (action.resumingThread() == null) {
            VMState vMState = this.vm.state();
            synchronized (vMState) {
                this.processThreadAction(new ThreadAction(this, 2));
            }
        }
        return super.vmNotSuspended(action);
    }

    @Override
    public String name() {
        String name = null;
        try {
            Cache local = (Cache)this.getCache();
            if (local != null) {
                name = local.name;
            }
            if (name == null) {
                name = JDWP.ThreadReference.Name.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).threadName;
                if (local != null) {
                    local.name = name;
                }
            }
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        return name;
    }

    public CompletableFuture<String> nameAsync() {
        String name = null;
        Cache local = (Cache)this.getCache();
        if (local != null) {
            name = local.name;
        }
        if (name == null) {
            return JDWP.ThreadReference.Name.processAsync(this.vm, this).thenApply(res2 -> {
                Cache cache = (Cache)this.getCache();
                if (cache != null) {
                    cache.name = res2.threadName;
                }
                return res2.threadName;
            });
        }
        return CompletableFuture.completedFuture(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PacketStream sendResumingCommand(CommandSender sender2) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.processThreadAction(new ThreadAction(this, 2));
            return sender2.send();
        }
    }

    @Override
    public void suspend() {
        try {
            JDWP.ThreadReference.Suspend.process(this.vm, this);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    public CompletableFuture<Void> suspendAsync() {
        return JDWP.ThreadReference.Suspend.processAsync(this.vm, this).thenAccept(r2 -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        PacketStream stream;
        if (this.suspendedZombieCount > 0) {
            --this.suspendedZombieCount;
            return;
        }
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.processThreadAction(new ThreadAction(this, 2));
            stream = JDWP.ThreadReference.Resume.enqueueCommand(this.vm, this);
        }
        try {
            JDWP.ThreadReference.Resume.waitForReply(this.vm, stream);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> resumeAsync() {
        if (this.suspendedZombieCount > 0) {
            --this.suspendedZombieCount;
            return CompletableFuture.completedFuture(null);
        }
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.processThreadAction(new ThreadAction(this, 2));
            return JDWP.ThreadReference.Resume.processAsync(this.vm, this).thenAccept(__ -> {});
        }
    }

    @Override
    public int suspendCount() {
        if (this.suspendedZombieCount > 0) {
            return this.suspendedZombieCount;
        }
        try {
            return JDWP.ThreadReference.SuspendCount.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).suspendCount;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    @Override
    public void stop(ObjectReference throwable) throws InvalidTypeException {
        this.validateMirrorOrNull(throwable);
        List<ReferenceType> list = this.vm.classesByName("java.lang.Throwable");
        ClassTypeImpl throwableClass = (ClassTypeImpl)list.get(0);
        if (throwable == null || !throwableClass.isAssignableFrom(throwable)) {
            throw new InvalidTypeException("Not an instance of Throwable");
        }
        try {
            JDWP.ThreadReference.Stop.process(this.vm, this, (ObjectReferenceImpl)throwable);
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 32: {
                    assert (this.isVirtual());
                    throw new InvalidStackFrameException("Opaque frame");
                }
                case 13: {
                    assert (this.isVirtual());
                    throw new IllegalThreadStateException("virtual thread not suspended");
                }
                case 10: {
                    throw new IllegalThreadStateException("thread has terminated");
                }
            }
            throw exc.toJDIException();
        }
    }

    @Override
    public void interrupt() {
        try {
            JDWP.ThreadReference.Interrupt.process(this.vm, this);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    private JDWP.ThreadReference.Status jdwpStatus() {
        LocalCache snapshot2 = this.localCache;
        JDWP.ThreadReference.Status myStatus = snapshot2.status;
        try {
            if (myStatus == null) {
                myStatus = JDWP.ThreadReference.Status.process(this.vm, this);
                if ((myStatus.suspendStatus & 1) != 0) {
                    snapshot2.status = myStatus;
                }
            }
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        return myStatus;
    }

    private CompletableFuture<JDWP.ThreadReference.Status> jdwpStatusAsync() {
        LocalCache snapshot2 = this.localCache;
        JDWP.ThreadReference.Status myStatus = snapshot2.status;
        if (myStatus != null) {
            return CompletableFuture.completedFuture(myStatus);
        }
        return JDWP.ThreadReference.Status.processAsync(this.vm, this).thenApply(res2 -> {
            if ((res2.suspendStatus & 1) != 0) {
                snapshot2.status = res2;
            }
            return res2;
        });
    }

    @Override
    public int status() {
        return this.jdwpStatus().threadStatus;
    }

    public CompletableFuture<Integer> statusAsync() {
        return this.jdwpStatusAsync().thenApply(res2 -> res2.threadStatus);
    }

    @Override
    public boolean isSuspended() {
        return this.suspendedZombieCount > 0 || (this.jdwpStatus().suspendStatus & 1) != 0;
    }

    public CompletableFuture<Boolean> isSuspendedAsync() {
        if (this.suspendedZombieCount > 0) {
            return CompletableFuture.completedFuture(true);
        }
        return this.jdwpStatusAsync().thenApply(res2 -> (res2.suspendStatus & 1) != 0);
    }

    @Override
    public boolean isAtBreakpoint() {
        try {
            StackFrame frame = this.frame(0);
            Location location = frame.location();
            List<BreakpointRequest> requests = this.vm.eventRequestManager().breakpointRequests();
            for (BreakpointRequest request : requests) {
                if (!location.equals(request.location())) continue;
                return true;
            }
            return false;
        }
        catch (IndexOutOfBoundsException iobe) {
            return false;
        }
        catch (IncompatibleThreadStateException itse) {
            return false;
        }
    }

    public CompletableFuture<Boolean> isAtBreakpointAsync() {
        return ((CompletableFuture)this.frameAsync(0).thenApply(frame -> {
            Location location = frame.location();
            for (BreakpointRequest request : this.vm.eventRequestManager().breakpointRequests()) {
                if (!location.equals(request.location())) continue;
                return true;
            }
            return false;
        })).exceptionally(throwable -> {
            if ((throwable = AsyncUtils.unwrap(throwable)) instanceof IndexOutOfBoundsException) {
                return false;
            }
            if (throwable instanceof IncompatibleThreadStateException) {
                return false;
            }
            throw (RuntimeException)throwable;
        });
    }

    @Override
    public ThreadGroupReference threadGroup() {
        if (this.threadGroup == null) {
            try {
                this.threadGroup = JDWP.ThreadReference.ThreadGroup.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).group;
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        return this.threadGroup;
    }

    public CompletableFuture<ThreadGroupReference> threadGroupAsync() {
        if (this.threadGroup != null) {
            return CompletableFuture.completedFuture(this.threadGroup);
        }
        return JDWP.ThreadReference.ThreadGroup.processAsync(this.vm, this).thenApply(tg -> {
            this.threadGroup = tg.group;
            return this.threadGroup;
        });
    }

    @Override
    public int frameCount() throws IncompatibleThreadStateException {
        LocalCache snapshot2 = this.localCache;
        try {
            if (snapshot2.frameCount == -1) {
                snapshot2.frameCount = JDWP.ThreadReference.FrameCount.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).frameCount;
            }
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 10: 
                case 13: {
                    throw new IncompatibleThreadStateException();
                }
            }
            throw exc.toJDIException();
        }
        return snapshot2.frameCount;
    }

    public CompletableFuture<Integer> frameCountAsync() {
        LocalCache snapshot2 = this.localCache;
        if (snapshot2.frameCount != -1) {
            return CompletableFuture.completedFuture(snapshot2.frameCount);
        }
        return ((CompletableFuture)JDWP.ThreadReference.FrameCount.processAsync(this.vm, this).exceptionally(throwable -> {
            if (JDWPException.isOfType(throwable = AsyncUtils.unwrap(throwable), 13) || throwable instanceof IllegalThreadStateException) {
                throw new CompletionException(new IncompatibleThreadStateException());
            }
            throw (RuntimeException)throwable;
        })).thenApply(res2 -> {
            this.localCache.frameCount = res2.frameCount;
            return this.localCache.frameCount;
        });
    }

    @Override
    public List<StackFrame> frames() throws IncompatibleThreadStateException {
        return this.privateFrames(0, -1);
    }

    public CompletableFuture<List<StackFrame>> framesAsync() {
        return this.privateFramesAsync(0, -1);
    }

    @Override
    public StackFrame frame(int index) throws IncompatibleThreadStateException {
        List<StackFrame> list = this.privateFrames(index, 1);
        return list.get(0);
    }

    public CompletableFuture<StackFrame> frameAsync(int index) {
        return this.privateFramesAsync(index, 1).thenApply(list -> (StackFrame)list.get(0));
    }

    private boolean isSubrange(LocalCache snapshot2, int start, int length) {
        if (start < snapshot2.framesStart) {
            return false;
        }
        if (length == -1) {
            return snapshot2.framesLength == -1;
        }
        if (snapshot2.framesLength == -1) {
            if (start + length > snapshot2.framesStart + snapshot2.frames.size()) {
                throw new IndexOutOfBoundsException();
            }
            return true;
        }
        return start + length <= snapshot2.framesStart + snapshot2.framesLength;
    }

    @Override
    public List<StackFrame> frames(int start, int length) throws IncompatibleThreadStateException {
        if (length < 0) {
            throw new IndexOutOfBoundsException("length must be greater than or equal to zero");
        }
        return this.privateFrames(start, length);
    }

    public CompletableFuture<List<StackFrame>> framesAsync(int start, int length) {
        if (length < 0) {
            throw new IndexOutOfBoundsException("length must be greater than or equal to zero");
        }
        return this.privateFramesAsync(start, length);
    }

    private List<StackFrame> privateFrames(int start, int length) throws IncompatibleThreadStateException {
        LocalCache snapshot2 = this.localCache;
        List<StackFrame> frames = this.getCachedFrames(start, length, snapshot2);
        if (frames != null) {
            return frames;
        }
        try {
            JDWP.ThreadReference.Frames jdwpFrames = JDWP.ThreadReference.Frames.process(this.vm, this, start, length);
            return this.cacheFrames(start, length, snapshot2, jdwpFrames);
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 10: 
                case 13: {
                    throw new IncompatibleThreadStateException();
                }
            }
            throw exc.toJDIException();
        }
    }

    private synchronized CompletableFuture<List<StackFrame>> privateFramesAsync(int start, int length) {
        LocalCache snapshot2 = this.localCache;
        try {
            List<StackFrame> frames = this.getCachedFrames(start, length, snapshot2);
            if (frames != null) {
                return CompletableFuture.completedFuture(frames);
            }
        }
        catch (Exception e2) {
            return CompletableFuture.failedFuture(e2);
        }
        return ((CompletableFuture)JDWP.ThreadReference.Frames.processAsync(this.vm, this, start, length).exceptionally(throwable -> {
            if (JDWPException.isOfType(throwable = AsyncUtils.unwrap(throwable), 13) || throwable instanceof IllegalThreadStateException) {
                throw new CompletionException(new IncompatibleThreadStateException());
            }
            throw (RuntimeException)throwable;
        })).thenApply(jdwpFrames -> this.cacheFrames(start, length, snapshot2, (JDWP.ThreadReference.Frames)jdwpFrames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StackFrame> getCachedFrames(int start, int length, LocalCache snapshot2) {
        ThreadReferenceImpl threadReferenceImpl = this;
        synchronized (threadReferenceImpl) {
            if (snapshot2.frames != null && this.isSubrange(snapshot2, start, length)) {
                int fromIndex = start - snapshot2.framesStart;
                int toIndex = length == -1 ? snapshot2.frames.size() - fromIndex : fromIndex + length;
                return Collections.unmodifiableList(snapshot2.frames.subList(fromIndex, toIndex));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StackFrame> cacheFrames(int start, int length, LocalCache snapshot2, JDWP.ThreadReference.Frames jdwpFrames) {
        ThreadReferenceImpl threadReferenceImpl = this;
        synchronized (threadReferenceImpl) {
            snapshot2.frames = Arrays.stream(jdwpFrames.frames).map(jdwpFrame -> {
                if (jdwpFrame.location == null) {
                    throw new InternalException("Invalid frame location");
                }
                return new StackFrameImpl(this.vm, this, jdwpFrame.frameID, jdwpFrame.location);
            }).collect(Collectors.toList());
            snapshot2.framesStart = start;
            snapshot2.framesLength = length;
            return Collections.unmodifiableList(snapshot2.frames);
        }
    }

    @Override
    public List<ObjectReference> ownedMonitors() throws IncompatibleThreadStateException {
        LocalCache snapshot2 = this.localCache;
        try {
            if (snapshot2.ownedMonitors == null) {
                snapshot2.ownedMonitors = Arrays.asList(JDWP.ThreadReference.OwnedMonitors.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).owned);
                if ((this.vm.traceFlags & 0x10) != 0) {
                    this.vm.printTrace(this.description() + " temporarily caching owned monitors (count = " + snapshot2.ownedMonitors.size() + ")");
                }
            }
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 10: 
                case 13: {
                    throw new IncompatibleThreadStateException();
                }
            }
            throw exc.toJDIException();
        }
        return snapshot2.ownedMonitors;
    }

    @Override
    public ObjectReference currentContendedMonitor() throws IncompatibleThreadStateException {
        LocalCache snapshot2 = this.localCache;
        try {
            if (snapshot2.contendedMonitor == null && !snapshot2.triedCurrentContended) {
                snapshot2.contendedMonitor = JDWP.ThreadReference.CurrentContendedMonitor.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).monitor;
                snapshot2.triedCurrentContended = true;
                if (snapshot2.contendedMonitor != null && (this.vm.traceFlags & 0x10) != 0) {
                    this.vm.printTrace(this.description() + " temporarily caching contended monitor (id = " + snapshot2.contendedMonitor.uniqueID() + ")");
                }
            }
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 10: 
                case 13: {
                    throw new IncompatibleThreadStateException();
                }
            }
            throw exc.toJDIException();
        }
        return snapshot2.contendedMonitor;
    }

    @Override
    public List<MonitorInfo> ownedMonitorsAndFrames() throws IncompatibleThreadStateException {
        LocalCache snapshot2 = this.localCache;
        try {
            if (snapshot2.ownedMonitorsInfo == null) {
                JDWP.ThreadReference.OwnedMonitorsStackDepthInfo.monitor[] minfo = JDWP.ThreadReference.OwnedMonitorsStackDepthInfo.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).owned;
                snapshot2.ownedMonitorsInfo = new ArrayList<MonitorInfo>(minfo.length);
                for (JDWP.ThreadReference.OwnedMonitorsStackDepthInfo.monitor monitor2 : minfo) {
                    MonitorInfoImpl mon = new MonitorInfoImpl(this.vm, monitor2.monitor, this, monitor2.stack_depth);
                    snapshot2.ownedMonitorsInfo.add(mon);
                }
                if ((this.vm.traceFlags & 0x10) != 0) {
                    this.vm.printTrace(this.description() + " temporarily caching owned monitors (count = " + snapshot2.ownedMonitorsInfo.size() + ")");
                }
            }
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 10: 
                case 13: {
                    throw new IncompatibleThreadStateException();
                }
            }
            throw exc.toJDIException();
        }
        return snapshot2.ownedMonitorsInfo;
    }

    @Override
    public void popFrames(StackFrame frame) throws IncompatibleThreadStateException {
        if (!frame.thread().equals(this)) {
            throw new IllegalArgumentException("frame does not belong to this thread");
        }
        if (!this.vm.canPopFrames()) {
            throw new UnsupportedOperationException("target does not support popping frames");
        }
        ((StackFrameImpl)frame).pop();
    }

    @Override
    public void forceEarlyReturn(Value returnValue) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException {
        StackFrameImpl sf;
        if (!this.vm.canForceEarlyReturn()) {
            throw new UnsupportedOperationException("target does not support the forcing of a method to return early");
        }
        this.validateMirrorOrNull(returnValue);
        try {
            sf = (StackFrameImpl)this.frame(0);
        }
        catch (IndexOutOfBoundsException exc) {
            throw new InvalidStackFrameException("No more frames on the stack");
        }
        sf.validateStackFrame();
        MethodImpl meth = (MethodImpl)sf.location().method();
        ValueImpl convertedValue = ThreadReferenceImpl.prepareForAssignment(returnValue, meth.getReturnValueContainer());
        try {
            JDWP.ThreadReference.ForceEarlyReturn.process(this.vm, this, convertedValue);
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 32: {
                    if (this.isVirtual() && !meth.isNative()) {
                        throw new InvalidStackFrameException("Opaque frame");
                    }
                    throw new NativeMethodException();
                }
                case 13: {
                    throw new IncompatibleThreadStateException("Thread not suspended");
                }
                case 15: {
                    throw new IncompatibleThreadStateException("Thread has not started or has finished");
                }
                case 31: {
                    throw new InvalidStackFrameException("No more frames on the stack");
                }
            }
            throw exc.toJDIException();
        }
    }

    @Override
    public boolean isVirtual() {
        if (this.isVirtualCached) {
            return this.isVirtual;
        }
        boolean result2 = false;
        if (this.vm.mayCreateVirtualThreads()) {
            try {
                result2 = JDWP.ThreadReference.IsVirtual.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).isVirtual;
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        this.isVirtual = result2;
        this.isVirtualCached = true;
        return result2;
    }

    @Override
    public String toString() {
        return "instance of " + this.referenceType().name() + "(name='" + this.name() + "', id=" + this.uniqueID() + ")";
    }

    @Override
    byte typeValueKey() {
        return 116;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(ThreadListener listener) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.listeners.add(new WeakReference<ThreadListener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processThreadAction(ThreadAction action) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            Iterator<WeakReference<ThreadListener>> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ThreadListener listener = (ThreadListener)iter.next().get();
                if (listener != null) {
                    if (action.id() != 2 || listener.threadResumable(action)) continue;
                    iter.remove();
                    continue;
                }
                iter.remove();
            }
            this.resetLocalCache();
        }
    }

    private static class LocalCache {
        JDWP.ThreadReference.Status status = null;
        List<StackFrame> frames = null;
        int framesStart = -1;
        int framesLength = 0;
        int frameCount = -1;
        List<ObjectReference> ownedMonitors = null;
        List<MonitorInfo> ownedMonitorsInfo = null;
        ObjectReference contendedMonitor = null;
        boolean triedCurrentContended = false;

        private LocalCache() {
        }
    }

    private static class Cache
    extends ObjectReferenceImpl.Cache {
        volatile String name = null;

        private Cache() {
        }
    }
}

