/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorContext;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.BuildersKt;
import org.jetbrains.kotlin.ir.declarations.impl.IrVariableImpl;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrStringConcatenationImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0002@AB;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ3\u0010\u001c\u001a\u0002H\u001d\"\b\b\u0000\u0010\u001d*\u00020\u001e*\u0002H\u001d2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020!0 H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J\u0014\u0010(\u001a\u00020)*\u00020*2\u0006\u0010+\u001a\u00020,H\u0014J \u0010-\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020*2\u0006\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020)H\u0014J\u001c\u0010-\u001a\u00020)*\u00020*2\u0006\u00100\u001a\u0002012\u0006\u0010/\u001a\u00020)H\u0004J\u0010\u00105\u001a\u00020!2\u0006\u00106\u001a\u000207H&J\u0010\u00108\u001a\u0002012\u0006\u0010.\u001a\u00020%H\u0016J\u0010\u00108\u001a\u0002012\u0006\u0010#\u001a\u00020$H&J\f\u00109\u001a\u00020:*\u00020\u0007H\u0016J\f\u0010;\u001a\u00020\r*\u00020<H$J\u0012\u0010=\u001a\b\u0012\u0004\u0012\u00020$0>*\u00020?H$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010#\u001a\u00020$*\u00020%8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0017\u00102\u001a\u00020\r*\u0004\u0018\u0001038F\u00a2\u0006\u0006\u001a\u0004\b2\u00104\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/ir/util/DataClassMembersGenerator;", "", "context", "Lorg/jetbrains/kotlin/ir/builders/IrGeneratorContext;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "forbidDirectFieldAccess", "", "<init>", "(Lorg/jetbrains/kotlin/ir/builders/IrGeneratorContext;Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;Z)V", "getContext", "()Lorg/jetbrains/kotlin/ir/builders/IrGeneratorContext;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getOrigin", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "getForbidDirectFieldAccess", "()Z", "buildWithScope", "T", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "builder", "Lkotlin/Function1;", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getType", "(Lorg/jetbrains/kotlin/ir/declarations/IrProperty;)Lorg/jetbrains/kotlin/ir/types/IrType;", "shiftResultOfHashCode", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "irResultVar", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "getHashCodeOf", "property", "irValue", "hashCodeFunctionInfo", "Lorg/jetbrains/kotlin/ir/util/DataClassMembersGenerator$HashCodeFunctionInfo;", "isArrayOrPrimitiveArray", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;)Z", "generateSyntheticFunctionParameterDeclarations", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getHashCodeFunctionInfo", "classNameForToString", "", "hasDispatchReceiver", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "typesOfTypeParameters", "", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "MemberFunctionBuilder", "HashCodeFunctionInfo", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nDataClassMembersGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataClassMembersGenerator.kt\norg/jetbrains/kotlin/ir/util/DataClassMembersGenerator\n+ 2 SymbolTable.kt\norg/jetbrains/kotlin/ir/util/SymbolTableKt\n*L\n1#1,408:1\n503#2,4:409\n*S KotlinDebug\n*F\n+ 1 DataClassMembersGenerator.kt\norg/jetbrains/kotlin/ir/util/DataClassMembersGenerator\n*L\n47#1:409,4\n*E\n"})
public abstract class DataClassMembersGenerator {
    @NotNull
    private final IrGeneratorContext context;
    @NotNull
    private final ReferenceSymbolTable symbolTable;
    @NotNull
    private final IrClass irClass;
    @Nullable
    private final FqName fqName;
    @NotNull
    private final IrDeclarationOrigin origin;
    private final boolean forbidDirectFieldAccess;

    public DataClassMembersGenerator(@NotNull IrGeneratorContext context2, @NotNull ReferenceSymbolTable symbolTable, @NotNull IrClass irClass, @Nullable FqName fqName, @NotNull IrDeclarationOrigin origin, boolean forbidDirectFieldAccess) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        this.context = context2;
        this.symbolTable = symbolTable;
        this.irClass = irClass;
        this.fqName = fqName;
        this.origin = origin;
        this.forbidDirectFieldAccess = forbidDirectFieldAccess;
    }

    public /* synthetic */ DataClassMembersGenerator(IrGeneratorContext irGeneratorContext, ReferenceSymbolTable referenceSymbolTable, IrClass irClass, FqName fqName, IrDeclarationOrigin irDeclarationOrigin, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(irGeneratorContext, referenceSymbolTable, irClass, fqName, irDeclarationOrigin, bl);
    }

    @NotNull
    public final IrGeneratorContext getContext() {
        return this.context;
    }

    @NotNull
    public final ReferenceSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @NotNull
    public final IrClass getIrClass() {
        return this.irClass;
    }

    @Nullable
    public final FqName getFqName() {
        return this.fqName;
    }

    @NotNull
    public final IrDeclarationOrigin getOrigin() {
        return this.origin;
    }

    public final boolean getForbidDirectFieldAccess() {
        return this.forbidDirectFieldAccess;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends IrDeclaration> T buildWithScope(@NotNull T $this$buildWithScope, @NotNull Function1<? super T, Unit> builder) {
        void $this$withReferenceScope$iv;
        T t;
        Intrinsics.checkNotNullParameter($this$buildWithScope, (String)"<this>");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        boolean $i$f$buildWithScope = false;
        T irDeclaration = t = $this$buildWithScope;
        boolean bl = false;
        ReferenceSymbolTable referenceSymbolTable = this.getSymbolTable();
        T owner$iv = irDeclaration;
        boolean $i$f$withReferenceScope = false;
        $this$withReferenceScope$iv.enterScope(owner$iv);
        void $this$buildWithScope_u24lambda_u240_u240 = $this$withReferenceScope$iv;
        boolean bl2 = false;
        builder.invoke(irDeclaration);
        Unit result$iv = Unit.INSTANCE;
        $this$withReferenceScope$iv.leaveScope(owner$iv);
        return t;
    }

    @NotNull
    protected final IrType getType(@NotNull IrProperty $this$type) {
        Intrinsics.checkNotNullParameter((Object)$this$type, (String)"<this>");
        IrAnnotationContainer irAnnotationContainer = $this$type.getBackingField();
        if (irAnnotationContainer == null || (irAnnotationContainer = irAnnotationContainer.getType()) == null) {
            IrSimpleFunction irSimpleFunction = $this$type.getGetter();
            if (irSimpleFunction != null) {
                irAnnotationContainer = irSimpleFunction.getReturnType();
            } else {
                throw new IllegalStateException(("Can't find type of " + RenderIrElementKt.render$default($this$type, null, 1, null)).toString());
            }
        }
        return irAnnotationContainer;
    }

    @NotNull
    protected IrExpression shiftResultOfHashCode(@NotNull IrBuilderWithScope $this$shiftResultOfHashCode, @NotNull IrVariable irResultVar) {
        IrCallImpl irCallImpl;
        Intrinsics.checkNotNullParameter((Object)$this$shiftResultOfHashCode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)irResultVar, (String)"irResultVar");
        int n = $this$shiftResultOfHashCode.getStartOffset();
        int n2 = $this$shiftResultOfHashCode.getEndOffset();
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = $this$shiftResultOfHashCode.getContext().getIrBuiltIns().getIntTimesSymbol();
        IrType irType = $this$shiftResultOfHashCode.getContext().getIrBuiltIns().getIntType();
        IrCallImpl $this$shiftResultOfHashCode_u24lambda_u240 = irCallImpl = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrCallImplWithShape$default(n, n2, irType, irSimpleFunctionSymbol, 0, 1, 0, true, false, null, null, 1536, null);
        boolean bl = false;
        $this$shiftResultOfHashCode_u24lambda_u240.getArguments().set(0, ExpressionHelpersKt.irGet($this$shiftResultOfHashCode, irResultVar));
        $this$shiftResultOfHashCode_u24lambda_u240.getArguments().set(1, ExpressionHelpersKt.irInt$default($this$shiftResultOfHashCode, 31, null, 2, null));
        return irCallImpl;
    }

    @NotNull
    protected IrExpression getHashCodeOf(@NotNull IrBuilderWithScope builder, @NotNull IrProperty property, @NotNull IrExpression irValue) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)irValue, (String)"irValue");
        return this.getHashCodeOf(builder, this.getHashCodeFunctionInfo(property), irValue);
    }

    @NotNull
    protected final IrExpression getHashCodeOf(@NotNull IrBuilderWithScope $this$getHashCodeOf, @NotNull HashCodeFunctionInfo hashCodeFunctionInfo, @NotNull IrExpression irValue) {
        IrCallImpl irCallImpl;
        Intrinsics.checkNotNullParameter((Object)$this$getHashCodeOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hashCodeFunctionInfo, (String)"hashCodeFunctionInfo");
        Intrinsics.checkNotNullParameter((Object)irValue, (String)"irValue");
        IrSimpleFunctionSymbol hashCodeFunctionSymbol = hashCodeFunctionInfo.getSymbol();
        Boolean bl = hashCodeFunctionInfo.getHasDispatchReceiver();
        boolean hasDispatchReceiver = bl != null ? bl.booleanValue() : this.hasDispatchReceiver(hashCodeFunctionSymbol);
        int n = $this$getHashCodeOf.getStartOffset();
        int n2 = $this$getHashCodeOf.getEndOffset();
        IrType irType = $this$getHashCodeOf.getContext().getIrBuiltIns().getIntType();
        int n3 = hasDispatchReceiver ? 0 : 1;
        IrCallImpl $this$getHashCodeOf_u24lambda_u240 = irCallImpl = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrCallImplWithShape$default(n, n2, irType, hashCodeFunctionSymbol, 0, n3, 0, hasDispatchReceiver, false, null, null, 1536, null);
        boolean bl2 = false;
        $this$getHashCodeOf_u24lambda_u240.getArguments().set(0, irValue);
        hashCodeFunctionInfo.commitSubstituted($this$getHashCodeOf_u24lambda_u240);
        return irCallImpl;
    }

    public final boolean isArrayOrPrimitiveArray(@Nullable IrClassifierSymbol $this$isArrayOrPrimitiveArray) {
        return AdditionalIrUtilsKt.isArrayOrPrimitiveArray($this$isArrayOrPrimitiveArray, this.context.getIrBuiltIns());
    }

    public abstract void generateSyntheticFunctionParameterDeclarations(@NotNull IrFunction var1);

    @NotNull
    public HashCodeFunctionInfo getHashCodeFunctionInfo(@NotNull IrProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return this.getHashCodeFunctionInfo(this.getType(property));
    }

    @NotNull
    public abstract HashCodeFunctionInfo getHashCodeFunctionInfo(@NotNull IrType var1);

    @NotNull
    public String classNameForToString(@NotNull IrClass $this$classNameForToString) {
        Intrinsics.checkNotNullParameter((Object)$this$classNameForToString, (String)"<this>");
        String string = this.irClass.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    protected abstract boolean hasDispatchReceiver(@NotNull IrSimpleFunctionSymbol var1);

    @NotNull
    protected abstract List<IrType> typesOfTypeParameters(@NotNull IrConstructorSymbol var1);

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0014\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/util/DataClassMembersGenerator$HashCodeFunctionInfo;", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "hasDispatchReceiver", "", "getHasDispatchReceiver", "()Ljava/lang/Boolean;", "commitSubstituted", "", "irMemberAccessExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "ir.tree"})
    public static interface HashCodeFunctionInfo {
        @NotNull
        public IrSimpleFunctionSymbol getSymbol();

        @Nullable
        public Boolean getHasDispatchReceiver();

        public void commitSubstituted(@NotNull IrMemberAccessExpression<?> var1);

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @Nullable
            public static Boolean getHasDispatchReceiver(@NotNull HashCodeFunctionInfo $this) {
                return null;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u0084\u0004\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ/\u0010\u000b\u001a\u00020\u00062!\u0010\f\u001a\u001d\u0012\b\u0012\u00060\u0000R\u00020\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u0010H\u0086\b\u00f8\u0001\u0000J/\u0010\u0011\u001a\u00020\u000f2!\u0010\f\u001a\u001d\u0012\b\u0012\u00060\u0000R\u00020\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u0010H\u0086\b\u00f8\u0001\u0000J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u0016\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0018J\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dJ\f\u0010\u001e\u001a\u00020\u001f*\u00020 H\u0002J\u0014\u0010!\u001a\u00020\u000f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180#J\u001c\u0010$\u001a\u00020\u000f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180#2\u0006\u0010%\u001a\u00020\u0003J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u0010'\u001a\u00020\u000f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180#R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/ir/util/DataClassMembersGenerator$MemberFunctionBuilder;", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "startOffset", "", "endOffset", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "<init>", "(Lorg/jetbrains/kotlin/ir/util/DataClassMembersGenerator;IILorg/jetbrains/kotlin/ir/declarations/IrFunction;)V", "getIrFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "addToClass", "builder", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/ir/util/DataClassMembersGenerator;", "", "Lkotlin/ExtensionFunctionType;", "build", "irThis", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "irOther", "irGetProperty", "receiver", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "generateComponentFunction", "irProperty", "generateCopyFunction", "constructorSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "isTypedEqualsInValueClass", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "generateEqualsMethodBody", "properties", "", "generateHashCodeMethodBody", "constHashCode", "getHashCodeOfProperty", "generateToStringMethodBody", "ir.tree"})
    @SourceDebugExtension(value={"SMAP\nDataClassMembersGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataClassMembersGenerator.kt\norg/jetbrains/kotlin/ir/util/DataClassMembersGenerator$MemberFunctionBuilder\n+ 2 DataClassMembersGenerator.kt\norg/jetbrains/kotlin/ir/util/DataClassMembersGenerator\n+ 3 SymbolTable.kt\norg/jetbrains/kotlin/ir/util/SymbolTableKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,408:1\n67#1:409\n68#1,3:415\n71#1:422\n46#2,2:410\n48#2:414\n49#2:418\n50#2:421\n46#2,2:423\n48#2,2:427\n50#2:431\n503#3,2:412\n505#3,2:419\n503#3,2:425\n505#3,2:429\n386#4,11:432\n*S KotlinDebug\n*F\n+ 1 DataClassMembersGenerator.kt\norg/jetbrains/kotlin/ir/util/DataClassMembersGenerator$MemberFunctionBuilder\n*L\n61#1:409\n61#1:415,3\n61#1:422\n61#1:410,2\n61#1:414\n61#1:418\n61#1:421\n67#1:423,2\n67#1:427,2\n67#1:431\n61#1:412,2\n61#1:419,2\n67#1:425,2\n67#1:429,2\n135#1:432,11\n*E\n"})
    protected final class MemberFunctionBuilder
    extends IrBlockBodyBuilder {
        @NotNull
        private final IrFunction irFunction;
        final /* synthetic */ DataClassMembersGenerator this$0;

        public MemberFunctionBuilder(DataClassMembersGenerator this$0, int startOffset, @NotNull int endOffset, IrFunction irFunction) {
            Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
            this.this$0 = this$0;
            super(this$0.getContext(), new Scope(irFunction.getSymbol()), startOffset, endOffset);
            this.irFunction = irFunction;
        }

        public /* synthetic */ MemberFunctionBuilder(DataClassMembersGenerator dataClassMembersGenerator, int n, int n2, IrFunction irFunction, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = -2;
            }
            if ((n3 & 2) != 0) {
                n2 = -2;
            }
            this(dataClassMembersGenerator, n, n2, irFunction);
        }

        @NotNull
        public final IrFunction getIrFunction() {
            return this.irFunction;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IrFunction addToClass(@NotNull Function2<? super MemberFunctionBuilder, ? super IrFunction, Unit> builder) {
            void $this$withReferenceScope$iv$iv$iv;
            void this_$iv$iv;
            IrDeclaration irDeclaration;
            Intrinsics.checkNotNullParameter(builder, (String)"builder");
            boolean $i$f$addToClass = false;
            MemberFunctionBuilder this_$iv = this;
            boolean $i$f$build = false;
            DataClassMembersGenerator dataClassMembersGenerator = this_$iv.this$0;
            IrDeclaration $this$buildWithScope$iv$iv = this_$iv.getIrFunction();
            boolean $i$f$buildWithScope = false;
            IrDeclaration irDeclaration$iv$iv = irDeclaration = $this$buildWithScope$iv$iv;
            boolean bl = false;
            ReferenceSymbolTable referenceSymbolTable = this_$iv$iv.getSymbolTable();
            IrDeclaration owner$iv$iv$iv = irDeclaration$iv$iv;
            boolean $i$f$withReferenceScope = false;
            $this$withReferenceScope$iv$iv$iv.enterScope(owner$iv$iv$iv);
            void $this$buildWithScope_u24lambda_u240_u240$iv$iv = $this$withReferenceScope$iv$iv$iv;
            boolean bl2 = false;
            IrFunction it$iv = (IrFunction)irDeclaration$iv$iv;
            boolean bl3 = false;
            builder.invoke((Object)this_$iv, (Object)this_$iv.getIrFunction());
            this_$iv.getIrFunction().setBody(this_$iv.doBuild());
            Unit result$iv$iv$iv = Unit.INSTANCE;
            $this$withReferenceScope$iv$iv$iv.leaveScope(owner$iv$iv$iv);
            this.this$0.getIrClass().getDeclarations().add(this.getIrFunction());
            return this.getIrFunction();
        }

        /*
         * WARNING - void declaration
         */
        public final void build(@NotNull Function2<? super MemberFunctionBuilder, ? super IrFunction, Unit> builder) {
            void $this$withReferenceScope$iv$iv;
            void this_$iv;
            IrDeclaration irDeclaration;
            Intrinsics.checkNotNullParameter(builder, (String)"builder");
            boolean $i$f$build = false;
            DataClassMembersGenerator dataClassMembersGenerator = this.this$0;
            IrDeclaration $this$buildWithScope$iv = this.getIrFunction();
            boolean $i$f$buildWithScope = false;
            IrDeclaration irDeclaration$iv = irDeclaration = $this$buildWithScope$iv;
            boolean bl = false;
            ReferenceSymbolTable referenceSymbolTable = this_$iv.getSymbolTable();
            IrDeclaration owner$iv$iv = irDeclaration$iv;
            boolean $i$f$withReferenceScope = false;
            $this$withReferenceScope$iv$iv.enterScope(owner$iv$iv);
            void $this$buildWithScope_u24lambda_u240_u240$iv = $this$withReferenceScope$iv$iv;
            boolean bl2 = false;
            IrFunction it = (IrFunction)irDeclaration$iv;
            boolean bl3 = false;
            builder.invoke((Object)this, (Object)this.getIrFunction());
            this.getIrFunction().setBody(this.doBuild());
            Unit result$iv$iv = Unit.INSTANCE;
            $this$withReferenceScope$iv$iv.leaveScope(owner$iv$iv);
        }

        @NotNull
        public final IrExpression irThis() {
            IrValueParameter irValueParameter = this.irFunction.getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter);
            IrValueParameter irDispatchReceiverParameter = irValueParameter;
            return org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrGetValueImpl$default(this.getStartOffset(), this.getEndOffset(), irDispatchReceiverParameter.getType(), irDispatchReceiverParameter.getSymbol(), null, 16, null);
        }

        private final IrExpression irOther() {
            IrValueParameter irFirstParameter = this.irFunction.getParameters().get(1);
            return org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrGetValueImpl$default(this.getStartOffset(), this.getEndOffset(), irFirstParameter.getType(), irFirstParameter.getSymbol(), null, 16, null);
        }

        @NotNull
        public final IrExpression irGetProperty(@NotNull IrExpression receiver, @NotNull IrProperty property) {
            IrExpression irExpression;
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            IrField backingField = property.getBackingField();
            if (!this.this$0.getForbidDirectFieldAccess() && IrUtilsKt.isFinalClass(this.this$0.getIrClass()) && backingField != null) {
                irExpression = ExpressionHelpersKt.irGetField$default(this, receiver, backingField, null, 4, null);
            } else {
                IrFunctionAccessExpression irFunctionAccessExpression;
                IrBuilder irBuilder = this;
                IrSimpleFunction irSimpleFunction = property.getGetter();
                Intrinsics.checkNotNull((Object)irSimpleFunction);
                IrFunctionAccessExpression $this$irGetProperty_u24lambda_u240 = irFunctionAccessExpression = ExpressionHelpersKt.irCall(irBuilder, irSimpleFunction);
                boolean bl = false;
                $this$irGetProperty_u24lambda_u240.getArguments().set(0, receiver);
                irExpression = irFunctionAccessExpression;
            }
            return irExpression;
        }

        public final void generateComponentFunction(@NotNull IrProperty irProperty) {
            Intrinsics.checkNotNullParameter((Object)irProperty, (String)"irProperty");
            this.unaryPlus(ExpressionHelpersKt.irReturn(this, this.irGetProperty(this.irThis(), irProperty)));
        }

        /*
         * WARNING - void declaration
         */
        public final void generateCopyFunction(@NotNull IrConstructorSymbol constructorSymbol) {
            void $this$generateCopyFunction_u24lambda_u240;
            Intrinsics.checkNotNullParameter((Object)constructorSymbol, (String)"constructorSymbol");
            IrConstructorCall irConstructorCall = ExpressionHelpersKt.irCall((IrBuilder)this, constructorSymbol, (IrType)IrUtilsKt.getDefaultType(this.this$0.getIrClass()), this.this$0.getIrClass());
            DataClassMembersGenerator dataClassMembersGenerator = this.this$0;
            IrConstructorCall irConstructorCall2 = irConstructorCall;
            IrBuilderWithScope irBuilderWithScope = this;
            MemberFunctionBuilder memberFunctionBuilder = this;
            boolean bl = false;
            Iterator<Object> iterator = ((Iterable)dataClassMembersGenerator.typesOfTypeParameters(constructorSymbol)).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int i = n++;
                IrType typeParameterType = (IrType)iterator.next();
                $this$generateCopyFunction_u24lambda_u240.getTypeArguments().set(i, typeParameterType);
            }
            for (IrValueParameter param : IrUtilsKt.getNonDispatchParameters(this.irFunction)) {
                $this$generateCopyFunction_u24lambda_u240.getArguments().set(param.getIndexInParameters() - 1, ExpressionHelpersKt.irGet((IrBuilder)this, param.getType(), param.getSymbol()));
            }
            Unit unit = Unit.INSTANCE;
            memberFunctionBuilder.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, irConstructorCall));
        }

        private final boolean isTypedEqualsInValueClass(IrSimpleFunction $this$isTypedEqualsInValueClass) {
            return Intrinsics.areEqual((Object)$this$isTypedEqualsInValueClass.getName(), (Object)OperatorNameConventions.EQUALS) && this.this$0.getIrClass().isValue() && IrUtilsKt.hasShape$default($this$isTypedEqualsInValueClass, true, false, 0, 1, null, 22, null) && Intrinsics.areEqual((Object)IrTypesKt.getClassifierOrNull($this$isTypedEqualsInValueClass.getParameters().get(1).getType()), (Object)this.this$0.getIrClass().getSymbol());
        }

        /*
         * WARNING - void declaration
         */
        public final void generateEqualsMethodBody(@NotNull List<? extends IrProperty> properties) {
            IrFunctionAccessExpression irFunctionAccessExpression;
            IrElementBase it;
            IrFunctionAccessExpression single$iv;
            IrSimpleType irType;
            block5: {
                Intrinsics.checkNotNullParameter(properties, (String)"properties");
                irType = IrUtilsKt.getDefaultType(this.this$0.getIrClass());
                Sequence<IrSimpleFunction> $this$singleOrNull$iv = IrUtilsKt.getFunctions(this.this$0.getIrClass());
                boolean $i$f$singleOrNull = false;
                single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    it = (IrSimpleFunction)element$iv;
                    boolean bl = false;
                    if (!this.isTypedEqualsInValueClass((IrSimpleFunction)it)) continue;
                    if (found$iv) {
                        irFunctionAccessExpression = null;
                        break block5;
                    }
                    single$iv = (IrFunctionAccessExpression)element$iv;
                    found$iv = true;
                }
                irFunctionAccessExpression = !found$iv ? null : single$iv;
            }
            IrSimpleFunction typedEqualsFunction = (IrSimpleFunction)((Object)irFunctionAccessExpression);
            if (this.this$0.getIrClass().isValue() && typedEqualsFunction != null) {
                void $this$generateEqualsMethodBody_u24lambda_u241;
                IrFunctionAccessExpression irFunctionAccessExpression2;
                this.unaryPlus(ExpressionHelpersKt.irIfThenReturnFalse(this, ExpressionHelpersKt.irNotIs(this, this.irOther(), irType)));
                IrTypeOperatorCallImpl otherCasted = ExpressionHelpersKt.irImplicitCast(this, this.irOther(), irType);
                single$iv = irFunctionAccessExpression2 = ExpressionHelpersKt.irCall((IrBuilder)this, typedEqualsFunction);
                IrBuilderWithScope irBuilderWithScope = this;
                MemberFunctionBuilder memberFunctionBuilder = this;
                boolean bl = false;
                $this$generateEqualsMethodBody_u24lambda_u241.getArguments().set(0, this.irThis());
                $this$generateEqualsMethodBody_u24lambda_u241.getArguments().set(1, otherCasted);
                Unit unit = Unit.INSTANCE;
                memberFunctionBuilder.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, irFunctionAccessExpression2));
                return;
            }
            if (!this.this$0.getIrClass().isValue()) {
                this.unaryPlus(ExpressionHelpersKt.irIfThenReturnTrue(this, ExpressionHelpersKt.irEqeqeq(this, this.irThis(), this.irOther())));
            }
            this.unaryPlus(ExpressionHelpersKt.irIfThenReturnFalse(this, ExpressionHelpersKt.irNotIs(this, this.irOther(), irType)));
            IrVariable otherWithCast = ExpressionHelpersKt.irTemporary$default(this, ExpressionHelpersKt.irImplicitCast(this, this.irOther(), irType), "other_with_cast", null, false, null, 28, null);
            for (IrProperty property : properties) {
                void $this$generateEqualsMethodBody_u24lambda_u242;
                IrExpression arg1 = this.irGetProperty(this.irThis(), property);
                IrExpression arg2 = this.irGetProperty(ExpressionHelpersKt.irGet((IrBuilder)this, irType, otherWithCast.getSymbol()), property);
                IrCallImpl irCallImpl = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrCallImplWithShape$default(this.getStartOffset(), this.getEndOffset(), this.getContext().getIrBuiltIns().getBooleanType(), this.getContext().getIrBuiltIns().getBooleanNotSymbol(), 0, 0, 0, true, false, IrStatementOrigin.Companion.getEXCLEQ(), null, 1024, null);
                it = irCallImpl;
                IrBuilderWithScope irBuilderWithScope = this;
                MemberFunctionBuilder memberFunctionBuilder = this;
                boolean bl = false;
                $this$generateEqualsMethodBody_u24lambda_u242.getArguments().set(0, ExpressionHelpersKt.irEquals(this, arg1, arg2, IrStatementOrigin.Companion.getEXCLEQ()));
                Unit unit = Unit.INSTANCE;
                memberFunctionBuilder.unaryPlus(ExpressionHelpersKt.irIfThenReturnFalse(irBuilderWithScope, irCallImpl));
            }
            this.unaryPlus(ExpressionHelpersKt.irReturnTrue(this));
        }

        public final void generateHashCodeMethodBody(@NotNull List<? extends IrProperty> properties, int constHashCode) {
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            if (properties.isEmpty()) {
                this.unaryPlus(ExpressionHelpersKt.irReturn(this, ExpressionHelpersKt.irInt$default(this, constHashCode, null, 2, null)));
                return;
            }
            if (properties.size() == 1) {
                this.unaryPlus(ExpressionHelpersKt.irReturn(this, this.getHashCodeOfProperty(properties.get(0))));
                return;
            }
            IrType irIntType = this.getContext().getIrBuiltIns().getIntType();
            int n = this.getStartOffset();
            int n2 = this.getEndOffset();
            IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.Companion.getDEFINED();
            IrVariableSymbol irVariableSymbol = new IrVariableSymbolImpl(null, 1, null);
            Name name = Name.identifier((String)"result");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
            IrVariableImpl irVariableImpl = BuildersKt.IrVariableImpl(n, n2, irDeclarationOrigin, irVariableSymbol, name, irIntType, true, false, false);
            IrVariableImpl it = irVariableImpl;
            boolean bl = false;
            it.setParent(this.irFunction);
            it.setInitializer(this.getHashCodeOfProperty(properties.get(0)));
            IrVariableImpl irResultVar = irVariableImpl;
            this.unaryPlus(irResultVar);
            for (IrProperty property : CollectionsKt.drop((Iterable)properties, (int)1)) {
                IrCallImpl irCallImpl;
                IrExpression shiftedResult = this.this$0.shiftResultOfHashCode(this, irResultVar);
                IrCallImpl $this$generateHashCodeMethodBody_u24lambda_u241 = irCallImpl = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrCallImplWithShape$default(this.getStartOffset(), this.getEndOffset(), irIntType, this.getContext().getIrBuiltIns().getIntPlusSymbol(), 0, 1, 0, true, false, null, null, 1536, null);
                boolean bl2 = false;
                $this$generateHashCodeMethodBody_u24lambda_u241.getArguments().set(0, shiftedResult);
                $this$generateHashCodeMethodBody_u24lambda_u241.getArguments().set(1, this.getHashCodeOfProperty(property));
                IrCallImpl irRhs = irCallImpl;
                this.unaryPlus(ExpressionHelpersKt.irSet$default((IrBuilder)this, irResultVar.getSymbol(), (IrExpression)irRhs, null, 4, null));
            }
            this.unaryPlus(ExpressionHelpersKt.irReturn(this, ExpressionHelpersKt.irGet(this, irResultVar)));
        }

        private final IrExpression getHashCodeOfProperty(IrProperty property) {
            return IrTypeUtilsKt.isNullable(this.this$0.getType(property)) ? (IrExpression)ExpressionHelpersKt.irIfNull(this, this.getContext().getIrBuiltIns().getIntType(), this.irGetProperty(this.irThis(), property), ExpressionHelpersKt.irInt$default(this, 0, null, 2, null), this.this$0.getHashCodeOf((IrBuilderWithScope)this, property, this.irGetProperty(this.irThis(), property))) : this.this$0.getHashCodeOf((IrBuilderWithScope)this, property, this.irGetProperty(this.irThis(), property));
        }

        public final void generateToStringMethodBody(@NotNull List<? extends IrProperty> properties) {
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            if (properties.isEmpty() && this.this$0.getIrClass().getKind() == ClassKind.OBJECT) {
                IrBuilderWithScope irBuilderWithScope = this;
                IrBuilder irBuilder = this;
                String string = this.this$0.getIrClass().getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                this.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, ExpressionHelpersKt.irString(irBuilder, string)));
                return;
            }
            IrStringConcatenationImpl irConcat = ExpressionHelpersKt.irConcat(this);
            IrExpressionsKt.addArgument(irConcat, ExpressionHelpersKt.irString(this, this.this$0.classNameForToString(this.this$0.getIrClass()) + '('));
            boolean first = true;
            for (IrProperty irProperty : properties) {
                IrExpression irExpression;
                if (!first) {
                    IrExpressionsKt.addArgument(irConcat, ExpressionHelpersKt.irString(this, ", "));
                }
                IrExpressionsKt.addArgument(irConcat, ExpressionHelpersKt.irString(this, irProperty.getName().asString() + '='));
                IrExpression irPropertyValue = this.irGetProperty(this.irThis(), irProperty);
                IrClassifierSymbol classifier = IrTypesKt.getClassifierOrNull(this.this$0.getType(irProperty));
                if (this.this$0.isArrayOrPrimitiveArray(classifier)) {
                    IrCall irCall;
                    IrCall $this$generateToStringMethodBody_u24lambda_u240 = irCall = ExpressionHelpersKt.irCall$default(this, this.getContext().getIrBuiltIns().getDataClassArrayMemberToStringSymbol(), this.getContext().getIrBuiltIns().getStringType(), 0, null, 12, null);
                    boolean bl = false;
                    $this$generateToStringMethodBody_u24lambda_u240.getArguments().set(0, irPropertyValue);
                    irExpression = irCall;
                } else {
                    irExpression = irPropertyValue;
                }
                IrExpression irPropertyStringValue = irExpression;
                IrExpressionsKt.addArgument(irConcat, irPropertyStringValue);
                first = false;
            }
            IrExpressionsKt.addArgument(irConcat, ExpressionHelpersKt.irString(this, ")"));
            this.unaryPlus(ExpressionHelpersKt.irReturn(this, irConcat));
        }
    }
}

