/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.ActionManager;
import org.jdesktop.swingx.action.ToggleActionPropertyChangeListener;

public class ActionContainerFactory {
    private static Insets TOOLBAR_BUTTON_MARGIN = new Insets(1, 1, 1, 1);
    private ActionMap manager;
    private Map<Integer, ButtonGroup> groupMap;

    public ActionContainerFactory() {
    }

    public ActionContainerFactory(ActionMap manager) {
        this.setActionManager(manager);
    }

    public ActionMap getActionManager() {
        if (this.manager == null) {
            this.manager = ActionManager.getInstance();
        }
        return this.manager;
    }

    public void setActionManager(ActionMap manager) {
        this.manager = manager;
    }

    public JToolBar createToolBar(Object[] list) {
        return this.createToolBar(Arrays.asList(list));
    }

    public JToolBar createToolBar(List<?> list) {
        JToolBar toolbar = new JToolBar();
        for (Object element : list) {
            if (element == null) {
                toolbar.addSeparator();
                continue;
            }
            AbstractButton button = this.createButton(element, (JComponent)toolbar);
            button.setFocusable(false);
            button.setMargin(TOOLBAR_BUTTON_MARGIN);
            button.setBorderPainted(false);
            toolbar.add(button);
        }
        return toolbar;
    }

    public JPopupMenu createPopup(Object[] list) {
        return this.createPopup(Arrays.asList(list));
    }

    public JPopupMenu createPopup(List<?> list) {
        JPopupMenu popup = new JPopupMenu();
        for (Object element : list) {
            if (element == null) {
                popup.addSeparator();
                continue;
            }
            if (element instanceof List) {
                JMenu newMenu = this.createMenu((List)element);
                if (newMenu == null) continue;
                popup.add(newMenu);
                continue;
            }
            popup.add(this.createMenuItem(element, (JComponent)popup));
        }
        return popup;
    }

    public JMenuBar createMenuBar(Object[] actionIds) {
        return this.createMenuBar(Arrays.asList(actionIds));
    }

    public JMenuBar createMenuBar(List<?> list) {
        JMenuBar menubar = new JMenuBar();
        for (Object element : list) {
            JMenuItem menu;
            if (element == null || (menu = element instanceof Object[] ? this.createMenu((Object[])element) : (element instanceof List ? this.createMenu((List)element) : this.createMenuItem(element, (JComponent)menubar))) == null) continue;
            menubar.add(menu);
        }
        return menubar;
    }

    public JMenu createMenu(Object[] actionIds) {
        return this.createMenu(Arrays.asList(actionIds));
    }

    public JMenu createMenu(List<?> list) {
        Action action = this.getAction(list.get(0));
        if (action == null) {
            return null;
        }
        JMenu menu = new JMenu(action);
        for (Object element : list.subList(1, list.size())) {
            if (element == null) {
                menu.addSeparator();
                continue;
            }
            JMenuItem newMenu = element instanceof Object[] ? this.createMenu((Object[])element) : (element instanceof List ? this.createMenu((List)element) : this.createMenuItem(element, (JComponent)menu));
            if (newMenu == null) continue;
            menu.add(newMenu);
        }
        return menu;
    }

    private Action getAction(Object id) {
        return this.getActionManager().get(id);
    }

    private ButtonGroup getGroup(String groupid, JComponent container) {
        Integer hashCode;
        ButtonGroup group;
        if (this.groupMap == null) {
            this.groupMap = new HashMap<Integer, ButtonGroup>();
        }
        int intCode = groupid.hashCode();
        if (container != null) {
            intCode ^= container.hashCode();
        }
        if ((group = this.groupMap.get(hashCode = new Integer(intCode))) == null) {
            group = new ButtonGroup();
            this.groupMap.put(hashCode, group);
        }
        return group;
    }

    private JMenuItem createMenuItem(Object id, JComponent container) {
        return this.createMenuItem(this.getAction(id), container);
    }

    @Deprecated
    public JMenuItem createMenuItem(Action action, JComponent container) {
        AbstractActionExt ta;
        JMenuItem menuItem = null;
        if (action instanceof AbstractActionExt && (ta = (AbstractActionExt)action).isStateAction()) {
            String groupid = (String)ta.getGroup();
            menuItem = groupid != null ? this.createRadioButtonMenuItem(this.getGroup(groupid, container), (AbstractActionExt)action) : this.createCheckBoxMenuItem((AbstractActionExt)action);
        }
        if (menuItem == null) {
            menuItem = new JMenuItem(action);
            this.configureMenuItemFromExtActionProperties(menuItem, action);
        }
        return menuItem;
    }

    public JMenuItem createMenuItem(Action action) {
        return this.createMenuItem(action, null);
    }

    public AbstractButton createButton(Object id, JComponent container) {
        return this.createButton(this.getAction(id), container);
    }

    public AbstractButton createButton(Action action, JComponent container) {
        AbstractActionExt ta;
        if (action == null) {
            return null;
        }
        AbstractButton button = null;
        if (action instanceof AbstractActionExt && (ta = (AbstractActionExt)action).isStateAction()) {
            String groupid = (String)ta.getGroup();
            button = groupid == null ? this.createToggleButton(ta) : this.createToggleButton(ta, this.getGroup(groupid, container));
        }
        if (button == null) {
            button = new JButton(action);
            this.configureButtonFromExtActionProperties(button, action);
        }
        return button;
    }

    public AbstractButton createButton(Action action) {
        return this.createButton(action, null);
    }

    private JToggleButton createToggleButton(AbstractActionExt a) {
        return this.createToggleButton(a, null);
    }

    private JToggleButton createToggleButton(AbstractActionExt a, ButtonGroup group) {
        JToggleButton button = new JToggleButton();
        this.configureButton(button, a, group);
        return button;
    }

    public void configureButton(JToggleButton button, AbstractActionExt a, ButtonGroup group) {
        this.configureSelectableButton(button, a, group);
        this.configureButtonFromExtActionProperties(button, a);
    }

    public void configureSelectableButton(AbstractButton button, AbstractActionExt a, ButtonGroup group) {
        if (a != null && !a.isStateAction()) {
            throw new IllegalArgumentException("the Action must be a stateAction");
        }
        if (button.getAction() == a) {
            return;
        }
        Action oldAction = button.getAction();
        if (oldAction instanceof AbstractActionExt) {
            AbstractActionExt actionExt = (AbstractActionExt)oldAction;
            button.removeItemListener(actionExt);
            PropertyChangeListener[] l = actionExt.getPropertyChangeListeners();
            for (int i2 = l.length - 1; i2 >= 0; --i2) {
                ToggleActionPropertyChangeListener togglePCL;
                if (!(l[i2] instanceof ToggleActionPropertyChangeListener) || !(togglePCL = (ToggleActionPropertyChangeListener)l[i2]).isToggling(button)) continue;
                actionExt.removePropertyChangeListener(togglePCL);
            }
        }
        button.setAction(a);
        if (group != null) {
            group.add(button);
        }
        if (a != null) {
            button.addItemListener(a);
            button.setSelected(a.isSelected());
            new ToggleActionPropertyChangeListener(a, button);
        }
    }

    protected void configureButtonFromExtActionProperties(AbstractButton button, Action action) {
        if (action.getValue("ShortDescription") == null) {
            button.setToolTipText((String)action.getValue("Name"));
        }
        if (action.getValue("__LargeIcon__") != null) {
            button.setIcon((Icon)action.getValue("__LargeIcon__"));
        }
        if (button.getIcon() != null) {
            button.setText("");
        }
    }

    protected void configureMenuItemFromExtActionProperties(JMenuItem menuItem, Action action) {
    }

    private JCheckBoxMenuItem createCheckBoxMenuItem(AbstractActionExt a) {
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem();
        this.configureSelectableButton(mi, a, null);
        this.configureMenuItemFromExtActionProperties(mi, a);
        return mi;
    }

    private JRadioButtonMenuItem createRadioButtonMenuItem(ButtonGroup group, AbstractActionExt a) {
        JRadioButtonMenuItem mi = new JRadioButtonMenuItem();
        this.configureSelectableButton(mi, a, group);
        this.configureMenuItemFromExtActionProperties(mi, a);
        return mi;
    }
}

