/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.logging;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.logging.LoggingUtil;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.Language;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastCommentSaver;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInspection/logging/LoggingGuardedByConditionInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "<init>", "()V", "showOnlyIfFixPossible", "", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "LoggingGuardedByLogConditionVisitor", "UnguardedFix", "intellij.jvm.analysis.impl"})
public final class LoggingGuardedByConditionInspection
extends AbstractBaseUastLocalInspectionTool {
    @JvmField
    public boolean showOnlyIfFixPossible = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.checkbox((String)"showOnlyIfFixPossible", (String)JvmAnalysisBundle.message("jvm.inspection.log.guarded.warn.if.fix.possible", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Class[] classArray = new Class[]{UIfExpression.class};
        return UastHintedVisitorAdapter.Companion.create(language, (AbstractUastNonRecursiveVisitor)new LoggingGuardedByLogConditionVisitor(holder, isOnTheFly), classArray, true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInspection/logging/LoggingGuardedByConditionInspection$LoggingGuardedByLogConditionVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "<init>", "(Lcom/intellij/codeInspection/logging/LoggingGuardedByConditionInspection;Lcom/intellij/codeInspection/ProblemsHolder;Z)V", "visitIfExpression", "node", "Lorg/jetbrains/uast/UIfExpression;", "checkIfFixPossible", "guardedCondition", "Lorg/jetbrains/uast/UExpression;", "Lorg/jetbrains/uast/UCallExpression;", "calls", "", "intellij.jvm.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\nLoggingGuardedByConditionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggingGuardedByConditionInspection.kt\ncom/intellij/codeInspection/logging/LoggingGuardedByConditionInspection$LoggingGuardedByLogConditionVisitor\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n18#2:183\n18#2:184\n1761#3,3:185\n*S KotlinDebug\n*F\n+ 1 LoggingGuardedByConditionInspection.kt\ncom/intellij/codeInspection/logging/LoggingGuardedByConditionInspection$LoggingGuardedByLogConditionVisitor\n*L\n67#1:183\n94#1:184\n116#1:185,3\n*E\n"})
    public final class LoggingGuardedByLogConditionVisitor
    extends AbstractUastNonRecursiveVisitor {
        @NotNull
        private final ProblemsHolder holder;
        private final boolean isOnTheFly;

        public LoggingGuardedByLogConditionVisitor(ProblemsHolder holder, boolean isOnTheFly) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
            this.isOnTheFly = isOnTheFly;
        }

        public boolean visitIfExpression(@NotNull UIfExpression node) {
            Object object;
            Object v4;
            List<UCallExpression> calls;
            UCallExpression guardedCondition;
            block11: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UExpression condition = node.getCondition();
                var visitor2 = new AbstractUastVisitor(){
                    private final List<UCallExpression> conditions;
                    {
                        this.conditions = new ArrayList<E>();
                    }

                    public final List<UCallExpression> getConditions() {
                        return this.conditions;
                    }

                    public boolean visitCallExpression(UCallExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        UExpression guardedCondition = LoggingUtil.Companion.getGuardedCondition$intellij_jvm_analysis_impl(node);
                        if (guardedCondition == null) {
                            this.conditions.add(node);
                        }
                        return true;
                    }
                };
                condition.accept((UastVisitor)visitor2);
                if (visitor2.getConditions().size() != 1) {
                    return true;
                }
                guardedCondition = visitor2.getConditions().get(0);
                UElement $this$getParentOfType_u24default$iv = (UElement)guardedCondition;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                UIfExpression uIfExpression = (UIfExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UIfExpression.class, (boolean)strict$iv);
                if (uIfExpression == null) {
                    return true;
                }
                UIfExpression uIfExpression2 = uIfExpression;
                if (!Intrinsics.areEqual((Object)node.getSourcePsi(), (Object)uIfExpression2.getSourcePsi())) {
                    return true;
                }
                LoggingUtil.Companion.LevelType levelType = LoggingUtil.Companion.getLevelFromCondition$intellij_jvm_analysis_impl((UExpression)guardedCondition);
                if (levelType == null) {
                    return true;
                }
                LoggingUtil.Companion.LevelType levelFromCondition = levelType;
                calls = LoggingUtil.Companion.getLoggerCalls$intellij_jvm_analysis_impl((UExpression)guardedCondition);
                if (calls.isEmpty()) {
                    return true;
                }
                Iterable iterable = calls;
                for (Object object2 : iterable) {
                    UExpression uExpression;
                    UExpression uExpression2;
                    LoggingUtil.Companion.LevelType currentLoggerLevel;
                    UCallExpression it = (UCallExpression)object2;
                    boolean bl = false;
                    if (!(LoggingUtil.Companion.getLoggerLevel$intellij_jvm_analysis_impl$default(LoggingUtil.Companion, it, false, 2, null) == null ? false : LoggingUtil.Companion.isGuardedIn$intellij_jvm_analysis_impl(levelFromCondition, currentLoggerLevel) && Intrinsics.areEqual((Object)((uExpression2 = guardedCondition.getReceiver()) != null && (uExpression2 = uExpression2.getSourcePsi()) != null ? uExpression2.getText() : null), (uExpression = it.getReceiver()) != null && (uExpression = uExpression.getSourcePsi()) != null ? uExpression.getText() : null) && LoggingUtil.Companion.getLOG_MATCHERS_WITHOUT_BUILDERS$intellij_jvm_analysis_impl().uCallMatches(it))) continue;
                    v4 = object2;
                    break block11;
                }
                v4 = null;
            }
            UCallExpression uCallExpression = v4;
            if (uCallExpression == null) {
                return true;
            }
            boolean fixPossible = this.checkIfFixPossible((UExpression)guardedCondition, uCallExpression, calls);
            if (!fixPossible && LoggingGuardedByConditionInspection.this.showOnlyIfFixPossible) {
                return true;
            }
            PsiElement psiElement = guardedCondition.getSourcePsi();
            if (psiElement == null) {
                return true;
            }
            PsiElement sourcePsiGuardedCondition = psiElement;
            if (fixPossible) {
                Object object2;
                object2 = new UnguardedFix[]{new UnguardedFix()};
                object = object2;
            } else {
                object = new UnguardedFix[]{};
            }
            UnguardedFix[] fixes = object;
            boolean isInformationLevel = this.isOnTheFly && InspectionProjectProfileManager.isInformationLevel((String)LoggingGuardedByConditionInspection.this.getShortName(), (PsiElement)sourcePsiGuardedCondition);
            UExpression toHighlight = isInformationLevel ? (UExpression)node : (UExpression)guardedCondition;
            String message = JvmAnalysisBundle.message("jvm.inspection.log.guarded.problem.descriptor", new Object[0]);
            Intrinsics.checkNotNull((Object)message);
            ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UExpression)toHighlight, (String)message, (LocalQuickFix[])((LocalQuickFix[])Arrays.copyOf(fixes, fixes.length)), null, (int)8, null);
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean checkIfFixPossible(UExpression guardedCondition, UCallExpression node, List<? extends UCallExpression> calls) {
            boolean bl;
            UExpression thenExpression;
            UIfExpression uIfExpression;
            block12: {
                UElement uElement;
                block13: {
                    UElement $this$getParentOfType_u24default$iv = (UElement)guardedCondition;
                    boolean strict$iv = true;
                    boolean $i$f$getParentOfType = false;
                    UIfExpression uIfExpression2 = (UIfExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UIfExpression.class, (boolean)strict$iv);
                    if (uIfExpression2 == null) {
                        return false;
                    }
                    uIfExpression = uIfExpression2;
                    if (Intrinsics.areEqual((Object)uIfExpression.getCondition().getSourcePsi(), (Object)guardedCondition.getSourcePsi())) break block12;
                    if (!(guardedCondition.getUastParent() instanceof UQualifiedReferenceExpression)) break block13;
                    UElement uElement2 = guardedCondition.getUastParent();
                    if (Intrinsics.areEqual((Object)uIfExpression.getCondition().getSourcePsi(), (Object)(uElement2 != null ? uElement2.getSourcePsi() : null))) break block12;
                }
                if (!(guardedCondition.getUastParent() instanceof USimpleNameReferenceExpression)) return false;
                UElement uElement3 = guardedCondition.getUastParent();
                if (!((uElement3 != null ? uElement3.getUastParent() : null) instanceof UQualifiedReferenceExpression)) return false;
                if (!Intrinsics.areEqual((Object)uIfExpression.getCondition().getSourcePsi(), (uElement = guardedCondition.getUastParent()) != null && (uElement = uElement.getUastParent()) != null ? uElement.getSourcePsi() : null)) {
                    return false;
                }
            }
            UExpression uExpression = thenExpression = uIfExpression.getThenExpression();
            if (Intrinsics.areEqual((Object)(uExpression != null ? uExpression.getSourcePsi() : null), (Object)node.getSourcePsi())) return true;
            if (thenExpression instanceof UQualifiedReferenceExpression) {
                UElement uElement = node.getUastParent();
                if (Intrinsics.areEqual((Object)(uElement != null ? uElement.getSourcePsi() : null), (Object)((UQualifiedReferenceExpression)thenExpression).getSourcePsi())) return true;
            }
            if (!(thenExpression instanceof UBlockExpression)) {
                return false;
            }
            List nestedExpressions = ((UBlockExpression)thenExpression).getExpressions();
            if (nestedExpressions.size() != calls.size()) {
                return false;
            }
            Iterable $this$any$iv = CollectionsKt.zip((Iterable)nestedExpressions, (Iterable)calls);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return true;
                Object element$iv = iterator.next();
                Pair pair = (Pair)element$iv;
                boolean bl2 = false;
                UExpression nested = (UExpression)pair.component1();
                UCallExpression call = (UCallExpression)pair.component2();
                if (!Intrinsics.areEqual((Object)nested.getSourcePsi(), (Object)call.getSourcePsi()) && call.getUastParent() instanceof UQualifiedReferenceExpression) {
                    UElement uElement = call.getUastParent();
                    if (!Intrinsics.areEqual((Object)(uElement != null ? uElement.getSourcePsi() : null), (Object)nested.getSourcePsi())) {
                        return false;
                    }
                }
                bl = false;
            } while (!bl);
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/codeInspection/logging/LoggingGuardedByConditionInspection$UnguardedFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.jvm.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\nLoggingGuardedByConditionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggingGuardedByConditionInspection.kt\ncom/intellij/codeInspection/logging/LoggingGuardedByConditionInspection$UnguardedFix\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 UastCodeGenerationPlugin.kt\norg/jetbrains/uast/generate/UastCodeGenerationPluginKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,182:1\n18#2:183\n229#3,6:184\n236#3:191\n13#4:190\n*S KotlinDebug\n*F\n+ 1 LoggingGuardedByConditionInspection.kt\ncom/intellij/codeInspection/logging/LoggingGuardedByConditionInspection$UnguardedFix\n*L\n133#1:183\n137#1:184,6\n137#1:191\n137#1:190\n*E\n"})
    private static final class UnguardedFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = JvmAnalysisBundle.message("jvm.inspection.log.guarded.fix.family.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            block21: {
                UastCodeGenerationPlugin uastCodeGenerationPlugin;
                UElement uElement;
                block20: {
                    block19: {
                        void $this$getParentOfType$iv;
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
                        uElement = UastContextKt.toUElement((PsiElement)element);
                        if (uElement == null) break block19;
                        UElement uElement2 = uElement;
                        boolean strict$iv = false;
                        boolean $i$f$getParentOfType = false;
                        uElement = (UIfExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UIfExpression.class, (boolean)strict$iv);
                        if (uElement != null) break block20;
                    }
                    return;
                }
                UElement uIfExpression = uElement;
                UExpression thenExpression = uIfExpression.getThenExpression();
                if (thenExpression == null) {
                    return;
                }
                if (!(thenExpression instanceof UBlockExpression)) {
                    void $this$replace$iv;
                    UElement uElement3 = uIfExpression;
                    UElement newElement$iv = (UElement)thenExpression;
                    boolean $i$f$replace = false;
                    if (!Intrinsics.areEqual((Object)$this$replace$iv, (Object)newElement$iv)) {
                        UastCodeGenerationPlugin $i$f$getParentOfType = UastCodeGenerationPlugin.Companion.byLanguage($this$replace$iv.getLang());
                        UastCodeGenerationPlugin it$iv = $i$f$getParentOfType = $i$f$getParentOfType != null ? $i$f$getParentOfType.replace((UElement)$this$replace$iv, newElement$iv, UExpression.class) : null;
                        boolean bl = false;
                        if (it$iv == null) {
                            boolean $i$f$logger = false;
                            Logger logger = Logger.getInstance(UastCodeGenerationPlugin.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                            logger.warn("failed replacing the " + (UElement)$this$replace$iv + " with " + newElement$iv);
                        }
                    }
                    return;
                }
                PsiElement psiElement = uIfExpression.getSourcePsi();
                if (psiElement == null) {
                    return;
                }
                PsiElement ifStatementSourcePsi = psiElement;
                Language language = ifStatementSourcePsi.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                UastCodeGenerationPlugin uastCodeGenerationPlugin2 = uastCodeGenerationPlugin = UastCodeGenerationPlugin.Companion.byLanguage(language);
                UastCommentSaver commentSaver = uastCodeGenerationPlugin2 != null ? UastCodeGenerationPlugin.grabComments$default((UastCodeGenerationPlugin)uastCodeGenerationPlugin2, (UElement)uIfExpression, null, (int)2, null) : null;
                List expressions = ((UBlockExpression)thenExpression).getExpressions();
                if (expressions.isEmpty()) {
                    return;
                }
                PsiElement currentParent = ifStatementSourcePsi.getParent();
                PsiElement after = ifStatementSourcePsi;
                PsiElement nextExpression = ((UExpression)expressions.get(0)).getSourcePsi();
                PsiElement psiElement2 = ((UExpression)CollectionsKt.last((List)expressions)).getSourcePsi();
                if (psiElement2 == null) {
                    return;
                }
                PsiElement lastExpression = psiElement2;
                while (true) {
                    PsiElement psiElement3 = nextExpression;
                    UElement uElement4 = UastContextKt.toUElement((PsiElement)(psiElement3 != null ? psiElement3.getParent() : null));
                    if (!Intrinsics.areEqual((Object)(uElement4 != null ? uElement4.getSourcePsi() : null), (Object)((UExpression)expressions.get(0)).getSourcePsi())) break;
                    PsiElement psiElement4 = nextExpression;
                    nextExpression = psiElement4 != null ? psiElement4.getParent() : null;
                }
                if (nextExpression == null) {
                    return;
                }
                while (true) {
                    PsiElement newAdded;
                    UastCommentSaver uastCommentSaver = commentSaver;
                    if (uastCommentSaver != null) {
                        UastCommentSaver.markUnchanged$default((UastCommentSaver)uastCommentSaver, (UElement)UastContextKt.toUElement((PsiElement)nextExpression), null, (int)2, null);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)currentParent.addAfter(nextExpression.copy(), after), (String)"addAfter(...)");
                    if (nextExpression instanceof PsiWhiteSpace) {
                        while (!(newAdded.getNextSibling() instanceof PsiWhiteSpace) && newAdded.getParent() != null) {
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)newAdded.getNextSibling(), (String)"getNextSibling(...)");
                    } else {
                        after = newAdded;
                    }
                    currentParent = newAdded.getParent();
                    if (PsiTreeUtil.isAncestor((PsiElement)nextExpression, (PsiElement)lastExpression, (boolean)false) || nextExpression.getNextSibling() == null) break;
                }
                ifStatementSourcePsi.delete();
                UElement uElement5 = UastContextKt.toUElement((PsiElement)after);
                if (uElement5 == null) break block21;
                UastCommentSaver uastCommentSaver = commentSaver;
                if (uastCommentSaver != null) {
                    UastCommentSaver.restore$default((UastCommentSaver)uastCommentSaver, (UElement)uElement5, null, (int)2, null);
                }
            }
        }
    }
}

