/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SupertypeLoopChecker;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationSplitter;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.CompositeAnnotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.FieldDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtContextReceiver;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AdditionalClassPartsProvider;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationReturnTypeSanitizer;
import org.jetbrains.kotlin.resolve.DeclarationSignatureAnonymousTypeTransformer;
import org.jetbrains.kotlin.resolve.DefinitelyNonNullableTypesKt;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.VariableAsPropertyInfo;
import org.jetbrains.kotlin.resolve.VariableTypeAndInitializerResolver;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.extensions.SyntheticResolveExtension;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyTypeAliasDescriptor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.SubstitutingScope;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.TypeApproximator;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.WrappedTypeFactory;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.DestructuringDeclarationResolver;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitor;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class DescriptorResolver {
    private final TypeResolver typeResolver;
    private final AnnotationResolver annotationResolver;
    private final StorageManager storageManager;
    private final KotlinBuiltIns builtIns;
    private final SupertypeLoopChecker supertypeLoopsResolver;
    private final VariableTypeAndInitializerResolver variableTypeAndInitializerResolver;
    private final ExpressionTypingServices expressionTypingServices;
    private final OverloadChecker overloadChecker;
    private final LanguageVersionSettings languageVersionSettings;
    private final FunctionsTypingVisitor functionsTypingVisitor;
    private final DestructuringDeclarationResolver destructuringDeclarationResolver;
    private final ModifiersChecker modifiersChecker;
    private final WrappedTypeFactory wrappedTypeFactory;
    private final SyntheticResolveExtension syntheticResolveExtension;
    private final TypeApproximator typeApproximator;
    private final DeclarationReturnTypeSanitizer declarationReturnTypeSanitizer;
    private final DataFlowValueFactory dataFlowValueFactory;
    private final Iterable<DeclarationSignatureAnonymousTypeTransformer> anonymousTypeTransformers;
    private final AdditionalClassPartsProvider additionalClassPartsProvider;

    public DescriptorResolver(@NotNull AnnotationResolver annotationResolver, @NotNull KotlinBuiltIns builtIns, @NotNull StorageManager storageManager, @NotNull TypeResolver typeResolver, @NotNull SupertypeLoopChecker supertypeLoopsResolver, @NotNull VariableTypeAndInitializerResolver variableTypeAndInitializerResolver, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull OverloadChecker overloadChecker, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull FunctionsTypingVisitor functionsTypingVisitor, @NotNull DestructuringDeclarationResolver destructuringDeclarationResolver, @NotNull ModifiersChecker modifiersChecker, @NotNull WrappedTypeFactory wrappedTypeFactory, @NotNull Project project, @NotNull TypeApproximator approximator, @NotNull DeclarationReturnTypeSanitizer declarationReturnTypeSanitizer, @NotNull DataFlowValueFactory dataFlowValueFactory, @NotNull Iterable<DeclarationSignatureAnonymousTypeTransformer> anonymousTypeTransformers, @NotNull AdditionalClassPartsProvider additionalClassPartsProvider) {
        if (annotationResolver == null) {
            DescriptorResolver.$$$reportNull$$$0(0);
        }
        if (builtIns == null) {
            DescriptorResolver.$$$reportNull$$$0(1);
        }
        if (storageManager == null) {
            DescriptorResolver.$$$reportNull$$$0(2);
        }
        if (typeResolver == null) {
            DescriptorResolver.$$$reportNull$$$0(3);
        }
        if (supertypeLoopsResolver == null) {
            DescriptorResolver.$$$reportNull$$$0(4);
        }
        if (variableTypeAndInitializerResolver == null) {
            DescriptorResolver.$$$reportNull$$$0(5);
        }
        if (expressionTypingServices == null) {
            DescriptorResolver.$$$reportNull$$$0(6);
        }
        if (overloadChecker == null) {
            DescriptorResolver.$$$reportNull$$$0(7);
        }
        if (languageVersionSettings == null) {
            DescriptorResolver.$$$reportNull$$$0(8);
        }
        if (functionsTypingVisitor == null) {
            DescriptorResolver.$$$reportNull$$$0(9);
        }
        if (destructuringDeclarationResolver == null) {
            DescriptorResolver.$$$reportNull$$$0(10);
        }
        if (modifiersChecker == null) {
            DescriptorResolver.$$$reportNull$$$0(11);
        }
        if (wrappedTypeFactory == null) {
            DescriptorResolver.$$$reportNull$$$0(12);
        }
        if (project == null) {
            DescriptorResolver.$$$reportNull$$$0(13);
        }
        if (approximator == null) {
            DescriptorResolver.$$$reportNull$$$0(14);
        }
        if (declarationReturnTypeSanitizer == null) {
            DescriptorResolver.$$$reportNull$$$0(15);
        }
        if (dataFlowValueFactory == null) {
            DescriptorResolver.$$$reportNull$$$0(16);
        }
        if (anonymousTypeTransformers == null) {
            DescriptorResolver.$$$reportNull$$$0(17);
        }
        if (additionalClassPartsProvider == null) {
            DescriptorResolver.$$$reportNull$$$0(18);
        }
        this.annotationResolver = annotationResolver;
        this.builtIns = builtIns;
        this.storageManager = storageManager;
        this.typeResolver = typeResolver;
        this.supertypeLoopsResolver = supertypeLoopsResolver;
        this.variableTypeAndInitializerResolver = variableTypeAndInitializerResolver;
        this.expressionTypingServices = expressionTypingServices;
        this.overloadChecker = overloadChecker;
        this.languageVersionSettings = languageVersionSettings;
        this.functionsTypingVisitor = functionsTypingVisitor;
        this.destructuringDeclarationResolver = destructuringDeclarationResolver;
        this.modifiersChecker = modifiersChecker;
        this.wrappedTypeFactory = wrappedTypeFactory;
        this.syntheticResolveExtension = SyntheticResolveExtension.Companion.getInstance(project);
        this.typeApproximator = approximator;
        this.declarationReturnTypeSanitizer = declarationReturnTypeSanitizer;
        this.dataFlowValueFactory = dataFlowValueFactory;
        this.anonymousTypeTransformers = anonymousTypeTransformers;
        this.additionalClassPartsProvider = additionalClassPartsProvider;
    }

    public List<KotlinType> resolveSupertypes(@NotNull LexicalScope scope, @NotNull ClassDescriptor classDescriptor, @Nullable KtPureClassOrObject correspondingClassOrObject, BindingTrace trace) {
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(19);
        }
        if (classDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(20);
        }
        ArrayList supertypes = Lists.newArrayList();
        List delegationSpecifiers = correspondingClassOrObject == null ? Collections.emptyList() : correspondingClassOrObject.getSuperTypeListEntries();
        Collection<KotlinType> declaredSupertypes = DescriptorResolver.resolveSuperTypeListEntries(scope, delegationSpecifiers, this.typeResolver, trace, false);
        for (KotlinType declaredSupertype : declaredSupertypes) {
            DescriptorResolver.addValidSupertype(supertypes, declaredSupertype);
        }
        if (classDescriptor.getKind() == ClassKind.ENUM_CLASS && !DescriptorResolver.containsClass(supertypes)) {
            supertypes.add(0, this.builtIns.getEnumType(classDescriptor.getDefaultType()));
        }
        this.syntheticResolveExtension.addSyntheticSupertypes(classDescriptor, supertypes);
        supertypes.addAll(this.additionalClassPartsProvider.getAdditionalSupertypes(classDescriptor, supertypes));
        if (supertypes.isEmpty()) {
            DescriptorResolver.addValidSupertype(supertypes, this.getDefaultSupertype(classDescriptor));
        }
        return supertypes;
    }

    private static void addValidSupertype(List<KotlinType> supertypes, KotlinType declaredSupertype) {
        if (!KotlinTypeKt.isError(declaredSupertype)) {
            supertypes.add(declaredSupertype);
        }
    }

    private static boolean containsClass(Collection<KotlinType> result) {
        for (KotlinType type : result) {
            ClassifierDescriptor descriptor = type.getConstructor().getDeclarationDescriptor();
            if (!(descriptor instanceof ClassDescriptor) || ((ClassDescriptor)descriptor).getKind() == ClassKind.INTERFACE) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private KotlinType getDefaultSupertype(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(21);
        }
        if (classDescriptor.getKind() == ClassKind.ENUM_ENTRY) {
            SimpleType simpleType = ((ClassDescriptor)classDescriptor.getContainingDeclaration()).getDefaultType();
            if (simpleType == null) {
                DescriptorResolver.$$$reportNull$$$0(22);
            }
            return simpleType;
        }
        if (classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS) {
            SimpleType simpleType = this.builtIns.getAnnotationType();
            if (simpleType == null) {
                DescriptorResolver.$$$reportNull$$$0(23);
            }
            return simpleType;
        }
        SimpleType simpleType = this.builtIns.getAnyType();
        if (simpleType == null) {
            DescriptorResolver.$$$reportNull$$$0(24);
        }
        return simpleType;
    }

    private static Collection<KotlinType> resolveSuperTypeListEntries(LexicalScope extensibleScope, List<KtSuperTypeListEntry> delegationSpecifiers, @NotNull TypeResolver resolver, BindingTrace trace, boolean checkBounds) {
        if (resolver == null) {
            DescriptorResolver.$$$reportNull$$$0(25);
        }
        if (delegationSpecifiers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (KtSuperTypeListEntry delegationSpecifier : delegationSpecifiers) {
            KtTypeReference typeReference = delegationSpecifier.getTypeReference();
            if (typeReference != null) {
                KotlinType supertype = resolver.resolveType(extensibleScope, typeReference, trace, checkBounds);
                if (DynamicTypesKt.isDynamic(supertype)) {
                    trace.report(Errors.DYNAMIC_SUPERTYPE.on(typeReference));
                    continue;
                }
                result.add(supertype);
                KtTypeElement bareSuperType = DescriptorResolver.checkNullableSupertypeAndStripQuestionMarks(trace, typeReference.getTypeElement());
                DescriptorResolver.checkProjectionsInImmediateArguments(trace, bareSuperType, supertype);
                continue;
            }
            result.add(ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_TYPE, delegationSpecifier.getText()));
        }
        return result;
    }

    @Nullable
    private static KtTypeElement checkNullableSupertypeAndStripQuestionMarks(@NotNull BindingTrace trace, @Nullable KtTypeElement typeElement) {
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(26);
        }
        while (typeElement instanceof KtNullableType) {
            KtNullableType nullableType = (KtNullableType)typeElement;
            if ((typeElement = nullableType.getInnerType()) instanceof KtNullableType || typeElement == null) continue;
            trace.report(Errors.NULLABLE_SUPERTYPE.on(nullableType));
        }
        return typeElement;
    }

    private static void checkProjectionsInImmediateArguments(@NotNull BindingTrace trace, @Nullable KtTypeElement typeElement, @NotNull KotlinType type) {
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(27);
        }
        if (type == null) {
            DescriptorResolver.$$$reportNull$$$0(28);
        }
        if (typeElement == null) {
            return;
        }
        boolean hasProjectionsInWrittenArguments = false;
        if (typeElement instanceof KtUserType) {
            KtUserType userType = (KtUserType)typeElement;
            List typeArguments = userType.getTypeArguments();
            for (KtTypeProjection typeArgument : typeArguments) {
                if (typeArgument.getProjectionKind() == KtProjectionKind.NONE) continue;
                trace.report(Errors.PROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE.on(typeArgument));
                hasProjectionsInWrittenArguments = true;
            }
        }
        if (!KotlinTypeKt.isError(type) && SpecialTypesKt.getAbbreviatedType(type) != null && !hasProjectionsInWrittenArguments && TypeUtilsKt.isInterface(type) && TypeUtilsKt.containsTypeProjectionsInTopLevelArguments(type)) {
            trace.report(Errors.EXPANDED_TYPE_CANNOT_BE_INHERITED.on(typeElement, type));
        }
    }

    public static DescriptorVisibility getDefaultVisibility(KtModifierListOwner modifierListOwner, DeclarationDescriptor containingDescriptor) {
        KtModifierList modifierList;
        DescriptorVisibility defaultVisibility = containingDescriptor instanceof ClassDescriptor ? ((modifierList = modifierListOwner.getModifierList()) != null && modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD) ? DescriptorVisibilities.INHERITED : DescriptorVisibilities.DEFAULT_VISIBILITY) : (containingDescriptor instanceof FunctionDescriptor || containingDescriptor instanceof PropertyDescriptor ? DescriptorVisibilities.LOCAL : DescriptorVisibilities.DEFAULT_VISIBILITY);
        return defaultVisibility;
    }

    public static Modality getDefaultModality(DeclarationDescriptor containingDescriptor, DescriptorVisibility visibility, boolean isBodyPresent) {
        Modality defaultModality;
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean isTrait = ((ClassDescriptor)containingDescriptor).getKind() == ClassKind.INTERFACE;
            boolean isDefinitelyAbstract = isTrait && !isBodyPresent;
            Modality basicModality = isTrait && !DescriptorVisibilities.isPrivate(visibility) ? Modality.OPEN : Modality.FINAL;
            defaultModality = isDefinitelyAbstract ? Modality.ABSTRACT : basicModality;
        } else {
            defaultModality = Modality.FINAL;
        }
        return defaultModality;
    }

    @NotNull
    public ValueParameterDescriptorImpl resolveValueParameterDescriptor(@NotNull LexicalScope scope, @NotNull FunctionDescriptor owner, @NotNull KtParameter valueParameter, int index, @NotNull KotlinType type, @NotNull BindingTrace trace, @NotNull Annotations additionalAnnotations, @Nullable InferenceSession inferenceSession) {
        Function0 destructuringVariables;
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(29);
        }
        if (owner == null) {
            DescriptorResolver.$$$reportNull$$$0(30);
        }
        if (valueParameter == null) {
            DescriptorResolver.$$$reportNull$$$0(31);
        }
        if (type == null) {
            DescriptorResolver.$$$reportNull$$$0(32);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(33);
        }
        if (additionalAnnotations == null) {
            DescriptorResolver.$$$reportNull$$$0(34);
        }
        KotlinType varargElementType = null;
        KotlinType variableType = type;
        if (valueParameter.hasModifier(KtTokens.VARARG_KEYWORD)) {
            varargElementType = type;
            variableType = this.getVarargParameterType(type);
        }
        Annotations valueParameterAnnotations = this.resolveValueParameterAnnotations(scope, valueParameter, trace, additionalAnnotations);
        KtDestructuringDeclaration destructuringDeclaration = valueParameter.getDestructuringDeclaration();
        if (destructuringDeclaration != null) {
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.DestructuringLambdaParameters)) {
                trace.report(Errors.UNSUPPORTED_FEATURE.on((PsiElement)valueParameter, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)LanguageFeature.DestructuringLambdaParameters, (Object)this.languageVersionSettings)));
            }
            destructuringVariables = () -> {
                ReceiverParameterDescriptor dispatchReceiver = owner.getDispatchReceiverParameter();
                assert (dispatchReceiver == null || dispatchReceiver.getContainingDeclaration() instanceof ScriptDescriptor) : "Destructuring declarations are only be parsed for lambdas, and they must not have a dispatch receiver";
                LexicalScope scopeForDestructuring = ScopeUtilsKt.createScopeForDestructuring(scope, owner.getExtensionReceiverParameter());
                List<VariableDescriptor> result = this.destructuringDeclarationResolver.resolveLocalVariablesFromDestructuringDeclaration(scope, destructuringDeclaration, new TransientReceiver(type), null, ExpressionTypingContext.newContext(trace, scopeForDestructuring, DataFlowInfoFactory.EMPTY, TypeUtils.NO_EXPECTED_TYPE, this.languageVersionSettings, this.dataFlowValueFactory, inferenceSession));
                this.modifiersChecker.withTrace(trace).checkModifiersForDestructuringDeclaration(destructuringDeclaration);
                return result;
            };
        } else {
            destructuringVariables = null;
        }
        Name parameterName = destructuringDeclaration == null ? (!valueParameter.hasValOrVar() && UnderscoreUtilKt.isSingleUnderscore((KtNamedDeclaration)valueParameter) ? SpecialNames.anonymousParameterName((int)index) : KtPsiUtil.safeName((String)valueParameter.getName())) : Name.special((String)("<name for destructuring parameter " + index + ">"));
        ValueParameterDescriptorImpl valueParameterDescriptor = ValueParameterDescriptorImpl.createWithDestructuringDeclarations(owner, null, index, valueParameterAnnotations, parameterName, variableType, valueParameter.hasDefaultValue(), valueParameter.hasModifier(KtTokens.CROSSINLINE_KEYWORD), valueParameter.hasModifier(KtTokens.NOINLINE_KEYWORD), varargElementType, KotlinSourceElementKt.toSourceElement((KtPureElement)valueParameter), (Function0<? extends List<? extends VariableDescriptor>>)destructuringVariables);
        trace.record(BindingContext.VALUE_PARAMETER, valueParameter, valueParameterDescriptor);
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = valueParameterDescriptor;
        if (valueParameterDescriptorImpl == null) {
            DescriptorResolver.$$$reportNull$$$0(35);
        }
        return valueParameterDescriptorImpl;
    }

    @NotNull
    private Annotations resolveValueParameterAnnotations(@NotNull LexicalScope scope, @NotNull KtParameter parameter, @NotNull BindingTrace trace, @NotNull Annotations additionalAnnotations) {
        KtModifierList modifierList;
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(36);
        }
        if (parameter == null) {
            DescriptorResolver.$$$reportNull$$$0(37);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(38);
        }
        if (additionalAnnotations == null) {
            DescriptorResolver.$$$reportNull$$$0(39);
        }
        if ((modifierList = parameter.getModifierList()) == null) {
            Annotations annotations = additionalAnnotations;
            if (annotations == null) {
                DescriptorResolver.$$$reportNull$$$0(40);
            }
            return annotations;
        }
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scope, modifierList, trace);
        if (!parameter.hasValOrVar()) {
            return new CompositeAnnotations(allAnnotations, additionalAnnotations);
        }
        AnnotationSplitter splitter = new AnnotationSplitter(this.storageManager, allAnnotations, SetsKt.setOf((Object)AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER));
        return new CompositeAnnotations(splitter.getAnnotationsForTarget(AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER), additionalAnnotations);
    }

    @NotNull
    private KotlinType getVarargParameterType(@NotNull KotlinType elementType) {
        SimpleType primitiveArrayType;
        if (elementType == null) {
            DescriptorResolver.$$$reportNull$$$0(41);
        }
        if ((primitiveArrayType = this.builtIns.getPrimitiveArrayKotlinTypeByPrimitiveKotlinType(elementType)) != null) {
            SimpleType simpleType = primitiveArrayType;
            if (simpleType == null) {
                DescriptorResolver.$$$reportNull$$$0(42);
            }
            return simpleType;
        }
        SimpleType simpleType = this.builtIns.getArrayType(Variance.OUT_VARIANCE, elementType);
        if (simpleType == null) {
            DescriptorResolver.$$$reportNull$$$0(43);
        }
        return simpleType;
    }

    public List<TypeParameterDescriptorImpl> resolveTypeParametersForDescriptor(DeclarationDescriptor containingDescriptor, LexicalWritableScope extensibleScope, LexicalScope scopeForAnnotationsResolve, List<KtTypeParameter> typeParameters, BindingTrace trace) {
        List<TypeParameterDescriptorImpl> descriptors = this.resolveTypeParametersForDescriptor(containingDescriptor, scopeForAnnotationsResolve, typeParameters, trace);
        for (TypeParameterDescriptorImpl descriptor : descriptors) {
            extensibleScope.addClassifierDescriptor(descriptor);
        }
        return descriptors;
    }

    private List<TypeParameterDescriptorImpl> resolveTypeParametersForDescriptor(DeclarationDescriptor containingDescriptor, LexicalScope scopeForAnnotationsResolve, List<KtTypeParameter> typeParameters, BindingTrace trace) {
        assert (containingDescriptor instanceof FunctionDescriptor || containingDescriptor instanceof PropertyDescriptor || containingDescriptor instanceof TypeAliasDescriptor) : "This method should be called for functions, properties, or type aliases, got " + containingDescriptor;
        ArrayList<TypeParameterDescriptorImpl> result = new ArrayList<TypeParameterDescriptorImpl>();
        int typeParametersSize = typeParameters.size();
        for (int i = 0; i < typeParametersSize; ++i) {
            KtTypeParameter typeParameter = typeParameters.get(i);
            result.add(this.resolveTypeParameterForDescriptor(containingDescriptor, scopeForAnnotationsResolve, typeParameter, i, trace));
        }
        return result;
    }

    private TypeParameterDescriptorImpl resolveTypeParameterForDescriptor(DeclarationDescriptor containingDescriptor, LexicalScope scopeForAnnotationsResolve, KtTypeParameter typeParameter, int index, BindingTrace trace) {
        if (typeParameter.getVariance() != Variance.INVARIANT) {
            trace.report(Errors.VARIANCE_ON_TYPE_PARAMETER_NOT_ALLOWED.on(typeParameter));
        }
        Annotations annotations = this.annotationResolver.resolveAnnotationsWithArguments(scopeForAnnotationsResolve, typeParameter.getModifierList(), trace);
        TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(containingDescriptor, annotations, typeParameter.hasModifier(KtTokens.REIFIED_KEYWORD), typeParameter.getVariance(), KtPsiUtil.safeName((String)typeParameter.getName()), index, KotlinSourceElementKt.toSourceElement((KtPureElement)typeParameter), (Function1<KotlinType, Void>)((Function1)type -> {
            if (!(containingDescriptor instanceof TypeAliasDescriptor)) {
                trace.report(Errors.CYCLIC_GENERIC_UPPER_BOUND.on((PsiElement)typeParameter));
            }
            return null;
        }), this.supertypeLoopsResolver, this.storageManager);
        trace.record(BindingContext.TYPE_PARAMETER, typeParameter, typeParameterDescriptor);
        return typeParameterDescriptor;
    }

    @NotNull
    public static ClassConstructorDescriptorImpl createAndRecordPrimaryConstructorForObject(@Nullable KtPureClassOrObject object, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        if (classDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(44);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(45);
        }
        ClassConstructorDescriptorImpl constructorDescriptor = DescriptorFactory.createPrimaryConstructorForObject(classDescriptor, KotlinSourceElementKt.toSourceElement((KtPureElement)object));
        if (object instanceof PsiElement) {
            KtPrimaryConstructor primaryConstructor = object.getPrimaryConstructor();
            trace.record(BindingContext.CONSTRUCTOR, primaryConstructor != null ? primaryConstructor : (PsiElement)object, constructorDescriptor);
        }
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl = constructorDescriptor;
        if (classConstructorDescriptorImpl == null) {
            DescriptorResolver.$$$reportNull$$$0(46);
        }
        return classConstructorDescriptorImpl;
    }

    public void resolveGenericBounds(@NotNull KtTypeParameterListOwner declaration, @NotNull DeclarationDescriptor descriptor, LexicalScope scope, List<TypeParameterDescriptorImpl> parameters, BindingTrace trace) {
        if (declaration == null) {
            DescriptorResolver.$$$reportNull$$$0(47);
        }
        if (descriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(48);
        }
        ArrayList upperBoundCheckRequests = Lists.newArrayList();
        List typeParameters = declaration.getTypeParameters();
        HashMap<Name, TypeParameterDescriptorImpl> parameterByName = new HashMap<Name, TypeParameterDescriptorImpl>();
        for (int i = 0; i < typeParameters.size(); ++i) {
            KtTypeParameter ktTypeParameter = (KtTypeParameter)typeParameters.get(i);
            TypeParameterDescriptorImpl typeParameterDescriptor = parameters.get(i);
            parameterByName.put(typeParameterDescriptor.getName(), typeParameterDescriptor);
            KtTypeReference extendsBound = ktTypeParameter.getExtendsBound();
            if (extendsBound == null) continue;
            KotlinType type = this.typeResolver.resolveType(scope, extendsBound, trace, false);
            typeParameterDescriptor.addUpperBound(type);
            upperBoundCheckRequests.add(new UpperBoundCheckRequest(ktTypeParameter.getNameAsName(), extendsBound, type));
        }
        for (KtTypeConstraint constraint : declaration.getTypeConstraints()) {
            KtSimpleNameExpression subjectTypeParameterName = constraint.getSubjectTypeParameterName();
            if (subjectTypeParameterName == null) continue;
            Name referencedName = subjectTypeParameterName.getReferencedNameAsName();
            TypeParameterDescriptorImpl typeParameterDescriptor = (TypeParameterDescriptorImpl)parameterByName.get(referencedName);
            KtTypeReference boundTypeReference = constraint.getBoundTypeReference();
            KotlinType bound = null;
            if (boundTypeReference != null) {
                bound = this.typeResolver.resolveType(scope, boundTypeReference, trace, false);
                upperBoundCheckRequests.add(new UpperBoundCheckRequest(referencedName, boundTypeReference, bound));
            }
            if (typeParameterDescriptor == null) continue;
            trace.record(BindingContext.REFERENCE_TARGET, subjectTypeParameterName, typeParameterDescriptor);
            if (bound == null) continue;
            typeParameterDescriptor.addUpperBound(bound);
        }
        for (TypeParameterDescriptorImpl parameter : parameters) {
            parameter.addDefaultUpperBound();
            parameter.setInitialized();
        }
        for (TypeParameterDescriptorImpl parameter : parameters) {
            DescriptorResolver.checkConflictingUpperBounds(trace, parameter, (KtTypeParameter)typeParameters.get(parameter.getIndex()));
        }
        if (!(declaration instanceof KtClass)) {
            DescriptorResolver.checkUpperBoundTypes(trace, upperBoundCheckRequests, declaration.hasModifier(KtTokens.OVERRIDE_KEYWORD));
            this.checkNamesInConstraints(declaration, descriptor, scope, trace);
        }
    }

    public static void checkUpperBoundTypes(@NotNull BindingTrace trace, @NotNull List<UpperBoundCheckRequest> requests, boolean hasOverrideModifier) {
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(49);
        }
        if (requests == null) {
            DescriptorResolver.$$$reportNull$$$0(50);
        }
        if (requests.isEmpty()) {
            return;
        }
        HashSet<Name> classBoundEncountered = new HashSet<Name>();
        HashSet<Pair> allBounds = new HashSet<Pair>();
        for (UpperBoundCheckRequest request : requests) {
            Name typeParameterName = request.typeParameterName;
            KotlinType upperBound = request.upperBoundType;
            KtTypeReference upperBoundElement = request.upperBound;
            if (!KotlinTypeKt.isError(upperBound)) {
                if (!allBounds.add(new Pair((Object)typeParameterName, (Object)upperBound.getConstructor()))) {
                    trace.report(Errors.REPEATED_BOUND.on(upperBoundElement));
                } else {
                    ClassKind kind;
                    ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(upperBound);
                    if (!(classDescriptor == null || (kind = classDescriptor.getKind()) != ClassKind.CLASS && kind != ClassKind.ENUM_CLASS && kind != ClassKind.OBJECT || classBoundEncountered.add(typeParameterName))) {
                        trace.report(Errors.ONLY_ONE_CLASS_BOUND_ALLOWED.on(upperBoundElement));
                    }
                }
            }
            DescriptorResolver.checkUpperBoundType(upperBoundElement, upperBound, trace, hasOverrideModifier);
        }
    }

    public static void checkConflictingUpperBounds(@NotNull BindingTrace trace, @NotNull TypeParameterDescriptor parameter, @NotNull KtTypeParameter typeParameter) {
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(51);
        }
        if (parameter == null) {
            DescriptorResolver.$$$reportNull$$$0(52);
        }
        if (typeParameter == null) {
            DescriptorResolver.$$$reportNull$$$0(53);
        }
        if (KotlinBuiltIns.isNothing(TypeIntersector.getUpperBoundsAsType(parameter))) {
            trace.report(Errors.CONFLICTING_UPPER_BOUNDS.on((KtNamedDeclaration)typeParameter, parameter));
        }
    }

    public void checkNamesInConstraints(@NotNull KtTypeParameterListOwner declaration, @NotNull DeclarationDescriptor descriptor, @NotNull LexicalScope scope, @NotNull BindingTrace trace) {
        if (declaration == null) {
            DescriptorResolver.$$$reportNull$$$0(54);
        }
        if (descriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(55);
        }
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(56);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(57);
        }
        for (KtTypeConstraint constraint : declaration.getTypeConstraints()) {
            KtTypeReference boundTypeReference;
            Name name;
            ClassifierDescriptor classifier;
            KtSimpleNameExpression nameExpression = constraint.getSubjectTypeParameterName();
            if (nameExpression == null || (classifier = ScopeUtilsKt.findClassifier(scope, name = nameExpression.getReferencedNameAsName(), (LookupLocation)NoLookupLocation.FOR_NON_TRACKED_SCOPE)) instanceof TypeParameterDescriptor && classifier.getContainingDeclaration() == descriptor) continue;
            if (classifier != null) {
                trace.report(Errors.NAME_IN_CONSTRAINT_IS_NOT_A_TYPE_PARAMETER.on(nameExpression, constraint, declaration));
                trace.record(BindingContext.REFERENCE_TARGET, nameExpression, classifier);
            } else {
                trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)nameExpression, (KtReferenceExpression)nameExpression));
            }
            if ((boundTypeReference = constraint.getBoundTypeReference()) == null) continue;
            this.typeResolver.resolveType(scope, boundTypeReference, trace, true);
        }
    }

    public static void checkUpperBoundType(KtTypeReference upperBound, @NotNull KotlinType upperBoundType, BindingTrace trace, boolean hasOverrideModifier) {
        if (upperBoundType == null) {
            DescriptorResolver.$$$reportNull$$$0(58);
        }
        if (!hasOverrideModifier && !TypeUtils.canHaveSubtypes(KotlinTypeChecker.DEFAULT, upperBoundType)) {
            trace.report(Errors.FINAL_UPPER_BOUND.on(upperBound, upperBoundType));
        }
        if (DynamicTypesKt.isDynamic(upperBoundType)) {
            trace.report(Errors.DYNAMIC_UPPER_BOUND.on(upperBound));
        }
        if (FunctionTypesKt.isExtensionFunctionType(upperBoundType)) {
            trace.report(Errors.UPPER_BOUND_IS_EXTENSION_FUNCTION_TYPE.on(upperBound));
        }
        if (DefinitelyNonNullableTypesKt.containsIncorrectExplicitDefinitelyNonNullableType(upperBoundType)) {
            trace.report(Errors.INCORRECT_LEFT_COMPONENT_OF_INTERSECTION.on(upperBound));
        }
    }

    @NotNull
    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull LexicalScope scope, @NotNull KtParameter parameter, BindingTrace trace) {
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(59);
        }
        if (parameter == null) {
            DescriptorResolver.$$$reportNull$$$0(60);
        }
        KotlinType type = this.resolveParameterType(scope, parameter, trace);
        VariableDescriptor variableDescriptor = this.resolveLocalVariableDescriptor(parameter, type, trace, scope);
        if (variableDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(61);
        }
        return variableDescriptor;
    }

    private KotlinType resolveParameterType(LexicalScope scope, KtParameter parameter, BindingTrace trace) {
        KtTypeReference typeReference = parameter.getTypeReference();
        KotlinType type = typeReference != null ? this.typeResolver.resolveType(scope, typeReference, trace, true) : ErrorUtils.createErrorType(ErrorTypeKind.NO_TYPE_SPECIFIED, parameter.getText());
        if (parameter.hasModifier(KtTokens.VARARG_KEYWORD)) {
            return this.getVarargParameterType(type);
        }
        return type;
    }

    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull KtParameter parameter, @NotNull KotlinType type, BindingTrace trace, @NotNull LexicalScope scope) {
        if (parameter == null) {
            DescriptorResolver.$$$reportNull$$$0(62);
        }
        if (type == null) {
            DescriptorResolver.$$$reportNull$$$0(63);
        }
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(64);
        }
        UnwrappedType approximatedType = this.typeApproximator.approximateDeclarationType(type, true);
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope.getOwnerDescriptor(), this.annotationResolver.resolveAnnotationsWithArguments(scope, parameter.getModifierList(), trace), KtPsiUtil.safeName((String)parameter.getName()), approximatedType, KotlinSourceElementKt.toSourceElement((KtPureElement)parameter));
        trace.record(BindingContext.VALUE_PARAMETER, parameter, variableDescriptor);
        ForceResolveUtil.forceResolveAllContents(type.getAnnotations());
        return variableDescriptor;
    }

    @NotNull
    public TypeAliasDescriptor resolveTypeAliasDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull LexicalScope scope, @NotNull KtTypeAlias typeAlias, @NotNull BindingTrace trace) {
        List<TypeParameterDescriptorImpl> typeParameterDescriptors;
        LexicalScope scopeWithTypeParameters;
        if (containingDeclaration == null) {
            DescriptorResolver.$$$reportNull$$$0(65);
        }
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(66);
        }
        if (typeAlias == null) {
            DescriptorResolver.$$$reportNull$$$0(67);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(68);
        }
        if (!(containingDeclaration instanceof PackageFragmentDescriptor) && !(containingDeclaration instanceof ScriptDescriptor)) {
            trace.report(Errors.TOPLEVEL_TYPEALIASES_ONLY.on(typeAlias));
        }
        KtModifierList modifierList = typeAlias.getModifierList();
        DescriptorVisibility visibility = ModifiersChecker.resolveVisibilityFromModifiers((KtModifierListOwner)typeAlias, DescriptorResolver.getDefaultVisibility((KtModifierListOwner)typeAlias, containingDeclaration));
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithArguments(scope, modifierList, trace);
        Name name = KtPsiUtil.safeName((String)typeAlias.getName());
        SourceElement sourceElement = KotlinSourceElementKt.toSourceElement((KtPureElement)typeAlias);
        LazyTypeAliasDescriptor typeAliasDescriptor = LazyTypeAliasDescriptor.create(this.storageManager, trace, containingDeclaration, allAnnotations, name, sourceElement, visibility);
        List typeParameters = typeAlias.getTypeParameters();
        if (typeParameters.isEmpty()) {
            scopeWithTypeParameters = scope;
            typeParameterDescriptors = Collections.emptyList();
        } else {
            LexicalWritableScope writableScope = new LexicalWritableScope(scope, containingDeclaration, false, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.TYPE_ALIAS_HEADER);
            typeParameterDescriptors = this.resolveTypeParametersForDescriptor(typeAliasDescriptor, writableScope, scope, typeParameters, trace);
            writableScope.freeze();
            DescriptorResolver.checkNoGenericBoundsOnTypeAliasParameters(typeAlias, trace);
            this.resolveGenericBounds((KtTypeParameterListOwner)typeAlias, typeAliasDescriptor, writableScope, typeParameterDescriptors, trace);
            scopeWithTypeParameters = writableScope;
        }
        KtTypeReference typeReference = typeAlias.getTypeReference();
        if (typeReference == null) {
            typeAliasDescriptor.initialize(typeParameterDescriptors, ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_TYPE_ALIAS, name.asString()), ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_TYPE_ALIAS, name.asString()));
        } else if (!this.languageVersionSettings.supportsFeature(LanguageFeature.TypeAliases)) {
            this.typeResolver.resolveAbbreviatedType(scopeWithTypeParameters, typeReference, trace);
            PsiElement typeAliasKeyword = typeAlias.getTypeAliasKeyword();
            trace.report(Errors.UNSUPPORTED_FEATURE.on((PsiElement)(typeAliasKeyword != null ? typeAliasKeyword : typeAlias), (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)LanguageFeature.TypeAliases, (Object)this.languageVersionSettings)));
            typeAliasDescriptor.initialize(typeParameterDescriptors, ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_TYPE_ALIAS, name.asString()), ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_TYPE_ALIAS, name.asString()));
        } else {
            typeAliasDescriptor.initialize(typeParameterDescriptors, (NotNullLazyValue<? extends SimpleType>)this.storageManager.createRecursionTolerantLazyValue(() -> this.typeResolver.resolveAbbreviatedType(scopeWithTypeParameters, typeReference, trace), (Object)ErrorUtils.createErrorType(ErrorTypeKind.RECURSIVE_TYPE_ALIAS, typeAliasDescriptor.getName().asString())), (NotNullLazyValue<? extends SimpleType>)this.storageManager.createRecursionTolerantLazyValue(() -> this.typeResolver.resolveExpandedTypeForTypeAlias(typeAliasDescriptor), (Object)ErrorUtils.createErrorType(ErrorTypeKind.RECURSIVE_TYPE_ALIAS, typeAliasDescriptor.getName().asString())));
        }
        trace.record(BindingContext.TYPE_ALIAS, typeAlias, typeAliasDescriptor);
        LazyTypeAliasDescriptor lazyTypeAliasDescriptor = typeAliasDescriptor;
        if (lazyTypeAliasDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(69);
        }
        return lazyTypeAliasDescriptor;
    }

    private static void checkNoGenericBoundsOnTypeAliasParameters(@NotNull KtTypeAlias typeAlias, @NotNull BindingTrace trace) {
        if (typeAlias == null) {
            DescriptorResolver.$$$reportNull$$$0(70);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(71);
        }
        for (KtTypeParameter typeParameter : typeAlias.getTypeParameters()) {
            KtTypeReference bound = typeParameter.getExtendsBound();
            if (bound == null) continue;
            trace.report(Errors.BOUND_ON_TYPE_ALIAS_PARAMETER_NOT_ALLOWED.on(bound));
        }
    }

    @NotNull
    public PropertyDescriptor resolveDestructuringDeclarationEntryAsProperty(@NotNull DeclarationDescriptor containingDeclaration, @NotNull LexicalScope scopeForDeclarationResolution, @NotNull LexicalScope scopeForInitializerResolution, @NotNull KtDestructuringDeclarationEntry entry, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @NotNull InferenceSession inferenceSession) {
        if (containingDeclaration == null) {
            DescriptorResolver.$$$reportNull$$$0(72);
        }
        if (scopeForDeclarationResolution == null) {
            DescriptorResolver.$$$reportNull$$$0(73);
        }
        if (scopeForInitializerResolution == null) {
            DescriptorResolver.$$$reportNull$$$0(74);
        }
        if (entry == null) {
            DescriptorResolver.$$$reportNull$$$0(75);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(76);
        }
        if (dataFlowInfo == null) {
            DescriptorResolver.$$$reportNull$$$0(77);
        }
        if (inferenceSession == null) {
            DescriptorResolver.$$$reportNull$$$0(78);
        }
        KtDestructuringDeclaration destructuringDeclaration = (KtDestructuringDeclaration)entry.getParent();
        KtExpression initializer = destructuringDeclaration.getInitializer();
        ExpressionTypingContext context = ExpressionTypingContext.newContext(trace, scopeForDeclarationResolution, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, this.languageVersionSettings, this.dataFlowValueFactory, inferenceSession);
        ExpressionReceiver receiver = this.createReceiverForDestructuringDeclaration(destructuringDeclaration, context);
        int componentIndex = destructuringDeclaration.getEntries().indexOf(entry);
        KotlinType componentType = this.destructuringDeclarationResolver.resolveInitializer(entry, receiver, initializer, context, componentIndex);
        return this.resolveAsPropertyDescriptor(containingDeclaration, scopeForDeclarationResolution, scopeForInitializerResolution, (KtVariableDeclaration)entry, trace, dataFlowInfo, inferenceSession, VariableAsPropertyInfo.Companion.createFromDestructuringDeclarationEntry(componentType));
    }

    private ExpressionReceiver createReceiverForDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration, @NotNull ExpressionTypingContext context) {
        KtExpression initializer;
        if (destructuringDeclaration == null) {
            DescriptorResolver.$$$reportNull$$$0(79);
        }
        if (context == null) {
            DescriptorResolver.$$$reportNull$$$0(80);
        }
        if ((initializer = destructuringDeclaration.getInitializer()) == null) {
            return null;
        }
        KotlinType initializerType = this.expressionTypingServices.getTypeInfo(initializer, context).getType();
        if (initializerType == null) {
            return null;
        }
        return ExpressionReceiver.Companion.create(initializer, initializerType, context.trace.getBindingContext());
    }

    @NotNull
    public PropertyDescriptor resolvePropertyDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull LexicalScope scopeForDeclarationResolution, @NotNull LexicalScope scopeForInitializerResolution, @NotNull KtProperty property2, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @NotNull InferenceSession inferenceSession) {
        if (containingDeclaration == null) {
            DescriptorResolver.$$$reportNull$$$0(81);
        }
        if (scopeForDeclarationResolution == null) {
            DescriptorResolver.$$$reportNull$$$0(82);
        }
        if (scopeForInitializerResolution == null) {
            DescriptorResolver.$$$reportNull$$$0(83);
        }
        if (property2 == null) {
            DescriptorResolver.$$$reportNull$$$0(84);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(85);
        }
        if (dataFlowInfo == null) {
            DescriptorResolver.$$$reportNull$$$0(86);
        }
        if (inferenceSession == null) {
            DescriptorResolver.$$$reportNull$$$0(87);
        }
        return this.resolveAsPropertyDescriptor(containingDeclaration, scopeForDeclarationResolution, scopeForInitializerResolution, (KtVariableDeclaration)property2, trace, dataFlowInfo, inferenceSession, VariableAsPropertyInfo.Companion.createFromProperty(property2));
    }

    @NotNull
    private PropertyDescriptor resolveAsPropertyDescriptor(@NotNull DeclarationDescriptor container, @NotNull LexicalScope scopeForDeclarationResolution, @NotNull LexicalScope scopeForInitializerResolution, @NotNull KtVariableDeclaration variableDeclaration, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @Nullable InferenceSession inferenceSession, @NotNull VariableAsPropertyInfo propertyInfo) {
        KotlinType type;
        List<Object> typeParameterDescriptors;
        LexicalScope scopeForInitializerResolutionWithTypeParameters;
        LexicalScope scopeForDeclarationResolutionWithTypeParameters;
        if (container == null) {
            DescriptorResolver.$$$reportNull$$$0(88);
        }
        if (scopeForDeclarationResolution == null) {
            DescriptorResolver.$$$reportNull$$$0(89);
        }
        if (scopeForInitializerResolution == null) {
            DescriptorResolver.$$$reportNull$$$0(90);
        }
        if (variableDeclaration == null) {
            DescriptorResolver.$$$reportNull$$$0(91);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(92);
        }
        if (dataFlowInfo == null) {
            DescriptorResolver.$$$reportNull$$$0(93);
        }
        if (propertyInfo == null) {
            DescriptorResolver.$$$reportNull$$$0(94);
        }
        KtModifierList modifierList = variableDeclaration.getModifierList();
        boolean isVar = variableDeclaration.isVar();
        DescriptorVisibility visibility = ModifiersChecker.resolveVisibilityFromModifiers((KtModifierListOwner)variableDeclaration, DescriptorResolver.getDefaultVisibility((KtModifierListOwner)variableDeclaration, container));
        Modality modality = container instanceof ClassDescriptor ? ModifiersChecker.resolveMemberModalityFromModifiers((KtModifierListOwner)variableDeclaration, DescriptorResolver.getDefaultModality(container, visibility, propertyInfo.getHasBody()), trace.getBindingContext(), container) : Modality.FINAL;
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scopeForDeclarationResolution, modifierList, trace);
        EnumSet<AnnotationUseSiteTarget> targetSet = EnumSet.of(AnnotationUseSiteTarget.PROPERTY, AnnotationUseSiteTarget.PROPERTY_GETTER, AnnotationUseSiteTarget.FIELD);
        if (isVar) {
            targetSet.add(AnnotationUseSiteTarget.PROPERTY_SETTER);
            targetSet.add(AnnotationUseSiteTarget.SETTER_PARAMETER);
        }
        if (variableDeclaration instanceof KtProperty && ((KtProperty)variableDeclaration).hasDelegate()) {
            targetSet.add(AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD);
        }
        AnnotationSplitter annotationSplitter = new AnnotationSplitter(this.storageManager, allAnnotations, targetSet);
        CompositeAnnotations propertyAnnotations = new CompositeAnnotations(CollectionsKt.listOf((Object[])new Annotations[]{annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY), annotationSplitter.getOtherAnnotations()}));
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(container, propertyAnnotations, modality, visibility, isVar, KtPsiUtil.safeName((String)variableDeclaration.getName()), CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement((KtPureElement)variableDeclaration), modifierList != null && modifierList.hasModifier(KtTokens.LATEINIT_KEYWORD), modifierList != null && modifierList.hasModifier(KtTokens.CONST_KEYWORD), modifierList != null && PsiUtilsKt.hasExpectModifier((KtModifierList)modifierList) && container instanceof PackageFragmentDescriptor || container instanceof ClassDescriptor && ((ClassDescriptor)container).isExpect(), modifierList != null && PsiUtilsKt.hasActualModifier((KtModifierList)modifierList), modifierList != null && modifierList.hasModifier(KtTokens.EXTERNAL_KEYWORD), propertyInfo.getHasDelegate());
        KotlinType receiverType = null;
        List typeParameters = variableDeclaration.getTypeParameters();
        if (typeParameters.isEmpty()) {
            scopeForDeclarationResolutionWithTypeParameters = scopeForDeclarationResolution;
            scopeForInitializerResolutionWithTypeParameters = scopeForInitializerResolution;
            typeParameterDescriptors = Collections.emptyList();
        } else {
            LexicalWritableScope writableScopeForDeclarationResolution = new LexicalWritableScope(scopeForDeclarationResolution, container, false, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.PROPERTY_HEADER);
            LexicalWritableScope writableScopeForInitializerResolution = new LexicalWritableScope(scopeForInitializerResolution, container, false, LocalRedeclarationChecker.DO_NOTHING.INSTANCE, LexicalScopeKind.PROPERTY_HEADER);
            typeParameterDescriptors = this.resolveTypeParametersForDescriptor(propertyDescriptor, scopeForDeclarationResolution, typeParameters, trace);
            for (TypeParameterDescriptor typeParameterDescriptor : typeParameterDescriptors) {
                writableScopeForDeclarationResolution.addClassifierDescriptor(typeParameterDescriptor);
                writableScopeForInitializerResolution.addClassifierDescriptor(typeParameterDescriptor);
            }
            writableScopeForDeclarationResolution.freeze();
            writableScopeForInitializerResolution.freeze();
            this.resolveGenericBounds((KtTypeParameterListOwner)variableDeclaration, propertyDescriptor, writableScopeForDeclarationResolution, typeParameterDescriptors, trace);
            scopeForDeclarationResolutionWithTypeParameters = writableScopeForDeclarationResolution;
            scopeForInitializerResolutionWithTypeParameters = writableScopeForInitializerResolution;
        }
        KtTypeReference receiverTypeRef = variableDeclaration.getReceiverTypeReference();
        ReceiverParameterDescriptor receiverDescriptor = null;
        if (receiverTypeRef != null) {
            receiverType = this.typeResolver.resolveType(scopeForDeclarationResolutionWithTypeParameters, receiverTypeRef, trace, true);
            AnnotationSplitter splitter = new AnnotationSplitter(this.storageManager, receiverType.getAnnotations(), EnumSet.of(AnnotationUseSiteTarget.RECEIVER));
            receiverDescriptor = DescriptorFactory.createExtensionReceiverParameterForCallable(propertyDescriptor, receiverType, splitter.getAnnotationsForTarget(AnnotationUseSiteTarget.RECEIVER));
        }
        List contextReceivers = variableDeclaration.getContextReceivers();
        List<ReceiverParameterDescriptor> contextReceiverDescriptors = IntStream.range(0, contextReceivers.size()).mapToObj(index -> {
            KtContextReceiver contextReceiver = (KtContextReceiver)contextReceivers.get(index);
            KtTypeReference typeReference = contextReceiver.typeReference();
            if (typeReference == null) {
                return null;
            }
            KotlinType type = this.typeResolver.resolveType(scopeForDeclarationResolutionWithTypeParameters, typeReference, trace, true);
            AnnotationSplitter splitter = new AnnotationSplitter(this.storageManager, type.getAnnotations(), EnumSet.of(AnnotationUseSiteTarget.RECEIVER));
            return DescriptorFactory.createContextReceiverParameterForCallable(propertyDescriptor, type, contextReceiver.labelNameAsName(), splitter.getAnnotationsForTarget(AnnotationUseSiteTarget.RECEIVER), index);
        }).collect(Collectors.toList());
        if (this.languageVersionSettings.supportsFeature(LanguageFeature.ContextReceivers)) {
            String receiverName;
            HashMultimap hashMultimap = HashMultimap.create();
            if (receiverTypeRef != null && (receiverName = receiverTypeRef.nameForReceiverLabel()) != null) {
                hashMultimap.put((Object)receiverName, (Object)receiverDescriptor);
            }
            for (int i = 0; i < contextReceivers.size(); ++i) {
                String contextReceiverName = ((KtContextReceiver)contextReceivers.get(i)).name();
                if (contextReceiverName == null) continue;
                hashMultimap.put((Object)contextReceiverName, contextReceiverDescriptors.get(i));
            }
            trace.record(BindingContext.DESCRIPTOR_TO_CONTEXT_RECEIVER_MAP, propertyDescriptor, hashMultimap);
        }
        LexicalScope lexicalScope = ScopeUtils.makeScopeForPropertyInitializer(scopeForInitializerResolutionWithTypeParameters, propertyDescriptor);
        KotlinType propertyType = propertyInfo.getVariableType();
        KotlinType typeIfKnown = propertyType != null ? propertyType : this.variableTypeAndInitializerResolver.resolveTypeNullable(propertyDescriptor, lexicalScope, variableDeclaration, dataFlowInfo, inferenceSession, trace, false);
        PropertyGetterDescriptorImpl getter = this.resolvePropertyGetterDescriptor(scopeForDeclarationResolutionWithTypeParameters, variableDeclaration, propertyDescriptor, annotationSplitter, trace, typeIfKnown, propertyInfo.getPropertyGetter(), propertyInfo.getHasDelegate(), inferenceSession);
        KotlinType kotlinType = type = typeIfKnown != null ? typeIfKnown : getter.getReturnType();
        assert (type != null) : "At least getter type must be initialized via resolvePropertyGetterDescriptor";
        this.variableTypeAndInitializerResolver.setConstantForVariableIfNeeded(propertyDescriptor, lexicalScope, variableDeclaration, dataFlowInfo, type, inferenceSession, trace);
        propertyDescriptor.setType(type, typeParameterDescriptors, DescriptorUtils.getDispatchReceiverParameterIfNeeded(container), receiverDescriptor, contextReceiverDescriptors);
        PropertySetterDescriptor setter = this.resolvePropertySetterDescriptor(scopeForDeclarationResolutionWithTypeParameters, variableDeclaration, propertyDescriptor, annotationSplitter, trace, propertyInfo.getPropertySetter(), propertyInfo.getHasDelegate(), inferenceSession);
        propertyDescriptor.initialize(getter, setter, new FieldDescriptorImpl(annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.FIELD), propertyDescriptor), new FieldDescriptorImpl(annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD), propertyDescriptor));
        trace.record(BindingContext.VARIABLE, variableDeclaration, propertyDescriptor);
        PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
        if (propertyDescriptorImpl == null) {
            DescriptorResolver.$$$reportNull$$$0(95);
        }
        return propertyDescriptorImpl;
    }

    @NotNull
    static KotlinType transformAnonymousTypeIfNeeded(@NotNull DeclarationDescriptorWithVisibility descriptor, @NotNull KtDeclaration declaration, @NotNull KotlinType type, @NotNull BindingTrace trace, @NotNull Iterable<DeclarationSignatureAnonymousTypeTransformer> anonymousTypeTransformers, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (descriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(96);
        }
        if (declaration == null) {
            DescriptorResolver.$$$reportNull$$$0(97);
        }
        if (type == null) {
            DescriptorResolver.$$$reportNull$$$0(98);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(99);
        }
        if (anonymousTypeTransformers == null) {
            DescriptorResolver.$$$reportNull$$$0(100);
        }
        if (languageVersionSettings == null) {
            DescriptorResolver.$$$reportNull$$$0(101);
        }
        for (DeclarationSignatureAnonymousTypeTransformer transformer2 : anonymousTypeTransformers) {
            KotlinType transformedType = transformer2.transformAnonymousType(descriptor, type);
            if (transformedType == null) continue;
            KotlinType kotlinType = transformedType;
            if (kotlinType == null) {
                DescriptorResolver.$$$reportNull$$$0(102);
            }
            return kotlinType;
        }
        ClassifierDescriptor classifier = type.getConstructor().getDeclarationDescriptor();
        if (classifier == null || !DescriptorUtils.isAnonymousObject(classifier) || DescriptorUtils.isLocal(descriptor)) {
            KotlinType kotlinType = type;
            if (kotlinType == null) {
                DescriptorResolver.$$$reportNull$$$0(103);
            }
            return kotlinType;
        }
        boolean isPrivate = DescriptorVisibilities.isPrivate(descriptor.getVisibility());
        boolean isInlineFunction = descriptor instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)descriptor).isInline();
        boolean isAnonymousReturnTypesInPrivateInlineFunctionsForbidden = languageVersionSettings.supportsFeature(LanguageFeature.ApproximateAnonymousReturnTypesInPrivateInlineFunctions);
        if (!isPrivate || isInlineFunction && isAnonymousReturnTypesInPrivateInlineFunctionsForbidden) {
            if (type.getConstructor().getSupertypes().size() == 1) {
                KotlinType approximatingSuperType = type.getConstructor().getSupertypes().iterator().next();
                MemberScope memberScope2 = type.getMemberScope();
                KotlinType substitutedSuperType = memberScope2 instanceof SubstitutingScope ? ((SubstitutingScope)memberScope2).substitute(approximatingSuperType) : approximatingSuperType;
                UnwrappedType unwrapped = type.unwrap();
                boolean lowerNullable = FlexibleTypesKt.lowerIfFlexible(unwrapped).isMarkedNullable();
                boolean upperNullable = FlexibleTypesKt.upperIfFlexible(unwrapped).isMarkedNullable();
                if (languageVersionSettings.supportsFeature(LanguageFeature.KeepNullabilityWhenApproximatingLocalType)) {
                    if (lowerNullable != upperNullable) {
                        UnwrappedType unwrappedType = KotlinTypeFactory.flexibleType(FlexibleTypesKt.lowerIfFlexible(substitutedSuperType), FlexibleTypesKt.upperIfFlexible(substitutedSuperType).makeNullableAsSpecified(true));
                        if (unwrappedType == null) {
                            DescriptorResolver.$$$reportNull$$$0(104);
                        }
                        return unwrappedType;
                    }
                    KotlinType kotlinType = TypeUtils.makeNullableIfNeeded(substitutedSuperType, upperNullable);
                    if (kotlinType == null) {
                        DescriptorResolver.$$$reportNull$$$0(105);
                    }
                    return kotlinType;
                }
                if (upperNullable) {
                    if (lowerNullable) {
                        trace.report(Errors.APPROXIMATED_LOCAL_TYPE_WILL_BECOME_NULLABLE.on(declaration, substitutedSuperType));
                    } else {
                        trace.report(Errors.APPROXIMATED_LOCAL_TYPE_WILL_BECOME_FLEXIBLE.on(declaration, substitutedSuperType));
                    }
                }
                KotlinType kotlinType = substitutedSuperType;
                if (kotlinType == null) {
                    DescriptorResolver.$$$reportNull$$$0(106);
                }
                return kotlinType;
            }
            trace.report(Errors.AMBIGUOUS_ANONYMOUS_TYPE_INFERRED.on(declaration, type.getConstructor().getSupertypes()));
        }
        KotlinType kotlinType = type;
        if (kotlinType == null) {
            DescriptorResolver.$$$reportNull$$$0(107);
        }
        return kotlinType;
    }

    @Nullable
    private PropertySetterDescriptor resolvePropertySetterDescriptor(@NotNull LexicalScope scopeWithTypeParameters, @NotNull KtVariableDeclaration property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull AnnotationSplitter annotationSplitter, @NotNull BindingTrace trace, @Nullable KtPropertyAccessor setter, boolean hasDelegate, @Nullable InferenceSession inferenceSession) {
        if (scopeWithTypeParameters == null) {
            DescriptorResolver.$$$reportNull$$$0(108);
        }
        if (property2 == null) {
            DescriptorResolver.$$$reportNull$$$0(109);
        }
        if (propertyDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(110);
        }
        if (annotationSplitter == null) {
            DescriptorResolver.$$$reportNull$$$0(111);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(112);
        }
        PropertySetterDescriptorImpl setterDescriptor = null;
        Annotations setterTargetedAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_SETTER);
        Annotations parameterTargetedAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.SETTER_PARAMETER);
        if (setter != null) {
            KotlinType returnType;
            CompositeAnnotations annotations = new CompositeAnnotations(CollectionsKt.listOf((Object[])new Annotations[]{setterTargetedAnnotations, this.annotationResolver.resolveAnnotationsWithoutArguments(scopeWithTypeParameters, setter.getModifierList(), trace)}));
            KtParameter parameter = setter.getParameter();
            setterDescriptor = new PropertySetterDescriptorImpl(propertyDescriptor, annotations, ModifiersChecker.resolveMemberModalityFromModifiers((KtModifierListOwner)setter, propertyDescriptor.getModality(), trace.getBindingContext(), propertyDescriptor.getContainingDeclaration()), ModifiersChecker.resolveVisibilityFromModifiers((KtModifierListOwner)setter, propertyDescriptor.getVisibility()), false, setter.hasModifier(KtTokens.EXTERNAL_KEYWORD), property2.hasModifier(KtTokens.INLINE_KEYWORD) || setter.hasModifier(KtTokens.INLINE_KEYWORD), CallableMemberDescriptor.Kind.DECLARATION, null, KotlinSourceElementKt.toSourceElement((KtPureElement)setter));
            KtTypeReference returnTypeReference = setter.getTypeReference();
            if (returnTypeReference != null && !KotlinBuiltIns.isUnit(returnType = this.typeResolver.resolveType(scopeWithTypeParameters, returnTypeReference, trace, true))) {
                trace.report(Errors.WRONG_SETTER_RETURN_TYPE.on(returnTypeReference));
            }
            if (parameter != null) {
                KotlinType type;
                KtTypeReference typeReference;
                if (parameter.hasDefaultValue()) {
                    trace.report(Errors.SETTER_PARAMETER_WITH_DEFAULT_VALUE.on(parameter.getDefaultValue()));
                }
                if ((typeReference = parameter.getTypeReference()) == null) {
                    type = propertyDescriptor.getType();
                } else {
                    KotlinType inType;
                    type = this.typeResolver.resolveType(scopeWithTypeParameters, typeReference, trace, true);
                    if (!TypeUtils.equalTypes(type, inType = propertyDescriptor.getType())) {
                        trace.report(Errors.WRONG_SETTER_PARAMETER_TYPE.on(typeReference, inType, type));
                    }
                }
                ValueParameterDescriptorImpl valueParameterDescriptor = this.resolveValueParameterDescriptor(scopeWithTypeParameters, setterDescriptor, parameter, 0, type, trace, parameterTargetedAnnotations, inferenceSession);
                setterDescriptor.initialize(valueParameterDescriptor);
            } else {
                setterDescriptor.initializeDefault();
            }
            trace.record(BindingContext.PROPERTY_ACCESSOR, setter, setterDescriptor);
        } else if (property2.isVar()) {
            setterDescriptor = DescriptorFactory.createSetter(propertyDescriptor, setterTargetedAnnotations, parameterTargetedAnnotations, !hasDelegate && setterTargetedAnnotations.isEmpty() && parameterTargetedAnnotations.isEmpty(), false, property2.hasModifier(KtTokens.INLINE_KEYWORD), propertyDescriptor.getSource());
        }
        if (!property2.isVar() && setter != null) {
            trace.report(Errors.VAL_WITH_SETTER.on(setter));
        }
        return setterDescriptor;
    }

    @NotNull
    private PropertyGetterDescriptorImpl resolvePropertyGetterDescriptor(@NotNull LexicalScope scopeForDeclarationResolution, @NotNull KtVariableDeclaration property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull AnnotationSplitter annotationSplitter, @NotNull BindingTrace trace, @Nullable KotlinType propertyTypeIfKnown, @Nullable KtPropertyAccessor getter, boolean hasDelegate, @Nullable InferenceSession inferenceSession) {
        KotlinType getterType;
        PropertyGetterDescriptorImpl getterDescriptor;
        if (scopeForDeclarationResolution == null) {
            DescriptorResolver.$$$reportNull$$$0(113);
        }
        if (property2 == null) {
            DescriptorResolver.$$$reportNull$$$0(114);
        }
        if (propertyDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(115);
        }
        if (annotationSplitter == null) {
            DescriptorResolver.$$$reportNull$$$0(116);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(117);
        }
        Annotations getterTargetedAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_GETTER);
        if (getter != null) {
            CompositeAnnotations getterAnnotations = new CompositeAnnotations(CollectionsKt.listOf((Object[])new Annotations[]{getterTargetedAnnotations, this.annotationResolver.resolveAnnotationsWithoutArguments(scopeForDeclarationResolution, getter.getModifierList(), trace)}));
            getterDescriptor = new PropertyGetterDescriptorImpl(propertyDescriptor, getterAnnotations, ModifiersChecker.resolveMemberModalityFromModifiers((KtModifierListOwner)getter, propertyDescriptor.getModality(), trace.getBindingContext(), propertyDescriptor.getContainingDeclaration()), ModifiersChecker.resolveVisibilityFromModifiers((KtModifierListOwner)getter, propertyDescriptor.getVisibility()), false, getter.hasModifier(KtTokens.EXTERNAL_KEYWORD), property2.hasModifier(KtTokens.INLINE_KEYWORD) || getter.hasModifier(KtTokens.INLINE_KEYWORD), CallableMemberDescriptor.Kind.DECLARATION, null, KotlinSourceElementKt.toSourceElement((KtPureElement)getter));
            getterType = this.determineGetterReturnType(scopeForDeclarationResolution, trace, getterDescriptor, getter, propertyTypeIfKnown, inferenceSession);
        } else {
            getterDescriptor = DescriptorFactory.createGetter(propertyDescriptor, getterTargetedAnnotations, !hasDelegate && getterTargetedAnnotations.isEmpty(), false, property2.hasModifier(KtTokens.INLINE_KEYWORD));
            getterType = propertyTypeIfKnown;
        }
        getterDescriptor.initialize(getterType != null ? getterType : VariableTypeAndInitializerResolver.getTypeForPropertyWithoutReturnType(propertyDescriptor.getName().asString()));
        if (getter != null) {
            trace.record(BindingContext.PROPERTY_ACCESSOR, getter, getterDescriptor);
        }
        PropertyGetterDescriptorImpl propertyGetterDescriptorImpl = getterDescriptor;
        if (propertyGetterDescriptorImpl == null) {
            DescriptorResolver.$$$reportNull$$$0(118);
        }
        return propertyGetterDescriptorImpl;
    }

    @Nullable
    private KotlinType determineGetterReturnType(@NotNull LexicalScope scope, @NotNull BindingTrace trace, @NotNull PropertyGetterDescriptor getterDescriptor, @NotNull KtPropertyAccessor getter, @Nullable KotlinType propertyTypeIfKnown, @Nullable InferenceSession inferenceSession) {
        KtTypeReference returnTypeReference;
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(119);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(120);
        }
        if (getterDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(121);
        }
        if (getter == null) {
            DescriptorResolver.$$$reportNull$$$0(122);
        }
        if ((returnTypeReference = getter.getTypeReference()) != null) {
            KotlinType explicitReturnType = this.typeResolver.resolveType(scope, returnTypeReference, trace, true);
            if (propertyTypeIfKnown != null && !TypeUtils.equalTypes(explicitReturnType, propertyTypeIfKnown)) {
                trace.report(Errors.WRONG_GETTER_RETURN_TYPE.on(returnTypeReference, propertyTypeIfKnown, explicitReturnType));
            }
            return explicitReturnType;
        }
        KtProperty property2 = getter.getProperty();
        if (!property2.hasDelegateExpressionOrInitializer() && property2.getTypeReference() == null && getter.hasBody() && !getter.hasBlockBody()) {
            return this.inferReturnTypeFromExpressionBody(trace, scope, DataFlowInfoFactory.EMPTY, (KtDeclarationWithBody)getter, getterDescriptor, inferenceSession);
        }
        return propertyTypeIfKnown;
    }

    @NotNull
    KotlinType inferReturnTypeFromExpressionBody(@NotNull BindingTrace trace, @NotNull LexicalScope scope, @NotNull DataFlowInfo dataFlowInfo, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor, @Nullable InferenceSession inferenceSession) {
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(123);
        }
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(124);
        }
        if (dataFlowInfo == null) {
            DescriptorResolver.$$$reportNull$$$0(125);
        }
        if (function2 == null) {
            DescriptorResolver.$$$reportNull$$$0(126);
        }
        if (functionDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(127);
        }
        KotlinType kotlinType = this.wrappedTypeFactory.createRecursionIntolerantDeferredType(trace, (Function0<? extends KotlinType>)((Function0)() -> {
            PreliminaryDeclarationVisitor.Companion.createForDeclaration((KtDeclaration)function2, trace, this.languageVersionSettings);
            KotlinType type = this.expressionTypingServices.getBodyExpressionType(trace, scope, dataFlowInfo, function2, functionDescriptor, inferenceSession);
            KotlinType publicType = DescriptorResolver.transformAnonymousTypeIfNeeded(functionDescriptor, (KtDeclaration)function2, type, trace, this.anonymousTypeTransformers, this.languageVersionSettings);
            UnwrappedType approximatedType = this.typeApproximator.approximateDeclarationType(publicType, false);
            UnwrappedType sanitizedType = this.declarationReturnTypeSanitizer.sanitizeReturnType(approximatedType, this.wrappedTypeFactory, trace, this.languageVersionSettings);
            this.functionsTypingVisitor.checkTypesForReturnStatements(function2, trace, sanitizedType);
            return sanitizedType;
        }));
        if (kotlinType == null) {
            DescriptorResolver.$$$reportNull$$$0(128);
        }
        return kotlinType;
    }

    public PropertyDescriptor resolvePrimaryConstructorParameterToAProperty(@NotNull ClassDescriptor classDescriptor, @NotNull ValueParameterDescriptor valueParameter, @NotNull LexicalScope scope, @NotNull KtParameter parameter, BindingTrace trace) {
        if (classDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(129);
        }
        if (valueParameter == null) {
            DescriptorResolver.$$$reportNull$$$0(130);
        }
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(131);
        }
        if (parameter == null) {
            DescriptorResolver.$$$reportNull$$$0(132);
        }
        KotlinType type = this.resolveParameterType(scope, parameter, trace);
        Name name = parameter.getNameAsSafeName();
        boolean isMutable = parameter.isMutable();
        KtModifierList modifierList = parameter.getModifierList();
        if (modifierList != null && modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            trace.report(Errors.ABSTRACT_PROPERTY_IN_PRIMARY_CONSTRUCTOR_PARAMETERS.on((KtModifierListOwner)parameter));
        }
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scope, parameter.getModifierList(), trace);
        EnumSet<AnnotationUseSiteTarget> targetSet = EnumSet.of(AnnotationUseSiteTarget.PROPERTY, AnnotationUseSiteTarget.PROPERTY_GETTER, AnnotationUseSiteTarget.FIELD, AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER, AnnotationUseSiteTarget.PROPERTY_SETTER);
        if (isMutable) {
            targetSet.add(AnnotationUseSiteTarget.PROPERTY_SETTER);
            targetSet.add(AnnotationUseSiteTarget.SETTER_PARAMETER);
        }
        AnnotationSplitter annotationSplitter = new AnnotationSplitter(this.storageManager, allAnnotations, targetSet);
        CompositeAnnotations propertyAnnotations = new CompositeAnnotations(annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY), annotationSplitter.getOtherAnnotations());
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(classDescriptor, propertyAnnotations, ModifiersChecker.resolveMemberModalityFromModifiers((KtModifierListOwner)parameter, Modality.FINAL, trace.getBindingContext(), classDescriptor), ModifiersChecker.resolveVisibilityFromModifiers((KtModifierListOwner)parameter, DescriptorResolver.getDefaultVisibility((KtModifierListOwner)parameter, classDescriptor)), isMutable, name, CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement((KtPureElement)parameter), false, false, classDescriptor.isExpect(), modifierList != null && PsiUtilsKt.hasActualModifier((KtModifierList)modifierList), false, false);
        propertyDescriptor.setType(type, Collections.emptyList(), DescriptorUtils.getDispatchReceiverParameterIfNeeded(classDescriptor), null, CollectionsKt.emptyList());
        Annotations setterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_SETTER);
        CompositeAnnotations getterAnnotations = new CompositeAnnotations(CollectionsKt.listOf((Object)annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_GETTER)));
        PropertyGetterDescriptorImpl getter = DescriptorFactory.createDefaultGetter(propertyDescriptor, getterAnnotations);
        PropertySetterDescriptorImpl setter = propertyDescriptor.isVar() ? DescriptorFactory.createDefaultSetter(propertyDescriptor, setterAnnotations, annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.SETTER_PARAMETER)) : null;
        propertyDescriptor.initialize(getter, setter, new FieldDescriptorImpl(annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.FIELD), propertyDescriptor), null);
        getter.initialize(propertyDescriptor.getType());
        trace.record(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter, propertyDescriptor);
        trace.record(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameter, propertyDescriptor);
        return propertyDescriptor;
    }

    public static boolean checkHasOuterClassInstance(@NotNull LexicalScope scope, @NotNull BindingTrace trace, @NotNull PsiElement reportErrorsOn, @NotNull ClassDescriptor target) {
        ClassDescriptor classDescriptor;
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(133);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(134);
        }
        if (reportErrorsOn == null) {
            DescriptorResolver.$$$reportNull$$$0(135);
        }
        if (target == null) {
            DescriptorResolver.$$$reportNull$$$0(136);
        }
        if (!DescriptorResolver.isInsideOuterClassOrItsSubclass(classDescriptor = DescriptorResolver.getContainingClass(scope), target)) {
            return true;
        }
        while (classDescriptor != null) {
            if (DescriptorUtils.isSubclass(classDescriptor, target)) {
                return true;
            }
            if (DescriptorUtils.isStaticNestedClass(classDescriptor)) {
                PsiElement onReport = CallResolverUtilKt.reportOnElement(reportErrorsOn);
                trace.report(Errors.INACCESSIBLE_OUTER_CLASS_EXPRESSION.on(onReport, classDescriptor));
                return false;
            }
            classDescriptor = DescriptorUtils.getParentOfType(classDescriptor, ClassDescriptor.class, true);
        }
        return true;
    }

    private static boolean isInsideOuterClassOrItsSubclass(@Nullable DeclarationDescriptor nested, @NotNull ClassDescriptor outer) {
        if (outer == null) {
            DescriptorResolver.$$$reportNull$$$0(137);
        }
        if (nested == null) {
            return false;
        }
        if (nested instanceof ClassDescriptor && DescriptorUtils.isSubclass((ClassDescriptor)nested, outer)) {
            return true;
        }
        return DescriptorResolver.isInsideOuterClassOrItsSubclass(nested.getContainingDeclaration(), outer);
    }

    @Nullable
    public static ClassDescriptor getContainingClass(@NotNull LexicalScope scope) {
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(138);
        }
        return DescriptorUtils.getParentOfType(scope.getOwnerDescriptor(), ClassDescriptor.class, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 61: 
            case 69: 
            case 95: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 118: 
            case 128: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 61: 
            case 69: 
            case 95: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 118: 
            case 128: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationResolver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeResolver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supertypeLoopsResolver";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableTypeAndInitializerResolver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionTypingServices";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overloadChecker";
                break;
            }
            case 8: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionsTypingVisitor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringDeclarationResolver";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiersChecker";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappedTypeFactory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "approximator";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationReturnTypeSanitizer";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowValueFactory";
                break;
            }
            case 17: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anonymousTypeTransformers";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalClassPartsProvider";
                break;
            }
            case 19: 
            case 29: 
            case 36: 
            case 56: 
            case 59: 
            case 64: 
            case 66: 
            case 119: 
            case 124: 
            case 131: 
            case 133: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 20: 
            case 21: 
            case 44: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 61: 
            case 69: 
            case 95: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 118: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/DescriptorResolver";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 26: 
            case 27: 
            case 33: 
            case 38: 
            case 45: 
            case 49: 
            case 51: 
            case 57: 
            case 68: 
            case 71: 
            case 76: 
            case 85: 
            case 92: 
            case 99: 
            case 112: 
            case 117: 
            case 120: 
            case 123: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 28: 
            case 32: 
            case 63: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 31: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParameter";
                break;
            }
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalAnnotations";
                break;
            }
            case 37: 
            case 52: 
            case 60: 
            case 62: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 47: 
            case 54: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 48: 
            case 55: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperBoundType";
                break;
            }
            case 65: 
            case 72: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDeclaration";
                break;
            }
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAlias";
                break;
            }
            case 73: 
            case 82: 
            case 89: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForDeclarationResolution";
                break;
            }
            case 74: 
            case 83: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForInitializerResolution";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 77: 
            case 86: 
            case 93: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowInfo";
                break;
            }
            case 78: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferenceSession";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringDeclaration";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 84: 
            case 109: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDeclaration";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyInfo";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeWithTypeParameters";
                break;
            }
            case 110: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 111: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationSplitter";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getterDescriptor";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportErrorsOn";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/DescriptorResolver";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSupertype";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveValueParameterDescriptor";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveValueParameterAnnotations";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarargParameterType";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndRecordPrimaryConstructorForObject";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalVariableDescriptor";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTypeAliasDescriptor";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAsPropertyDescriptor";
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "transformAnonymousTypeIfNeeded";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePropertyGetterDescriptor";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "inferReturnTypeFromExpressionBody";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveSupertypes";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSupertype";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 61: 
            case 69: 
            case 95: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 118: 
            case 128: {
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveSuperTypeListEntries";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkNullableSupertypeAndStripQuestionMarks";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkProjectionsInImmediateArguments";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "resolveValueParameterDescriptor";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "resolveValueParameterAnnotations";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getVarargParameterType";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createAndRecordPrimaryConstructorForObject";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "resolveGenericBounds";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "checkUpperBoundTypes";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "checkConflictingUpperBounds";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "checkNamesInConstraints";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "checkUpperBoundType";
                break;
            }
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocalVariableDescriptor";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeAliasDescriptor";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "checkNoGenericBoundsOnTypeAliasParameters";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "resolveDestructuringDeclarationEntryAsProperty";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "createReceiverForDestructuringDeclaration";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "resolvePropertyDescriptor";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "resolveAsPropertyDescriptor";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "transformAnonymousTypeIfNeeded";
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "resolvePropertySetterDescriptor";
                break;
            }
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "resolvePropertyGetterDescriptor";
                break;
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "determineGetterReturnType";
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "inferReturnTypeFromExpressionBody";
                break;
            }
            case 129: 
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "resolvePrimaryConstructorParameterToAProperty";
                break;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "checkHasOuterClassInstance";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "isInsideOuterClassOrItsSubclass";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 61: 
            case 69: 
            case 95: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 118: 
            case 128: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class UpperBoundCheckRequest {
        public final Name typeParameterName;
        public final KtTypeReference upperBound;
        public final KotlinType upperBoundType;

        UpperBoundCheckRequest(Name typeParameterName, KtTypeReference upperBound, KotlinType upperBoundType) {
            this.typeParameterName = typeParameterName;
            this.upperBound = upperBound;
            this.upperBoundType = upperBoundType;
        }
    }
}

