/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.logical.impl.LogicalStructureViewService;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LogicalStructureNode;
import com.intellij.testFramework.PlatformTestUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import junit.framework.ComparisonFailure;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a'\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\b\t\u001a/\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\b\t\u001a?\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\b\t\u001a\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"MAX_DEPTH", "", "assertLogicalStructure", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "expectedStructureInitializer", "Lkotlin/Function1;", "Lcom/intellij/testFramework/LogicalStructureNode;", "Lkotlin/ExtensionFunctionType;", "nodePath", "", "selectedElement", "Lcom/intellij/psi/PsiElement;", "createActualNode", "element", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "intellij.java.testFramework"})
@SourceDebugExtension(value={"SMAP\nLogicalStructureTestUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogicalStructureTestUtils.kt\ncom/intellij/testFramework/LogicalStructureTestUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,262:1\n1869#2:263\n1870#2:266\n1400#3,2:264\n1#4:267\n*S KotlinDebug\n*F\n+ 1 LogicalStructureTestUtils.kt\ncom/intellij/testFramework/LogicalStructureTestUtilsKt\n*L\n55#1:263\n55#1:266\n56#1:264,2\n*E\n"})
public final class LogicalStructureTestUtilsKt {
    private static final int MAX_DEPTH = 20;

    public static final void assertLogicalStructure(@NotNull PsiFile psiFile, @NotNull Function1<? super LogicalStructureNode, Unit> expectedStructureInitializer) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter(expectedStructureInitializer, (String)"expectedStructureInitializer");
        LogicalStructureTestUtilsKt.assertLogicalStructure(psiFile, null, null, expectedStructureInitializer);
    }

    public static final void assertLogicalStructure(@NotNull PsiFile psiFile, @NotNull String nodePath, @NotNull Function1<? super LogicalStructureNode, Unit> expectedStructureInitializer) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)nodePath, (String)"nodePath");
        Intrinsics.checkNotNullParameter(expectedStructureInitializer, (String)"expectedStructureInitializer");
        LogicalStructureTestUtilsKt.assertLogicalStructure(psiFile, null, nodePath, expectedStructureInitializer);
    }

    public static final void assertLogicalStructure(@NotNull PsiFile psiFile, @Nullable PsiElement selectedElement, @Nullable String nodePath, @NotNull Function1<? super LogicalStructureNode, Unit> expectedStructureInitializer) {
        Object $this$forEach$iv;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter(expectedStructureInitializer, (String)"expectedStructureInitializer");
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        StructureViewBuilder builder = LogicalStructureViewService.Companion.getInstance(project2).getLogicalStructureBuilder(psiFile);
        TestCase.assertNotNull((Object)builder);
        StructureViewBuilder structureViewBuilder = builder;
        Intrinsics.checkNotNull((Object)structureViewBuilder);
        StructureView structureView = structureViewBuilder.createStructureView(null, project2);
        StructureViewTreeElement targetStructureElement = null;
        StructureViewTreeElement structureViewTreeElement = structureView.getTreeModel().getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)structureViewTreeElement, (String)"getRoot(...)");
        targetStructureElement = structureViewTreeElement;
        Object object = nodePath;
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{"/"}), (boolean)false, (int)0, (int)6, null)) != null) {
            $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object object2;
                String pathPart;
                block11: {
                    Object element$iv = iterator.next();
                    pathPart = (String)element$iv;
                    boolean bl = false;
                    TreeElement[] treeElementArray = targetStructureElement.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)treeElementArray, (String)"getChildren(...)");
                    Object[] $this$firstOrNull$iv = treeElementArray;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        Object object3;
                        ItemPresentation presentation;
                        TreeElement it = (TreeElement)element$iv2;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it.getPresentation(), (String)"getPresentation(...)");
                        if (!(Intrinsics.areEqual((Object)presentation.getPresentableText(), (Object)pathPart) || Intrinsics.areEqual((object3 = presentation instanceof PresentationData ? (PresentationData)presentation : null) != null && (object3 = object3.getColoredText()) != null && (object3 = (PresentableNodeDescriptor.ColoredFragment)CollectionsKt.firstOrNull((List)object3)) != null ? object3.getText() : null, (Object)pathPart))) continue;
                        object2 = element$iv2;
                        break block11;
                    }
                    object2 = null;
                }
                Object object4 = object2;
                StructureViewTreeElement child = object4 instanceof StructureViewTreeElement ? (StructureViewTreeElement)object4 : null;
                TestCase.assertNotNull((String)("Can't find a child '" + pathPart + "'"), (Object)child);
                Intrinsics.checkNotNull((Object)child);
            }
        }
        Object actualRoot = null;
        actualRoot = LogicalStructureTestUtilsKt.createActualNode(targetStructureElement);
        if (nodePath != null) {
            Object it = $this$forEach$iv = new LogicalStructureNode(null, "", "", null, 8, null);
            boolean bl = false;
            ((LogicalStructureNode)it).subNode((LogicalStructureNode)actualRoot);
            actualRoot = $this$forEach$iv;
        }
        LogicalStructureNode expectedRoot = new LogicalStructureNode(null, "", "", null, 8, null);
        expectedStructureInitializer.invoke((Object)expectedRoot);
        if (!LogicalStructureNode.isEqualTo$default(expectedRoot, (LogicalStructureNode)actualRoot, false, 0, 4, null)) {
            expectedRoot.synchronizeImportantElements((LogicalStructureNode)actualRoot);
            throw new ComparisonFailure("The models are not equal: ", expectedRoot.print("", false), ((LogicalStructureNode)actualRoot).print("", false));
        }
        if (selectedElement != null) {
            String[] stringArray2;
            Object treePath;
            List<LogicalStructureNode> it = expectedRoot.getSelectedNodePath();
            boolean bl = false;
            List<LogicalStructureNode> expectedSelectedPath = it.subList(1, it.size());
            Intrinsics.checkNotNull((Object)structureView, (String)"null cannot be cast to non-null type com.intellij.ide.structureView.newStructureView.StructureViewComponent");
            Promise promise = ((StructureViewComponent)structureView).select((Object)selectedElement, true);
            Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"select(...)");
            Promise select = promise;
            try {
                treePath = (TreePath)PlatformTestUtil.waitForPromise(select);
                TreePath treePath2 = treePath;
                Intrinsics.checkNotNull((Object)treePath2);
                Object[] objectArray = treePath2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getPath(...)");
                List it2 = ArraysKt.toList((Object[])objectArray);
                boolean bl3 = false;
                treePath = it2.subList(1, it2.size());
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw e;
            }
            Object actualPaths = treePath;
            Object object5 = nodePath;
            if (object5 == null || (object5 = StringsKt.split$default((CharSequence)((CharSequence)object5), (String[])(stringArray2 = new String[]{"/"}), (boolean)false, (int)0, (int)6, null)) == null) {
                object5 = CollectionsKt.emptyList();
            }
            Object nodePaths = object5;
            Iterator iterator = ((Iterable)actualPaths).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                Object any = iterator.next();
                if (index < nodePaths.size()) {
                    TestCase.assertTrue((String)"Selected node is different: ", (boolean)StringsKt.startsWith$default((String)any.toString(), (String)((String)nodePaths.get(index)), (boolean)false, (int)2, null));
                    continue;
                }
                Object object6 = CollectionsKt.getOrNull(expectedSelectedPath, (int)(index - nodePaths.size()));
                Intrinsics.checkNotNull((Object)object6);
                LogicalStructureNode expectedNode = (LogicalStructureNode)object6;
                String expectedName = !((Collection)expectedNode.getColoredTextElements()).isEmpty() ? CollectionsKt.joinToString$default((Iterable)expectedNode.getColoredTextElements(), (CharSequence)"", null, null, (int)0, null, LogicalStructureTestUtilsKt::assertLogicalStructure$lambda$4, (int)30, null) : expectedNode.getName();
                TestCase.assertEquals((String)"Selected node is different: ", (String)expectedName, (String)any.toString());
            }
        }
    }

    public static /* synthetic */ void assertLogicalStructure$default(PsiFile psiFile, PsiElement psiElement, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            psiElement = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        LogicalStructureTestUtilsKt.assertLogicalStructure(psiFile, psiElement, string, (Function1<? super LogicalStructureNode, Unit>)function1);
    }

    private static final LogicalStructureNode createActualNode(StructureViewTreeElement element) {
        Object object;
        String string;
        ItemPresentation itemPresentation = element.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)itemPresentation, (String)"getPresentation(...)");
        ItemPresentation presentation = itemPresentation;
        Icon icon = presentation.getIcon(false);
        String string2 = presentation.getPresentableText();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = presentation.getLocationString()) == null) {
            string = "";
        }
        if ((object = presentation instanceof PresentationData ? (PresentationData)presentation : null) == null || (object = object.getColoredText()) == null) {
            object = CollectionsKt.emptyList();
        }
        LogicalStructureNode node = new LogicalStructureNode(icon, string2, string, (List<PresentableNodeDescriptor.ColoredFragment>)object);
        TreeElement[] treeElementArray = element.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)treeElementArray, (String)"getChildren(...)");
        for (TreeElement child : treeElementArray) {
            if (!(child instanceof StructureViewTreeElement)) continue;
            node.subNode(LogicalStructureTestUtilsKt.createActualNode((StructureViewTreeElement)child));
        }
        node.navigationElement((Function0<? extends PsiElement>)((Function0)() -> LogicalStructureTestUtilsKt.createActualNode$lambda$0(element)));
        return node;
    }

    private static final CharSequence assertLogicalStructure$lambda$4(PresentableNodeDescriptor.ColoredFragment it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final PsiElement createActualNode$lambda$0(StructureViewTreeElement $element) {
        PsiTreeElementBase psiTreeElementBase = $element instanceof PsiTreeElementBase ? (PsiTreeElementBase)$element : null;
        return psiTreeElementBase != null ? psiTreeElementBase.getElement() : null;
    }
}

