/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.PatternContextInfo;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StructuralSearchProfile {
    public static final ExtensionPointName<StructuralSearchProfile> EP_NAME = ExtensionPointName.create((String)"com.intellij.structuralsearch.profile");
    @NonNls
    protected static final String PATTERN_PLACEHOLDER = "$$PATTERN_PLACEHOLDER$$";
    private Boolean myReplaceSupported;

    public abstract void compile(PsiElement @NotNull [] var1, @NotNull GlobalCompilingVisitor var2);

    @NotNull
    public abstract PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor var1);

    public boolean isMatchNode(PsiElement element) {
        return !(element instanceof PsiWhiteSpace) && !(element instanceof PsiErrorElement);
    }

    @NotNull
    public abstract CompiledPattern createCompiledPattern();

    @NotNull
    public List<MatchPredicate> getCustomPredicates(@NotNull MatchVariableConstraint constraint, @NotNull String name, @NotNull MatchOptions options) {
        if (constraint == null) {
            StructuralSearchProfile.$$$reportNull$$$0(0);
        }
        if (name == null) {
            StructuralSearchProfile.$$$reportNull$$$0(1);
        }
        if (options == null) {
            StructuralSearchProfile.$$$reportNull$$$0(2);
        }
        List<MatchPredicate> list = Collections.emptyList();
        if (list == null) {
            StructuralSearchProfile.$$$reportNull$$$0(3);
        }
        return list;
    }

    public abstract boolean isMyLanguage(@NotNull Language var1);

    @NotNull
    public @NotNull PsiElement @NotNull [] createPatternTree(@NotNull String text, @NotNull PatternTreeContext context, @NotNull LanguageFileType fileType, @NotNull Language language, @Nullable String contextId, @NotNull Project project, boolean physical) {
        if (text == null) {
            StructuralSearchProfile.$$$reportNull$$$0(4);
        }
        if (context == null) {
            StructuralSearchProfile.$$$reportNull$$$0(5);
        }
        if (fileType == null) {
            StructuralSearchProfile.$$$reportNull$$$0(6);
        }
        if (language == null) {
            StructuralSearchProfile.$$$reportNull$$$0(7);
        }
        if (project == null) {
            StructuralSearchProfile.$$$reportNull$$$0(8);
        }
        return this.doCreatePatternTree(text, context, fileType, language, project, physical, this.getContext(text, language, contextId));
    }

    @NotNull
    public @NotNull PsiElement @NotNull [] createPatternTree(@NotNull String text, @NotNull PatternContextInfo contextInfo, @NotNull LanguageFileType fileType, @NotNull Language language, @NotNull Project project, boolean physical) {
        String contextConstraint;
        if (text == null) {
            StructuralSearchProfile.$$$reportNull$$$0(9);
        }
        if (contextInfo == null) {
            StructuralSearchProfile.$$$reportNull$$$0(10);
        }
        if (fileType == null) {
            StructuralSearchProfile.$$$reportNull$$$0(11);
        }
        if (language == null) {
            StructuralSearchProfile.$$$reportNull$$$0(12);
        }
        if (project == null) {
            StructuralSearchProfile.$$$reportNull$$$0(13);
        }
        if (StringUtil.isEmpty((String)(contextConstraint = contextInfo.getContextConstraint()))) {
            PatternContext patternContext = contextInfo.getPatternContext();
            String contextId = patternContext != null ? patternContext.getId() : null;
            PsiElement[] psiElementArray = this.createPatternTree(text, contextInfo.getTreeContext(), fileType, language, contextId, project, physical);
            if (psiElementArray == null) {
                StructuralSearchProfile.$$$reportNull$$$0(14);
            }
            return psiElementArray;
        }
        return this.doCreatePatternTree(text, contextInfo.getTreeContext(), fileType, language, project, physical, this.getContextByConstraint(contextConstraint, project));
    }

    @NotNull
    private @NotNull PsiElement @NotNull [] doCreatePatternTree(@NotNull String text, @NotNull PatternTreeContext context, @NotNull LanguageFileType fileType, @NotNull Language language, @NotNull Project project, boolean physical, @NotNull String strContext) {
        if (text == null) {
            StructuralSearchProfile.$$$reportNull$$$0(15);
        }
        if (context == null) {
            StructuralSearchProfile.$$$reportNull$$$0(16);
        }
        if (fileType == null) {
            StructuralSearchProfile.$$$reportNull$$$0(17);
        }
        if (language == null) {
            StructuralSearchProfile.$$$reportNull$$$0(18);
        }
        if (project == null) {
            StructuralSearchProfile.$$$reportNull$$$0(19);
        }
        if (strContext == null) {
            StructuralSearchProfile.$$$reportNull$$$0(20);
        }
        String placeholderName = this.getPlaceholderVarName();
        String patternInContext = context == PatternTreeContext.File ? text : strContext.replace(placeholderName, text);
        @NonNls String name = "__dummy." + fileType.getDefaultExtension();
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(name, language, (CharSequence)patternInContext, physical, true);
        if (file == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                StructuralSearchProfile.$$$reportNull$$$0(21);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (context == PatternTreeContext.File) {
            PsiElement[] psiElementArray = new PsiElement[]{file};
            if (psiElementArray == null) {
                StructuralSearchProfile.$$$reportNull$$$0(22);
            }
            return psiElementArray;
        }
        int offset = strContext.indexOf(placeholderName);
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                StructuralSearchProfile.$$$reportNull$$$0(23);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement topElement = element;
        int patternLength = text.length();
        for (element = element.getParent(); element != null; element = element.getParent()) {
            if (element.getTextRange().getStartOffset() != offset || element.getTextLength() > patternLength) continue;
            topElement = element;
        }
        if (topElement instanceof PsiFile) {
            PsiElement[] psiElementArray = topElement.getChildren();
            if (psiElementArray == null) {
                StructuralSearchProfile.$$$reportNull$$$0(24);
            }
            return psiElementArray;
        }
        SmartList result = new SmartList();
        result.add(topElement);
        int endOffset = offset + patternLength;
        for (topElement = topElement.getNextSibling(); topElement != null && topElement.getTextRange().getEndOffset() <= endOffset; topElement = topElement.getNextSibling()) {
            result.add(topElement);
        }
        PsiElement[] psiElementArray = result.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            StructuralSearchProfile.$$$reportNull$$$0(25);
        }
        return psiElementArray;
    }

    @NotNull
    public List<PatternContext> getPatternContexts() {
        List<PatternContext> list = Collections.emptyList();
        if (list == null) {
            StructuralSearchProfile.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    protected String getPlaceholderVarName() {
        return PATTERN_PLACEHOLDER;
    }

    @NotNull
    protected String getContext(@NotNull String pattern, @Nullable Language language, @Nullable String contextId) {
        if (pattern == null) {
            StructuralSearchProfile.$$$reportNull$$$0(27);
        }
        String string = this.getPlaceholderVarName();
        if (string == null) {
            StructuralSearchProfile.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private String getContextByConstraint(@NotNull String contextConstraint, @NotNull Project project) {
        Configuration configuration;
        if (contextConstraint == null) {
            StructuralSearchProfile.$$$reportNull$$$0(29);
        }
        if (project == null) {
            StructuralSearchProfile.$$$reportNull$$$0(30);
        }
        String string = (configuration = ConfigurationManager.getInstance(project).findConfigurationByName(contextConstraint)) != null ? configuration.getMatchOptions().getSearchPattern() : this.getPlaceholderVarName();
        if (string == null) {
            StructuralSearchProfile.$$$reportNull$$$0(31);
        }
        return string;
    }

    @Nullable
    public PsiCodeFragment createCodeFragment(@NotNull Project project, @NotNull String text, @Nullable String contextId) {
        if (project == null) {
            StructuralSearchProfile.$$$reportNull$$$0(32);
        }
        if (text == null) {
            StructuralSearchProfile.$$$reportNull$$$0(33);
        }
        return null;
    }

    @NotNull
    public String getCodeFragmentText(@NotNull PsiFile fragment) {
        if (fragment == null) {
            StructuralSearchProfile.$$$reportNull$$$0(34);
        }
        String string = fragment.getText();
        if (string == null) {
            StructuralSearchProfile.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    public abstract Class<? extends TemplateContextType> getTemplateContextTypeClass();

    @Nullable
    public LanguageFileType detectFileType(@NotNull PsiElement context) {
        if (context == null) {
            StructuralSearchProfile.$$$reportNull$$$0(36);
        }
        return null;
    }

    @Nullable
    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project, @NotNull ReplaceOptions replaceOptions) {
        if (project == null) {
            StructuralSearchProfile.$$$reportNull$$$0(37);
        }
        if (replaceOptions == null) {
            StructuralSearchProfile.$$$reportNull$$$0(38);
        }
        return null;
    }

    public boolean supportsShortenFQNames() {
        return false;
    }

    public boolean supportsUseStaticImports() {
        return false;
    }

    public void checkSearchPattern(@NotNull CompiledPattern pattern) {
        if (pattern == null) {
            StructuralSearchProfile.$$$reportNull$$$0(39);
        }
    }

    public void checkReplacementPattern(@NotNull Project project, @NotNull ReplaceOptions options) {
        if (project == null) {
            StructuralSearchProfile.$$$reportNull$$$0(40);
        }
        if (options == null) {
            StructuralSearchProfile.$$$reportNull$$$0(41);
        }
        if (this.isReplaceSupported()) {
            return;
        }
        LanguageFileType fileType = options.getMatchOptions().getFileType();
        if (fileType == null) {
            return;
        }
        String fileTypeName = StringUtil.toLowerCase((String)fileType.getName());
        throw new UnsupportedPatternException(SSRBundle.message("replacement.not.supported.for.filetype", fileTypeName));
    }

    private boolean isReplaceSupported() {
        if (this.myReplaceSupported != null) {
            return this.myReplaceSupported;
        }
        Class declaringClass = ReflectionUtil.getMethodDeclaringClass(this.getClass(), (String)"getReplaceHandler", (Class[])new Class[]{Project.class, ReplaceOptions.class});
        this.myReplaceSupported = !StructuralSearchProfile.class.equals((Object)declaringClass);
        return this.myReplaceSupported;
    }

    public boolean shouldShowProblem(@NotNull PsiErrorElement error) {
        if (error == null) {
            StructuralSearchProfile.$$$reportNull$$$0(42);
        }
        return false;
    }

    public boolean canBeVarDelimiter(@NotNull PsiElement element) {
        if (element == null) {
            StructuralSearchProfile.$$$reportNull$$$0(43);
        }
        return false;
    }

    @NotNull
    public String getText(@NotNull PsiElement match, int start, int end) {
        if (match == null) {
            StructuralSearchProfile.$$$reportNull$$$0(44);
        }
        String matchText = match.getText();
        if (start == 0 && end == -1) {
            String string = matchText;
            if (string == null) {
                StructuralSearchProfile.$$$reportNull$$$0(45);
            }
            return string;
        }
        String string = matchText.substring(start, end == -1 ? matchText.length() : end);
        if (string == null) {
            StructuralSearchProfile.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    public String getTypedVarString(@NotNull PsiElement element) {
        String name;
        if (element == null) {
            StructuralSearchProfile.$$$reportNull$$$0(47);
        }
        if (element instanceof PsiNamedElement && (name = ((PsiNamedElement)element).getName()) != null) {
            String string = name;
            if (string == null) {
                StructuralSearchProfile.$$$reportNull$$$0(48);
            }
            return string;
        }
        String string = element.getText();
        if (string == null) {
            StructuralSearchProfile.$$$reportNull$$$0(49);
        }
        return string;
    }

    public String getMeaningfulText(@NotNull PsiElement element) {
        if (element == null) {
            StructuralSearchProfile.$$$reportNull$$$0(50);
        }
        return this.getTypedVarString(element);
    }

    public String getAlternativeText(@NotNull PsiElement element, @NotNull String previousText) {
        if (element == null) {
            StructuralSearchProfile.$$$reportNull$$$0(51);
        }
        if (previousText == null) {
            StructuralSearchProfile.$$$reportNull$$$0(52);
        }
        return null;
    }

    @NotNull
    public PsiElement updateCurrentNode(@NotNull PsiElement node) {
        if (node == null) {
            StructuralSearchProfile.$$$reportNull$$$0(53);
        }
        PsiElement psiElement = node;
        if (psiElement == null) {
            StructuralSearchProfile.$$$reportNull$$$0(54);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement extendMatchedByDownUp(@NotNull PsiElement node) {
        if (node == null) {
            StructuralSearchProfile.$$$reportNull$$$0(55);
        }
        PsiElement psiElement = node;
        if (psiElement == null) {
            StructuralSearchProfile.$$$reportNull$$$0(56);
        }
        return psiElement;
    }

    public LanguageFileType getDefaultFileType(@Nullable LanguageFileType fileType) {
        return fileType;
    }

    public Configuration @NotNull [] getPredefinedTemplates() {
        if (Configuration.EMPTY_ARRAY == null) {
            StructuralSearchProfile.$$$reportNull$$$0(57);
        }
        return Configuration.EMPTY_ARRAY;
    }

    public void provideAdditionalReplaceOptions(@NotNull PsiElement node, @NotNull ReplaceOptions options, @NotNull ReplacementBuilder builder) {
        if (node == null) {
            StructuralSearchProfile.$$$reportNull$$$0(58);
        }
        if (options == null) {
            StructuralSearchProfile.$$$reportNull$$$0(59);
        }
        if (builder == null) {
            StructuralSearchProfile.$$$reportNull$$$0(60);
        }
    }

    public void handleSubstitution(@NotNull ParameterInfo info, @NotNull MatchResult match, @NotNull StringBuilder result, @NotNull ReplacementInfo replacementInfo) {
        if (info == null) {
            StructuralSearchProfile.$$$reportNull$$$0(61);
        }
        if (match == null) {
            StructuralSearchProfile.$$$reportNull$$$0(62);
        }
        if (result == null) {
            StructuralSearchProfile.$$$reportNull$$$0(63);
        }
        if (replacementInfo == null) {
            StructuralSearchProfile.$$$reportNull$$$0(64);
        }
        if (info.getName().equals(match.getName())) {
            String replacementString;
            boolean removeSemicolon = false;
            if (match.hasChildren() && !match.isScopeMatch()) {
                StringBuilder buf = new StringBuilder();
                for (MatchResult matchResult : match.getChildren()) {
                    PsiElement currentElement = matchResult.getMatch();
                    if (!buf.isEmpty()) {
                        if (info.isArgumentContext()) {
                            buf.append(',');
                        } else {
                            PsiElement sibling = currentElement.getPrevSibling();
                            buf.append(sibling instanceof PsiWhiteSpace ? sibling.getText() : " ");
                        }
                    }
                    buf.append(matchResult.getMatchImage());
                    removeSemicolon = currentElement instanceof PsiComment;
                }
                replacementString = buf.toString();
            } else {
                if (info.isStatementContext()) {
                    removeSemicolon = match.getMatch() instanceof PsiComment;
                }
                replacementString = match.getMatchImage();
            }
            int offset = Replacer.insertSubstitution(result, 0, info, replacementString);
            if (info.isStatementContext() && (removeSemicolon || StringUtil.endsWithChar((CharSequence)replacementString, (char)';') || StringUtil.endsWithChar((CharSequence)replacementString, (char)'}'))) {
                int start = info.getStartIndex() + offset;
                result.delete(start, start + 1);
            }
        }
    }

    public void handleNoSubstitution(@NotNull ParameterInfo info, @NotNull StringBuilder result) {
        if (info == null) {
            StructuralSearchProfile.$$$reportNull$$$0(65);
        }
        if (result == null) {
            StructuralSearchProfile.$$$reportNull$$$0(66);
        }
        if (info.isHasCommaBefore()) {
            result.delete(info.getBeforeDelimiterPos(), info.getBeforeDelimiterPos() + 1);
        } else if (info.isHasCommaAfter()) {
            result.delete(info.getAfterDelimiterPos(), info.getAfterDelimiterPos() + 1);
        } else if (info.getStartIndex() < result.length() && StringUtil.isLineBreak((char)result.charAt(info.getStartIndex()))) {
            result.deleteCharAt(info.getStartIndex());
        }
    }

    @Contract(value="null -> false")
    public boolean isIdentifier(@Nullable PsiElement element) {
        return false;
    }

    @NotNull
    public Collection<String> getReservedWords() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            StructuralSearchProfile.$$$reportNull$$$0(67);
        }
        return set;
    }

    public boolean isDocCommentOwner(@NotNull PsiElement match) {
        if (match == null) {
            StructuralSearchProfile.$$$reportNull$$$0(68);
        }
        return false;
    }

    @NotNull
    public PsiElement getPresentableElement(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            StructuralSearchProfile.$$$reportNull$$$0(69);
        }
        if (this.isIdentifier(element) && (parent = element.getParent()) != null) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                StructuralSearchProfile.$$$reportNull$$$0(70);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            StructuralSearchProfile.$$$reportNull$$$0(71);
        }
        return psiElement;
    }

    public boolean isApplicableConstraint(@NotNull String constraintName, @Nullable PsiElement variableNode, boolean completePattern, boolean target) {
        if (constraintName == null) {
            StructuralSearchProfile.$$$reportNull$$$0(72);
        }
        switch (constraintName) {
            case "MINIMUM ZERO": {
                if (target) {
                    return false;
                }
            }
            case "MAXIMUM UNLIMITED": 
            case "TEXT": 
            case "REFERENCE": {
                return !completePattern;
            }
        }
        return false;
    }

    public final boolean isApplicableConstraint(@NotNull String constraintName, @NotNull List<? extends PsiElement> nodes, boolean completePattern, boolean target) {
        if (constraintName == null) {
            StructuralSearchProfile.$$$reportNull$$$0(73);
        }
        if (nodes == null) {
            StructuralSearchProfile.$$$reportNull$$$0(74);
        }
        if (nodes.isEmpty()) {
            return this.isApplicableConstraint(constraintName, (PsiElement)null, completePattern, target);
        }
        boolean result = true;
        for (PsiElement psiElement : nodes) {
            result &= this.isApplicableConstraint(constraintName, psiElement, completePattern, target);
        }
        return result;
    }

    public boolean isApplicableContextConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            StructuralSearchProfile.$$$reportNull$$$0(75);
        }
        return !configuration.isPredefined();
    }

    public boolean isReplacementTypedVariable(@NotNull String name) {
        if (name == null) {
            StructuralSearchProfile.$$$reportNull$$$0(76);
        }
        return name.length() > 1 && name.charAt(0) == '$' && name.charAt(name.length() - 1) == '$';
    }

    @NotNull
    public String compileReplacementTypedVariable(@NotNull String name) {
        if (name == null) {
            StructuralSearchProfile.$$$reportNull$$$0(77);
        }
        String string = "$" + name + "$";
        if (string == null) {
            StructuralSearchProfile.$$$reportNull$$$0(78);
        }
        return string;
    }

    @NotNull
    public String stripReplacementTypedVariableDecorations(@NotNull String name) {
        if (name == null) {
            StructuralSearchProfile.$$$reportNull$$$0(79);
        }
        String string = name.substring(1, name.length() - 1);
        if (string == null) {
            StructuralSearchProfile.$$$reportNull$$$0(80);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 14, 21, 22, 23, 24, 25, 26, 28, 31, 35, 45, 46, 48, 49, 54, 56, 57, 67, 70, 71, 78, 80 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 1: 
            case 76: 
            case 77: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 41: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 31: 
            case 35: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 54: 
            case 56: 
            case 57: 
            case 67: 
            case 70: 
            case 71: 
            case 78: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/StructuralSearchProfile";
                break;
            }
            case 4: 
            case 9: 
            case 15: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 16: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 7: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 8: 
            case 13: 
            case 19: 
            case 30: 
            case 32: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextInfo";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strContext";
                break;
            }
            case 27: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextConstraint";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceOptions";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 43: 
            case 47: 
            case 50: 
            case 51: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 44: 
            case 62: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousText";
                break;
            }
            case 53: 
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementInfo";
                break;
            }
            case 72: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchProfile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomPredicates";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternTree";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreatePatternTree";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternContexts";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextByConstraint";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeFragmentText";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedVarString";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "updateCurrentNode";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "extendMatchedByDownUp";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedTemplates";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedWords";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableElement";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "compileReplacementTypedVariable";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "stripReplacementTypedVariableDecorations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomPredicates";
                break;
            }
            case 3: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 31: 
            case 35: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 54: 
            case 56: 
            case 57: 
            case 67: 
            case 70: 
            case 71: 
            case 78: 
            case 80: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createPatternTree";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doCreatePatternTree";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getContextByConstraint";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createCodeFragment";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getCodeFragmentText";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "detectFileType";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceHandler";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkSearchPattern";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkReplacementPattern";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowProblem";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "canBeVarDelimiter";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getTypedVarString";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getMeaningfulText";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativeText";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "updateCurrentNode";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "extendMatchedByDownUp";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "provideAdditionalReplaceOptions";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "handleSubstitution";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "handleNoSubstitution";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isDocCommentOwner";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableElement";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableConstraint";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableContextConfiguration";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isReplacementTypedVariable";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "compileReplacementTypedVariable";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "stripReplacementTypedVariableDecorations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 14, 21, 22, 23, 24, 25, 26, 28, 31, 35, 45, 46, 48, 49, 54, 56, 57, 67, 70, 71, 78, 80 -> new IllegalStateException(string);
        };
    }
}

