/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibility;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\t\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ!\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\r\u0010\u000bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities;", "", "<init>", "()V", "ORDERED_VISIBILITIES", "", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "", "compare", "first", "second", "(Lorg/jetbrains/kotlin/descriptors/Visibility;Lorg/jetbrains/kotlin/descriptors/Visibility;)Ljava/lang/Integer;", "compareLocal", "compareLocal$compiler_common", "isPrivate", "", "visibility", "DEFAULT_VISIBILITY", "Lorg/jetbrains/kotlin/descriptors/Visibilities$Public;", "getDEFAULT_VISIBILITY", "()Lorg/jetbrains/kotlin/descriptors/Visibilities$Public;", "Private", "PrivateToThis", "Protected", "Internal", "Public", "Local", "Inherited", "InvisibleFake", "Unknown", "compiler.common"})
public final class Visibilities {
    @NotNull
    public static final Visibilities INSTANCE;
    @NotNull
    private static final Map<Visibility, Integer> ORDERED_VISIBILITIES;
    @NotNull
    private static final Public DEFAULT_VISIBILITY;

    private Visibilities() {
    }

    @Nullable
    public final Integer compare(@NotNull Visibility first, @NotNull Visibility second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        Integer result2 = first.compareTo(second);
        if (result2 != null) {
            return result2;
        }
        Integer oppositeResult = second.compareTo(first);
        return oppositeResult != null ? Integer.valueOf(-oppositeResult.intValue()) : null;
    }

    @Nullable
    public final Integer compareLocal$compiler_common(@NotNull Visibility first, @NotNull Visibility second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (first == second) {
            return 0;
        }
        Integer firstIndex = ORDERED_VISIBILITIES.get(first);
        Integer secondIndex = ORDERED_VISIBILITIES.get(second);
        return firstIndex == null || secondIndex == null || Intrinsics.areEqual((Object)firstIndex, (Object)secondIndex) ? null : Integer.valueOf(firstIndex - secondIndex);
    }

    public final boolean isPrivate(@NotNull Visibility visibility) {
        Intrinsics.checkNotNullParameter((Object)visibility, (String)"visibility");
        return visibility == Private.INSTANCE || visibility == PrivateToThis.INSTANCE;
    }

    @NotNull
    public final Public getDEFAULT_VISIBILITY() {
        return DEFAULT_VISIBILITY;
    }

    static {
        Map map;
        INSTANCE = new Visibilities();
        Map $this$ORDERED_VISIBILITIES_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$ORDERED_VISIBILITIES_u24lambda_u240.put(PrivateToThis.INSTANCE, 0);
        $this$ORDERED_VISIBILITIES_u24lambda_u240.put(Private.INSTANCE, 0);
        $this$ORDERED_VISIBILITIES_u24lambda_u240.put(Internal.INSTANCE, 1);
        $this$ORDERED_VISIBILITIES_u24lambda_u240.put(Protected.INSTANCE, 1);
        $this$ORDERED_VISIBILITIES_u24lambda_u240.put(Public.INSTANCE, 2);
        ORDERED_VISIBILITIES = MapsKt.build((Map)map);
        DEFAULT_VISIBILITY = Public.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities$Inherited;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "mustCheckInImports", "", "compiler.common"})
    public static final class Inherited
    extends Visibility {
        @NotNull
        public static final Inherited INSTANCE = new Inherited();

        private Inherited() {
            super("inherited", false);
        }

        @Override
        public boolean mustCheckInImports() {
            throw new IllegalStateException("This method shouldn't be invoked for INHERITED visibility");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities$Internal;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "mustCheckInImports", "", "compiler.common"})
    public static final class Internal
    extends Visibility {
        @NotNull
        public static final Internal INSTANCE = new Internal();

        private Internal() {
            super("internal", false);
        }

        @Override
        public boolean mustCheckInImports() {
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities$InvisibleFake;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "mustCheckInImports", "", "externalDisplayName", "", "getExternalDisplayName", "()Ljava/lang/String;", "compiler.common"})
    public static final class InvisibleFake
    extends Visibility {
        @NotNull
        public static final InvisibleFake INSTANCE = new InvisibleFake();

        private InvisibleFake() {
            super("invisible_fake", false);
        }

        @Override
        public boolean mustCheckInImports() {
            return true;
        }

        @Override
        @NotNull
        public String getExternalDisplayName() {
            return "invisible (private in a supertype)";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities$Local;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "mustCheckInImports", "", "compiler.common"})
    public static final class Local
    extends Visibility {
        @NotNull
        public static final Local INSTANCE = new Local();

        private Local() {
            super("local", false);
        }

        @Override
        public boolean mustCheckInImports() {
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities$Private;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "mustCheckInImports", "", "compiler.common"})
    public static final class Private
    extends Visibility {
        @NotNull
        public static final Private INSTANCE = new Private();

        private Private() {
            super("private", false);
        }

        @Override
        public boolean mustCheckInImports() {
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities$PrivateToThis;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "internalDisplayName", "", "getInternalDisplayName", "()Ljava/lang/String;", "mustCheckInImports", "", "compiler.common"})
    public static final class PrivateToThis
    extends Visibility {
        @NotNull
        public static final PrivateToThis INSTANCE = new PrivateToThis();

        private PrivateToThis() {
            super("private_to_this", false);
        }

        @Override
        @NotNull
        public String getInternalDisplayName() {
            return "private/*private to this*/";
        }

        @Override
        public boolean mustCheckInImports() {
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities$Protected;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "mustCheckInImports", "", "compiler.common"})
    public static final class Protected
    extends Visibility {
        @NotNull
        public static final Protected INSTANCE = new Protected();

        private Protected() {
            super("protected", true);
        }

        @Override
        public boolean mustCheckInImports() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities$Public;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "mustCheckInImports", "", "compiler.common"})
    public static final class Public
    extends Visibility {
        @NotNull
        public static final Public INSTANCE = new Public();

        private Public() {
            super("public", true);
        }

        @Override
        public boolean mustCheckInImports() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities$Unknown;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "mustCheckInImports", "", "compiler.common"})
    public static final class Unknown
    extends Visibility {
        @NotNull
        public static final Unknown INSTANCE = new Unknown();

        private Unknown() {
            super("unknown", false);
        }

        @Override
        public boolean mustCheckInImports() {
            throw new IllegalStateException("This method shouldn't be invoked for UNKNOWN visibility");
        }
    }
}

