/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.statistics.impl.StatisticsManagerImpl;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.fixtures.LightJavaCodeInsightFixtureTestCase;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class LightFixtureCompletionTestCase
extends LightJavaCodeInsightFixtureTestCase {
    protected LookupElement[] myItems;

    @Override
    @NotNull
    protected LightProjectDescriptor getProjectDescriptor() {
        LightProjectDescriptor lightProjectDescriptor = JAVA_1_6;
        if (lightProjectDescriptor == null) {
            LightFixtureCompletionTestCase.$$$reportNull$$$0(0);
        }
        return lightProjectDescriptor;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ((StatisticsManagerImpl)StatisticsManager.getInstance()).enableStatistics(this.myFixture.getTestRootDisposable());
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.myItems = null;
            CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
            if (codeInsightSettings != null) {
                codeInsightSettings.setCompletionCaseSensitive(3);
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected void configureByFile(String path) {
        this.myFixture.configureFromExistingVirtualFile(this.myFixture.copyFileToProject(path, StringUtil.getShortName((String)path, (char)'/')));
        this.complete();
    }

    protected void configureByTestName() {
        this.configureByFile("/" + this.getTestName(false) + ".java");
    }

    protected void doAntiTest() {
        this.configureByTestName();
        this.checkResultByFile(this.getTestName(false) + ".java");
        LightFixtureCompletionTestCase.assertEmpty(this.myItems);
        LightFixtureCompletionTestCase.assertNull((Object)this.getLookup());
    }

    protected void complete() {
        this.myItems = this.myFixture.completeBasic();
    }

    protected void selectItem(LookupElement item) {
        this.selectItem(item, '\u0000');
    }

    protected void checkResultByFile(String path) {
        this.myFixture.checkResultByFile(path);
    }

    protected void selectItem(@NotNull LookupElement item, char completionChar) {
        if (item == null) {
            LightFixtureCompletionTestCase.$$$reportNull$$$0(1);
        }
        LookupImpl lookup = this.getLookup();
        lookup.setCurrentItem(item);
        if (LookupEvent.isSpecialCompletionChar((char)completionChar)) {
            lookup.finishLookup(completionChar);
        } else {
            this.type(completionChar);
        }
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
        PlatformTestUtil.waitForAllDocumentsCommitted(10L, TimeUnit.SECONDS);
    }

    protected LookupImpl getLookup() {
        return (LookupImpl)LookupManager.getInstance((Project)this.getProject()).getActiveLookup();
    }

    protected void assertFirstStringItems(String ... items) {
        List<String> strings = this.myFixture.getLookupElementStrings();
        LightFixtureCompletionTestCase.assertNotNull(strings);
        LightFixtureCompletionTestCase.assertOrderedEquals(ContainerUtil.getFirstItems(strings, (int)items.length), items);
    }

    protected void assertStringItems(String ... items) {
        List<String> strings = this.myFixture.getLookupElementStrings();
        LightFixtureCompletionTestCase.assertNotNull(strings);
        LightFixtureCompletionTestCase.assertOrderedEquals(strings, items);
    }

    protected void type(String s) {
        this.myFixture.type(s);
    }

    protected void type(char c) {
        this.myFixture.type(c);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/LightFixtureCompletionTestCase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/LightFixtureCompletionTestCase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectItem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

